/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf.glyph;

import com.inet.pdfview.PDFParser;
import com.inet.pdfview.font.ttf.glyph.GlyfSimpleDyn;
import com.inet.pdfview.font.util.CubicBezierCurve;
import com.inet.pdfview.font.util.QuadraticBezierCurve;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class GlyfConversionMap {
    private static final double CUBIC_TO_QUADRATIC_BEZIER_APX_MAX_ERROR = 1.0E-7;
    private Map<Character, GlyfSimpleDyn> glyphMap = new TreeMap<Character, GlyfSimpleDyn>();
    private int hashCode;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private double maxAdvanceWidth = 0.0;
    private int maxContourNum = 1;
    private int maxPointNum = 1;
    private int unitsPerEm = 4096;
    private double xPrev;
    private double yPrev;
    private boolean onlyEmptyGlyphs = true;

    public void add(char unicode, GeneralPath path, double advanceWidth) {
        PathIterator pathIterator = path.getPathIterator(null);
        if (advanceWidth > this.maxAdvanceWidth) {
            this.maxAdvanceWidth = advanceWidth;
        }
        this.hashCode = this.hashCode * 31 + unicode;
        GlyfSimpleDyn glyph = new GlyfSimpleDyn(advanceWidth);
        double[] coords = new double[6];
        while (!pathIterator.isDone()) {
            int cmd = pathIterator.currentSegment(coords);
            this.hashCode = this.hashCode * 31 + cmd;
            this.hashCode = this.hashCode * 31 + (int)(10000.0 * coords[0]);
            this.hashCode = this.hashCode * 31 + (int)(10000.0 * coords[1]);
            switch (cmd) {
                case 0: {
                    glyph.addContour();
                    this.addPoint(glyph, coords[0], coords[1], true);
                    break;
                }
                case 2: {
                    this.addPoint(glyph, coords[0], coords[1], false);
                    this.addPoint(glyph, coords[2], coords[3], true);
                    break;
                }
                case 3: {
                    List<QuadraticBezierCurve> quadCurves = new CubicBezierCurve(this.xPrev, this.yPrev, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]).toListOfQuadraticApproximation(1.0E-7);
                    for (QuadraticBezierCurve quadCurve : quadCurves) {
                        double[] x = quadCurve.getX();
                        double[] y = quadCurve.getY();
                        this.addPoint(glyph, x[1], y[1], false);
                        this.addPoint(glyph, x[2], y[2], true);
                    }
                    break;
                }
                case 1: {
                    this.addPoint(glyph, coords[0], coords[1], true);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    PDFParser.LOGGER.error((Object)("Unsupported path command " + cmd));
                }
            }
            pathIterator.next();
        }
        if (glyph.getNumContours() == 0) {
            glyph.addContour();
            this.addPoint(glyph, 0.0, 0.0, true);
        } else {
            this.onlyEmptyGlyphs = false;
        }
        if (!this.glyphMap.containsKey(Character.valueOf(unicode))) {
            glyph.done();
            if (glyph.getNumContours() > this.maxContourNum) {
                this.maxContourNum = glyph.getNumContours();
            }
            if (glyph.getNumPoints() > this.maxPointNum) {
                this.maxPointNum = glyph.getNumPoints();
            }
            this.glyphMap.put(Character.valueOf(unicode), glyph);
        }
    }

    private void addPoint(GlyfSimpleDyn glyph, double x, double y, boolean onCurve) {
        short xu = this.toUnits(x);
        short yu = this.toUnits(y);
        glyph.addPoint(xu, yu, onCurve);
        if (onCurve) {
            if (xu < this.minX) {
                this.minX = xu;
            }
            if (xu > this.maxX) {
                this.maxX = xu;
            }
            if (yu < this.minY) {
                this.minY = yu;
            }
            if (yu > this.maxY) {
                this.maxY = yu;
            }
        }
        this.xPrev = x;
        this.yPrev = y;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public boolean ensureMissingCharExists() {
        if (this.glyphMap.get(Character.valueOf('\u0000')) == null) {
            double advanceWidth = 0.25 * this.maxAdvanceWidth;
            GlyfSimpleDyn glyph = new GlyfSimpleDyn(advanceWidth);
            glyph.addContour();
            this.addPoint(glyph, 0.0, 0.0, true);
            this.glyphMap.put(Character.valueOf('\u0000'), glyph);
            return true;
        }
        if (this.onlyEmptyGlyphs) {
            for (char i = '\u0000'; i < '\u0100'; i = (char)(i + '\u0001')) {
                Character chr = Character.valueOf(i);
                if (this.glyphMap.containsKey(chr)) continue;
                GlyfSimpleDyn glyph = new GlyfSimpleDyn(1.0);
                glyph.addContour();
                this.addPoint(glyph, 0.0, 0.0, true);
                this.addPoint(glyph, 1.0, 0.0, true);
                this.addPoint(glyph, 1.0, 1.0, true);
                this.addPoint(glyph, 0.0, 1.0, true);
                return true;
            }
        }
        return false;
    }

    public Set<Map.Entry<Character, GlyfSimpleDyn>> entrySet() {
        return this.glyphMap.entrySet();
    }

    public int getXMax() {
        if (this.maxX == this.minX) {
            return this.maxX + 1;
        }
        return this.maxX;
    }

    public int getYMax() {
        if (this.maxY == this.minY) {
            return this.maxY + 1;
        }
        return this.maxY;
    }

    public int getXMin() {
        return this.minX;
    }

    public int getYMin() {
        return this.minY;
    }

    public double getMaxAdvanceWidth() {
        return this.maxAdvanceWidth;
    }

    public int getMaxContourNum() {
        return this.maxContourNum;
    }

    public int getMaxPointNum() {
        return this.maxPointNum;
    }

    public int size() {
        return this.glyphMap.size();
    }

    private short toUnits(double v) {
        return (short)Math.max(-32768.0, Math.min(32767.0, v * (double)this.unitsPerEm));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<Character, GlyfSimpleDyn> e : this.entrySet()) {
            b.append("Char '" + String.valueOf(e.getKey()) + "' (" + e.getKey().charValue() + ") = " + String.valueOf(e.getValue()) + "\n");
        }
        return b.toString();
    }
}

