/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.otf;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.otf.OTFBasedOnAwt;
import com.inet.pdfview.font.otf.OTFInfo;
import com.inet.pdfview.font.otf.OTFPool;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class OTFFactory {
    private static OTFFactory instance = new OTFFactory();
    private static OTFPool pool = new OTFPool();

    private OTFFactory() {
    }

    public OTFPool getPool() {
        return pool;
    }

    public static OTFFactory getInstance() {
        return instance;
    }

    @Nullable
    public synchronized PDFFont getOTFFont(String baseFont, PDFObject obj, PDFFontDescriptor descriptor, PDFDecrypter decryptor, PDFFontToUnicodeMap toUnicodeMap, String encodingType) {
        PDFFont f = null;
        String fontName = baseFont.replace("#20", " ");
        OTFInfo info = pool.getFontInfo(fontName = fontName.replace("#2D", "-"));
        if (info == null) {
            return null;
        }
        f = info.getPDFFont();
        if (f == null) {
            try {
                f = this.createOTFBasedOnAwt(fontName, obj, descriptor, decryptor, toUnicodeMap, encodingType, info);
                info.setPDFFont(f);
            }
            catch (Exception ex) {
                PDFParser.LOGGER.error((Throwable)ex);
            }
        }
        return f;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private PDFFont createOTFBasedOnAwt(String fontName, PDFObject obj, PDFFontDescriptor descriptor, PDFDecrypter decryptor, PDFFontToUnicodeMap toUnicodeMap, String encodingType, OTFInfo info) throws FontFormatException, IOException {
        Font awtfont = Font.createFont(0, new File(info.getFontPath()));
        int fontStyle = descriptor.calculateStyle();
        return new OTFBasedOnAwt(fontName, obj, descriptor, decryptor, toUnicodeMap, awtfont, fontStyle, encodingType);
    }
}

