/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.otf;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.PDFGlyph;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class OTFBasedOnAwt
extends PDFFont {
    private static final int FONT_SIZE = 1;
    private int fontStyle = 0;
    private Font awtFont;
    private PDFFontToUnicodeMap toUnicodeMap;

    OTFBasedOnAwt(String baseFont, PDFObject obj, PDFFontDescriptor descriptor, PDFDecrypter decryptor, PDFFontToUnicodeMap toUnicodeMap, Font awtFont, int fontStyle, String encodingType) {
        super(baseFont, descriptor, encodingType);
        this.toUnicodeMap = toUnicodeMap;
        this.awtFont = awtFont;
        this.fontStyle = fontStyle;
    }

    @Override
    public PDFGlyph getGlyph(char src, String name, boolean isTwoByteChar) {
        FontRenderContext frc = new FontRenderContext(null, false, true);
        String str = Character.toString(src);
        Shape glyphShape = new TextLayout(str, this.getAWTFont(), frc).getOutline(AffineTransform.getTranslateInstance(0.0, 0.0));
        GeneralPath gp = new GeneralPath(glyphShape);
        double advanceX = this.getAWTFont().getStringBounds(str, frc).getWidth();
        float advanceX_fe = (float)advanceX / 1.0f;
        Point2D.Float advance = new Point2D.Float(advanceX_fe, 0.0f);
        PDFGlyph glyph = new PDFGlyph(src, name, gp, advance);
        return glyph;
    }

    @Override
    public int getStyle() {
        return this.fontStyle;
    }

    @Override
    public PDFFontToUnicodeMap getUnicodeMapping() {
        return this.toUnicodeMap;
    }

    @Override
    public Font getAWTFont() {
        return this.awtFont;
    }
}

