/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFFile;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.PDFGlyph;
import com.inet.shared.utils.BlendComposite;
import com.inet.shared.utils.LayerGraphics2D;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public class Type3Font
extends PDFFont {
    private Map<String, PDFObject> rsrc;
    private Map<String, PDFObject> charProcs;
    private Rectangle2D bbox;
    private double bboxHeight;
    private double measuredHeight = -1.0;
    private AffineTransform at;
    private float[] widths;
    private int firstChar;
    private int lastChar;
    private PDFFontToUnicodeMap toUnicodeMap;
    private Map<String, PDFGlyph> glyphCache = new HashMap<String, PDFGlyph>();
    private PDFFile owner;

    private Type3Font(String baseFont, PDFFontDescriptor descriptor, String encodingType) {
        super(baseFont, descriptor, encodingType);
    }

    public Type3Font(String baseFont, PDFObject fontObj, Map<String, PDFObject> resources, PDFFontDescriptor descriptor, PDFFontToUnicodeMap unicodemap, String encodingType) throws PDFParseException {
        super(baseFont, descriptor, encodingType);
        this.owner = fontObj.getOwner();
        this.rsrc = new HashMap<String, PDFObject>();
        if (resources != null) {
            this.rsrc.putAll(resources);
        }
        PDFObject matrix = fontObj.getDictRef("FontMatrix");
        float[] matrixAry = new float[6];
        for (int i = 0; i < 6; ++i) {
            matrixAry[i] = matrix.getAt(i).getFloatValue();
        }
        this.at = new AffineTransform(matrixAry);
        PDFObject rsrcObj = fontObj.getDictRef("Resources");
        if (rsrcObj != null) {
            this.rsrc.putAll(rsrcObj.getDictionary());
        }
        this.charProcs = fontObj.getDictRef("CharProcs").getDictionary();
        PDFObject[] bboxdef = fontObj.getDictRef("FontBBox").getArray();
        float[] bboxfdef = new float[4];
        for (int i = 0; i < 4; ++i) {
            bboxfdef[i] = bboxdef[i].getFloatValue();
        }
        this.bbox = new Rectangle2D.Float(bboxfdef[0], bboxfdef[1], bboxfdef[2] - bboxfdef[0], bboxfdef[3] - bboxfdef[1]);
        float scale = Math.abs(matrixAry[3]);
        this.bboxHeight = (float)(this.bbox.getHeight() + (this.bbox.getY() < 0.0 ? this.bbox.getY() : 0.0)) * scale;
        if (this.bbox.isEmpty()) {
            this.bbox = null;
        }
        PDFObject[] widthArray = fontObj.getDictRef("Widths").getArray();
        this.widths = new float[widthArray.length];
        for (int i = 0; i < widthArray.length; ++i) {
            this.widths[i] = widthArray[i].getFloatValue();
        }
        this.firstChar = fontObj.getDictRef("FirstChar").getIntValue();
        this.lastChar = fontObj.getDictRef("LastChar").getIntValue();
        this.toUnicodeMap = unicodemap;
        RectangularShape bounds = null;
        if (this.charProcs != null) {
            for (String charName : this.charProcs.keySet()) {
                try {
                    MeasuringGraphics g = new MeasuringGraphics();
                    PDFGlyph glyph = this.getGlyph('\u0000', charName, false);
                    new PDFRenderer(glyph.getPage(), (Graphics2D)((Object)g), null, null).go(true);
                    if (g.bounds == null) continue;
                    if (bounds == null) {
                        bounds = g.bounds;
                        continue;
                    }
                    Rectangle2D.union((Rectangle2D)bounds, g.bounds, (Rectangle2D)bounds);
                }
                catch (Throwable th) {
                    PDFParser.LOGGER.warn((Object)th);
                }
            }
        }
        if (bounds != null) {
            this.measuredHeight = bounds.getHeight() + (bounds.getY() < 0.0 ? bounds.getY() : 0.0);
        }
        this.glyphCache.clear();
    }

    public Rectangle2D getBbox() {
        return this.bbox;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public double getDesignHeight() {
        return this.bboxHeight;
    }

    public double getMeasuredHeight() {
        return this.measuredHeight;
    }

    @Override
    public PDFGlyph getGlyph(char src, String name, boolean isTwoByteChar) {
        if (name == null) {
            if (src == '\u0000') {
                PDFGlyph glyph = new PDFGlyph(src, name, new GeneralPath(), new Point2D.Float(0.0f, 0.0f));
                return glyph;
            }
            throw new IllegalArgumentException("Glyph name required for Type3 font!Source character: " + src);
        }
        PDFGlyph cached = this.glyphCache.get(name);
        if (cached != null) {
            return cached;
        }
        PDFObject pageObj = this.charProcs.get(name);
        if (pageObj == null) {
            PDFGlyph glyph = new PDFGlyph(src, name, new GeneralPath(), new Point2D.Float(0.0f, 0.0f));
            this.glyphCache.put(name, glyph);
            return glyph;
        }
        try {
            PDFPage page = new PDFPage(this.bbox, 0);
            page.addXform(this.at);
            PDFParser prc = new PDFParser(page, pageObj.getStream(null, null, true), this.rsrc, this.getCacheAccess(), this.owner);
            prc.setType3GlyphParser(true);
            prc.go(true);
            int idx = src - this.firstChar;
            float width = idx < 0 || idx >= this.widths.length ? 1.0f : this.widths[idx];
            Point2D advance = new Point2D.Float(width, 0.0f);
            advance = this.at.transform(advance, null);
            PDFGlyph glyph = new PDFGlyph(src, name, page, advance);
            this.glyphCache.put(name, glyph);
            return glyph;
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
            return null;
        }
    }

    @Override
    public int getStyle() {
        return -1;
    }

    @Override
    public PDFFontToUnicodeMap getUnicodeMapping() {
        return this.toUnicodeMap;
    }

    @Override
    public Font getAWTFont() {
        return null;
    }

    public double getBaseAscend() {
        double ascend = 0.0;
        PDFFontDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            ascend = descriptor.getAscent();
        }
        if (ascend == 0.0 && this.bboxHeight != 0.0) {
            ascend = this.bboxHeight;
        }
        if (ascend == 0.0 && this.widths != null && this.widths.length != 0) {
            ascend = (double)this.widths[0] * this.at.getScaleY();
        }
        return ascend;
    }

    public static class MeasuringGraphics
    extends LayerGraphics2D {
        private Rectangle2D bounds = null;
        private Graphics2D source = (Graphics2D)new BufferedImage(1, 1, 6).getGraphics();
        private MeasuringGraphics parent = null;

        public MeasuringGraphics() {
            this.setGraphics(this.source);
            this.setInitialInformation(new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0), AffineTransform.getTranslateInstance(0.0, 0.0));
        }

        public void addLayer(boolean knockout, boolean isolate, BlendComposite composite) throws UnsupportedOperationException {
            super.addLayer(false, false, BlendComposite.getInstance((BlendComposite.BlendingMode)BlendComposite.BlendingMode.NORMAL));
        }

        private void addBounds(Shape s) {
            Rectangle2D newBounds = this.getTransform().createTransformedShape(s).getBounds2D();
            Shape clip = this.getClip();
            if (clip != null) {
                Area a = new Area(clip);
                a.intersect(new Area(s));
                newBounds = a.getBounds2D();
            }
            if (this.parent != null) {
                this.parent.addBounds(newBounds);
            } else if (this.bounds == null) {
                this.bounds = newBounds;
            } else {
                Rectangle2D.union(this.bounds, newBounds, this.bounds);
            }
        }

        public Rectangle2D getBounds() {
            return this.bounds;
        }

        public void draw(Shape s) {
            this.addBounds(s);
        }

        public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
            Rectangle r = this.getImageBounds(0, 0, img);
            this.addBounds(xform != null ? xform.createTransformedShape(r) : r);
            return true;
        }

        private Rectangle getImageBounds(int x, int y, Image img) {
            Rectangle r = new Rectangle(x, y, img.getWidth(null), img.getHeight(null));
            return r;
        }

        public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
            this.addBounds(this.getImageBounds(x, y, img));
        }

        public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
            Rectangle r = new Rectangle(img.getWidth(), img.getHeight());
            this.addBounds(xform != null ? xform.createTransformedShape(r) : r);
        }

        public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
            Rectangle2D.Float r = new Rectangle2D.Float(0.0f, 0.0f, img.getWidth(), img.getHeight());
            this.addBounds(xform != null ? xform.createTransformedShape(r) : r);
        }

        public void drawString(String str, int x, int y) {
            this.drawString(str, (float)x, (float)y);
        }

        public void drawString(String str, float x, float y) {
            Rectangle2D sBounds = this.getFontMetrics().getStringBounds(str, (Graphics)((Object)this));
            AffineTransform t = new AffineTransform();
            t.translate(x, y);
            this.addBounds(t.createTransformedShape(sBounds));
        }

        public void drawString(AttributedCharacterIterator iterator, int x, int y) {
            this.drawString(iterator, (float)x, (float)y);
        }

        public void drawString(AttributedCharacterIterator iterator, float x, float y) {
            Rectangle2D sBounds = this.getFontMetrics().getStringBounds(iterator, iterator.getBeginIndex(), iterator.getEndIndex(), (Graphics)((Object)this));
            AffineTransform t = new AffineTransform();
            t.translate(x, y);
            this.addBounds(t.createTransformedShape(sBounds));
        }

        public void drawGlyphVector(GlyphVector g, float x, float y) {
            AffineTransform t = new AffineTransform();
            t.translate(x, y);
            this.addBounds(t.createTransformedShape(g.getVisualBounds()));
        }

        public void fill(Shape s) {
            this.addBounds(s);
        }

        public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
            return new Area(s).intersects(rect);
        }

        public GraphicsConfiguration getDeviceConfiguration() {
            return this.source.getDeviceConfiguration();
        }

        public void setComposite(Composite comp) {
            this.source.setComposite(comp);
        }

        public void setPaint(Paint paint) {
            this.source.setPaint(paint);
        }

        public void setStroke(Stroke s) {
            this.source.setStroke(s);
        }

        public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
            this.source.setRenderingHint(hintKey, hintValue);
        }

        public Object getRenderingHint(RenderingHints.Key hintKey) {
            return this.source.getRenderingHint(hintKey);
        }

        public void setRenderingHints(Map<?, ?> hints) {
            this.source.setRenderingHints(hints);
        }

        public void addRenderingHints(Map<?, ?> hints) {
            this.source.addRenderingHints(hints);
        }

        public RenderingHints getRenderingHints() {
            return this.source.getRenderingHints();
        }

        public void translate(int x, int y) {
            this.source.translate(x, y);
        }

        public void translate(double tx, double ty) {
            this.source.translate(tx, ty);
        }

        public void rotate(double theta) {
            this.source.rotate(theta);
        }

        public void rotate(double theta, double x, double y) {
            this.source.rotate(theta, x, y);
        }

        public void scale(double sx, double sy) {
            this.source.scale(sx, sy);
        }

        public void shear(double shx, double shy) {
            this.source.shear(shx, shy);
        }

        public void transform(AffineTransform Tx) {
            this.source.transform(Tx);
        }

        public void setTransform(AffineTransform Tx) {
            this.source.setTransform(Tx);
        }

        public AffineTransform getTransform() {
            return this.source.getTransform();
        }

        public Paint getPaint() {
            return this.source.getPaint();
        }

        public Composite getComposite() {
            return this.source.getComposite();
        }

        public void setBackground(Color color) {
            this.source.setBackground(color);
        }

        public Color getBackground() {
            return this.source.getBackground();
        }

        public Stroke getStroke() {
            return this.source.getStroke();
        }

        public void clip(Shape s) {
            this.source.clip(s);
        }

        public FontRenderContext getFontRenderContext() {
            return this.source.getFontRenderContext();
        }

        public Graphics create() {
            MeasuringGraphics g = new MeasuringGraphics();
            g.parent = this;
            return g;
        }

        public Color getColor() {
            return this.source.getColor();
        }

        public void setColor(Color c) {
            this.source.setColor(c);
        }

        public void setPaintMode() {
            this.source.setPaintMode();
        }

        public void setXORMode(Color c1) {
            this.source.setXORMode(c1);
        }

        public Font getFont() {
            return this.source.getFont();
        }

        public void setFont(Font font) {
            this.source.setFont(font);
        }

        public FontMetrics getFontMetrics(Font f) {
            return this.source.getFontMetrics(f);
        }

        public Rectangle getClipBounds() {
            return this.source.getClipBounds();
        }

        public void clipRect(int x, int y, int width, int height) {
            this.source.clearRect(x, y, width, height);
        }

        public void setClip(int x, int y, int width, int height) {
            this.source.setClip(x, y, width, height);
        }

        public Shape getClip() {
            return this.source.getClip();
        }

        public void setClip(Shape clip) {
            this.source.setClip(clip);
        }

        public void copyArea(int x, int y, int width, int height, int dx, int dy) {
            this.source.copyArea(x, y, width, height, dx, dy);
        }

        public void drawLine(int x1, int y1, int x2, int y2) {
            this.addBounds(new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1)));
        }

        public void fillRect(int x, int y, int width, int height) {
            this.addBounds(new Rectangle(x, y, width, height));
        }

        public void clearRect(int x, int y, int width, int height) {
            this.addBounds(new Rectangle(x, y, width, height));
        }

        public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            this.addBounds(new Rectangle(x, y, width, height));
        }

        public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            this.addBounds(new Rectangle(x, y, width, height));
        }

        public void drawOval(int x, int y, int width, int height) {
            this.addBounds(new Rectangle(x, y, width, height));
        }

        public void fillOval(int x, int y, int width, int height) {
            this.addBounds(new Rectangle(x, y, width, height));
        }

        public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            this.addBounds(new Rectangle(x, y, width, height));
        }

        public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            this.addBounds(new Rectangle(x, y, width, height));
        }

        public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
            this.addBounds(new Polygon(xPoints, yPoints, nPoints).getBounds2D());
        }

        public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            this.addBounds(new Polygon(xPoints, yPoints, nPoints).getBounds2D());
        }

        public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            this.addBounds(new Polygon(xPoints, yPoints, nPoints).getBounds2D());
        }

        public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
            this.addBounds(this.getImageBounds(x, y, img));
            return true;
        }

        public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
            this.addBounds(new Rectangle(x, y, width, height));
            return false;
        }

        public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
            this.addBounds(this.getImageBounds(x, y, img));
            return false;
        }

        public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
            this.addBounds(new Rectangle(x, y, width, height));
            return false;
        }

        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
            this.addBounds(new Rectangle(dx1, dy1, dx2 - dx1, dy2 - dy1));
            return true;
        }

        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
            this.addBounds(new Rectangle(Math.min(dx1, dx2), Math.min(dy1, dy2), Math.abs(dx2 - dx1), Math.abs(dy2 - dy1)));
            return true;
        }

        public void dispose() {
        }
    }

    public static class Type3FontScaled
    extends Type3Font {
        private double scale;

        public Type3FontScaled(Type3Font wrapped, double scale) {
            super(wrapped.getBaseFont(), wrapped.getDescriptor(), wrapped.encodingType);
            this.scale = scale;
            this.setSubtype(wrapped.getSubtype());
            this.setEncoding(wrapped.getEncoding());
            this.setParent(wrapped.getParent());
            this.setExtraCharacters(wrapped.getExtraCharacters());
            this.setCacheAccess(wrapped.getCacheAccess());
        }

        @Override
        public double getBaseAscend() {
            return super.getBaseAscend() / this.scale;
        }

        @Override
        public Rectangle2D getBbox() {
            return super.getBbox();
        }

        @Override
        public double getDesignHeight() {
            return super.getDesignHeight();
        }

        @Override
        public int getFirstChar() {
            return super.getFirstChar();
        }

        @Override
        public PDFGlyph getGlyph(char src, String name, boolean isTwoByteChar) {
            return super.getGlyph(src, name, isTwoByteChar);
        }

        @Override
        public int getLastChar() {
            return super.getLastChar();
        }

        @Override
        public double getMeasuredHeight() {
            return super.getMeasuredHeight();
        }

        @Override
        public int getStyle() {
            return super.getStyle();
        }

        @Override
        public PDFFontToUnicodeMap getUnicodeMapping() {
            return super.getUnicodeMapping();
        }
    }
}

