/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.CIDFontType0;
import com.inet.pdfview.font.CIDFontType2;
import com.inet.pdfview.font.CidMapFactory;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontEncoding;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.PDFGlyph;
import java.awt.Font;
import javax.annotation.Nullable;

public class Type0Font
extends PDFFont {
    private static final boolean DYNAMIC_PARENT = true;
    private PDFFont[] fonts;
    private PDFFontToUnicodeMap toUnicodeMap;
    private boolean isIdentityEncoding;
    private Font awtFont;

    public Type0Font(String baseFont, PDFObject fontObj, PDFFontDescriptor descriptor, PDFFontToUnicodeMap toUnicodeMap, @Nullable PDFDecrypter decryptor, CacheAccess fontGenerationListener, PDFObject encodingObj, PDFFontEncoding encoding) throws PDFParseException {
        super(baseFont, descriptor, encodingObj == null ? null : encodingObj.getStringValue());
        PDFObject[] descendantFonts = fontObj.getDictRef("DescendantFonts").getArray();
        this.fonts = new PDFFont[descendantFonts.length];
        boolean isCIDType1C = false;
        if (encodingObj != null) {
            this.isIdentityEncoding = "Identity-H".equals(encodingObj.getStringValue()) || "Identity-V".equals(encodingObj.getStringValue());
        }
        for (int i = 0; i < descendantFonts.length; ++i) {
            this.fonts[i] = Type0Font.getFont(descendantFonts[i], this, null, decryptor, toUnicodeMap, fontGenerationListener, this);
            this.setHasValidMapping(this.isValidMapping() & this.fonts[i].isValidMapping());
            PDFFont.Subtype subtype = this.fonts[i].getSubtype();
            if (subtype == PDFFont.Subtype.CIDFontType0 && this.fonts[i] instanceof CIDFontType0) {
                CIDFontType0 cidfont = (CIDFontType0)this.fonts[i];
                isCIDType1C = cidfont.isCIDType1C();
            }
            if (toUnicodeMap != null) continue;
            toUnicodeMap = this.fonts[i].getUnicodeMapping();
        }
        if (toUnicodeMap == null && encoding != null) {
            toUnicodeMap = CidMapFactory.getUnicodeMapping(encodingObj, encoding);
            if (isCIDType1C) {
                this.setTRY_AWT(false);
            }
        }
        this.toUnicodeMap = toUnicodeMap;
        this.setCacheAccess(fontGenerationListener);
    }

    public PDFFont getDescendantFont(int fontID) {
        return this.fonts[fontID];
    }

    public int getDescendantCount() {
        return this.fonts.length;
    }

    @Override
    public PDFGlyph getGlyph(char src, String name, boolean isTwoByteChar) {
        return this.getDescendantFont(0).getGlyph(src, name, false);
    }

    @Override
    public PDFFontToUnicodeMap getUnicodeMapping() {
        return this.toUnicodeMap;
    }

    public void setUnicodeMapping(PDFFontToUnicodeMap map) {
        this.toUnicodeMap = map;
    }

    @Override
    public int getStyle() {
        int result = -1;
        for (PDFFont font : this.fonts) {
            int subStyle = font.getStyle();
            if (subStyle <= 0) continue;
            result = result >= 0 ? result | subStyle : subStyle;
        }
        return result;
    }

    @Override
    public Font getAWTFont() {
        if (this.awtFont != null) {
            return this.awtFont;
        }
        if (this.isTRY_AWT()) {
            PDFFont f = this.getDescendantFont(0);
            if (f instanceof CIDFontType2) {
                CIDFontType2 cidFont2 = (CIDFontType2)f;
                cidFont2.setParent(this);
                cidFont2.refreshAWTFont();
                this.awtFont = cidFont2.getAWTFont();
                return this.awtFont;
            }
            return f.getAWTFont();
        }
        return null;
    }

    boolean isIdentityEncoding() {
        return this.isIdentityEncoding;
    }
}

