/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.command.PDFDrawTextCmd;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.AdobeCharNames;
import com.inet.pdfview.font.CharCharMap;
import com.inet.pdfview.font.FontSupport;
import com.inet.pdfview.font.ICharMapper;
import com.inet.pdfview.font.OutlineFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.TTFBasedFont;
import com.inet.pdfview.font.Type1CFont;
import com.inet.pdfview.font.ttf.TrueTypeFont;
import com.inet.pdfview.font.ttf.cmap.CMap;
import com.inet.pdfview.font.ttf.cmap.CMapFormat4;
import com.inet.pdfview.font.ttf.glyph.Glyf;
import com.inet.pdfview.font.ttf.glyph.GlyfCompound;
import com.inet.pdfview.font.ttf.glyph.GlyfSimple;
import com.inet.pdfview.font.ttf.table.CmapTable;
import com.inet.pdfview.font.ttf.table.GlyfTable;
import com.inet.pdfview.font.ttf.table.HeadTable;
import com.inet.pdfview.font.ttf.table.HheaTable;
import com.inet.pdfview.font.ttf.table.HmtxTable;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TTFFont
extends OutlineFont {
    private TrueTypeFont font;
    private float unitsPerEm;
    private int fontstyle = 0;
    private Font attachedFont;
    private PDFFontToUnicodeMap toUnicode;
    private PDFFontToUnicodeMap ascendantToUnicode;
    private Set<String> unknownAdobeNames;

    public TTFFont(String baseFont, PDFObject fontObj, PDFFontDescriptor descriptor, PDFDecrypter decryptor, PDFFontToUnicodeMap ascendantToUnicode, String encodingType) throws PDFParseException {
        super(baseFont, fontObj, descriptor, encodingType);
        this.ascendantToUnicode = ascendantToUnicode;
        if (this.toUnicode == null) {
            this.toUnicode = ascendantToUnicode;
        }
        PDFObject ttfObj = descriptor.getFontFile2();
        PDFXref ref = null;
        if (ttfObj != null) {
            if (decryptor != null) {
                ref = ttfObj.getRefValue();
            }
            IDataBuffer data = ttfObj.getStreamBuffer(ref, decryptor);
            this.font = TrueTypeFont.parseFont(data, fontObj.getOwner());
            if (this.font.isCFF()) {
                return;
            }
            HeadTable head = this.font.getHEADTable();
            if (head != null) {
                short macStyle = head.getMacStyle();
                this.fontstyle |= (macStyle & 1) > 0 ? 1 : 0;
                this.fontstyle |= (macStyle & 2) > 0 ? 2 : 0;
            }
        } else {
            ttfObj = descriptor.getFontFile3();
            if (ttfObj != null) {
                PDFParser.LOGGER.warn((Object)"TTFFont contains data in FontFile3");
            }
            this.parseFontStyle(baseFont);
            String faceName = baseFont.split(",")[0];
            Font af = new Font(faceName, this.fontstyle, 1);
            Font af2 = TTFBasedFont.getAWTFontBasedOnPhysicalFont(af, faceName, this.fontstyle, 1);
            if (af2 != null) {
                af = af2;
            }
            this.setAttachedFont(af);
        }
        if (this.font != null && this.font.getHEADTable() != null) {
            this.unitsPerEm = this.font.getHEADTable().getUnitsPerEm();
        }
    }

    public TTFFont(String baseFont, PDFObject fontObj, PDFFontDescriptor descriptor, PDFFontToUnicodeMap map, PDFDecrypter decryptor, String encodingType) throws PDFParseException {
        super(baseFont, fontObj, descriptor, encodingType);
        HeadTable head;
        this.toUnicode = map;
        PDFObject ttfObj = descriptor.getFontFile2();
        if (ttfObj != null) {
            PDFXref ref = null;
            if (decryptor != null) {
                ref = ttfObj.getRefValue();
            }
            if (ttfObj.getCache() instanceof TrueTypeFont) {
                this.font = (TrueTypeFont)ttfObj.getCache();
            } else {
                IDataBuffer data = ttfObj.getStreamBuffer(ref, decryptor);
                this.font = TrueTypeFont.parseFont(data, fontObj.getOwner());
                ttfObj.setCache(this.font);
            }
        }
        if ((head = this.font.getHEADTable()) != null) {
            this.unitsPerEm = head.getUnitsPerEm();
            short macStyle = head.getMacStyle();
            this.fontstyle |= (macStyle & 1) > 0 ? 1 : 0;
            this.fontstyle |= (macStyle & 2) > 0 ? 2 : 0;
        }
        if (this.fontstyle == 0) {
            this.parseFontStyle(baseFont);
        }
    }

    private void parseFontStyle(String baseFont) {
        String style;
        String[] args = baseFont.split(",");
        String string = style = args.length > 1 ? args[1] : null;
        if (style != null) {
            if (style.toLowerCase().contains("bold")) {
                this.fontstyle |= 1;
            }
            if (style.toLowerCase().contains("italic") || style.toLowerCase().contains("oblique") || style.toLowerCase().endsWith("italic")) {
                this.fontstyle |= 2;
            }
        } else {
            this.fontstyle = -1;
        }
    }

    @Override
    protected synchronized GeneralPath getOutline(char src, float width) {
        if (this.font.isCFF()) {
            return this.font.getCFFTable().getFont().getOutline(src, width);
        }
        CmapTable cmap = this.font.getCMAPTable();
        if (cmap == null) {
            return this.getOutline((int)src, width);
        }
        CMap[] maps = cmap.getCMaps();
        GeneralPath path = null;
        for (int i = 0; i < maps.length; ++i) {
            CMapFormat4 map4;
            char idx = maps[i].map(src);
            if (idx != '\u0000') {
                GeneralPath currentpath = this.getOutline((int)idx, width);
                if (!this.isPathEmpty(currentpath)) {
                    return currentpath;
                }
                if (path != null) continue;
                path = currentpath;
                continue;
            }
            if (!(maps[i] instanceof CMapFormat4) || !(map4 = (CMapFormat4)maps[i]).canBeSymbolic() || (idx = map4.map((char)(src + 61440))) == '\u0000') continue;
            return this.getOutline((int)idx, width);
        }
        return path;
    }

    @Override
    protected synchronized GeneralPath getOutline(String name, float width) {
        if (this.font.isCFF()) {
            return this.font.getCFFTable().getFont().getOutline(name, width);
        }
        GeneralPath path = null;
        CmapTable cmap = this.font.getCMAPTable();
        if (cmap != null) {
            CMap[] maps = cmap.getCMaps();
            for (int i = 0; i < maps.length; ++i) {
                CMapFormat4 map4;
                CMap map = maps[i];
                short platformID = map.getPlatformID();
                short platformSpecificID = map.getPlatformSpecificID();
                if (platformID == 1 && platformSpecificID == 0 || platformID == 0 && platformSpecificID == 3) {
                    PDFParser.LOGGER.warn((Object)("TrueTypeFont CMAP with platformID = " + platformID + " and platformSpecificID = " + platformSpecificID + " not implement"));
                    continue;
                }
                char src = this.getCharCodeByCharName(name, platformID, platformSpecificID);
                if (src == '\u0000') continue;
                char idx = maps[i].map(src);
                if (idx != '\u0000') {
                    GeneralPath currentpath = this.getOutline((int)idx, width);
                    if (!this.isPathEmpty(currentpath)) {
                        return currentpath;
                    }
                    if (!name.equalsIgnoreCase("space")) {
                        PDFParser.LOGGER.warn((Object)("TrueTypeFont CMAP with platformID = " + platformID + " and platformSpecificID = " + platformSpecificID + " has no glyph!"));
                    }
                    if (path != null) continue;
                    path = currentpath;
                    continue;
                }
                if (!(maps[i] instanceof CMapFormat4) || !(map4 = (CMapFormat4)maps[i]).canBeSymbolic() || (idx = map4.map((char)(src + 61440))) == '\u0000') continue;
                return this.getOutline((int)idx, width);
            }
        }
        return path;
    }

    private char getCharCodeByCharName(String name, short platformID, short platformSpecificID) {
        char ch = '\u0000';
        if (platformID == 1 && platformSpecificID == 0) {
            ICharMapper macCharMapper = FontSupport.getCharMapper("MacRomanEncoding");
            ch = macCharMapper.getCharCode(name);
        } else if (platformID == 3 && platformSpecificID == 1) {
            Character unicode = AdobeCharNames.getCharBasedOnAdobeName(name);
            if (unicode == null) {
                if (!".notdef".equals(name)) {
                    if (this.unknownAdobeNames == null) {
                        this.unknownAdobeNames = new HashSet<String>();
                    }
                    if (this.unknownAdobeNames.add(name) && PDFParser.LOGGER.isDebug()) {
                        PDFParser.LOGGER.debug((Object)("adobe character name not found: " + name));
                    }
                }
            } else {
                ch = unicode.charValue();
            }
        }
        return ch;
    }

    protected synchronized GeneralPath getOutline(int glyphId, float width) {
        if (this.font != null) {
            if (this.font.isCFF()) {
                Type1CFont cffFont = this.font.getCFFTable().getFont();
                return cffFont.getOutline((char)glyphId, width);
            }
            GlyfTable glyf = this.font.getGLYFTable();
            Glyf g = glyf != null ? glyf.getGlyph(glyphId) : null;
            GeneralPath gp = null;
            if (g instanceof GlyfSimple) {
                gp = this.renderSimpleGlyph((GlyfSimple)g);
            } else if (g instanceof GlyfCompound) {
                try {
                    gp = this.renderCompoundGlyph(glyf, (GlyfCompound)g);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    gp = new GeneralPath();
                }
            } else {
                gp = new GeneralPath();
            }
            HmtxTable hmtx = this.font.getHMTXTable();
            AffineTransform at = AffineTransform.getScaleInstance(1.0f / this.unitsPerEm, 1.0f / this.unitsPerEm);
            HeadTable head = this.font.getHEADTable();
            if (head != null && g != null) {
                short lsb = hmtx.getLeftSideBearing(glyphId);
                if ((head.getFlags() & 2) == 0 && g.getMinX() != lsb) {
                    at.concatenate(AffineTransform.getTranslateInstance(lsb - g.getMinX(), 0.0));
                }
            }
            gp.transform(at);
            return gp;
        }
        return this.getGlyphFromJavaFont(glyphId, false);
    }

    @Override
    protected void checkUnicodeMapping() {
        if (this.font == null) {
            return;
        }
        super.checkUnicodeMapping();
    }

    GeneralPath getGlyphFromJavaFont(int glyphId, boolean isTwoByteChars) {
        FontRenderContext frc = new FontRenderContext(AffineTransform.getTranslateInstance(0.0, 0.0), true, true);
        if (this.getAttachedFont() != null) {
            char src = (char)glyphId;
            String text = new String(new char[]{src});
            CharCharMap extras = this.getParent() != null ? this.getParent().getExtraCharacters() : this.getExtraCharacters();
            String res = PDFDrawTextCmd.getUnicodeString(this.ascendantToUnicode, text, true, isTwoByteChars, extras, null);
            GlyphVector glyphList = this.getAttachedFont().createGlyphVector(frc, res);
            int glyphIndex = 0;
            if (glyphList.getNumGlyphs() < 1) {
                return null;
            }
            Shape shape = glyphList.getGlyphOutline(glyphIndex);
            AffineTransform at = AffineTransform.getScaleInstance(1.0, -1.0);
            shape = at.createTransformedShape(shape);
            GeneralPath gp = new GeneralPath(shape);
            return gp;
        }
        return null;
    }

    protected GeneralPath renderSimpleGlyph(GlyfSimple g) {
        int curContour = 0;
        RenderState rs = new RenderState();
        rs.gp = new GeneralPath();
        for (int i = 0; i < g.getNumPoints(); ++i) {
            PointRec rec = new PointRec(g, i);
            if (rec.onCurve) {
                this.addOnCurvePoint(rec, rs);
            } else {
                this.addOffCurvePoint(rec, rs);
            }
            if (i != g.getContourEndPoint(curContour)) continue;
            ++curContour;
            if (rs.firstOff != null) {
                this.addOffCurvePoint(rs.firstOff, rs);
            }
            if (rs.firstOn != null) {
                this.addOnCurvePoint(rs.firstOn, rs);
            }
            rs.firstOn = null;
            rs.firstOff = null;
            rs.prevOff = null;
        }
        return rs.gp;
    }

    protected GeneralPath renderCompoundGlyph(GlyfTable glyf, GlyfCompound g) {
        GeneralPath gp = new GeneralPath();
        for (int i = 0; i < g.getNumComponents(); ++i) {
            double[] matrix;
            AffineTransform matrixTransform;
            Glyf gc = glyf.getGlyph(g.getGlyphIndex(i));
            if (gc == null || this.readGlyphAsSimple(gc, gp, matrixTransform = new AffineTransform(matrix = g.getTransform(i)))) continue;
            GlyfCompound g1 = (GlyfCompound)gc;
            for (int j = 0; j < g1.getNumComponents(); ++j) {
                Glyf gc1 = glyf.getGlyph(g1.getGlyphIndex(j));
                if (gc1 == null) continue;
                double[] matrix1 = g1.getTransform(j);
                AffineTransform matrix1Transform = new AffineTransform(matrix1);
                matrix1Transform.concatenate(matrixTransform);
                if (this.readGlyphAsSimple(gc1, gp, matrix1Transform)) continue;
                GlyfCompound g2 = (GlyfCompound)gc1;
                for (int k = 0; k < g2.getNumComponents(); ++k) {
                    double[] matrix2 = g2.getTransform(k);
                    AffineTransform matrix2Transform = new AffineTransform(matrix2);
                    matrix2Transform.concatenate(matrix1Transform);
                    if (this.readGlyphAsSimple(gc1, gp, matrix2Transform)) continue;
                    PDFParser.LOGGER.warn((Object)"Flat characters failed. This may cause incorrectly displayed ligatures or combined characters.");
                }
            }
        }
        return gp;
    }

    private boolean readGlyphAsSimple(Glyf gl, GeneralPath gp, AffineTransform matrix) {
        if (gl instanceof GlyfSimple) {
            GlyfSimple gs = (GlyfSimple)gl;
            GeneralPath path = this.renderSimpleGlyph(gs);
            path.transform(matrix);
            gp.append(path, false);
            return true;
        }
        return false;
    }

    private void addOnCurvePoint(PointRec rec, RenderState rs) {
        if (rs.firstOn == null) {
            rs.firstOn = rec;
            rs.gp.moveTo(rec.x, rec.y);
            rs.prevOff = null;
        } else if (rs.prevOff != null) {
            rs.gp.quadTo(rs.prevOff.x, rs.prevOff.y, rec.x, rec.y);
            rs.prevOff = null;
        } else {
            rs.gp.lineTo(rec.x, rec.y);
        }
    }

    private void addOffCurvePoint(PointRec rec, RenderState rs) {
        if (rs.prevOff != null) {
            PointRec oc = new PointRec((rec.x + rs.prevOff.x) / 2, (rec.y + rs.prevOff.y) / 2, true);
            this.addOnCurvePoint(oc, rs);
        } else if (rs.firstOn == null) {
            rs.firstOff = rec;
        }
        rs.prevOff = rec;
    }

    @Override
    public PDFFontToUnicodeMap getUnicodeMapping() {
        return this.toUnicode;
    }

    Font getAttachedFont() {
        return this.attachedFont;
    }

    void setAttachedFont(Font f) {
        this.attachedFont = f;
    }

    TrueTypeFont getNativeFont() {
        return this.font;
    }

    @Override
    public int getStyle() {
        return this.fontstyle;
    }

    private boolean isPathEmpty(GeneralPath path) {
        Rectangle rect = path.getBounds();
        return rect.getHeight() == 0.0 && rect.getWidth() == 0.0;
    }

    @Override
    public float getAscent() {
        if (this.font != null && this.font.hasTable(1751672161)) {
            HheaTable hheaTable = this.font.getHHEATable();
            return (float)hheaTable.getAscent() / this.unitsPerEm;
        }
        return super.getAscent();
    }

    @Override
    protected int getDefaultFirstChar() {
        if (this.ascendantToUnicode != null) {
            return this.ascendantToUnicode.getMinChar();
        }
        return super.getDefaultFirstChar();
    }

    @Override
    protected int getDefaultLastChar() {
        if (this.ascendantToUnicode != null) {
            return this.ascendantToUnicode.getMaxChar();
        }
        if (this.font != null) {
            if (this.font.isCFF() && this.font.getCFFTable().getFont() != null) {
                return this.font.getCFFTable().getFont().getDefaultLastChar();
            }
            if (this.font.getGLYFTable() != null) {
                return this.font.getGLYFTable().getGlyphCount() - 1;
            }
        }
        return 65535;
    }

    Map<Character, Character> getGlyphToUnicodeMap() {
        if (this.font == null) {
            return null;
        }
        CmapTable cmap = this.font.getCMAPTable();
        if (cmap == null) {
            return null;
        }
        HashMap<Character, Character> inverseMap = new HashMap<Character, Character>();
        CMap[] maps = cmap.getCMaps();
        for (int i = 0; i < maps.length; ++i) {
            if (!(maps[i] instanceof CMapFormat4)) continue;
            CMapFormat4 map4 = (CMapFormat4)maps[i];
            char endValue = '\uffff';
            int startValue = 0;
            if (map4.canBeSymbolic()) {
                startValue = 61440;
                endValue -= startValue;
            }
            for (char unicode = '\u0000'; unicode < endValue; unicode = (char)(unicode + 1)) {
                char glyphId = map4.map((char)(unicode + startValue));
                if (glyphId == '\u0000') continue;
                inverseMap.put(Character.valueOf(glyphId), Character.valueOf(unicode));
            }
        }
        return inverseMap;
    }

    int getLastCodeFromCMap() {
        if (this.font == null) {
            return -1;
        }
        CmapTable cmap = this.font.getCMAPTable();
        if (cmap == null) {
            return -1;
        }
        CMap[] maps = cmap.getCMaps();
        int maxIndex = -1;
        for (int i = 0; i < maps.length; ++i) {
            maxIndex = Math.max(maxIndex, maps[i].getLastCode());
        }
        return maxIndex;
    }

    protected void setUnicodeMap(PDFFontToUnicodeMap map) {
        this.toUnicode = map;
    }

    protected TrueTypeFont getTrueTypeFont() {
        return this.font;
    }

    class RenderState {
        GeneralPath gp;
        PointRec firstOn;
        PointRec firstOff;
        PointRec prevOff;

        RenderState() {
        }
    }

    class PointRec {
        int x;
        int y;
        boolean onCurve;

        public PointRec(int x, int y, boolean onCurve) {
            this.x = x;
            this.y = y;
            this.onCurve = onCurve;
        }

        public PointRec(GlyfSimple g, int idx) {
            this.x = g.getXCoord(idx);
            this.y = g.getYCoord(idx);
            this.onCurve = g.onCurve(idx);
        }
    }
}

