/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.font.AdobeCharNames;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.PDFGlyph;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TTFBasedFont
extends PDFFont {
    public static final int FONT_SIZE = 1;
    private static final TTFBasedFont NULL_FONT = new TTFBasedFont(null, null, null);
    private static final Object LOCK1 = new Object();
    private static Map<String, TTFBasedFont> fontcache = new HashMap<String, TTFBasedFont>();
    private int fontStyle = 0;
    private Font awtFont;

    private TTFBasedFont(@Nonnull String baseFont, @Nonnull PDFFontDescriptor descriptor, String encodingType) {
        super(baseFont, descriptor, encodingType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static TTFBasedFont getTTBasedFont(@Nonnull String baseFont, @Nonnull PDFFontDescriptor descriptor, String encodingType) {
        String fontName = baseFont.replace("#20", " ");
        int fontStyle = descriptor.calculateStyle();
        String key = fontName + "~" + fontStyle;
        Object object = LOCK1;
        synchronized (object) {
            TTFBasedFont ttbasedFont = fontcache.get(key);
            if (ttbasedFont != null) {
                if (!ttbasedFont.equals(NULL_FONT)) {
                    TTFBasedFont copy = new TTFBasedFont(ttbasedFont.getBaseFont(), ttbasedFont.getDescriptor(), encodingType);
                    copy.awtFont = ttbasedFont.awtFont;
                    copy.fontStyle = ttbasedFont.fontStyle;
                    copy.setParent(ttbasedFont.getParent());
                    copy.setExtraCharacters(ttbasedFont.getExtraCharacters());
                    copy.setSubtype(ttbasedFont.getSubtype());
                    copy.setCacheAccess(ttbasedFont.getCacheAccess());
                    copy.setEncoding(ttbasedFont.getEncoding());
                    Map<Character, PDFGlyph> sourceCache = ttbasedFont.getGlyphCache();
                    if (sourceCache.size() > 0) {
                        copy.getGlyphCache().putAll(sourceCache);
                    }
                    return copy;
                }
                return null;
            }
            Font awtfont = new Font(fontName, fontStyle, 1);
            if ((awtfont = TTFBasedFont.getAWTFontBasedOnPhysicalFont(awtfont, fontName, fontStyle, 1)) != null) {
                TTFBasedFont ttfBased = new TTFBasedFont(fontName, descriptor, encodingType);
                ttfBased.awtFont = awtfont;
                ttfBased.fontStyle = fontStyle;
                fontcache.put(key, ttfBased);
                return ttfBased;
            }
            fontcache.put(key, NULL_FONT);
            return null;
        }
    }

    @Override
    public PDFGlyph getGlyph(char src, String name, boolean isTwoByteChar) {
        Character ch;
        FontRenderContext frc = new FontRenderContext(null, true, true);
        char unicode = src;
        if (name != null && (ch = AdobeCharNames.getCharBasedOnAdobeName(name)) != null) {
            unicode = ch.charValue();
        }
        String str = Character.toString(unicode);
        Shape glyphShape = new TextLayout(str, this.getAWTFont(), frc).getOutline(null);
        Shape pdfshape = AffineTransform.getScaleInstance(1.0, -1.0).createTransformedShape(glyphShape);
        GeneralPath gp = new GeneralPath(pdfshape);
        double advanceX = this.getAWTFont().getStringBounds(str, frc).getWidth();
        float advanceX_fe = (float)advanceX / 1.0f;
        Point2D.Float advance = new Point2D.Float(advanceX_fe, 0.0f);
        PDFGlyph glyph = new PDFGlyph(src, name, gp, advance);
        return glyph;
    }

    @Override
    public int getStyle() {
        return this.fontStyle;
    }

    @Override
    public PDFFontToUnicodeMap getUnicodeMapping() {
        return null;
    }

    @Override
    public Font getAWTFont() {
        return this.awtFont;
    }

    @Nullable
    public static Font getAWTFontBasedOnPhysicalFont(Font awtfont, String fontName, int fontStyle, int fontSize) {
        if (awtfont.getFontName(Locale.ENGLISH).equals(fontName)) {
            return awtfont;
        }
        awtfont = new Font(fontName = fontName.replace(',', ' ').trim(), fontStyle, fontSize);
        if (awtfont.getFontName(Locale.ENGLISH).equals(fontName)) {
            return awtfont;
        }
        awtfont = new Font(fontName = fontName.replaceAll("([A-Z][a-z])", " $1").trim(), fontStyle, fontSize);
        if (awtfont.getFontName(Locale.ENGLISH).equals(fontName)) {
            return awtfont;
        }
        return null;
    }
}

