/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.PDFFile;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFTextFormat;
import com.inet.pdfview.command.PDFDrawTextCmd;
import com.inet.pdfview.command.PDFDrawTextCmds;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.AdobeCharacterCollection;
import com.inet.pdfview.font.BuiltinFont;
import com.inet.pdfview.font.CIDFontType0;
import com.inet.pdfview.font.CIDFontType0B;
import com.inet.pdfview.font.CIDFontType2;
import com.inet.pdfview.font.CharCharMap;
import com.inet.pdfview.font.ExtensionCharacterMap;
import com.inet.pdfview.font.NullFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontEncoding;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.PDFGlyph;
import com.inet.pdfview.font.TTFBasedFont;
import com.inet.pdfview.font.TTFFont;
import com.inet.pdfview.font.Type0Font;
import com.inet.pdfview.font.Type1CFont;
import com.inet.pdfview.font.Type1Font;
import com.inet.pdfview.font.Type3Font;
import com.inet.pdfview.font.otf.OTFFactory;
import com.inet.pdfview.font.otf.OTFPool;
import com.inet.pdfview.font.ttf.TrueTypeFont;
import com.inet.pdfview.font.ttf.cmap.CMap;
import com.inet.pdfview.font.ttf.table.CFFTable;
import com.inet.pdfview.font.ttf.table.CmapTable;
import com.inet.pdfview.font.ttf.table.GlyfTable;
import java.awt.Font;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class PDFFont {
    public static final boolean RETURN_ZERO_IF_NULL;
    public static final boolean RETURN_FFFF_IF_NULL;
    public static final boolean CHECK_ZERO;
    private static final boolean APPEND_NULL_GLYPH;
    private static final String ALLOW_MISSING_CHAR;
    private static final String ALLOW_ZERO_CHAR;
    private boolean tryAWT = true;
    private Subtype subtype;
    private String baseFont;
    private PDFFontEncoding encoding;
    private PDFFontDescriptor descriptor;
    private Map<Character, PDFGlyph> charCache;
    private PDFFont parent;
    private CacheAccess fontGenerationListener;
    private CharCharMap extraCharacters = null;
    private boolean loggedUnicodeMapUndefined;
    private boolean isSymbolic;
    protected boolean isVertical;
    protected String encodingType;
    private boolean hasValidMapping = true;

    public boolean isVertical() {
        return this.isVertical;
    }

    protected PDFFont(String baseFont, PDFFontDescriptor descriptor, String encodingType) {
        this.encodingType = encodingType;
        this.isVertical = encodingType != null && encodingType.endsWith("-V");
        this.descriptor = descriptor;
        this.setBaseFont(baseFont);
    }

    public static PDFFont getFont(PDFObject obj, PDFFont parent, Map<String, PDFObject> resources, PDFDecrypter decryptor, PDFFontToUnicodeMap ascendantUnicodeMap, CacheAccess fontGenerationListener, Type0Font ascenderFont) throws PDFParseException {
        Subtype type;
        PDFFont fontWithParent;
        HashMap<PDFFont, PDFFont> cacheMap = (HashMap<PDFFont, PDFFont>)obj.getCache();
        if (cacheMap != null && (fontWithParent = (PDFFont)cacheMap.get(parent)) != null) {
            return fontWithParent;
        }
        PDFFile owner = obj.getOwner();
        String baseFont = null;
        PDFFontEncoding encoding = null;
        PDFFontDescriptor descriptor = null;
        PDFFontToUnicodeMap toUnicodeMap = null;
        String typeString = obj.getDictRef("Subtype").getStringValue();
        if ("MMType1".equals(typeString)) {
            typeString = "Type1";
        }
        try {
            type = Subtype.valueOf(typeString);
        }
        catch (IllegalArgumentException e) {
            if (typeString.endsWith("Type")) {
                type = Subtype.TrueType;
            }
            throw new PDFParseException("Don't know how to handle a '" + typeString + "' font");
        }
        PDFObject baseFontObj = obj.getDictRef("BaseFont");
        PDFObject encodingObj = obj.getDictRef("Encoding");
        PDFObject descObj = obj.getDictRef("FontDescriptor");
        PDFObject toUnicodeObj = obj.getDictRef("ToUnicode");
        String encodingType = null;
        if (baseFontObj != null) {
            baseFont = baseFontObj.getStringValue();
        } else {
            baseFontObj = obj.getDictRef("Name");
            if (baseFontObj != null) {
                baseFont = baseFontObj.getStringValue();
            }
        }
        if (!(encodingObj == null || ascenderFont != null && ascenderFont.isIdentityEncoding())) {
            encodingType = encodingObj.getStringValue();
            encoding = new PDFFontEncoding(type, encodingObj, decryptor);
        }
        descriptor = descObj != null ? new PDFFontDescriptor(descObj) : new PDFFontDescriptor(baseFont);
        if (toUnicodeObj != null) {
            ExtensionCharacterMap extensionMap = encoding != null ? encoding.getIndirectUnicodeExtention() : null;
            toUnicodeMap = new PDFFontToUnicodeMap(toUnicodeObj, decryptor, extensionMap);
        }
        PDFFont font = null;
        try {
            switch (type) {
                case Type0: {
                    font = new Type0Font(baseFont, obj, descriptor, toUnicodeMap, decryptor, fontGenerationListener, encodingObj, encoding);
                    break;
                }
                case Type1: {
                    if (descriptor.getFontFile() != null) {
                        font = new Type1Font(baseFont, obj, descriptor, encodingType, toUnicodeMap, decryptor);
                        break;
                    }
                    if (descriptor.getFontFile3() != null) {
                        PDFObject dataObj = descriptor.getFontFile3();
                        byte[] data = dataObj.getStream(dataObj.getRefValue(), decryptor, true);
                        boolean isOTFont = PDFFont.checkOTF(data, dataObj.getDictRef("Subtype"));
                        if (isOTFont) {
                            TrueTypeFont ttFont = TrueTypeFont.parseFont(data, owner);
                            font = PDFFont.extractOTFFont(obj, baseFont, descriptor, toUnicodeMap, ttFont, type, encodingType);
                        }
                        if (font != null) break;
                        font = new Type1CFont(baseFont, obj, descriptor, encodingType, decryptor, toUnicodeMap);
                        if (!BuiltinFont.isDefaultFont(baseFont)) break;
                        String origFamily = BuiltinFont.resolveDefaultFontFamilyName(descriptor.getFontFamilyName());
                        BuiltinFont parentFont = new BuiltinFont(baseFont, obj, descriptor, toUnicodeMap, encodingType, false);
                        font.setParent(parentFont);
                        descriptor.setFontFamilyName(origFamily);
                        break;
                    }
                    font = OTFFactory.getInstance().getOTFFont(baseFont, obj, descriptor, decryptor, toUnicodeMap, encodingType);
                    if (font != null) break;
                    PDFObject charWidthsObj = obj.getDictRef("Widths");
                    boolean hasWidthsArr = charWidthsObj != null;
                    font = new BuiltinFont(baseFont, obj, descriptor, toUnicodeMap, encodingType, hasWidthsArr);
                    break;
                }
                case TrueType: {
                    if (descriptor.getFontFile2() != null) {
                        font = new TTFFont(baseFont, obj, descriptor, toUnicodeMap, decryptor, encodingType);
                    } else {
                        font = TTFBasedFont.getTTBasedFont(baseFont, descriptor, encodingType);
                        if (font == null) {
                            if (encoding != null) {
                                toUnicodeMap = null;
                            }
                            font = new BuiltinFont(baseFont, obj, descriptor, toUnicodeMap, encodingType, true);
                        }
                    }
                    int flags = descriptor.getFlags();
                    if ((flags & 4) == 0) break;
                    font.isSymbolic = true;
                    break;
                }
                case Type3: {
                    font = new Type3Font(baseFont, obj, resources, descriptor, toUnicodeMap, encodingType);
                    break;
                }
                case CIDFontType2: {
                    if (ascendantUnicodeMap == null) {
                        if (toUnicodeMap != null) {
                            ascendantUnicodeMap = toUnicodeMap;
                        } else {
                            ascendantUnicodeMap = PDFFont.buildUnicodeMap(obj);
                            if (ascenderFont == null) {
                                PDFParser.LOGGER.warn((Object)"missing parent font for CIDFontType2");
                            } else {
                                ascenderFont.setUnicodeMapping(ascendantUnicodeMap);
                            }
                        }
                    }
                    CIDFontType2 cidFont2 = new CIDFontType2(baseFont, obj, descriptor, decryptor, ascendantUnicodeMap, encodingType);
                    cidFont2.setParent(ascenderFont);
                    if (!cidFont2.checkType2()) {
                        boolean isIdentityEncoding = ascenderFont != null ? ascenderFont.isIdentityEncoding() : false;
                        TrueTypeFont ttFont = cidFont2.getTrueTypeFont();
                        font = PDFFont.extractOTFFont(obj, baseFont, descriptor, toUnicodeMap, ttFont, type, encodingType);
                        if (!(font instanceof CIDFontType0)) break;
                        PDFFont.setMixedFont((CIDFontType0)font, cidFont2, isIdentityEncoding, ascendantUnicodeMap);
                        font.setParent(ascenderFont);
                        break;
                    }
                    font = cidFont2;
                    break;
                }
                case CIDFontType0: {
                    PDFObject dataObj;
                    if (ascendantUnicodeMap == null) {
                        ascendantUnicodeMap = toUnicodeMap != null ? toUnicodeMap : PDFFont.buildUnicodeMap(obj);
                    }
                    if (ascenderFont == null) {
                        PDFParser.LOGGER.warn((Object)"missing parent font for CIDFontType0");
                    }
                    if ((dataObj = descriptor.getFontFile3()) == null) {
                        dataObj = descriptor.getFontFile2();
                    }
                    if (dataObj != null) {
                        PDFObject subtypeObj;
                        byte[] data = dataObj.getStream(dataObj.getRefValue(), decryptor, true);
                        boolean isOTFont = PDFFont.checkOTF(data, subtypeObj = dataObj.getDictRef("Subtype"));
                        if (isOTFont) {
                            TrueTypeFont ttFont = TrueTypeFont.parseFont(data, owner);
                            font = PDFFont.extractOTFFont(obj, baseFont, descriptor, toUnicodeMap, ttFont, type, encodingType);
                        }
                        if (font != null) break;
                        try {
                            font = new CIDFontType0(baseFont, obj, descriptor, encodingType, decryptor, ascendantUnicodeMap);
                        }
                        catch (Exception e) {
                            font = new CIDFontType2(baseFont, obj, descriptor, decryptor, ascendantUnicodeMap, encodingType);
                        }
                        break;
                    }
                    font = new CIDFontType0B(baseFont, obj, descriptor, ascendantUnicodeMap, encodingType);
                    PDFParser.LOGGER.warn((Object)("CID font '" + baseFont + "' is not embedded, using a standard font as fallback."));
                    break;
                }
                default: {
                    font = new CIDFontType2(baseFont, obj, descriptor, decryptor, ascendantUnicodeMap, encodingType);
                }
            }
            font.setSubtype(type);
            font.setEncoding(encoding);
        }
        catch (PDFParseException e) {
            PDFParser.LOGGER.warn((Object)("Parsing failed for font '" + baseFont + "'"));
            PDFParser.LOGGER.warn((Object)e);
            font = new NullFont(baseFont);
        }
        catch (RuntimeException e) {
            PDFParser.LOGGER.warn((Object)("Parsing failed for font '" + baseFont + "'"));
            PDFParser.LOGGER.warn((Object)e);
            font = new NullFont(baseFont);
        }
        if (!(toUnicodeMap == null || toUnicodeMap.isHasCmap() || toUnicodeMap.getMapCharCodeToUnicode() != null && toUnicodeMap.getMapCharCodeToUnicode().length != 0)) {
            font.setHasValidMapping(toUnicodeMap.isHasCmap());
        }
        font.setCacheAccess(fontGenerationListener);
        if (parent != null) {
            font.setParent(parent);
        }
        if (cacheMap == null) {
            cacheMap = new HashMap<PDFFont, PDFFont>();
            obj.setCache(cacheMap);
        }
        cacheMap.put(parent, font);
        return font;
    }

    @Nullable
    static PDFFont extractOTFFont(PDFObject obj, String baseFont, PDFFontDescriptor descriptor, PDFFontToUnicodeMap toUnicodeMap, TrueTypeFont ttFont, Subtype type, String encodingType) throws PDFParseException {
        Type1CFont font = null;
        CFFTable cffTable = ttFont.getCFFTable();
        if (cffTable != null) {
            ByteBuffer bb = cffTable.toByteBuffer();
            byte[] cffData = bb.array();
            switch (type) {
                case Type1: {
                    font = new Type1CFont(baseFont, obj, descriptor, encodingType, toUnicodeMap, cffData);
                    break;
                }
                case CIDFontType2: 
                case CIDFontType0: {
                    font = new CIDFontType0(baseFont, obj, descriptor, encodingType, toUnicodeMap, ArrayBuffer.wrap(bb.array()));
                    break;
                }
            }
        } else {
            GlyfTable glyphTable = ttFont.getGLYFTable();
            if (glyphTable != null) {
                PDFParser.LOGGER.warn((Object)("extractOTFFont with case " + type.toString() + " :   Truetype fonts are not expected here"));
            }
        }
        return font;
    }

    static boolean checkOTF(byte[] data, PDFObject subtypeObj) throws PDFParseException {
        int MARKER_SIZE = OTFPool.OTF_LABEL.length;
        if (data != null && data.length > MARKER_SIZE) {
            byte[] marker = new byte[4];
            System.arraycopy(data, 0, marker, 0, marker.length);
            if (Arrays.equals(marker, OTFPool.OTF_LABEL)) {
                String subtype;
                String string = subtype = subtypeObj != null ? subtypeObj.getStringValue() : null;
                if (!"OpenType".equals(subtype)) {
                    PDFParser.LOGGER.warn((Object)("incorrect font subtype for OTFont in Type1: " + subtype));
                }
                return true;
            }
        }
        return false;
    }

    public Subtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(Subtype subtype) {
        this.subtype = subtype;
    }

    public String getBaseFont() {
        return this.baseFont != null ? this.baseFont : "";
    }

    public boolean isValidMapping() {
        return this.hasValidMapping;
    }

    public void setBaseFont(String baseFont) {
        this.baseFont = baseFont;
    }

    public PDFFontEncoding getEncoding() {
        PDFFont parent;
        if (this.encoding == null && (parent = this.getParent()) instanceof Type0Font && !((Type0Font)parent).isIdentityEncoding()) {
            this.encoding = this.getParent().getEncoding();
        }
        return this.encoding;
    }

    public void setEncoding(PDFFontEncoding encoding) {
        this.encoding = encoding;
    }

    public PDFFontDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(PDFFontDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public List<PDFGlyph> getGlyphs(PDFTextFormat.TextWrapper textWrapper) {
        List<PDFGlyph> outList = null;
        PDFFontEncoding enc = this.getEncoding();
        if (this instanceof BuiltinFont) {
            enc = this.encoding;
        }
        outList = enc != null ? enc.getGlyphs(this, textWrapper) : this.getCachedGlyphs(textWrapper);
        return outList;
    }

    public List<PDFGlyph> getCachedGlyphs(PDFTextFormat.TextWrapper textWrapper) {
        ArrayList<PDFGlyph> outList = new ArrayList<PDFGlyph>();
        Map<Character, PDFGlyph> glyphCache = this.getGlyphCache();
        String text = textWrapper.getText();
        for (int i = 0; i < text.length(); ++i) {
            char src = text.charAt(i);
            Character c = Character.valueOf(src);
            PDFGlyph glyph = glyphCache.get(c);
            if (glyph == null) {
                glyph = this.getGlyph(src, null, false);
                glyphCache.put(c, glyph);
            }
            outList.add(glyph);
        }
        return outList;
    }

    public PDFGlyph getCachedGlyph(char src, String name, boolean isTwoByteChar) {
        Character c;
        Map<Character, PDFGlyph> glyphCache = this.getGlyphCache();
        PDFGlyph glyph = glyphCache.get(c = Character.valueOf(src));
        if (glyph == null) {
            glyph = this.getGlyph(src, name, isTwoByteChar);
            if ((glyph == null || glyph.getShape() == null && glyph.getPage() == null) && src != '\u0000') {
                return this.getCachedGlyph('\u0000', null, isTwoByteChar);
            }
            glyphCache.put(c, glyph);
        }
        return glyph;
    }

    public void clearCache() {
        this.charCache = null;
    }

    protected Map<Character, PDFGlyph> getGlyphCache() {
        if (this.charCache == null) {
            this.charCache = new HashMap<Character, PDFGlyph>();
        }
        return this.charCache;
    }

    public abstract PDFGlyph getGlyph(char var1, String var2, boolean var3);

    public String toString() {
        return this.getBaseFont();
    }

    public abstract int getStyle();

    public abstract PDFFontToUnicodeMap getUnicodeMapping();

    public void setParent(PDFFont parent) {
        if (this.parent != null && parent != this.parent) {
            PDFParser.LOGGER.warn((Object)("Parent font changed! " + String.valueOf(this.parent) + " -> " + String.valueOf(parent)));
        }
        this.parent = parent;
    }

    public char mapCharacter(char src, boolean forDrawString) {
        PDFFontToUnicodeMap map;
        if (forDrawString) {
            char character;
            CharCharMap extraCharacters;
            CharCharMap charCharMap = extraCharacters = this.getParent() == null ? this.getExtraCharacters() : this.getParent().getExtraCharacters();
            if (extraCharacters != null && (character = extraCharacters.get(src)) != '\uffff') {
                return character;
            }
        }
        if ((map = this.getUnicodeMapping()) != null) {
            StringBuilder sb = new StringBuilder();
            map.addUnicodeValues(src, sb, this);
            if (sb.length() == 1) {
                return sb.charAt(0);
            }
            return '\uffff';
        }
        if (this.encoding != null) {
            Character charFromEncoding = this.encoding.getCharFromEncoding(src);
            if (charFromEncoding != null) {
                return charFromEncoding.charValue();
            }
            if (RETURN_ZERO_IF_NULL) {
                return '\u0000';
            }
            if (RETURN_FFFF_IF_NULL) {
                return '\uffff';
            }
        }
        if (this.parent != null) {
            return this.parent.mapCharacter(src, forDrawString);
        }
        return src;
    }

    public abstract Font getAWTFont();

    public PDFDrawTextCmd.UnicodeConvertResult decodeText(String text, boolean isAlreadyTwoByte, boolean forDrawString) {
        CharCharMap extraCharacters;
        PDFFontToUnicodeMap map = this.getUnicodeMapping();
        if (map != null) {
            CharCharMap extraCharacters2 = null;
            if (forDrawString) {
                extraCharacters2 = this.getParent() == null ? this.getExtraCharacters() : this.getParent().getExtraCharacters();
            }
            return PDFDrawTextCmd.getUnicodeStringDiff(map, text, false, isAlreadyTwoByte, extraCharacters2, this);
        }
        CharCharMap charCharMap = extraCharacters = this.getParent() == null ? this.getExtraCharacters() : this.getParent().getExtraCharacters();
        if (extraCharacters == null && this.encoding == null) {
            this.logMapUnicodeUndefined();
            return new PDFDrawTextCmd.UnicodeConvertResult(text, null);
        }
        if (APPEND_NULL_GLYPH) {
            return new PDFDrawTextCmd.UnicodeConvertResult(this.mapExtraCharacters(text, forDrawString), null);
        }
        ArrayList<PDFDrawTextCmds.ContentModification> changes = null;
        StringBuilder sb = new StringBuilder();
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            char mapped = this.mapCharacter(c, forDrawString);
            if (mapped != '\uffff') {
                sb.append(mapped);
                continue;
            }
            if (changes == null) {
                changes = new ArrayList<PDFDrawTextCmds.ContentModification>();
            }
            changes.add(new PDFDrawTextCmds.ContentModification(i, 0));
        }
        return new PDFDrawTextCmd.UnicodeConvertResult(sb.toString(), changes);
    }

    public String mapExtraCharacters(String text, boolean forDrawString) {
        CharCharMap extraCharacters;
        CharCharMap charCharMap = extraCharacters = this.getParent() == null ? this.getExtraCharacters() : this.getParent().getExtraCharacters();
        if (extraCharacters == null && this.encoding == null) {
            return text;
        }
        StringBuilder sb = null;
        int start = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            char mapped = this.mapCharacter(c, forDrawString);
            if (mapped == c) continue;
            if (sb == null) {
                sb = new StringBuilder(text.length());
            }
            sb.append(text.substring(start, i));
            sb.append(mapped);
            start = i + 1;
        }
        if (sb != null) {
            if (start < text.length()) {
                sb.append(text.substring(start));
            }
            return sb.toString();
        }
        return text;
    }

    public CacheAccess getCacheAccess() {
        return this.fontGenerationListener;
    }

    public void setCacheAccess(CacheAccess fontGenerationListener) {
        this.fontGenerationListener = fontGenerationListener;
    }

    public PDFFont getParent() {
        return this.parent;
    }

    public CharCharMap getExtraCharacters() {
        return this.extraCharacters;
    }

    public void setExtraCharacters(CharCharMap extraCharacters) {
        this.extraCharacters = extraCharacters;
    }

    public void logMapUnicodeUndefined() {
        if (!this.loggedUnicodeMapUndefined) {
            PDFParser.LOGGER.warn((Object)("No unicode mapping is defined: text can not be recognized and the results can be incorrect for font " + this.baseFont));
            this.loggedUnicodeMapUndefined = true;
        }
    }

    @Nullable
    private static PDFFontToUnicodeMap buildUnicodeMap(@Nonnull PDFObject descendantFontObj) {
        try {
            PDFObject sinfo = descendantFontObj.getDictRef("CIDSystemInfo");
            if (sinfo != null) {
                PDFObject registry = sinfo.getDictRef("Registry");
                PDFObject ordering = sinfo.getDictRef("Ordering");
                PDFObject supplement = sinfo.getDictRef("Supplement");
                String charCollection = registry.getStringValue() + "-" + ordering.getStringValue() + "-" + supplement.getIntValue();
                AdobeCharacterCollection acc = AdobeCharacterCollection.fromName(charCollection);
                if (acc != null) {
                    return acc.getToUnicodeMap();
                }
            }
        }
        catch (PDFParseException ex) {
            PDFParser.LOGGER.error((Throwable)((Object)ex));
        }
        return null;
    }

    public boolean isTRY_AWT() {
        return this.tryAWT;
    }

    public void setTRY_AWT(boolean try_awt) {
        this.tryAWT = try_awt;
    }

    public boolean isSymbolic() {
        return this.isSymbolic;
    }

    protected void setHasValidMapping(boolean hasValidMapping) {
        this.hasValidMapping = hasValidMapping;
    }

    static void setMixedFont(CIDFontType0 font, CIDFontType2 cidFont2, boolean isIdentityEncoding, PDFFontToUnicodeMap toUnicodeMap) {
        boolean isCIDCFF = font.isCIDType1C();
        if (isIdentityEncoding && !isCIDCFF) {
            IDataBuffer cidToGidMap = cidFont2.getCidToGidMap();
            int[] srcToGlyph = null;
            if (cidToGidMap != null) {
                int cidArraySize = cidToGidMap.limit() / 2;
                srcToGlyph = new int[cidArraySize];
                int maxSource = 0;
                char maxGID = '\u0000';
                for (int i = 0; i < cidArraySize; ++i) {
                    char gid = cidToGidMap.getChar(2 * i);
                    srcToGlyph[i] = gid;
                    if (gid == '\u0000') continue;
                    if (i > maxSource) {
                        maxSource = i;
                    }
                    if (gid <= maxGID) continue;
                    maxGID = gid;
                }
                TrueTypeFont ttf = cidFont2.getTrueTypeFont();
                CmapTable cmap = ttf.getCMAPTable();
                CMap cmap3_1 = null;
                if (cmap != null && (cmap3_1 = cmap.getCMap((short)3, (short)1)) != null) {
                    for (int i = 0; i < cidArraySize; ++i) {
                        char unicode = (char)toUnicodeMap.getUnicodeValue(i);
                        char glyphIndex = cmap3_1.map(unicode);
                        int glyphID = srcToGlyph[i];
                        if ((glyphIndex == '\u0000' || glyphID != 0) && (glyphIndex != '\u0000' || glyphID == 0)) continue;
                        PDFParser.LOGGER.warn((Object)"cmap and CidToGid data are not conform");
                    }
                } else {
                    PDFParser.LOGGER.warn((Object)"test of CidToGid mapping is not possible because cmap is not available");
                }
                CIDFontType0 cidFont0 = font;
                cidFont0.setCidToGidMap(cidToGidMap);
            }
        }
    }

    static {
        boolean allowZeroChars;
        ALLOW_MISSING_CHAR = System.getProperty("allowmissingchar", "false");
        ALLOW_ZERO_CHAR = System.getProperty("allowzerochar", "false");
        boolean allowMissingChars = ALLOW_MISSING_CHAR.equals("true");
        boolean bl = allowZeroChars = allowMissingChars ? false : ALLOW_ZERO_CHAR.equals("true");
        if (allowMissingChars) {
            RETURN_ZERO_IF_NULL = false;
            RETURN_FFFF_IF_NULL = !RETURN_ZERO_IF_NULL;
            CHECK_ZERO = true;
            APPEND_NULL_GLYPH = true;
        } else if (allowZeroChars) {
            RETURN_ZERO_IF_NULL = true;
            RETURN_FFFF_IF_NULL = !RETURN_ZERO_IF_NULL;
            CHECK_ZERO = false;
            APPEND_NULL_GLYPH = false;
        } else {
            RETURN_ZERO_IF_NULL = false;
            RETURN_FFFF_IF_NULL = false;
            APPEND_NULL_GLYPH = false;
            CHECK_ZERO = true;
        }
    }

    public static enum Subtype {
        Type0,
        Type1,
        TrueType,
        Type3,
        CIDFontType2,
        CIDFontType0,
        None;

    }
}

