/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.PDFCIDMap;
import java.util.HashMap;

public abstract class PDFCMap {
    private static HashMap<String, PDFCMap> cache;

    protected PDFCMap() {
    }

    public static PDFCMap getCMap(PDFObject map, PDFDecrypter decryptor) throws PDFParseException {
        if (map.getType() == 4) {
            return PDFCMap.getCMap(map.getStringValue());
        }
        if (map.getType() == 7) {
            return PDFCMap.parseCMap(map, decryptor);
        }
        throw new PDFParseException("CMap type not Name or Stream!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static PDFCMap getCMap(String mapName) throws PDFParseException {
        if (cache == null) {
            Class<PDFCMap> clazz = PDFCMap.class;
            // MONITORENTER : com.inet.pdfview.font.PDFCMap.class
            if (cache == null) {
                PDFCMap.populateCache();
            }
            // MONITOREXIT : clazz
        }
        if (cache.containsKey(mapName)) return cache.get(mapName);
        return null;
    }

    protected static void populateCache() {
        cache = new HashMap();
        cache.put("Identity-H", new PDFCMap(){

            @Override
            public char map(char src) {
                return src;
            }
        });
    }

    protected static PDFCMap parseCMap(PDFObject map, PDFDecrypter decryptor) throws PDFParseException {
        return new PDFCIDMap(map, decryptor);
    }

    public abstract char map(char var1);

    public int getFontID(char src) {
        return 0;
    }
}

