/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.Logger;
import com.inet.pdfview.PDFFile;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFTextFormat;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.BuiltinFont;
import com.inet.pdfview.font.CIDFontType2;
import com.inet.pdfview.font.CharCharMap;
import com.inet.pdfview.font.FontCache;
import com.inet.pdfview.font.FontFactory;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.PDFGlyph;
import com.inet.pdfview.font.ttf.TTFUnit;
import com.inet.pdfview.font.ttf.TrueTypeFont;
import com.inet.pdfview.font.ttf.cmap.CMapFormat4;
import com.inet.pdfview.font.ttf.glyph.GlyfConversionMap;
import com.inet.pdfview.font.ttf.glyph.GlyfSimpleDyn;
import com.inet.pdfview.font.ttf.table.CmapTable;
import com.inet.pdfview.font.ttf.table.GlyfTable;
import com.inet.pdfview.font.ttf.table.HeadTable;
import com.inet.pdfview.font.ttf.table.HheaTable;
import com.inet.pdfview.font.ttf.table.HmtxTable;
import com.inet.pdfview.font.ttf.table.LocaTable;
import com.inet.pdfview.font.ttf.table.MaxpTable;
import com.inet.pdfview.font.ttf.table.NameTable;
import com.inet.pdfview.font.ttf.table.OS2Table;
import com.inet.pdfview.font.ttf.table.PostTable;
import com.inet.plugin.ServerPluginManager;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.SuppressFBWarnings;

public abstract class OutlineFont
extends PDFFont {
    protected static final File DUMP_FONT_PATH;
    private boolean saveAWT = true;
    private final PDFFile owner;
    private static int MAX_BASENAME_LENGTH_FOR_EXPORT;
    private int firstChar = -1;
    private int lastChar = -1;
    private float[] widths;
    private Font font;
    private boolean created;
    private boolean isGeneratingAWT;
    private boolean checkUnicodeMappingErrorIssued;

    public OutlineFont(String baseFont, PDFObject fontObj, PDFFontDescriptor descriptor, String encodingType) throws PDFParseException {
        super(baseFont, descriptor, encodingType);
        PDFObject firstCharObj = fontObj.getDictRef("FirstChar");
        PDFObject lastCharObj = fontObj.getDictRef("LastChar");
        PDFObject widthArrayObj = fontObj.getDictRef("Widths");
        if (firstCharObj != null) {
            this.firstChar = firstCharObj.getIntValue();
        }
        if (lastCharObj != null) {
            this.lastChar = lastCharObj.getIntValue();
        }
        if (widthArrayObj != null) {
            PDFObject[] widthArray = widthArrayObj.getArray();
            this.widths = new float[widthArray.length];
            for (int i = 0; i < widthArray.length; ++i) {
                this.widths[i] = widthArray[i].getFloatValue() / (float)this.getDefaultWidth();
            }
        }
        this.owner = fontObj.getOwner();
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public int getDefaultWidth() {
        return 1000;
    }

    public float getWidth(char code, String name) {
        int idx = (code & 0xFF) - this.getFirstChar();
        if (idx < 0 || this.widths == null || idx >= this.widths.length) {
            if (this.getDescriptor() != null && this.getDefaultWidth() != 0) {
                return (float)this.getDescriptor().getMissingWidth() / (float)this.getDefaultWidth();
            }
            return 0.0f;
        }
        return this.widths[idx];
    }

    @Override
    public PDFGlyph getGlyph(char src, String name, boolean isTwoByteChars) {
        GeneralPath outline = null;
        float width = this.getWidth(src, name);
        if (name != null && !this.isSymbolic()) {
            outline = this.getOutline(name, width);
        }
        if (outline == null) {
            CIDFontType2 ttfont;
            if (this instanceof CIDFontType2 && (ttfont = (CIDFontType2)this).getNativeFont() == null) {
                outline = ttfont.getGlyphFromJavaFont(src, isTwoByteChars);
            }
            if (outline == null) {
                outline = this.getOutline(src, width);
            }
        }
        Point2D.Float advance = new Point2D.Float(width, 0.0f);
        return new PDFGlyph(src, name, outline, advance);
    }

    protected abstract GeneralPath getOutline(String var1, float var2);

    protected abstract GeneralPath getOutline(char var1, float var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Font getAWTFont() {
        OutlineFont outlineFont = this;
        synchronized (outlineFont) {
            Font awtFont = this.font;
            if (!this.created) {
                try {
                    this.setIsGeneratingAWT(true);
                    awtFont = this.createFont();
                }
                catch (IOException e) {
                    PDFParser.LOGGER.warn((Object)("Font generating failure " + this.getBaseFont()));
                    PDFParser.LOGGER.warn((Object)e);
                }
                catch (FontFormatException e) {
                    PDFParser.LOGGER.warn((Object)("Font generating failure " + this.getBaseFont()));
                    PDFParser.LOGGER.warn((Object)e);
                }
                this.created = true;
                if (this.saveAWT) {
                    this.font = awtFont;
                } else {
                    this.saveAWT = true;
                }
            }
            this.setIsGeneratingAWT(false);
            return awtFont;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path is check")
    protected final Font createFont() throws IOException, FontFormatException {
        PDFFontDescriptor descr;
        PDFFont.Subtype subtype;
        PDFFont.Subtype parentType;
        PDFFont parent = this.getParent();
        if (parent != null && (parentType = parent.getSubtype()) == PDFFont.Subtype.Type0 && (subtype = this.getSubtype()) == PDFFont.Subtype.CIDFontType0 && (descr = this.getDescriptor()) != null && descr.getFontFile() == null && descr.getFontFile3() == null) {
            String fontName = null;
            int flags = descr.getFlags();
            fontName = (flags & 1) != 0 ? "Monospaced" : ((flags & 2) != 0 ? "Serif" : "SansSerif");
            return new Font(fontName, this.getStyle(), 1);
        }
        Logger logger = PDFParser.LOGGER;
        this.checkUnicodeMapping();
        int firstChar = this.getFirstCharForFontExportToTrueType();
        int lastChar = this.getLastCharForFontExportToTrueType();
        if (lastChar == 0 || lastChar < firstChar || firstChar == 65535) {
            firstChar = 0;
            lastChar = 65535;
        }
        if (lastChar == 65535 && logger.isDebug()) {
            logger.debug((Object)("First Char/Last Char not available for font " + this.getBaseFont() + ". Checking all Character-Codes. This can be very slow!"));
        }
        GlyfConversionMap glyfMap = new GlyfConversionMap();
        int nameHashCode = 0;
        for (int glyphInt = firstChar; glyphInt <= lastChar; ++glyphInt) {
            GeneralPath gp;
            PDFGlyph sourceGlyph;
            char glyphId = (char)glyphInt;
            char unicode = this.mapCharacter(glyphId, true);
            nameHashCode = (nameHashCode * 31 + glyphId) * 31 + unicode;
            if (unicode == '\uffff' || unicode == '\u0000' && glyphId != '\u0000' || (sourceGlyph = this.getGlyphForFontExportToTrueType(glyphId)) == null || (gp = sourceGlyph.getShape()) == null) continue;
            double advanceX = sourceGlyph.getAdvance().getX();
            if (advanceX == 0.0 && gp.getBounds().getWidth() > 0.0 && parent instanceof BuiltinFont) {
                advanceX = ((OutlineFont)parent).getWidth(unicode, sourceGlyph.getName());
            }
            nameHashCode += (int)(advanceX * 100.0 * 31.0);
            glyfMap.add(unicode, gp, advanceX);
        }
        this.clearCache();
        boolean addedMissing = glyfMap.ensureMissingCharExists();
        int idDelta = 0;
        char firstCharIndex = '\u0000';
        int lastCharIndex = -1;
        HmtxTable hmtxTable = new HmtxTable(glyfMap.size());
        LocaTable locaTable = new LocaTable(glyfMap.size(), true);
        GlyfTable glyfTable = new GlyfTable(locaTable, glyfMap.size());
        int glyphId = 0;
        CMapFormat4 cmap = new CMapFormat4(0);
        TreeMap<Character, char[]> cmapAddition = null;
        CharCharMap mapped = this.getParent() != null ? this.getParent().getExtraCharacters() : this.getExtraCharacters();
        PDFFontToUnicodeMap unicodeMap = this.getUnicodeMapping();
        if (mapped != null && mapped.size() > 0) {
            CharCharMap reverseMap = new CharCharMap(mapped.size(), 1.0f);
            char[] keys = mapped.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                char key = keys[i];
                char value = mapped.getValues()[i];
                if (value == '\uffff') continue;
                reverseMap.put(value, key);
            }
            mapped = reverseMap;
        }
        int startCode = -1;
        long totalXWidth = 0L;
        int nonZeroWidthGlyhes = 0;
        short minRSB = Short.MAX_VALUE;
        for (Map.Entry<Character, GlyfSimpleDyn> en : glyfMap.entrySet()) {
            char key;
            char value;
            GlyfSimpleDyn glyph = en.getValue();
            char code = en.getKey().charValue();
            int curIdDelta = code - lastCharIndex - 1;
            if (mapped != null && mapped.size() > 0 && (value = mapped.get(key = en.getKey().charValue())) != '\uffff') {
                Character gID = Character.valueOf((char)glyphId);
                if (cmapAddition == null) {
                    cmapAddition = new TreeMap<Character, char[]>();
                }
                if (unicodeMap != null && unicodeMap.getUnicodeValue(value) >= 65536) {
                    StringBuilder chars = new StringBuilder();
                    unicodeMap.addUnicodeValues(value, chars, this);
                    cmapAddition.put(gID, chars.toString().toCharArray());
                } else {
                    cmapAddition.put(gID, new char[]{value});
                }
            }
            if (curIdDelta != 0 && startCode != -1) {
                cmap.insertSegment((short)startCode, (short)lastCharIndex, (short)idDelta);
                startCode = -1;
            }
            idDelta -= curIdDelta;
            if (code > '\u0000' && firstCharIndex == '\u0000') {
                firstCharIndex = code;
            }
            if (startCode == -1) {
                startCode = code;
            }
            lastCharIndex = code;
            glyfTable.setGlyph(glyphId, glyph);
            short advance = TTFUnit.toUnits(glyph.getAdvanceWidth());
            hmtxTable.setAdvanceWidth(glyphId, advance);
            hmtxTable.setLeftSideBearing(glyphId, glyph.getMinX());
            if (advance > 0) {
                ++nonZeroWidthGlyhes;
                totalXWidth += (long)advance;
            }
            minRSB = (short)Math.min(minRSB, advance - glyph.getMaxX());
            ++glyphId;
        }
        if (startCode != -1) {
            cmap.insertSegment((short)startCode, (short)lastCharIndex, (short)idDelta);
        }
        HeadTable headTable = new HeadTable();
        headTable.setFontRevision(65536);
        headTable.setUnitsPerEm((short)4096);
        headTable.setXMin((short)glyfMap.getXMin());
        headTable.setYMin((short)glyfMap.getYMin());
        headTable.setXMax((short)glyfMap.getXMax());
        headTable.setYMax((short)glyfMap.getYMax());
        headTable.setIndexToLocFormat((short)1);
        headTable.setLowestRecPPem((short)8);
        if (this.getStyle() > 0) {
            headTable.setMacStyle((short)this.getStyle());
        }
        HheaTable hheaTable = new HheaTable();
        hheaTable.setNumOfLongHorMetrics((short)glyphId);
        hheaTable.setAdvanceWidthMax(TTFUnit.toUnits(glyfMap.getMaxAdvanceWidth()));
        float ascend = this.getAscent();
        hheaTable.setAscent((short)(ascend == 0.0f ? glyfMap.getYMax() : (int)TTFUnit.toUnits(ascend)));
        hheaTable.setDescent((short)(this.getDescent() == 0.0f ? glyfMap.getYMin() : (int)TTFUnit.toUnits(this.getDescent())));
        hheaTable.setCaretSlopeRise((short)1);
        hheaTable.setXMaxExtent((short)glyfMap.getXMax());
        hheaTable.setMinLeftSideBearing((short)glyfMap.getXMin());
        hheaTable.setMinRightSideBearing(minRSB);
        MaxpTable maxpTable = new MaxpTable();
        maxpTable.setNumGlyphs((short)glyphId);
        maxpTable.setMaxPoints((short)glyfMap.getMaxPointNum());
        maxpTable.setMaxContours((short)glyfMap.getMaxContourNum());
        nameHashCode = nameHashCode * 31 + glyfMap.getHashCode();
        String baseFontName = this.getBaseFont();
        int plusIdx = baseFontName.indexOf(43);
        if (plusIdx > -1 && plusIdx < baseFontName.length() - 1) {
            baseFontName = baseFontName.substring(plusIdx + 1);
        }
        if (baseFontName.length() > MAX_BASENAME_LENGTH_FOR_EXPORT) {
            nameHashCode = nameHashCode * 31 ^ baseFontName.hashCode();
            baseFontName = baseFontName.substring(0, MAX_BASENAME_LENGTH_FOR_EXPORT);
        }
        String fontName = baseFontName + "_" + Integer.toHexString(nameHashCode);
        FontCache fontCache = this.owner.getFontCache();
        synchronized (fontCache) {
            Font recent = this.owner.getFontCache().get(fontName);
            if (recent != null) {
                return recent;
            }
            NameTable nameTable = new NameTable();
            for (short platform : new short[]{3, 1}) {
                short plSpec = platform == 3 ? (short)1 : 0;
                short lang = platform == 3 ? (short)1033 : 0;
                block15: for (short i = 0; i <= 14; i = (short)(i + 1)) {
                    switch (i) {
                        case 2: {
                            nameTable.addRecord(platform, plSpec, lang, i, "Regular");
                            continue block15;
                        }
                        case 5: {
                            nameTable.addRecord(platform, plSpec, lang, i, "Version 1.0000");
                            continue block15;
                        }
                        default: {
                            nameTable.addRecord(platform, plSpec, lang, i, fontName);
                        }
                    }
                }
            }
            PostTable postTable = new PostTable();
            if (glyphId <= 2) {
                postTable.setIsFixedPitch(hmtxTable.getAdvance(1));
            }
            OS2Table os2Table = new OS2Table();
            os2Table.setUsWinAscent(Math.max(hheaTable.getAscent(), 1024));
            os2Table.setUsWinDescent(-hheaTable.getDescent());
            os2Table.setsTypoAscender(hheaTable.getAscent());
            os2Table.setsTypoDescender(-hheaTable.getDescent());
            os2Table.setsTypoLineGap(hheaTable.getLineGap());
            os2Table.setxAvgCharWidth((short)(totalXWidth / (long)Math.max(nonZeroWidthGlyhes, 1)));
            os2Table.setUsFirstCharIndex(firstCharIndex);
            os2Table.setUsLastCharIndex(lastCharIndex);
            if (lastCharIndex != 65535) {
                cmap.insertSegment((short)-1, (short)-1, (short)1);
            }
            CmapTable cmapTable = new CmapTable();
            cmapTable.addCMap((short)3, (short)1, cmap);
            TrueTypeFont generatedFont = new TrueTypeFont(this.owner);
            generatedFont.addTable(headTable);
            generatedFont.addTable(hmtxTable);
            generatedFont.addTable(nameTable);
            generatedFont.addTable(cmapTable);
            generatedFont.addTable(hheaTable);
            generatedFont.addTable(glyfTable);
            generatedFont.addTable(locaTable);
            generatedFont.addTable(maxpTable);
            generatedFont.addTable(postTable);
            generatedFont.addTable(os2Table);
            byte[] ttfGen = generatedFont.writeFont();
            try {
                FontFactory fontFactory = (FontFactory)ServerPluginManager.getInstance().getSingleInstance(FontFactory.class);
                this.font = fontFactory.createFont(ttfGen);
            }
            catch (IllegalStateException e) {
                this.font = Font.createFont(0, (InputStream)new FastByteArrayInputStream(ttfGen));
            }
            if (this.getCacheAccess() != null) {
                this.getCacheAccess().fontGenerated(this.font, ttfGen, cmapAddition);
            }
            if (DUMP_FONT_PATH != null) {
                if (IOFunctions.isPathTraversal((String)fontName)) {
                    throw new IOException("Bad font in pdf file");
                }
                File dumpFile = new File(DUMP_FONT_PATH, "created_" + fontName + ".ttf");
                if (logger.isDebug()) {
                    logger.debug((Object)("Create font '" + fontName + "'"));
                    logger.debug((Object)("Missing char added: " + addedMissing));
                    logger.debug((Object)("HEAD: " + String.valueOf(headTable)));
                    logger.debug((Object)("HTMX: " + String.valueOf(hmtxTable)));
                    logger.debug((Object)("CMAP: " + String.valueOf(cmapTable)));
                    logger.debug((Object)("HHEA: " + String.valueOf(hheaTable)));
                    logger.debug((Object)("GLYF: " + String.valueOf(glyfTable)));
                    logger.debug((Object)("LOCA: " + String.valueOf(locaTable)));
                    logger.debug((Object)("MAXP: " + String.valueOf(maxpTable)));
                    logger.debug((Object)("POST: " + String.valueOf(postTable)));
                    logger.debug((Object)("OS2: " + String.valueOf(os2Table)));
                    logger.debug((Object)("OutlineFont.createFont() " + String.valueOf(this.getDescriptor().getFontFile2()) + " (" + String.valueOf(this.getClass()) + ", " + glyfMap.entrySet().size() + " glyphes) , SAVED AS " + String.valueOf(dumpFile)));
                }
                try {
                    FileOutputStream out = new FileOutputStream(dumpFile);
                    out.write(ttfGen);
                    out.close();
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                }
            }
            if (this.getCacheAccess() != null) {
                this.owner.getFontCache().put(fontName, this.font);
            }
        }
        return this.font;
    }

    public PDFGlyph getGlyphForFontExportToTrueType(char src) {
        List<PDFGlyph> glyphs2 = this.getGlyphs(new PDFTextFormat.TextWrapper("" + src, true, null));
        if (glyphs2.isEmpty()) {
            return null;
        }
        if (glyphs2.size() > 1) {
            PDFParser.LOGGER.error((Object)("More than one glyph returned for one char:" + src));
        }
        return glyphs2.get(0);
    }

    public int getFirstCharForFontExportToTrueType() {
        int result = -1;
        result = (char)this.getFirstChar();
        if (result > 0 && result <= this.getLastChar() && result < 65535) {
            if (this.getUnicodeMapping() != null && this.getUnicodeMapping().getMinChar() < result && this.getUnicodeMapping().getMinChar() > 0) {
                result = this.getUnicodeMapping().getMinChar();
            }
            return result;
        }
        if (this.getEncoding() != null) {
            if (this.getEncoding().getType() == 0) {
                return 0;
            }
        } else if (this.getUnicodeMapping() != null) {
            result = this.getUnicodeMapping().getMinChar();
            if (result != -1) {
                return result;
            }
        } else {
            return this.getDefaultFirstChar();
        }
        return 0;
    }

    protected int getDefaultFirstChar() {
        return 0;
    }

    public int getLastCharForFontExportToTrueType() {
        if (this.getEncoding() != null && this.getEncoding().getType() == 0) {
            return 255;
        }
        if (this.getUnicodeMapping() != null && this.getUnicodeMapping().getMaxChar() != -1) {
            return this.getUnicodeMapping().getMaxChar();
        }
        char result = (char)this.getLastChar();
        if (result > '\u0000' && result >= this.getFirstChar() && result < '\uffff') {
            return result;
        }
        return this.getDefaultLastChar();
    }

    public float getAscent() {
        float designAscend;
        PDFFontDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 == null || descriptor2.getAscent() == 0) {
            if (this.isGeneratingAWT) {
                return 0.0f;
            }
            Font awtFont = this.getAWTFont();
            if (awtFont == null) {
                awtFont = new Font(this.getBaseFont(), 0, 1);
            }
            FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(awtFont.deriveFont(200.0f));
            designAscend = (float)metrics.getMaxAscent() / 200.0f;
        } else {
            designAscend = (float)descriptor2.getAscent() / 1000.0f;
        }
        return designAscend;
    }

    public float getDescent() {
        PDFFontDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 == null) {
            return 0.0f;
        }
        return (float)descriptor2.getDescent() / 1000.0f;
    }

    protected int getDefaultLastChar() {
        return 255;
    }

    protected void checkUnicodeMapping() {
        int first = this.getFirstCharForFontExportToTrueType();
        int last = this.getLastCharForFontExportToTrueType();
        LinkedHashSet<PDFGlyph> missingGlyphs = new LinkedHashSet<PDFGlyph>();
        CharCharMap usedUnicodes = new CharCharMap();
        for (int glyph = first; glyph <= last; ++glyph) {
            boolean isOverlayChar;
            char unicode = this.mapCharacter((char)glyph, true);
            boolean isWhitespace = PDFTextFormat.isWhiteSpaceChar(unicode);
            boolean bl = isOverlayChar = unicode >= '\u0e31' && unicode <= '\u0e3a' || unicode >= '\u0e47' && unicode <= '\u0e4e';
            if ((unicode == '\uffff' || unicode == '\u0000' || isWhitespace || isOverlayChar || usedUnicodes.contains(unicode)) && glyph != 0) {
                PDFGlyph glyphData = this.getGlyphForFontExportToTrueType((char)glyph);
                if (glyphData == null || glyphData.getShape() == null || !isWhitespace && glyphData.getShape().getPathIterator(null).isDone()) continue;
                missingGlyphs.add(glyphData);
                continue;
            }
            usedUnicodes.put(unicode, unicode);
        }
        if (!missingGlyphs.isEmpty()) {
            CharCharMap extraCharacters = new CharCharMap();
            char mappedUnicode = '\ue000';
            block1: for (PDFGlyph pdfGlyph : missingGlyphs) {
                char glyphChar = pdfGlyph.getChar();
                while (mappedUnicode < '\uffff') {
                    if (!usedUnicodes.contains(mappedUnicode)) {
                        extraCharacters.put(glyphChar, mappedUnicode);
                        usedUnicodes.put(mappedUnicode, mappedUnicode);
                        mappedUnicode = (char)(mappedUnicode + '\u0001');
                        continue block1;
                    }
                    mappedUnicode = (char)(mappedUnicode + '\u0001');
                }
            }
            if (this.getParent() == null) {
                this.setExtraCharacters(extraCharacters);
            } else {
                this.getParent().setExtraCharacters(extraCharacters);
            }
        }
    }

    @Override
    public void setParent(PDFFont parent) {
        if (this.getParent() != null) {
            PDFParser.LOGGER.debug((Object)("Parent font changed, was:" + String.valueOf(this.getParent()) + ". now:" + String.valueOf(parent) + " - this may result in incorrectly rendered text"));
            this.created = false;
            this.font = null;
        }
        super.setParent(parent);
    }

    public void refreshAWTFont() {
        this.created = false;
        this.saveAWT = false;
    }

    public void setIsGeneratingAWT(boolean b) {
        this.isGeneratingAWT = b;
    }

    public boolean isGeneratingAWT() {
        return this.isGeneratingAWT;
    }

    public void setCheckUnicodeMappingErrorIssued() {
        this.checkUnicodeMappingErrorIssued = true;
    }

    public boolean isCheckUnicodeMappingErrorIssued() {
        return this.checkUnicodeMappingErrorIssued;
    }

    protected int getStyleFromName(String name) {
        String nameLC;
        int style = 0;
        if (name.endsWith("MT")) {
            name = name.substring(0, name.length() - 2);
        }
        if (name.endsWith("PS")) {
            name = name.substring(0, name.length() - 2);
        }
        if ((nameLC = name.toLowerCase()).contains("-bold") || nameLC.endsWith("bold")) {
            style |= 1;
        }
        if (nameLC.contains("-italic") || nameLC.endsWith("italic") || nameLC.endsWith("ita") || nameLC.contains("-oblique") || nameLC.endsWith("oblique")) {
            style |= 2;
        }
        return style;
    }

    static {
        String debug = null;
        try {
            debug = System.getProperty("dumpFontPath");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (debug == null) {
            DUMP_FONT_PATH = null;
        } else {
            DUMP_FONT_PATH = new File(debug);
            DUMP_FONT_PATH.mkdirs();
        }
        MAX_BASENAME_LENGTH_FOR_EXPORT = 20;
    }
}

