/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFParser;
import com.inet.pdfview.font.AdobeCharNames;
import com.inet.pdfview.font.FontSupport;
import com.inet.pdfview.font.ICharMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LatinCharMapper
implements ICharMapper {
    private int[] srcCodeToCharIndex;
    private List<Character> missingCode;
    private final int size;
    private Map<String, Character> nameToSrcCode;

    LatinCharMapper(int[] srcCodeToCharIndex) {
        this.srcCodeToCharIndex = srcCodeToCharIndex;
        this.size = srcCodeToCharIndex.length;
    }

    @Override
    public String getCharName(char src) {
        if (src >= this.size) {
            return null;
        }
        int charID = this.srcCodeToCharIndex[src];
        String charName = FontSupport.getName(charID);
        return charName;
    }

    @Override
    public int getUnicodeValue(char src) {
        if (src >= this.size) {
            return 0;
        }
        String adobeName = this.getCharName(src);
        Character chr = AdobeCharNames.getCharBasedOnAdobeName(adobeName);
        if (chr == null) {
            if (this.missingCode == null) {
                this.missingCode = new ArrayList<Character>();
            }
            if (!this.missingCode.contains(Character.valueOf(src))) {
                this.missingCode.add(Character.valueOf(src));
                PDFParser.LOGGER.warn((Object)("src=0x" + Integer.toHexString(src) + " is not contained in encoding"));
            }
            return 0;
        }
        return chr.charValue();
    }

    @Override
    public char getCharCode(String charName) {
        Character srcCode;
        if (this.nameToSrcCode == null) {
            this.nameToSrcCode = new HashMap<String, Character>();
            for (char src = '\u0000'; src < this.srcCodeToCharIndex.length; src = (char)(src + '\u0001')) {
                int charID = this.srcCodeToCharIndex[src];
                String chName = FontSupport.getName(charID);
                this.nameToSrcCode.put(chName, Character.valueOf(src));
            }
        }
        if ((srcCode = this.nameToSrcCode.get(charName)) != null) {
            return srcCode.charValue();
        }
        return '\u0000';
    }
}

