/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFParser;
import com.inet.pdfview.font.ICharMapper;
import com.inet.pdfview.font.LatinCharMapper;
import com.inet.pdfview.font.SymbolCharMapper;
import com.inet.pdfview.font.ZapfDingbatsCharMapper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class FontSupport {
    public static final String CHAR_NOT_DEFINED = ".notdef";
    public static final String[] stdNames = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold", "Euro"};
    static final String[] stdValues = new String[]{"", " ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", "\u00a1", "\u00a2", "\u00a3", "/fraction", "\u00a5", "Fflorin", "\u00a7", "\u00a4", "\u00b4quotesingle", "\u201c", "?guillemotleft", "\u2039", "\u203a", "fi", "fl", "--", "\u2020", "\u2021", "\u00b7", "\u00b6", "\u2022", "'quotesinglbase", "\"quotedblbase", "\"quotedblright", "?guillemotright", "...ellipsis", "%perthousand", "?questiondown", "`grave", "'acute", "^circumflex", "~tilde", "-macron", "?breve", "?dotaccent", "?dieresis", "oring", "ccedilla", ":hungarumlaut", "?ogonek", ",caron", "---emdash", "AE", "aordfeminine", "LLslash", "OOslash", "OE", "oordmasculine", "ae", "idotlessi", "llslash", "ooslash", "oe", "Bgermandbls", "1onesuperior", "~logicalnot", "?mu", "(TM)trademark", "?Eth", "1/2", "+/-", "?Thorn", "1/4", "/divide", "|brokenbar", "*degree", "?thorn", "3/4", "2twosuperior", "(R)", "-minus", "?eth", "*multiply", "3threesuperior", "(C)", "AAacute", "AAcircumflex", "AAdieresis", "AAgrave", "AAring", "AAtilde", "CCcedilla", "EEacute", "EEcircumflex", "EEdieresis", "EEgrave", "IIacute", "IIcircumflex", "IIdieresis", "IIgrave", "NNtilde", "OOacute", "OOcircumflex", "OOdieresis", "OOgrave", "OOtilde", "SScaron", "UUacute", "UUcircumflex", "UUdieresis", "UUgrave", "YYacute", "YYdieresis", "ZZcaron", "aaacute", "aacircumflex", "aadieresis", "aagrave", "aaring", "aatilde", "cccedilla", "eeacute", "eecircumflex", "eedieresis", "eegrave", "iiacute", "iicircumflex", "iidieresis", "iigrave", "nntilde", "ooacute", "oocircumflex", "oodieresis", "oograve", "ootilde", "sscaron", "uuacute", "uucircumflex", "uudieresis", "uugrave", "yyacute", "yydieresis", "zzcaron", "!exclamsmall", "?Hungarumlautsmall", "$dollaroldstyle", "$dollarsuperior", "&ampersandsmall", "'Acutesmall", "/parenleftsuperior", "\\parenrightsuperior", "?twodotenleader", "?onedotenleader", "0zerooldstyle", "1oneoldstyle", "2twooldstyle", "3threeoldstyle", "4fouroldstyle", "5fiveoldstyle", "6sixoldstyle", "7sevenoldstyle", "8eightoldstyle", "9nineoldstyle", "'commasuperior", "--threequartersemdash", ".periodsuperior", "?questionsmall", "aasuperior", "bbsuperior", "ccentsuperior", "ddsuperior", "eesuperior", "iisuperior", "llsuperior", "mmsuperior", "nnsuperior", "oosuperior", "rrsuperior", "sssuperior", "ttsuperior", "ff", "ffi", "ffl", "\\parenleftinferior", "/parenrightinferior", "^Circumflexsmall", "-hyphensuperior", "`Gravesmall", "AAsmall", "BBsmall", "CCsmall", "DDsmall", "EEsmall", "FFsmall", "GGsmall", "HHsmall", "IIsmall", "JJsmall", "KKsmall", "LLsmall", "MMsmall", "NNsmall", "OOsmall", "PPsmall", "QQsmall", "RRsmall", "SSsmall", "TTsmall", "UUsmall", "VVsmall", "WWsmall", "XXsmall", "YYsmall", "ZZsmall", ":colonmonetary", "1onefitted", "?rupiah", "~Tildesmall", "!exclamdownsmall", "ccentoldstyle", "LLslashsmall", "SScaronsmall", "ZZcaronsmall", "?Dieresissmall", "?Brevesmall", "^Caronsmall", "?Dotaccentsmall", "?Macronsmall", "--figuredash", "-hypheninferior", "?Ogoneksmall", "oRingsmall", ",Cedillasmall", "?questiondownsmall", "1/8oneeighth", "3/8threeeighths", "5/8fiveeighths", "7/8seveneighths", "1/3onethird", "2/3twothirds", "0zerosuperior", "4foursuperior", "5fivesuperior", "6sixsuperior", "7sevensuperior", "8eightsuperior", "9ninesuperior", "0zeroinferior", "1oneinferior", "2twoinferior", "3threeinferior", "4fourinferior", "5fiveinferior", "6sixinferior", "7seveninferior", "8eightinferior", "9nineinferior", "ccentinferior", "$dollarinferior", ".periodinferior", ",commainferior", "AAgravesmall", "AAacutesmall", "AAcircumflexsmall", "AAtildesmall", "AAdieresissmall", "AAringsmall", "AEAEsmall", "CCcedillasmall", "EEgravesmall", "EEacutesmall", "EEcircumflexsmall", "EEdieresissmall", "IIgravesmall", "IIacutesmall", "IIcircumflexsmall", "IIdieresissmall", "EthEthsmall", "NNtildesmall", "OOgravesmall", "OOacutesmall", "OOcircumflexsmall", "OOtildesmall", "OOdieresissmall", "OEOEsmall", "OOslashsmall", "UUgravesmall", "UUacutesmall", "UUcircumflexsmall", "UUdieresissmall", "YYacutesmall", "?Thornsmall", "YYdieresissmall", "?001.000", "?001.001", "?001.002", "?001.003", " Black", " Bold", " Book", " Light", " Medium", " Regular", " Roman", " Semibold", "?NUL", "?HT", " LF", " CR", "?DLE", "?DC1", "?DC2", "?DC3", "?DC4", "?RS", "?US", "!=", "?DEL", "?infinity", "<=", ">=", "?partialdiff", "?summation", "xproduct", "?pi", "?integral", "?Omega", "?radical", "~=", "?Delta", " nbspace", "?lozenge", "?apple"};
    public static final int[] type1CExpertCharset = new int[]{1, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 158, 155, 163, 319, 320, 321, 282, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};
    public static final int[] type1CExpertSubCharset = new int[]{1, 231, 232, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 272, 300, 301, 302, 305, 314, 315, 158, 155, 163, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346};
    public static final String[] macExtras = new String[]{"NUL", "HT", "LF", "CR", "DLE", "DC1", "DC2", "DC3", "DC4", "RS", "US", "notequal", "DEL", "infinity", "lessequal", "greaterequal", "partialdiff", "summation", "product", "pi", "integral", "Omega", "radical", "approxequal", "Delta", "nbspace", "lozenge", "apple"};
    public static final int[] macRomanEncoding = new int[]{391, 154, 167, 140, 146, 192, 221, 197, 226, 392, 393, 157, 162, 394, 199, 228, 395, 396, 397, 398, 399, 155, 158, 150, 163, 169, 164, 160, 166, 168, 400, 401, 1, 2, 3, 4, 5, 6, 7, 104, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 124, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 403, 173, 175, 177, 178, 186, 189, 195, 200, 203, 201, 202, 205, 204, 206, 207, 210, 208, 209, 211, 214, 212, 213, 215, 216, 219, 217, 218, 220, 222, 225, 223, 224, 112, 161, 97, 98, 102, 116, 115, 149, 165, 170, 153, 125, 131, 402, 138, 141, 404, 156, 405, 406, 100, 152, 407, 408, 409, 410, 411, 139, 143, 412, 144, 147, 123, 96, 151, 413, 101, 414, 415, 106, 120, 121, 416, 174, 176, 191, 142, 148, 111, 137, 105, 119, 65, 8, 159, 417, 227, 198, 99, 103, 107, 108, 109, 110, 113, 114, 117, 118, 122, 172, 179, 171, 180, 181, 182, 183, 184, 185, 187, 188, 418, 190, 193, 194, 196, 145, 126, 127, 128, 129, 130, 132, 133, 134, 135, 136};
    public static final int[] macExpertEncoding = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 229, 230, 305, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 0, 250, 0, 252, 0, 0, 0, 0, 363, 0, 0, 158, 155, 163, 320, 321, 322, 323, 324, 325, 0, 0, 0, 0, 0, 0, 266, 109, 110, 267, 268, 269, 0, 270, 271, 315, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 0, 0, 253, 255, 0, 0, 0, 0, 348, 347, 349, 351, 350, 352, 354, 356, 355, 357, 358, 360, 359, 361, 362, 364, 366, 365, 367, 369, 368, 373, 372, 374, 375, 0, 331, 337, 336, 339, 341, 340, 307, 0, 343, 335, 0, 309, 0, 311, 262, 338, 0, 346, 345, 376, 0, 344, 0, 0, 377, 0, 342, 333, 308, 353, 371, 319, 334, 306, 0, 0, 0, 0, 0, 0, 318, 0, 0, 0, 0, 0, 370, 314, 272, 0, 0, 0, 0, 304, 0, 378, 0, 150, 164, 169, 327, 328, 329, 330, 332, 326, 0, 257, 263, 265, 0, 0, 258, 264, 256, 0, 0, 0, 0, 0, 259, 316, 310, 313, 254, 261, 260, 249, 251, 312, 317, 0, 0, 0, 0};
    public static final int[] isoLatin1Encoding = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 166, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 124, 125, 126, 127, 128, 129, 130, 131, 0, 132, 133, 0, 134, 135, 136, 1, 96, 97, 98, 103, 100, 160, 102, 131, 170, 139, 106, 151, 14, 165, 128, 161, 156, 164, 169, 125, 152, 115, 114, 133, 150, 143, 120, 158, 155, 163, 123, 174, 171, 172, 176, 173, 175, 138, 177, 181, 178, 179, 180, 185, 182, 183, 184, 154, 186, 190, 187, 188, 191, 189, 168, 141, 196, 193, 194, 195, 197, 157, 149, 203, 200, 201, 205, 202, 204, 144, 206, 210, 207, 208, 209, 214, 211, 212, 213, 167, 215, 219, 216, 217, 220, 218, 159, 147, 225, 222, 223, 224, 226, 162, 227};
    public static final int[] winAnsiEncoding = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 104, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 0, 391, 0, 117, 101, 118, 121, 112, 113, 0, 122, 192, 107, 142, 0, 199, 0, 0, 65, 8, 105, 119, 116, 111, 137, 0, 153, 221, 108, 148, 0, 228, 198, 1, 96, 97, 98, 103, 100, 160, 102, 131, 170, 139, 106, 151, 14, 165, 128, 161, 156, 164, 169, 125, 152, 115, 114, 133, 150, 143, 120, 158, 155, 163, 123, 174, 171, 172, 176, 173, 175, 138, 177, 181, 178, 179, 180, 185, 182, 183, 184, 154, 186, 190, 187, 188, 191, 189, 168, 141, 196, 193, 194, 195, 197, 157, 149, 203, 200, 201, 205, 202, 204, 144, 206, 210, 207, 208, 209, 214, 211, 212, 213, 167, 215, 219, 216, 217, 220, 218, 159, 147, 225, 222, 223, 224, 226, 162, 227};
    public static final int[] standardEncoding = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 0, 111, 112, 113, 114, 0, 115, 116, 117, 118, 119, 120, 121, 122, 0, 123, 0, 124, 125, 126, 127, 128, 129, 130, 131, 0, 132, 133, 0, 134, 135, 136, 137, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 0, 139, 0, 0, 0, 0, 140, 141, 142, 143, 0, 0, 0, 0, 0, 144, 0, 0, 0, 145, 0, 0, 146, 147, 148, 149, 0, 0, 0, 0};
    public static final String[] STD_STRINGS = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
    public static final String[] STD_STRINGS_ASTEXT = new String[]{".notdef", " ", "!", "\"", "#", "$", "%", "&", "\u2019", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "\u2018", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", "\u00a1", "\u00a2", "\u00a3", "\u2044", "\u00a5", "\u0192", "\u00a7", "\u00a4", "'", "\u201c", "\u00ab", "\u2039", "\u203a", "\ufb01", "\ufb02", "\u2013", "\u2020", "\u2021", "\u00b7", "\u00b6", "\u2022", "\u201a", "\u201e", "\u201d", "\u00bb", "\u2026", "\u2030", "\u00bf", "`", "\u00b4", "^", "~", "\u00af", "\u02d8", "\u02d9", "\u00a8", "\u02da", "\u00b8", "\u02dd", "\u02db", "\u02c7", "\u2014", "\u00c6", "\u00aa", "\u0141", "\u00d8", "\u0152", "\u00ba", "\u00e6", "\u0131", "\u0142", "\u00f8", "oe", "\u00df", "\u00b9", "\u00ac", "\u03bc", "\u2122", "\u00d0", "\u00bd", "\u00b1", "\u00de", "\u00bc", "\u2223", "\u00a6", "\u00b0", "\u00fe", "\u00be", "\u00b2", "\u00ae", "-", "\u00f0", "\u00d7", "\u00b3", "\u00a9", "\u00c1", "\u00c2", "\u00c4", "\u00c0", "\u00c5", "\u00c3", "\u00c7", "\u00c9", "\u00ca", "\u00cb", "\u00c8", "\u00c9", "\u00c2", "\u00cf", "\u00cc", "\u00d1", "\u00d3", "\u00d4", "\u00d6", "\u00d2", "\u00d5", "\u0160", "\u00da", "\u00db", "\u00dc", "\u00d9", "\u00dd", "\u0178", "\u017d", "\u00e1", "\u00e2", "\u00e4", "\u00e0", "\u00e5", "\u00e3", "\u00e7", "\u0107", "\u0109", "\u00eb", "\u00e8", "\u00ed", "\u00ee", "\u00ef", "\u00ec", "\u00f1", "\u00f3", "\u00f4", "\u00f6", "\u00f2", "\u00f5", "\u0161", "\u00fa", "\u00fb", "\u00fc", "\u00f9", "\u00fd", "\u00ff", "\u017e", "\ufe57", "\uf6f8", "\uf724", "\uf6e4", "\uf726", "\uf7b4", "\u207d", "\u207e", "\u2025", "\u2024", "\uf730", "\uf731", "\uf732", "\uf733", "\uf734", "\uf735", "\uf736", "\uf737", "\uf738", "\uf739", "\uf6e2", "\uf6de", "\uf6e8", "\uf73f", "\uf6e9", "\uf6ea", "\uf6e0", "\uf6eb", "\uf6ec", "\uf6ed", "\uf6ee", "\uf6ef", "\u207f", "\uf6f0", "\uf6f1", "\uf6f2", "\uf6f3", "\ufb00", "\ufb03", "\ufb04", "\u208d", "\u208e", "\uf6f6", "\uf6e6", "\uf760", "\uf761", "\uf762", "\uf763", "\uf764", "\uf765", "\uf766", "\uf767", "\uf768", "\uf769", "\uf76a", "\uf76b", "\uf76c", "\uf76d", "\uf76e", "\uf76f", "\uf770", "\uf771", "\uf772", "\uf773", "\uf774", "\uf775", "\uf776", "\uf777", "\uf778", "\uf779", "\uf77a", "\u20a1", "\uf6dc", "\uf6dd", "\uf6fe", "\uf7a1", "\uf7a2", "\uf6f9", "\uf6fd", "\uf6ff", "\uf7a8", "\uf6f4", "\uf6f5", "\uf6f7", "\uf7af", "\u2012", "\uf6e5", "\uf6fb", "\uf6fc", "\uf7b8", "\uf7bf", "\u215b", "\u215c", "\u215d", "\u215e", "\u2153", "\u2154", "\u2070", "\u2074", "\u2075", "\u2076", "\u2077", "\u2078", "\u2079", "\u2080", "\u2081", "\u2082", "\u2083", "\u2084", "\u2085", "\u2086", "\u2087", "\u2088", "\u2089", "\uf6df", "\uf6e3", "\uf6e7", "\uf6e1", "\uf7e0", "\uf7e1", "\uf7e2", "\uf7e3", "\uf7e4", "\uf7e5", "\uf7e6", "\uf7e7", "\uf7e8", "\uf7e9", "\uf7ea", "\uf7eb", "\uf7ec", "\uf7ed", "\uf7ee", "\uf7ef", "\uf7f0", "\uf7f1", "\uf7f2", "\uf7f3", "\uf7f4", "\uf7f5", "\uf7f6", "\uf6fa", "\uf7f8", "\uf7f9", "\uf7fa", "\uf7fb", "\uf7fc", "\uf7fd", "\uf7fe", "\uf7ff", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold", "\u20ac"};
    private static final Map<String, String> nameToCharacter = new HashMap<String, String>();
    private static final int[] MAC2UNICODE;
    private static char[] adobeSymbolEncoding;
    private static char[] ZapfDingBatsEncoding;
    private static String[] adobeSymbolSetNames;
    public static final int[] expertEncoding;
    private static String[] zapfDingBatsSetNames;

    public static String getName(int i) {
        if (i < stdNames.length) {
            return stdNames[i];
        }
        if ((i -= stdNames.length) < macExtras.length) {
            return macExtras[i];
        }
        return CHAR_NOT_DEFINED;
    }

    public static int findName(String name, String[] table) {
        for (int i = 0; i < table.length; ++i) {
            if (!name.equals(table[i])) continue;
            return i;
        }
        return -1;
    }

    public static int findName(String name, int[] table) {
        for (int i = 0; i < table.length; ++i) {
            if (!name.equals(FontSupport.getName(table[i]))) continue;
            return i;
        }
        return -1;
    }

    public static int getStrIndex(String name) {
        for (int i = 0; i < stdNames.length; ++i) {
            if (!name.equals(stdNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static String getCharForStandardName(String name) {
        return nameToCharacter.get(name);
    }

    public static char getUnicodeFromMacEncoding(int code) {
        if (code < 128) {
            return (char)code;
        }
        if (code > 255) {
            return '\u0000';
        }
        return (char)MAC2UNICODE[code - 128];
    }

    public static char getUnicodeFromSymbolEncoding(char code) {
        if (code < '\u0000' || code > '\u00fe') {
            return '\u0000';
        }
        if (code < '\u007f') {
            return code;
        }
        if (code < '\u00a0' || code == '\u00f0') {
            return '\u0000';
        }
        int index = code - 160 + 95;
        if (code < '\u00f0') {
            return adobeSymbolEncoding[index];
        }
        return adobeSymbolEncoding[index - 1];
    }

    @Nonnull
    public static String getCharNameFromSymbolEncoding(int code) {
        if (code < 32 || code > 254) {
            return CHAR_NOT_DEFINED;
        }
        if (code < 127) {
            return adobeSymbolSetNames[code - 32];
        }
        if (code < 160) {
            if (PDFParser.LOGGER.isDebug()) {
                PDFParser.LOGGER.debug((Object)("this character code is not defined in symbol encoding " + code));
            }
            return CHAR_NOT_DEFINED;
        }
        if (code == 240) {
            return CHAR_NOT_DEFINED;
        }
        int index = code - 160 + 95;
        if (code < 240) {
            return adobeSymbolSetNames[index];
        }
        return adobeSymbolSetNames[index - 1];
    }

    static ICharMapper getCharMapper(String encodingName) throws IllegalArgumentException {
        if (encodingName.equals("MacRomanEncoding")) {
            return new LatinCharMapper(macRomanEncoding);
        }
        if (encodingName.equals("MacExpertEncoding")) {
            return new LatinCharMapper(macExpertEncoding);
        }
        if (encodingName.equals("WinAnsiEncoding")) {
            return new LatinCharMapper(winAnsiEncoding);
        }
        if (encodingName.equals("SymbolSetEncoding")) {
            return new SymbolCharMapper();
        }
        if (encodingName.equals("ZapfDingbatsEncoding")) {
            return new ZapfDingbatsCharMapper();
        }
        if (encodingName.equals("StandardEncoding")) {
            return new LatinCharMapper(standardEncoding);
        }
        throw new IllegalArgumentException("Unknown encoding: " + encodingName);
    }

    @Nonnull
    public static String getCharNameFromZapfDingbatsEncoding(char code) {
        int index = -1;
        if (code >= ' ' && code < '\u00ff' && code != '\u007f' && code != '\u00f0') {
            if (code < '\u007f') {
                index = code - 32;
            } else if (code < '\u008e') {
                index = code - 33;
            } else if (code > '\u00a0') {
                index = code < '\u00f0' ? code - 52 : code - 53;
            }
        }
        if (index == -1) {
            return CHAR_NOT_DEFINED;
        }
        return zapfDingBatsSetNames[index];
    }

    public static char getUnicodeFromZapfDingbatsEncoding(char code) {
        if (code < ' ' || code > '\u00fe') {
            return '\u0000';
        }
        return ZapfDingBatsEncoding[code - 32];
    }

    /*
     * Opcode count of 17449 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        for (int i = 0; i < STD_STRINGS.length; ++i) {
            String name = STD_STRINGS[i];
            String character = STD_STRINGS_ASTEXT[i];
            if (character.length() != 1) continue;
            nameToCharacter.put(name, character);
        }
        MAC2UNICODE = new int[]{196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232, 234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252, 8224, 176, 162, 163, 167, 8226, 182, 223, 174, 169, 8482, 180, 168, 8800, 198, 216, 8734, 177, 8804, 8805, 165, 181, 8706, 8721, 8719, 960, 8747, 170, 186, 937, 230, 248, 191, 161, 172, 8730, 402, 8776, 8710, 171, 187, 8230, 160, 192, 195, 213, 338, 339, 8211, 8212, 8220, 8221, 8216, 8217, 247, 9674, 255, 376, 8260, 8364, 8249, 8250, 64257, 64258, 8225, 183, 8218, 8222, 8240, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212, 63743, 210, 218, 219, 217, 305, 710, 732, 175, 728, 729, 730, 184, 733, 731, 711};
        adobeSymbolEncoding = new char[]{' ', '!', '\u2200', '#', '\u2203', '%', '&', '\u220b', '(', ')', '\u2217', '+', ',', '\u2212', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u2245', '\u0391', '\u0392', '\u03a7', '\u0394', '\u0395', '\u03a6', '\u0393', '\u0397', '\u0399', '\u03d1', '\u039a', '\u039b', '\u039c', '\u039d', '\u039f', '\u03a0', '\u0398', '\u03a1', '\u03a3', '\u03a4', '\u03a5', '\u03c2', '\u03a9', '\u039e', '\u03a8', '\u0396', '[', '\u2234', ']', '\u22a5', '_', '\uf8e5', '\u03b1', '\u03b2', '\u03c7', '\u03b4', '\u03b5', '\u03c6', '\u03b3', '\u03b7', '\u03b9', '\u03d5', '\u03ba', '\u03bb', '\u00b5', '\u03bd', '\u03bf', '\u03c0', '\u03b8', '\u03c1', '\u03c3', '\u03c4', '\u03c5', '\u03d6', '\u03c9', '\u03be', '\u03c8', '\u03b6', '{', '|', '}', '\u223c', '\u20ac', '\u03d2', '\u2032', '\u2264', '\u2044', '\u221e', '\u0192', '\u2663', '\u2666', '\u2665', '\u2660', '\u2194', '\u2190', '\u2191', '\u2192', '\u2193', '\u00b0', '\u00b1', '\u2033', '\u2265', '\u00d7', '\u221d', '\u2202', '\u2022', '\u00f7', '\u2260', '\u2261', '\u2248', '\u2026', '\uf8e6', '\uf8e7', '\u21b5', '\u2135', '\u2111', '\u211c', '\u2118', '\u2297', '\u2295', '\u2205', '\u2229', '\u222a', '\u2283', '\u2287', '\u2284', '\u2282', '\u2286', '\u2208', '\u2209', '\u2220', '\u2207', '\uf6da', '\uf6d9', '\uf6db', '\u220f', '\u221a', '\u22c5', '\u00ac', '\u2227', '\u2228', '\u21d4', '\u21d0', '\u21d1', '\u21d2', '\u21d3', '\u25ca', '\u2329', '\uf8e8', '\uf8e9', '\uf8ea', '\u2211', '\uf8eb', '\uf8ec', '\uf8ed', '\uf8ee', '\uf8ef', '\uf8f0', '\uf8f1', '\uf8f2', '\uf8f3', '\uf8f4', '\u232a', '\u222b', '\u2320', '\uf8f5', '\u2321', '\uf8f6', '\uf8f7', '\uf8f8', '\uf8f9', '\uf8fa', '\uf8fb', '\uf8fc', '\uf8fd', '\uf8fe'};
        ZapfDingBatsEncoding = new char[]{' ', '\u2701', '\u2702', '\u2703', '\u2704', '\u260e', '\u2706', '\u2707', '\u2708', '\u2709', '\u261b', '\u261e', '\u270c', '\u270d', '\u270e', '\u270f', '\u2710', '\u2711', '\u2712', '\u2713', '\u2714', '\u2715', '\u2716', '\u2717', '\u2718', '\u2719', '\u271a', '\u271b', '\u271c', '\u271d', '\u271e', '\u271f', '\u2720', '\u2721', '\u2722', '\u2723', '\u2724', '\u2725', '\u2726', '\u2727', '\u2605', '\u2729', '\u272a', '\u272b', '\u272c', '\u272d', '\u272e', '\u272f', '\u2730', '\u2731', '\u2732', '\u2733', '\u2734', '\u2735', '\u2736', '\u2737', '\u2738', '\u2739', '\u273a', '\u273b', '\u273c', '\u273d', '\u273e', '\u273f', '\u2740', '\u2741', '\u2742', '\u2743', '\u2744', '\u2745', '\u2746', '\u2747', '\u2748', '\u2749', '\u274a', '\u274b', '\u25cf', '\u274d', '\u25a0', '\u274f', '\u2750', '\u2751', '\u2752', '\u25b2', '\u25bc', '\u25c6', '\u2756', '\u25d7', '\u2758', '\u2759', '\u275a', '\u275b', '\u275c', '\u275d', '\u275e', '\u0000', '\uf8d7', '\uf8d8', '\uf8d9', '\uf8da', '\uf8db', '\uf8dc', '\uf8dd', '\uf8de', '\uf8df', '\uf8e0', '\uf8e1', '\uf8e2', '\uf8e3', '\uf8e4', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u2761', '\u2762', '\u2763', '\u2764', '\u2765', '\u2766', '\u2767', '\u2663', '\u2666', '\u2665', '\u2660', '\u2460', '\u2461', '\u2462', '\u2463', '\u2464', '\u2465', '\u2466', '\u2467', '\u2468', '\u2469', '\u2776', '\u2777', '\u2778', '\u2779', '\u277a', '\u277b', '\u277c', '\u277d', '\u277e', '\u277f', '\u2780', '\u2781', '\u2782', '\u2783', '\u2784', '\u2785', '\u2786', '\u2787', '\u2788', '\u2789', '\u278a', '\u278b', '\u278c', '\u278d', '\u278e', '\u278f', '\u2790', '\u2791', '\u2792', '\u2793', '\u2794', '\u2192', '\u2194', '\u2195', '\u2798', '\u2799', '\u279a', '\u279b', '\u279c', '\u279d', '\u279e', '\u279f', '\u27a0', '\u27a1', '\u27a2', '\u27a3', '\u27a4', '\u27a5', '\u27a6', '\u27a7', '\u27a8', '\u27a9', '\u27aa', '\u27ab', '\u27ac', '\u27ad', '\u27ae', '\u27af', '\u0000', '\u27b1', '\u27b2', '\u27b3', '\u27b4', '\u27b5', '\u27b6', '\u27b7', '\u27b8', '\u27b9', '\u27ba', '\u27bb', '\u27bc', '\u27bd', '\u27be', '\u0000'};
        adobeSymbolSetNames = new String[]{"space", "exclam", "universal", "numbersign", "existential", "percent", "ampersand", "suchthat", "parenleft", "parenright", "asteriskmath", "plus", "comma", "minus", "period", "slash", "zero", "one", "two", "three", "four\t", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "congruent", "Alpha", "Beta", "Chi", "Delta", "Epsilon", "Phi", "Gamma", "Eta", "Iota", "theta1", "Kappa", "Lambda", "Mu", "Nu", "Omicron", "Pi", "Theta", "Rho", "Sigma", "Tau", "Upsilon", "sigma1", "Omega", "Xi", "Psi", "Zeta", "bracketleft", "therefore", "bracketright", "perpendicular", "underscore", "radicalex (CUS)", "alpha", "beta", "chi", "delta", "epsilon", "phi", "gamma", "eta", "iota", "phi1", "kappa", "lambda", "mu", "nu", "omicron", "pi", "theta", "rho", "sigma", "tau", "upsilon", "omega1", "omega", "xi", "psi", "zeta", "braceleft", "bar", "braceright", "similar", "Euro", "Upsilon1", "minute", "lessequal", "fraction", "infinity", "florin", "club", "diamond", "heart", "spade", "arrowboth", "arrowleft", "arrowup", "arrowright", "arrowdown", "degree", "plusminus", "second", "greaterequal", "multiply", "proportional", "partialdiff", "bullet", "divide", "notequal", "equivalence", "approxequal", "ellipsis", "arrowvertex (CUS)", "arrowhorizex (CUS)", "carriagereturn", "aleph", "Ifraktur", "Rfraktur", "weierstrass", "circlemultiply", "circleplus", "emptyset", "intersection", "union", "propersuperset", "reflexsuperset", "notsubset", "propersubset", "reflexsubset", "element", "notelement", "angle", "gradient", "registerserif (CUS)", "copyrightserif (CUS)", "trademarkserif (CUS)", "product", "radical", "dotmath", "logicalnot", "logicaland", "logicalor", "arrowdblboth", "arrowdblleft", "arrowdblup", "arrowdblright", "arrowdbldown", "lozenge", "angleleft", "registersans (CUS)", "copyrightsans (CUS)", "trademarksans (CUS)", "summation", "parenlefttp (CUS)", "parenleftex (CUS)", "parenleftbt (CUS)", "bracketlefttp (CUS)", "bracketleftex (CUS)", "bracketleftbt (CUS)", "bracelefttp (CUS)", "braceleftmid (CUS)", "braceleftbt (CUS)", "braceex (CUS)", "angleright", "integral", "integraltp", "integralex (CUS)", "integralbt", "parenrighttp (CUS)", "parenrightex (CUS)", "parenrightbt (CUS)", "bracketrighttp (CUS)", "bracketrightex (CUS)", "bracketrightbt (CUS)", "bracerighttp (CUS)", "bracerightmid (CUS)", "bracerightbt (CUS)"};
        expertEncoding = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 229, 230, 0, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 0, 253, 254, 255, 256, 257, 0, 0, 0, 258, 0, 0, 259, 260, 261, 262, 0, 0, 263, 264, 265, 0, 266, 109, 110, 267, 268, 269, 0, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 304, 305, 306, 0, 0, 307, 308, 309, 310, 311, 0, 312, 0, 0, 313, 0, 0, 314, 315, 0, 0, 316, 317, 318, 0, 0, 0, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 0, 0, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};
        zapfDingBatsSetNames = new String[]{"space", "a1", "a2", "a202", "a3", "a4", "a5", "a119", "a118", "a117", "a11", "a12", "a13", "a14", "a15", "a16", "a105", "a17", "a18", "a19", "a20", "a21", "a22", "a23", "a24", "a25", "a26", "a27", "a28", "a6", "a7", "a8", "a9", "a10", "a29", "a30", "a31", "a32", "a33", "a34", "a35", "a36", "a37", "a38", "a39", "a40", "a41", "a42", "a43", "a44", "a45", "a46", "a47", "a48", "a49", "a50", "a51", "a52", "a53", "a54", "a55", "a56", "a57", "a58", "a59", "a60", "a61", "a62", "a63", "a64", "a65", "a66", "a67", "a68", "a69", "a70", "a71", "a72", "a73", "a74", "a203", "a75", "a204", "a76", "a77", "a78", "a79", "a81", "a82", "a83", "a84", "a97", "a98", "a99", "a100", "a89", "a90", "a93", "a94", "a91", "a92", "a205", "a85", "a206", "a86", "a87", "a88", "a95", "a96", "a101", "a102", "a103", "a104", "a106", "a107", "a108", "a112", "a111", "a110", "a109", "a120", "a121", "a122", "a123", "a124", "a125", "a126", "a127", "a128", "a129", "a130", "a131", "a132", "a133", "a134", "a135", "a136", "a137", "a138", "a139", "a140", "a141", "a142", "a143", "a144", "a145", "a146", "a147", "a148", "a149", "a150", "a151", "a152", "a153", "a154", "a155", "a156", "a157", "a158", "a159", "a160", "a161", "a163", "a164", "a196", "a165", "a192", "a166", "a167", "a168", "a169", "a170", "a171", "a172", "a173", "a162", "a174", "a175", "a176", "a177", "a178", "a179", "a193", "a180", "a199", "a181", "a200", "a182", "a201", "a183", "a184", "a197", "a185", "a194", "a198", "a186", "a195", "a187", "a188", "a189", "a190", "a191"};
    }
}

