/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.CIDFontWidthDelegate;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontEncoding;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.TTFFont;
import com.inet.pdfview.font.Type0Font;
import com.inet.pdfview.font.ttf.TrueTypeFont;
import java.awt.geom.GeneralPath;
import java.util.Map;

public class CIDFontType2
extends TTFFont {
    private IDataBuffer cidToGidMap = null;
    private CIDFontWidthDelegate widthDelegate;
    private boolean warningPrinted = false;
    private int exportLastChar = -1;

    public CIDFontType2(String baseName, PDFObject fontObj, PDFFontDescriptor descriptor, PDFDecrypter decryptor, PDFFontToUnicodeMap ascendantUnicodeMap, String encodingType) throws PDFParseException {
        super(baseName, fontObj, descriptor, decryptor, ascendantUnicodeMap, encodingType);
        this.widthDelegate = new CIDFontWidthDelegate(fontObj);
        PDFObject mapObj = fontObj.getDictRef("CIDToGIDMap");
        if (mapObj != null && mapObj.getType() == 7) {
            PDFXref ref = null;
            if (decryptor != null) {
                ref = mapObj.getRefValue();
            }
            this.cidToGidMap = mapObj.getStreamBuffer(ref, decryptor);
        }
        PDFFontToUnicodeMap uMap = super.getUnicodeMapping();
        this.setHasValidMapping(this.cidToGidMap != null || uMap != null && uMap.getMapCharCodeToUnicode() != null && uMap.getMapCharCodeToUnicode().length > 0);
    }

    @Override
    public int getDefaultWidth() {
        return this.widthDelegate.getDefaultWidth();
    }

    @Override
    public float getWidth(char code, String name) {
        return this.widthDelegate.getWidth(code, name);
    }

    @Override
    protected synchronized GeneralPath getOutline(char src, float width) {
        int index;
        int glyphId = src & 0xFFFF;
        if (this.cidToGidMap != null && (index = glyphId * 2) < this.cidToGidMap.limit() - 1) {
            glyphId = this.cidToGidMap.getChar(index);
        }
        if (glyphId == 0 && src != '\u0000') {
            return null;
        }
        return this.getOutline(glyphId, width);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public char mapCharacter(char src, boolean forDrawString) {
        char mapCharacter = super.mapCharacter(src, forDrawString);
        if (mapCharacter != src) {
            return mapCharacter;
        }
        if (this.cidToGidMap != null) {
            int index = src * 2;
            if (index >= this.cidToGidMap.limit()) return '\u0000';
            char glyphId = this.cidToGidMap.getChar(index);
            if (glyphId != '\u0000') return mapCharacter;
            return '\u0000';
        }
        if (this.widthDelegate.contains(src)) return mapCharacter;
        return '\u0000';
    }

    @Override
    public int getLastCharForFontExportToTrueType() {
        if (this.exportLastChar >= 0) {
            return this.exportLastChar;
        }
        int lastChar = super.getLastCharForFontExportToTrueType();
        if (this.cidToGidMap != null && lastChar < this.cidToGidMap.limit()) {
            this.exportLastChar = Math.min(65535, this.cidToGidMap.limit() / 2);
            return this.exportLastChar;
        }
        int lastFromMap = this.getLastCodeFromCMap();
        this.exportLastChar = Math.max(lastChar, lastFromMap);
        return this.exportLastChar;
    }

    @Override
    public PDFFontToUnicodeMap getUnicodeMapping() {
        PDFFontToUnicodeMap map = this.getParent().getUnicodeMapping();
        if (map == null) {
            map = super.getUnicodeMapping();
        }
        if (map == null) {
            Map<Character, Character> glyphToUnicode;
            PDFFontEncoding enc;
            Type0Font parent = (Type0Font)this.getParent();
            if (!parent.isIdentityEncoding() && !this.warningPrinted && (enc = parent.getEncoding()) != null) {
                PDFParser.LOGGER.warn((Object)("The unicode mapping of font '" + this.getBaseFont() + "' may be incomplete since it's 'non-identity' encoding is not supported"));
                this.warningPrinted = true;
            }
            if ((glyphToUnicode = this.getGlyphToUnicodeMap()) != null) {
                int[] mapCharCodeToUnicode;
                if (this.cidToGidMap != null) {
                    int cidArraySize = this.cidToGidMap.limit() / 2;
                    mapCharCodeToUnicode = new int[cidArraySize];
                    for (int i = 0; i < cidArraySize; ++i) {
                        char gid = this.cidToGidMap.getChar(2 * i);
                        Character unicodeChar = glyphToUnicode.get(Character.valueOf(gid));
                        mapCharCodeToUnicode[i] = unicodeChar != null ? unicodeChar.charValue() : (char)'\u0000';
                    }
                } else {
                    char maxCid = '\u0000';
                    for (Character key : glyphToUnicode.keySet()) {
                        char glyph = key.charValue();
                        if (glyph <= maxCid) continue;
                        maxCid = glyph;
                    }
                    int cidArraySize = maxCid + 1;
                    mapCharCodeToUnicode = new int[cidArraySize];
                    for (Map.Entry<Character, Character> entry : glyphToUnicode.entrySet()) {
                        char cid = entry.getKey().charValue();
                        Character unicodeChar = entry.getValue();
                        mapCharCodeToUnicode[cid] = unicodeChar != null ? unicodeChar.charValue() : (char)'\u0000';
                    }
                }
                map = new PDFFontToUnicodeMap(mapCharCodeToUnicode);
                this.setUnicodeMap(map);
            }
        }
        return map;
    }

    boolean checkType2() {
        TrueTypeFont ttf = this.getTrueTypeFont();
        return ttf == null || !ttf.isCFF();
    }

    IDataBuffer getCidToGidMap() {
        return this.cidToGidMap;
    }
}

