/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.CIDFontWidthDelegate;
import com.inet.pdfview.font.PDFFontDescriptor;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.Type1CFont;
import java.awt.geom.GeneralPath;

public class CIDFontType0
extends Type1CFont {
    private CIDFontWidthDelegate widthDelegate;
    int[] cidToGlyph;

    public CIDFontType0(String baseFont, PDFObject src, PDFFontDescriptor descriptor, String encodingType, PDFDecrypter decryptor, PDFFontToUnicodeMap toUnicodeMap) throws PDFParseException {
        super(baseFont, src, descriptor, encodingType, decryptor, toUnicodeMap);
        this.widthDelegate = new CIDFontWidthDelegate(src);
        this.encoding = null;
    }

    public CIDFontType0(String baseFont, PDFObject src, PDFFontDescriptor descriptor, String encodingType, PDFFontToUnicodeMap toUnicodeMap, IDataBuffer fb) throws PDFParseException {
        super(baseFont, src, descriptor, encodingType, toUnicodeMap, fb);
        this.widthDelegate = new CIDFontWidthDelegate(src);
        this.encoding = null;
    }

    @Override
    public float getWidth(char code, String name) {
        return this.widthDelegate.getWidth(code, name);
    }

    @Override
    protected GeneralPath getOutline(char src, float width) {
        if (this.cidToGlyph != null) {
            try {
                int glyph = src < this.cidToGlyph.length ? this.cidToGlyph[src] : src;
                return super.readGlyph(glyph);
            }
            catch (Exception ex) {
                PDFParser.LOGGER.error((Throwable)ex);
            }
        }
        if (!this.isCIDType1C() && this.glyphnames.length > src) {
            src = (char)this.glyphnames[src];
        }
        return super.getOutline((char)src, width);
    }

    @Override
    public int getFirstCharForFontExportToTrueType() {
        int superFirst = super.getFirstCharForFontExportToTrueType();
        if (this.isCIDType1C() && this.encoding == null && this.glyphnames != null) {
            int minCode = Integer.MAX_VALUE;
            for (int i = 0; i < this.glyphnames.length; ++i) {
                minCode = Math.min(minCode, this.glyphnames[i]);
            }
            if (minCode < superFirst) {
                return minCode;
            }
        }
        return superFirst;
    }

    @Override
    public int getLastCharForFontExportToTrueType() {
        int superLast = super.getLastCharForFontExportToTrueType();
        if (this.isCIDType1C() && this.encoding == null && this.glyphnames != null) {
            int maxCode = 0;
            for (int i = 0; i < this.glyphnames.length; ++i) {
                maxCode = Math.max(maxCode, this.glyphnames[i]);
            }
            if (maxCode > superLast) {
                return maxCode;
            }
        }
        return superLast;
    }

    @Override
    public int getDefaultWidth() {
        return this.widthDelegate.getDefaultWidth();
    }

    void setCidToGidMap(IDataBuffer cidToGidMap) {
        if (cidToGidMap == null) {
            return;
        }
        int cidArraySize = cidToGidMap.limit() / 2;
        this.cidToGlyph = new int[cidArraySize];
        int maxSource = 0;
        char maxGID = '\u0000';
        for (int i = 0; i < cidArraySize; ++i) {
            char gid = cidToGidMap.getChar(2 * i);
            this.cidToGlyph[i] = gid;
            if (gid == '\u0000') continue;
            if (i > maxSource) {
                maxSource = i;
            }
            if (gid <= maxGID) continue;
            maxGID = gid;
        }
    }
}

