/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decrypt;

import com.inet.pdfview.decrypt.PDFDecrypter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DecrypterAES128
extends PDFDecrypter {
    private String userPassword;

    DecrypterAES128(String userPassword, byte[] ownerEntryData, int permission, byte[] docIdData, int keyLength, int algorithmVersion, int handlerRevision, boolean isMetadataEncrypted) {
        super(userPassword, ownerEntryData, permission, docIdData, keyLength, algorithmVersion, handlerRevision, isMetadataEncrypted);
        this.userPassword = userPassword;
    }

    @Override
    public byte[] decrypt(byte[] bytes, int length, int objNum, int revNum) throws RuntimeException {
        byte[] currentKey = this.computeObjectEncryptionKey(objNum, revNum);
        try {
            return this.decrypt(bytes, length, currentKey, false);
        }
        catch (IllegalBlockSizeException e) {
            try {
                return this.decrypt(bytes, length, currentKey, true);
            }
            catch (Exception e1) {
                throw new PDFDecrypter.DecryptionExcpetion(e1, this.userPassword != null && !this.userPassword.isEmpty());
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException e) {
            throw new PDFDecrypter.DecryptionExcpetion(e, this.userPassword != null && !this.userPassword.isEmpty());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    byte[] decrypt(byte[] initVectorAndEncryptedData, int length, byte[] currentKey, boolean noPadding) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher mainCipher = Cipher.getInstance("AES/CBC/" + (noPadding ? "NoPadding" : "PKCS5Padding"));
        byte[] iv = new byte[16];
        System.arraycopy(initVectorAndEncryptedData, 0, iv, 0, iv.length);
        int copyLength = initVectorAndEncryptedData.length - iv.length;
        int arrayLength = noPadding ? (copyLength + 15) / 16 * 16 : copyLength;
        byte[] encrypted = new byte[arrayLength];
        System.arraycopy(initVectorAndEncryptedData, iv.length, encrypted, 0, copyLength);
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        SecretKeySpec fileDecryptionKey = new SecretKeySpec(currentKey, "AES");
        mainCipher.init(2, (Key)fileDecryptionKey, paramSpec);
        byte[] res = mainCipher.doFinal(encrypted);
        return res;
    }

    @Override
    byte[] computeObjectEncryptionKey(int objNum, int revNum) {
        byte[] currentKey = null;
        if (this.getEncryptionKey() != null) {
            int n = this.getEncryptionKey().length;
            int size = n + 9;
            byte[] tmp = new byte[size];
            System.arraycopy(this.getEncryptionKey(), 0, tmp, 0, n);
            tmp[n] = (byte)objNum;
            tmp[n + 1] = (byte)(objNum >> 8);
            tmp[n + 2] = (byte)(objNum >> 16);
            tmp[n + 3] = (byte)revNum;
            tmp[n + 4] = (byte)(revNum >> 8);
            tmp[n + 5] = 115;
            tmp[n + 6] = 65;
            tmp[n + 7] = 108;
            tmp[n + 8] = 84;
            currentKey = this.initMD5().digest(tmp);
            int maxLengthOfObjectKey = Math.min(n + 5, 16);
            if (currentKey.length > maxLengthOfObjectKey) {
                tmp = new byte[maxLengthOfObjectKey];
                System.arraycopy(currentKey, 0, tmp, 0, maxLengthOfObjectKey);
                currentKey = tmp;
            }
        }
        return currentKey;
    }
}

