/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode.jpeg;

import com.inet.pdfview.PDFImage;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.DataBufferInputStream;
import com.inet.pdfview.decode.jpeg.JpegImageInfo;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class JpegImageProcessor {
    private ImageReader reader;
    private JpegImageInfo info;

    public JpegImageProcessor(@Nonnull JpegImageInfo info) {
        this.info = info;
    }

    @Nullable
    public BufferedImage readImage(@Nonnull IDataBuffer imageData) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName("JPEG");
        while (iter.hasNext()) {
            this.reader = iter.next();
            if (this.reader.canReadRaster()) break;
            this.reader.dispose();
            this.reader = null;
        }
        if (this.reader == null) {
            return null;
        }
        BufferedImage image = null;
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(new DataBufferInputStream(imageData));
            this.reader.setInput(stream);
            WritableRaster raster = (WritableRaster)this.reader.readRaster(0, null);
            int colorType = this.info.getColorType();
            int dataType = raster.getDataBuffer().getDataType();
            boolean cmykRasterIsReady = false;
            if (dataType == 0) {
                if (colorType == 0) {
                    cmykRasterIsReady = true;
                } else if (colorType == 2) {
                    JpegImageProcessor.convertYcckToCmyk(raster);
                    cmykRasterIsReady = true;
                }
            }
            if (cmykRasterIsReady) {
                PDFImage.checkMemoryForImage(raster.getWidth(), raster.getHeight());
                image = new BufferedImage(raster.getWidth(), raster.getHeight(), 2);
                image.setData(raster);
            }
        }
        catch (IOException ex) {
            PDFParser.LOGGER.error((Throwable)ex);
        }
        return image;
    }

    public static void convertYcckToCmyk(WritableRaster raster) {
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = width * 4;
        int[] pixelRow = new int[stride];
        for (int h = 0; h < height; ++h) {
            raster.getPixels(0, h, width, 1, pixelRow);
            for (int x = 0; x < stride; x += 4) {
                int y = pixelRow[x];
                int cb = pixelRow[x + 1];
                int cr = pixelRow[x + 2];
                int c = JpegImageProcessor.normalize((int)((double)y + 1.402 * (double)cr - 178.956));
                int m = JpegImageProcessor.normalize((int)((double)y - 0.34414 * (double)cb - 0.71414 * (double)cr + 135.95984));
                y = JpegImageProcessor.normalize((int)((double)y + 1.772 * (double)cb - 226.316));
                pixelRow[x] = 255 - c;
                pixelRow[x + 1] = 255 - m;
                pixelRow[x + 2] = 255 - y;
            }
            raster.setPixels(0, h, width, 1, pixelRow);
        }
    }

    private static int normalize(int comp) {
        if (comp < 0) {
            comp = 0;
        } else if (comp > 255) {
            comp = 255;
        }
        return comp;
    }
}

