/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.ASCII85Decode;
import com.inet.pdfview.decode.ASCIIHexDecode;
import com.inet.pdfview.decode.CCITTDecode;
import com.inet.pdfview.decode.DCTDecode;
import com.inet.pdfview.decode.FlateDecode;
import com.inet.pdfview.decode.LZWDecode;
import com.inet.pdfview.decode.RLDecode;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;

public class PDFDecoder {
    private PDFDecoder() {
    }

    public static IDataBuffer decodeStream(PDFObject dict, IDataBuffer streamBuf, PDFDecrypter decryptor) throws PDFParseException {
        PDFObject encoding = dict.getDictRef("Filter");
        if (encoding != null) {
            PDFObject[] params;
            PDFObject[] ary;
            if (encoding.getType() == 4) {
                ary = new PDFObject[]{encoding};
                params = new PDFObject[]{dict.getDictRef("DecodeParms")};
            } else {
                ary = encoding.getArray();
                PDFObject parmsobj = dict.getDictRef("DecodeParms");
                params = parmsobj != null ? parmsobj.getArray() : new PDFObject[ary.length];
            }
            for (int i = 0; i < ary.length; ++i) {
                String enctype = ary[i].getStringValue();
                if (enctype == null) continue;
                if (enctype.equals("FlateDecode") || enctype.equals("Fl")) {
                    streamBuf = FlateDecode.decode(streamBuf, params[i]);
                    continue;
                }
                if (enctype.equals("LZWDecode") || enctype.equals("LZW")) {
                    streamBuf = LZWDecode.decode(streamBuf, params[i]);
                    continue;
                }
                if (enctype.equals("ASCII85Decode") || enctype.equals("A85")) {
                    streamBuf = ASCII85Decode.decode(streamBuf, params[i]);
                    continue;
                }
                if (enctype.equals("ASCIIHexDecode") || enctype.equals("AHx")) {
                    streamBuf = ASCIIHexDecode.decode(streamBuf, params[i]);
                    continue;
                }
                if (enctype.equals("DCTDecode") || enctype.equals("DCT")) {
                    streamBuf = DCTDecode.decode(dict, streamBuf, decryptor);
                    continue;
                }
                if (enctype.equals("CCITTFaxDecode") || enctype.equals("CCF")) {
                    streamBuf = CCITTDecode.decode(dict, streamBuf, params[i]);
                    continue;
                }
                if (enctype.equals("RunLengthDecode")) {
                    streamBuf = RLDecode.decode(streamBuf);
                    continue;
                }
                if (enctype.equals("JBIG2Decode")) {
                    try {
                        PDFObject globals;
                        byte[] data = new byte[streamBuf.remaining()];
                        streamBuf.get(data);
                        JBIG2StreamDecoder decoder = new JBIG2StreamDecoder();
                        if (params != null && params.length >= 1 && params[0] != null && (globals = params[0].getDictRef("JBIG2Globals")) != null) {
                            decoder.setGlobalData(globals.getStream(dict.getRefValue(), decryptor, false));
                        }
                        decoder.decodeJBIG2(data);
                        JBIG2Bitmap bitmap = decoder.getPageAsJBIG2Bitmap(0);
                        if (bitmap == null) {
                            throw new PDFParseException("Failed to decode JBIG2: no bitmap");
                        }
                        return ArrayBuffer.wrap(bitmap.getData(true));
                    }
                    catch (IOException | JBIG2Exception e) {
                        throw new PDFParseException("Failed to decode JBIG2", e);
                    }
                }
                if (enctype.equals("JPXDecode")) {
                    streamBuf.rewind();
                    byte[] data = new byte[streamBuf.remaining()];
                    streamBuf.get(data);
                    if (decryptor != null && dict.getRefValue() != null) {
                        int objNum = dict.getRefValue().getID();
                        int revNum = dict.getRefValue().getGeneration();
                        data = decryptor.decrypt(data, data.length, objNum, revNum);
                    }
                    try {
                        BufferedImage img = ImageIO.read(new ByteArrayInputStream(data));
                        dict.setCache(img);
                        return null;
                    }
                    catch (Throwable th) {
                        throw new PDFParseException(th.getMessage());
                    }
                }
                throw new PDFParseException("Unknown coding method:" + ary[i].getStringValue());
            }
        }
        return streamBuf;
    }
}

