/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.decode;

import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.pdfview.PDFImage;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decode.DataBufferInputStream;
import com.inet.pdfview.decode.jpeg.JpegImageInfo;
import com.inet.pdfview.decode.jpeg.JpegImageProcessor;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JPanel;

public class DCTDecode {
    private static final JPanel REF_COMPONENT = new JPanel();
    private static final int COLOR_TYPE_UNKNOWN = 0;
    private static final int COLOR_TYPE_GRAY = 1;
    private static final int COLOR_TYPE_RGB = 2;
    private static final int COLOR_TYPE_YCbCr = 3;
    private static final int COLOR_TYPE_CMYK = 4;
    private static final int COLOR_TYPE_PYCC = 5;
    private static final int COLOR_TYPE_RGBA = 6;
    private static final int COLOR_TYPE_YCbCrA = 7;
    private static final int COLOR_TYPE_RGBA_INVERTED = 8;
    private static final int COLOR_TYPE_YCbCrA_INVERTED = 9;
    private static final int COLOR_TYPE_PYCCA = 10;
    private static final int COLOR_TYPE_YCCK = 11;

    public static BufferedImage decodeImage(PDFObject dict, IDataBuffer buf, PDFDecrypter decryptor) throws PDFParseException {
        return DCTDecode.decodeToImage((PDFObject)dict, (IDataBuffer)buf, (PDFDecrypter)decryptor).img;
    }

    protected static IDataBuffer decode(PDFObject dict, IDataBuffer buf, PDFDecrypter decryptor) throws PDFParseException {
        DecodeResult result = DCTDecode.decodeToImage(dict, buf, decryptor);
        return DCTDecode.getImageData(result.isCMYK, result.img);
    }

    private static DecodeResult decodeToImage(PDFObject dict, final IDataBuffer buf, PDFDecrypter decryptor) throws PDFParseException {
        BufferedImage bimg;
        boolean isCMYK;
        Image img;
        int numComponents;
        block38: {
            Logger logger;
            buf.rewind();
            numComponents = 3;
            int colorTransform = 0;
            PDFColorSpace cs = null;
            PDFObject wObj = dict.getDictRef("Width");
            PDFObject hObj = dict.getDictRef("Height");
            if (wObj != null && hObj != null) {
                int w = wObj.getIntValue();
                int h = hObj.getIntValue();
                PDFImage.checkMemoryForImage(w, h);
            }
            PDFObject csObj = dict.getDictRef("ColorSpace");
            try {
                if (csObj != null && (cs = PDFColorSpace.getColorSpace(csObj, null, decryptor)) != null && (numComponents = cs.getNumComponents()) == 3) {
                    colorTransform = 1;
                }
            }
            catch (PDFParseException ioe) {
                logger = PDFParser.LOGGER;
                logger.warn((Object)("Unable to parse color space: " + String.valueOf((Object)ioe)));
                logger.debug((Object)ioe);
            }
            try {
                PDFObject colorTransformObj = dict.getDictRef("ColorTransform");
                if (colorTransformObj != null && colorTransformObj.getType() == 2) {
                    colorTransform = colorTransformObj.getIntValue();
                }
            }
            catch (PDFParseException e) {
                logger = PDFParser.LOGGER;
                logger.debug((Object)"ColorTransform entry not found");
            }
            img = null;
            isCMYK = false;
            try {
                String stringValue;
                if (csObj != null && ("DeviceCMYK".equals(stringValue = csObj.getStringValue()) || cs != null && cs.getColorSpace() != null && cs.getColorSpace().getType() == 9)) {
                    isCMYK = true;
                    JpegImageInfo info = JpegImageInfo.createInfo(buf);
                    if (info != null && info.needsSpecialHandling(colorTransform)) {
                        JpegImageProcessor processor = new JpegImageProcessor(info);
                        try {
                            buf.rewind();
                            BufferedImage bufferedImage = processor.readImage(buf);
                            if (bufferedImage != null) {
                                return new DecodeResult(bufferedImage, isCMYK);
                            }
                        }
                        catch (Throwable th) {
                            LogManager.getApplicationLogger().debug((Object)th);
                        }
                    }
                }
                try {
                    img = Toolkit.getDefaultToolkit().createImage(new URL("http", "localhost", 9900, "/someImage", new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) throws IOException {
                            return new URLConnection(u){

                                @Override
                                public void connect() throws IOException {
                                }

                                @Override
                                public InputStream getInputStream() throws IOException {
                                    return new DataBufferInputStream(buf);
                                }
                            };
                        }
                    }));
                }
                catch (MalformedURLException e1) {
                    PDFParser.LOGGER.error((Throwable)e1);
                }
                MediaTracker mt = new MediaTracker(REF_COMPONENT);
                mt.addImage(img, 0);
                mt.waitForAll(2000L);
                if (!mt.isErrorAny() && img.getWidth(null) >= 0) break block38;
                byte[] ary = new byte[32];
                buf.rewind();
                buf.get(ary);
                buf.rewind();
                boolean successOnFallback = false;
                if (ary.length > 2 && ary[0] == -1 && ary[1] == -40) {
                    try {
                        ImageInputStream stream = ImageIO.createImageInputStream(new DataBufferInputStream(buf));
                        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
                        while (iter.hasNext() && !successOnFallback) {
                            ImageReader reader = iter.next();
                            reader.setInput(stream);
                            try {
                                img = reader.read(0);
                            }
                            catch (IIOException e) {
                                buf.rewind();
                                JpegImageInfo info = JpegImageInfo.createInfo(buf);
                                WritableRaster raster = (WritableRaster)reader.readRaster(0, null);
                                if (info.getColorType() == 2) {
                                    DCTDecode.convertYCCKToCMYK(raster);
                                } else if (info.getColorType() == 1) {
                                    DCTDecode.convertYCCA(raster);
                                } else if (DCTDecode.isAdobeConversion(ary)) {
                                    DCTDecode.invertColors(raster);
                                }
                                img = new BufferedImage(raster.getWidth(), raster.getHeight(), 2);
                                ((BufferedImage)img).setData(raster);
                                isCMYK = true;
                                successOnFallback = true;
                            }
                        }
                    }
                    catch (IOException e1) {
                        PDFParser.LOGGER.warn((Object)e1);
                    }
                }
                if (!successOnFallback) {
                    try {
                        buf.rewind();
                        img = ImageIO.read(new DataBufferInputStream(buf));
                        successOnFallback = img != null;
                    }
                    catch (IOException e) {
                        throw new PDFParseException(e);
                    }
                }
                if (!successOnFallback) {
                    throw new PDFParseException("Unable to decode image");
                }
            }
            catch (PDFParseException ex) {
                throw ex;
            }
            catch (InterruptedException e) {
                throw new PDFParseException(e);
            }
        }
        int type = 1;
        if (numComponents == 1) {
            type = 10;
        } else if (numComponents == 4) {
            type = 2;
        }
        if (img instanceof BufferedImage && ((BufferedImage)img).getType() == type) {
            bimg = (BufferedImage)img;
        } else {
            int width = img.getWidth(null);
            int height = img.getHeight(null);
            if (width < 0 || height < 0) {
                throw new PDFParseException("Image has invalid format. Negativ value not expected: " + width + ":" + height);
            }
            bimg = new BufferedImage(width, height, type);
            Graphics bg = bimg.getGraphics();
            bg.drawImage(img, 0, 0, null);
        }
        return new DecodeResult(bimg, isCMYK);
    }

    public static IDataBuffer getImageData(boolean isCMYK, BufferedImage bimg) {
        byte[] output = null;
        PDFImage.checkMemoryForImage(bimg.getWidth(), bimg.getHeight());
        if (bimg.getType() == 1) {
            WritableRaster raster = bimg.getRaster();
            DataBufferInt db = (DataBufferInt)raster.getDataBuffer();
            int[] data = db.getData();
            output = new byte[data.length * 3];
            for (int i = 0; i < data.length; ++i) {
                output[i * 3] = (byte)(data[i] >> 16);
                output[i * 3 + 1] = (byte)(data[i] >> 8);
                output[i * 3 + 2] = (byte)data[i];
            }
        } else if (bimg.getType() == 5) {
            WritableRaster raster = bimg.getRaster();
            DataBufferByte db = (DataBufferByte)raster.getDataBuffer();
            byte[] data = db.getData();
            output = new byte[data.length];
            for (int i = 0; i < data.length / 3; ++i) {
                output[i * 3] = data[i * 3 + 2];
                output[i * 3 + 1] = data[i * 3 + 1];
                output[i * 3 + 2] = data[i * 3];
            }
        } else if (bimg.getType() == 10) {
            DataBufferByte db = (DataBufferByte)bimg.getData().getDataBuffer();
            output = db.getData();
        } else if (bimg.getType() == 2) {
            DataBufferInt db = (DataBufferInt)bimg.getData().getDataBuffer();
            int[] data = db.getData();
            output = new byte[data.length * 4];
            if (isCMYK) {
                for (int i = 0; i < data.length; ++i) {
                    output[i * 4 + 0] = (byte)(data[i] >> 16);
                    output[i * 4 + 1] = (byte)(data[i] >> 8);
                    output[i * 4 + 2] = (byte)data[i];
                    output[i * 4 + 3] = (byte)(data[i] >> 24);
                }
            } else {
                for (int i = 0; i < data.length; ++i) {
                    output[i * 4] = (byte)(data[i] >> 24);
                    output[i * 4 + 1] = (byte)(data[i] >> 16);
                    output[i * 4 + 2] = (byte)(data[i] >> 8);
                    output[i * 4 + 3] = (byte)data[i];
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported BufferedImage format " + bimg.getType());
        }
        return ArrayBuffer.wrap(output);
    }

    private static void convertYCCA(WritableRaster raster) {
        float[] pixel = new float[raster.getNumBands()];
        for (int x = 0; x < raster.getWidth(); ++x) {
            for (int y = 0; y < raster.getHeight(); ++y) {
                raster.getPixel(x, y, pixel);
                float oK = pixel[3];
                pixel[3] = 255.0f - pixel[0];
                pixel[0] = 255.0f - pixel[1];
                pixel[1] = 255.0f - pixel[2];
                pixel[2] = oK;
                raster.setPixel(x, y, pixel);
            }
        }
    }

    public static void invertColors(WritableRaster raster) {
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = width * raster.getNumBands();
        int[] pixelRow = new int[stride];
        for (int h = 0; h < height; ++h) {
            raster.getPixels(0, h, width, 1, pixelRow);
            for (int x = 0; x < stride; ++x) {
                pixelRow[x] = 255 - pixelRow[x];
            }
            raster.setPixels(0, h, width, 1, pixelRow);
        }
    }

    private static int getColorType(Object decoder) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object decodeParam = decoder.getClass().getMethod("getJPEGDecodeParam", new Class[0]).invoke(decoder, new Object[0]);
        int colorType = ((Number)decodeParam.getClass().getMethod("getEncodedColorID", new Class[0]).invoke(decodeParam, new Object[0])).intValue();
        return colorType;
    }

    private static boolean isAdobeConversion(byte[] data) {
        return data.length >= 18 && data[6] == 65 && data[7] == 100 && data[8] == 111 && data[9] == 98 && data[10] == 101 && data[17] == 2;
    }

    private static void convertYCCKToCMYK(WritableRaster raster) {
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = width * 4;
        int[] pixelRow = new int[stride];
        for (int h = 0; h < height; ++h) {
            raster.getPixels(0, h, width, 1, pixelRow);
            for (int x = 0; x < stride; x += 4) {
                int y = pixelRow[x];
                int cb = pixelRow[x + 1];
                int cr = pixelRow[x + 2];
                int c = (int)((double)y + 1.402 * (double)cr - 178.956);
                int m = (int)((double)y - 0.34414 * (double)cb - 0.71414 * (double)cr + 135.95984);
                y = (int)((double)y + 1.772 * (double)cb - 226.316);
                if (c < 0) {
                    c = 0;
                } else if (c > 255) {
                    c = 255;
                }
                if (m < 0) {
                    m = 0;
                } else if (m > 255) {
                    m = 255;
                }
                if (y < 0) {
                    y = 0;
                } else if (y > 255) {
                    y = 255;
                }
                pixelRow[x] = 255 - c;
                pixelRow[x + 1] = 255 - m;
                pixelRow[x + 2] = 255 - y;
            }
            raster.setPixels(0, h, width, 1, pixelRow);
        }
    }

    private static class DecodeResult {
        private BufferedImage img;
        private boolean isCMYK;

        public DecodeResult(BufferedImage img, boolean isCMYK) {
            this.img = img;
            this.isCMYK = isCMYK;
        }
    }
}

