/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.data;

import com.inet.cache.MemoryStoreMap;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.persistence.RandomAccessRead;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;

public class RandomAccessBuffer
implements IDataBuffer,
Closeable {
    private static final int BLOCK_SIZE = 262144;
    private static final int READ_COMPLETELY_LIMIT = 0x200000;
    private int offset = 0;
    private int position;
    private int mark;
    private int limit;
    private int capacity;
    private FileInfo f;

    public RandomAccessBuffer(RandomAccessRead f) throws IOException {
        this.f = new FileInfo(f);
        this.mark = -1;
        this.limit = (int)f.length();
        this.capacity = (int)f.length();
    }

    private RandomAccessBuffer(int position, int mark, int limit, int capacity, int offset, FileInfo raf) {
        this.position = position;
        this.mark = mark;
        this.limit = limit;
        this.capacity = capacity;
        this.f = raf;
        this.offset = offset;
    }

    @Override
    public final IDataBuffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    @Override
    public final int remaining() {
        return this.limit - this.position;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public final IDataBuffer position(int newPosition) {
        if (newPosition > this.limit || newPosition < 0) {
            throw new IllegalArgumentException("Invalid jump stream position " + newPosition + " for limit " + this.limit);
        }
        this.position = newPosition;
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public IDataBuffer get(byte[] dst) {
        this.f.get(this.offset + this.position, dst);
        this.position += dst.length;
        return this;
    }

    @Override
    public final int limit() {
        return this.limit;
    }

    @Override
    public byte get() {
        return this.f.get(this.offset + this.position++);
    }

    @Override
    public byte get(int index) {
        return this.f.getNoSeek(this.offset + index);
    }

    @Override
    public final IDataBuffer limit(int newLimit) {
        if (newLimit > this.capacity || newLimit < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if (this.mark > this.limit) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public IDataBuffer duplicate() {
        return new RandomAccessBuffer(this.position, this.mark, this.limit, this.capacity, this.offset, this.f);
    }

    @Override
    public short getShort() {
        short result = this.f.getShort(this.offset + this.position);
        this.position += 2;
        return result;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final IDataBuffer mark() {
        this.mark = this.position;
        return this;
    }

    @Override
    public final IDataBuffer reset() {
        int m = this.mark;
        if (m < 0) {
            throw new IllegalStateException("Invalid mark: " + m);
        }
        this.position = m;
        return this;
    }

    @Override
    public RandomAccessBuffer slice() {
        return new RandomAccessBuffer(0, -1, this.limit - this.position, this.capacity - this.position, this.offset + this.position, this.f);
    }

    @Override
    public int getInt() {
        int result = this.f.getInt(this.offset + this.position);
        this.position += 4;
        return result;
    }

    @Override
    public long getLong() {
        long result = this.f.getLong(this.offset + this.position);
        this.position += 8;
        return result;
    }

    @Override
    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    @Override
    public final byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final IDataBuffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    @Override
    public IDataBuffer put(byte[] src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char getChar(int index) {
        return this.f.getCharNoSeek(this.offset + index);
    }

    @Override
    public char getChar() {
        char result = this.f.getChar(this.offset + this.position);
        this.position += 2;
        return result;
    }

    @Override
    public void close() {
        try {
            this.f.raf.close();
            this.f.buffer = null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private class FileInfo {
        private RandomAccessRead raf;
        private int filePosition;
        private int bufferBlockNr;
        private byte[] buffer;
        private boolean isBE = ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN;
        private long upperLimit;
        private int bufferSize;
        private MemoryStoreMap<Integer, byte[]> bufferMap;

        public FileInfo(RandomAccessRead raf) throws IOException {
            this.upperLimit = raf.length();
            if (this.upperLimit > 0x200000L) {
                this.bufferMap = new MemoryStoreMap(10, false);
                this.bufferSize = 262144;
            } else {
                this.bufferSize = (int)this.upperLimit;
            }
            this.raf = raf;
            if (this.bufferSize == 0) {
                this.buffer = new byte[0];
                return;
            }
            this.readToBuffer((int)(this.upperLimit < (long)this.bufferSize ? 0L : (this.upperLimit - 1L) / (long)this.bufferSize));
        }

        private boolean access(int logicalPosition, int length) {
            this.readToBuffer(logicalPosition / this.bufferSize);
            return this.bufferMap == null || logicalPosition + length < this.bufferBlockNr * this.bufferSize + this.buffer.length;
        }

        private void readToBuffer(int blockNr) {
            if (this.buffer != null && this.bufferBlockNr == blockNr) {
                return;
            }
            if (this.bufferMap != null) {
                Integer key = blockNr;
                this.buffer = (byte[])this.bufferMap.get((Object)key);
                if (this.buffer != null) {
                    this.bufferBlockNr = blockNr;
                    return;
                }
                try {
                    this.internalSeek(blockNr * this.bufferSize);
                    this.buffer = new byte[this.bufferSize];
                    int length = (int)Math.min((long)this.bufferSize, this.upperLimit - (long)this.filePosition);
                    int read = this.raf.read(this.buffer, 0, length);
                    this.bufferBlockNr = blockNr;
                    this.filePosition += read;
                    this.bufferMap.put((Object)key, (Object)this.buffer);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (blockNr > 0) {
                throw new IllegalStateException("Cannot read new block since there is no storage map set");
            }
            if (this.buffer == null) {
                try {
                    this.internalSeek(blockNr * this.bufferSize);
                    this.buffer = new byte[this.bufferSize];
                    int read = this.raf.read(this.buffer);
                    this.bufferBlockNr = 0;
                    this.filePosition = RandomAccessBuffer.this.position + read;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        private void internalSeek(int position) throws IOException {
            if (position != this.filePosition) {
                this.raf.seek((long)position);
                this.filePosition = position;
            }
        }

        public synchronized byte getNoSeek(int position) {
            int bufferOffset = this.bufferBlockNr * this.bufferSize;
            if (position >= bufferOffset && position < bufferOffset + this.buffer.length) {
                return this.buffer[position - bufferOffset];
            }
            try {
                this.raf.seek((long)position);
                this.filePosition = position + 1;
                return (byte)(this.raf.read() & 0xFF);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public synchronized char getCharNoSeek(int position) {
            int bufferOffset = this.bufferBlockNr * this.bufferSize;
            if (position >= bufferOffset && position + 1 < bufferOffset + this.buffer.length) {
                return this.getCharFromBuffer(position);
            }
            try {
                this.raf.seek((long)position);
                this.filePosition = position + 2;
                return this.raf.readChar();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        private char getCharFromBuffer(int position) {
            position -= this.bufferBlockNr * this.bufferSize;
            if (this.isBE) {
                return (char)((this.buffer[position] << 8) + (this.buffer[position + 1] & 0xFF));
            }
            return (char)((this.buffer[position + 1] << 8) + (this.buffer[position] & 0xFF));
        }

        public synchronized byte get(int position) {
            this.access(position, 1);
            return this.buffer[position - this.bufferBlockNr * this.bufferSize];
        }

        public synchronized char getChar(int position) {
            int offset;
            byte[] buffer;
            int length = 2;
            if (this.access(position, length)) {
                buffer = this.buffer;
                offset = position - this.bufferBlockNr * this.bufferSize;
            } else {
                buffer = this.readChunked(position, length);
                offset = 0;
            }
            if (this.isBE) {
                return (char)((buffer[offset] << 8) + (buffer[offset + 1] & 0xFF));
            }
            return (char)((buffer[offset + 1] << 8) + (buffer[offset] & 0xFF));
        }

        private byte[] readChunked(int position, int length) {
            byte[] bufferPointer = new byte[length];
            int offset = position - this.bufferBlockNr * this.bufferSize;
            int firstChunkSize = this.buffer.length - offset;
            System.arraycopy(this.buffer, offset, bufferPointer, 0, firstChunkSize);
            this.access(position + length - 1, 1);
            System.arraycopy(this.buffer, 0, bufferPointer, 0, length - firstChunkSize);
            return bufferPointer;
        }

        public synchronized short getShort(int position) {
            int offset;
            byte[] buffer;
            int length = 2;
            if (this.access(position, length)) {
                buffer = this.buffer;
                offset = position - this.bufferBlockNr * this.bufferSize;
            } else {
                buffer = this.readChunked(position, length);
                offset = 0;
            }
            if (this.isBE) {
                return (short)((buffer[offset] << 8) + (buffer[offset + 1] & 0xFF));
            }
            return (short)((buffer[offset + 1] << 8) + (buffer[offset] & 0xFF));
        }

        public synchronized int getInt(int position) {
            int offset;
            byte[] buffer;
            int length = 4;
            if (this.access(position, length)) {
                buffer = this.buffer;
                offset = position - this.bufferBlockNr * this.bufferSize;
            } else {
                buffer = this.readChunked(position, length);
                offset = 0;
            }
            if (this.isBE) {
                return (buffer[offset] << 24) + ((buffer[offset + 1] & 0xFF) << 16) + ((buffer[offset + 2] & 0xFF) << 8) + (buffer[offset + 3] & 0xFF);
            }
            return (buffer[offset + 3] << 24) + ((buffer[offset + 2] & 0xFF) << 16) + ((buffer[offset + 1] & 0xFF) << 8) + (buffer[offset] & 0xFF);
        }

        public synchronized long getLong(int position) {
            int offset;
            byte[] buffer;
            int length = 8;
            if (this.access(position, length)) {
                buffer = this.buffer;
                offset = position - this.bufferBlockNr * this.bufferSize;
            } else {
                buffer = this.readChunked(position, length);
                offset = 0;
            }
            if (this.isBE) {
                return ((long)buffer[offset] << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (long)((buffer[offset + 4] & 0xFF) << 24) + (long)((buffer[offset + 5] & 0xFF) << 16) + (long)((buffer[offset + 6] & 0xFF) << 8) + (long)(buffer[offset + 7] & 0xFF);
            }
            return ((long)buffer[offset + 7] << 56) + (((long)buffer[offset + 6] & 0xFFL) << 48) + (((long)buffer[offset + 5] & 0xFFL) << 40) + (((long)buffer[offset + 4] & 0xFFL) << 32) + (long)((buffer[offset + 3] & 0xFF) << 24) + (long)((buffer[offset + 2] & 0xFF) << 16) + (long)((buffer[offset + 1] & 0xFF) << 8) + (long)(buffer[offset] & 0xFF);
        }

        public synchronized void get(int position, byte[] data) {
            if (this.access(position, data.length)) {
                System.arraycopy(this.buffer, position - this.bufferBlockNr * this.bufferSize, data, 0, data.length);
            } else {
                int offset = position - this.bufferBlockNr * this.bufferSize;
                int firstChunkSize = this.buffer.length - offset;
                System.arraycopy(this.buffer, offset, data, 0, firstChunkSize);
                int bytesDone = firstChunkSize;
                while ((long)(position + bytesDone) < this.upperLimit && !this.access(position + bytesDone, data.length - bytesDone)) {
                    System.arraycopy(this.buffer, 0, data, bytesDone, this.buffer.length);
                    bytesDone += this.buffer.length;
                }
                System.arraycopy(this.buffer, 0, data, bytesDone, data.length - bytesDone);
            }
        }
    }
}

