/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.data;

import com.inet.pdfview.PDFParser;
import com.inet.pdfview.data.IDataBuffer;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;

public class FileBuffer
implements IDataBuffer,
Closeable {
    private static final int DEFAULT_BLOCK_SIZE = 0x100000;
    private int offset = 0;
    private int position;
    private int mark;
    private int limit;
    private int capacity;
    private FileInfo f;
    private File f2;

    public FileBuffer(File f) throws IOException {
        this.f2 = f;
        this.f = new FileInfo(new RandomAccessFile(f, "r"), 0x100000);
        this.mark = -1;
        this.limit = (int)f.length();
        this.capacity = (int)f.length();
    }

    private FileBuffer(int position, int mark, int limit, int capacity, int offset, FileInfo raf) {
        this.position = position;
        this.mark = mark;
        this.limit = limit;
        this.capacity = capacity;
        this.f = raf;
        this.offset = offset;
    }

    @Override
    public final IDataBuffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    @Override
    public final int remaining() {
        return this.limit - this.position;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public final IDataBuffer position(int newPosition) {
        if (newPosition > this.limit || newPosition < 0) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public IDataBuffer get(byte[] dst) {
        this.f.get(this.offset + this.position, dst);
        this.position += dst.length;
        return this;
    }

    @Override
    public final int limit() {
        return this.limit;
    }

    @Override
    public byte get() {
        return this.f.get(this.offset + this.position++);
    }

    @Override
    public byte get(int index) {
        return this.f.getNoSeek(this.offset + index);
    }

    @Override
    public final IDataBuffer limit(int newLimit) {
        if (newLimit > this.capacity || newLimit < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if (this.mark > this.limit) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public IDataBuffer duplicate() {
        return new FileBuffer(this.position, this.mark, this.limit, this.capacity, this.offset, this.f);
    }

    @Override
    public short getShort() {
        short result = this.f.getShort(this.offset + this.position);
        this.position += 2;
        return result;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final IDataBuffer mark() {
        this.mark = this.position;
        return this;
    }

    @Override
    public final IDataBuffer reset() {
        int m = this.mark;
        if (m < 0) {
            throw new IllegalStateException("Invalid mark: " + m);
        }
        this.position = m;
        return this;
    }

    @Override
    public FileBuffer slice() {
        return new FileBuffer(0, -1, this.limit - this.position, this.capacity - this.position, this.offset + this.position, this.f);
    }

    @Override
    public int getInt() {
        int result = this.f.getInt(this.offset + this.position);
        this.position += 4;
        return result;
    }

    @Override
    public long getLong() {
        long result = this.f.getLong(this.offset + this.position);
        this.position += 8;
        return result;
    }

    @Override
    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    @Override
    public final byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final IDataBuffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    @Override
    public IDataBuffer put(byte[] src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char getChar(int index) {
        return this.f.getCharNoSeek(this.offset + index);
    }

    @Override
    public char getChar() {
        char result = this.f.getChar(this.offset + this.position);
        this.position += 2;
        return result;
    }

    @Override
    public void close() {
        try {
            this.f.raf.close();
            this.f.buffer = null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private class FileInfo {
        private RandomAccessFile raf;
        private int filePosition;
        private int bufferOffset;
        private int bufferEnd;
        private byte[] buffer;
        private boolean isBE = ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN;
        private int upperLimit;
        private int bufferSize;
        private int offset;

        public FileInfo(RandomAccessFile raf, int bufferSize) throws IOException {
            this.raf = raf;
            this.bufferSize = bufferSize;
            this.upperLimit = (int)raf.length();
            this.buffer = new byte[bufferSize];
            this.offset = raf.length() < (long)this.buffer.length ? 0 : (int)raf.length() - this.buffer.length;
            this.readToBuffer(this.offset, 0, Math.min((int)raf.length(), this.buffer.length));
        }

        private boolean access(int logicalPosition, int length) {
            if (this.buffer == null) {
                this.filePosition = 0;
                this.bufferOffset = 0;
                this.bufferEnd = 0;
                this.buffer = new byte[this.bufferSize];
                try {
                    this.raf = new RandomAccessFile(FileBuffer.this.f2, "r");
                    this.readToBuffer(this.offset, 0, this.bufferSize);
                }
                catch (FileNotFoundException ex) {
                    PDFParser.LOGGER.error((Throwable)ex);
                }
            }
            if (length > this.buffer.length) {
                return false;
            }
            int readEnd = logicalPosition + length;
            if (logicalPosition >= this.bufferOffset && readEnd <= this.bufferEnd) {
                return true;
            }
            if (logicalPosition > this.bufferOffset && logicalPosition < this.bufferEnd) {
                int overlapLength = this.bufferEnd - logicalPosition;
                System.arraycopy(this.buffer, logicalPosition - this.bufferOffset, this.buffer, 0, overlapLength);
                this.readToBuffer(logicalPosition + overlapLength, overlapLength, this.buffer.length - overlapLength);
                return true;
            }
            if (logicalPosition + this.buffer.length > this.bufferOffset && logicalPosition + this.buffer.length < this.bufferEnd) {
                int overlapLength = logicalPosition + this.buffer.length - this.bufferOffset;
                System.arraycopy(this.buffer, 0, this.buffer, this.buffer.length - overlapLength, overlapLength);
                this.readToBuffer(logicalPosition, 0, this.buffer.length - overlapLength);
                return true;
            }
            this.readToBuffer(logicalPosition, 0, this.buffer.length);
            return true;
        }

        private void readToBuffer(int position, int start, int length) {
            try {
                this.internalSeek(position);
                int read = this.raf.read(this.buffer, start, length);
                this.bufferOffset = position - start;
                this.bufferEnd = Math.min(this.upperLimit, this.bufferOffset + this.buffer.length);
                this.filePosition = position + read;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        private void internalSeek(int position) throws IOException {
            if (position != this.filePosition) {
                this.raf.seek(position);
                this.filePosition = position;
            }
        }

        public synchronized byte getNoSeek(int position) {
            if (position >= this.bufferOffset && position < this.bufferEnd) {
                return this.buffer[position - this.bufferOffset];
            }
            try {
                this.raf.seek(position);
                this.filePosition = position + 1;
                return this.raf.readByte();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public synchronized char getCharNoSeek(int position) {
            if (position >= this.bufferOffset && position + 1 < this.bufferEnd) {
                return this.getCharFromBuffer(position);
            }
            try {
                this.raf.seek(position);
                this.filePosition = position + 2;
                return this.raf.readChar();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        private char getCharFromBuffer(int position) {
            position -= this.bufferOffset;
            if (this.isBE) {
                return (char)((this.buffer[position] << 8) + (this.buffer[position + 1] & 0xFF));
            }
            return (char)((this.buffer[position + 1] << 8) + (this.buffer[position] & 0xFF));
        }

        public synchronized byte get(int position) {
            this.access(position, 1);
            return this.buffer[position++ - this.bufferOffset];
        }

        public synchronized char getChar(int position) {
            this.access(position, 2);
            int offset = position - this.bufferOffset;
            if (this.isBE) {
                return (char)((this.buffer[offset] << 8) + (this.buffer[offset + 1] & 0xFF));
            }
            return (char)((this.buffer[offset + 1] << 8) + (this.buffer[offset] & 0xFF));
        }

        public synchronized short getShort(int position) {
            this.access(position, 2);
            int offset = position - this.bufferOffset;
            if (this.isBE) {
                return (short)((this.buffer[offset] << 8) + (this.buffer[offset + 1] & 0xFF));
            }
            return (short)((this.buffer[offset + 1] << 8) + (this.buffer[offset] & 0xFF));
        }

        public synchronized int getInt(int position) {
            this.access(position, 4);
            int offset = position - this.bufferOffset;
            if (this.isBE) {
                return (this.buffer[offset] << 24) + ((this.buffer[offset + 1] & 0xFF) << 16) + ((this.buffer[offset + 2] & 0xFF) << 8) + (this.buffer[offset + 3] & 0xFF);
            }
            return (this.buffer[offset + 3] << 24) + ((this.buffer[offset + 2] & 0xFF) << 16) + ((this.buffer[offset + 1] & 0xFF) << 8) + (this.buffer[offset] & 0xFF);
        }

        public synchronized long getLong(int position) {
            this.access(position, 8);
            int offset = position - this.bufferOffset;
            if (this.isBE) {
                return ((long)this.buffer[offset] << 56) + (((long)this.buffer[offset + 1] & 0xFFL) << 48) + (((long)this.buffer[offset + 2] & 0xFFL) << 40) + (((long)this.buffer[offset + 3] & 0xFFL) << 32) + (long)((this.buffer[offset + 4] & 0xFF) << 24) + (long)((this.buffer[offset + 5] & 0xFF) << 16) + (long)((this.buffer[offset + 6] & 0xFF) << 8) + (long)(this.buffer[offset + 7] & 0xFF);
            }
            return ((long)this.buffer[offset + 7] << 56) + (((long)this.buffer[offset + 6] & 0xFFL) << 48) + (((long)this.buffer[offset + 5] & 0xFFL) << 40) + (((long)this.buffer[offset + 4] & 0xFFL) << 32) + (long)((this.buffer[offset + 3] & 0xFF) << 24) + (long)((this.buffer[offset + 2] & 0xFF) << 16) + (long)((this.buffer[offset + 1] & 0xFF) << 8) + (long)(this.buffer[offset] & 0xFF);
        }

        public synchronized void get(int position, byte[] data) {
            if (this.access(position, data.length)) {
                System.arraycopy(this.buffer, position - this.bufferOffset, data, 0, data.length);
            } else {
                try {
                    this.raf.seek(position);
                    int readLen = this.raf.read(data);
                    this.filePosition = position + readLen;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

