/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.command;

import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.ParserListener;
import com.inet.pdfview.command.PDFCmd;
import com.inet.pdfview.structure.StructureTreeNode;
import java.util.List;
import javax.annotation.Nonnull;

public class PDFSwitchStructureElement
extends PDFCmd {
    @Nonnull
    private List<StructureTreeNode> endPath;
    @Nonnull
    private List<StructureTreeNode> startPath;
    @Nonnull
    private StructureTreeNode node;

    public PDFSwitchStructureElement(@Nonnull StructureTreeNode node, @Nonnull List<StructureTreeNode> endPath, @Nonnull List<StructureTreeNode> startPath) {
        this.node = node;
        this.endPath = endPath;
        this.startPath = startPath;
    }

    @Override
    public void execute(PDFRenderer state) {
        ParserListener listener = state.getParserListener();
        if (listener == null) {
            return;
        }
        if (this.endPath.size() > 0) {
            this.endPath.forEach(n -> listener.endStructureElement(n.getType()));
        }
        if (this.startPath.size() > 0) {
            this.startPath.forEach(n -> listener.startStructureElement(n.getType(), n.getLanguage(), n.getAlt(), n.getActualText()));
        }
    }
}

