/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.command;

import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.command.PDFCmd;
import com.inet.shared.utils.BlendComposite;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PDFShapeCmd
extends PDFCmd {
    public static final int STROKE = 1;
    public static final int FILL = 2;
    public static final int BOTH = 3;
    public static final int CLIP = 4;
    private Shape gp;
    private int style;
    private boolean glyphShape;
    private int pageIndex;

    public PDFShapeCmd(Shape gp, int style, boolean fromGlyph, int pageIndex) {
        this.pageIndex = pageIndex;
        this.gp = gp;
        this.style = style;
        this.glyphShape = fromGlyph;
    }

    @Override
    public String toString() {
        Object s = "";
        if ((this.style & 1) > 0) {
            s = (String)s + "STROKE ";
        }
        if ((this.style & 2) > 0) {
            s = (String)s + "FILL ";
        }
        if ((this.style & 4) > 0) {
            s = (String)s + "CLIP ";
        }
        return "Shape{ shape=" + String.valueOf(this.gp) + ", style=" + ((String)s).toString() + " }";
    }

    @Override
    public void execute(PDFRenderer renderer) {
        Rectangle2D rect = null;
        Paint fillP = null;
        Paint strokeP = null;
        BasicStroke stroke = null;
        if (this.pageIndex < 0) {
            this.pageIndex = renderer.getPageIndex();
        }
        if ((this.style & 2) != 0) {
            PDFPaint fillPaint = renderer.getCurrentState().getFillPaint();
            if (fillPaint != null) {
                fillP = fillPaint.getPaint(renderer);
            }
            if (this.gp != null) {
                BlendComposite fillComposite = renderer.getCurrentState().getFillComposite();
                rect = renderer.drawShapeFilled(this.gp, this.isVisible(), fillComposite);
                if (fillComposite.getAlpha() == 0.0f) {
                    fillP = null;
                }
            }
        }
        if ((this.style & 1) != 0) {
            AffineTransform at;
            PDFPaint strokePaint = renderer.getCurrentState().getStrokePaint();
            if (strokePaint != null) {
                strokeP = strokePaint.getPaint(renderer);
            }
            if ((at = renderer.getTransform()).getScaleX() != 1.0 || at.getScaleY() != 1.0) {
                double factor = Math.sqrt(at.getScaleX() * at.getScaleX() + at.getShearY() * at.getShearY());
                BasicStroke s = renderer.getCurrentState().getStroke();
                stroke = new BasicStroke((float)((double)s.getLineWidth() * factor), s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), s.getDashArray(), s.getDashPhase());
            } else {
                stroke = renderer.getCurrentState().getStroke();
            }
            BlendComposite strokeComposite = renderer.getCurrentState().getStrokeComposite();
            Rectangle2D strokeRect = renderer.drawShapeStroked(this.gp, this.isVisible(), strokeComposite);
            rect = rect == null ? strokeRect : rect.createUnion(strokeRect);
            if (strokeComposite.getAlpha() == 0.0f) {
                strokeP = null;
            }
        }
        if (rect != null && !this.glyphShape && !this.isSkip() && (this.style & 3) != 0) {
            AffineTransform at = renderer.getTransform();
            Shape shape = PDFRenderer.createTransformedShape(this.gp, at);
            rect = shape.getBounds2D();
            Point2D.Double offset = new Point2D.Double(rect.getX(), rect.getY());
            renderer.notifyNewShapeElement(false, this.pageIndex, offset, shape, stroke, strokeP, fillP);
        }
        if ((this.style & 4) != 0) {
            Shape clipShape = renderer.clip(this.gp);
            if (this.gp == null || clipShape == null) {
                renderer.notifyNewShapeElement(true, this.pageIndex, null, null, null, null, null);
            } else {
                rect = clipShape.getBounds2D();
                Point2D.Double offset = new Point2D.Double(rect.getX(), rect.getY());
                renderer.notifyNewShapeElement(true, this.pageIndex, offset, clipShape, null, null, null);
            }
        }
    }

    public void executeAdditionalClip(PDFRenderer renderer) {
        if ((this.style & 4) != 0) {
            Point2D.Double offset = null;
            if (this.gp != null) {
                Rectangle2D rect = this.gp.getBounds2D();
                offset = new Point2D.Double(rect.getX(), rect.getY());
                renderer.notifyNewShapeElement(true, this.pageIndex, offset, null, null, null, null);
            }
            renderer.notifyNewShapeElement((this.style & 4) != 0, this.pageIndex, offset, this.gp, null, null, null);
        }
    }

    public int getStyle() {
        return this.style;
    }

    public Shape getPath() {
        return this.gp;
    }
}

