/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.command;

import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.PDFTextFormat;
import com.inet.pdfview.ParserListener;
import com.inet.pdfview.command.PDFCmd;
import com.inet.pdfview.command.PDFDrawTextCmd;
import com.inet.pdfview.font.FontSupport;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFFontEncoding;
import com.inet.pdfview.font.PDFFontToUnicodeMap;
import com.inet.pdfview.font.Type1Font;
import com.inet.pdfview.font.Type3Font;
import com.inet.pdfview.font.otf.OTFBasedOnAwt;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PDFDrawTextCmds
extends PDFCmd {
    private List<PDFDrawTextCmd> textCommands = new ArrayList<PDFDrawTextCmd>();
    private String actualText;
    private Shape clip;

    public void setClip(Shape clip) {
        this.clip = clip;
    }

    @Nullable
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void execute(PDFRenderer renderer) {
        Paint strokePaint;
        if (this.textCommands.isEmpty()) {
            return;
        }
        PDFDrawTextCmd first = this.textCommands.get(0);
        int mode = first.getTextFormat().getMode();
        Paint fillPaint = (mode & 2) != 0 ? this.getPaint(renderer.getCurrentState().getFillPaint(), renderer) : null;
        Paint paint = strokePaint = (mode & 1) != 0 ? this.getPaint(renderer.getCurrentState().getStrokePaint(), renderer) : null;
        if (fillPaint != null && renderer.getCurrentState().getFillComposite().getAlpha() == 0.0f) {
            fillPaint = null;
        }
        if (strokePaint != null && renderer.getCurrentState().getStrokeComposite().getAlpha() == 0.0f) {
            strokePaint = null;
        }
        for (PDFDrawTextCmd cmd : this.textCommands) {
            cmd.execute(renderer);
        }
        StringBuilder sb = new StringBuilder();
        int charWidthLength = 0;
        int kerninglength = 0;
        for (PDFDrawTextCmd cmd : this.textCommands) {
            sb.append(cmd.getText());
            charWidthLength += cmd.getCharWidths().length;
            if (cmd.getKerning() == null || cmd.getKerning().length <= 0) continue;
            kerninglength += cmd.getKerning().length;
        }
        double[] charWidths = new double[charWidthLength];
        double[] kerning = new double[Math.max(kerninglength, 0)];
        int indexCharWidth = 0;
        int indexKerning = 0;
        for (PDFDrawTextCmd cmd : this.textCommands) {
            double[] cmdCharWidths = cmd.getCharWidths();
            System.arraycopy(cmdCharWidths, 0, charWidths, indexCharWidth, cmdCharWidths.length);
            indexCharWidth += cmdCharWidths.length;
            double[] cmdKerning = Arrays.copyOf(cmd.getKerning(), cmd.getKerning().length);
            if (cmdKerning.length <= 0) continue;
            System.arraycopy(cmdKerning, 0, kerning, indexKerning, cmdKerning.length);
            indexKerning += cmdKerning.length;
        }
        AffineTransform textTransform = first.getTextTransform(renderer);
        if (!this.isSkip()) {
            this.addText(first, sb.toString(), textTransform, fillPaint, strokePaint, charWidths, kerning.length == 0 ? null : kerning, renderer);
        }
        this.actualText = null;
        if (this.clip != null) {
            renderer.clip(new GeneralPath(this.clip));
        }
    }

    private Paint getPaint(PDFPaint paint, PDFRenderer state) {
        return paint != null ? paint.getPaint(state) : null;
    }

    private double[] resize(double[] in, int len, boolean isKerning) {
        double[] out;
        block11: {
            int i;
            block10: {
                int i2;
                if (in == null || len == in.length) {
                    return in;
                }
                out = new double[len];
                if (in.length == 0 || len == 0) {
                    return out;
                }
                double factor = (double)in.length / (double)len;
                System.arraycopy(in, 0, out, 0, Math.min(len, in.length));
                int inlen = in.length;
                if (isKerning) {
                    out[len - 1] = in[inlen - 1];
                    if (len > inlen) {
                        out[inlen - 1] = 0.0;
                    }
                    --len;
                    --inlen;
                }
                if (len <= in.length) break block10;
                double total = 0.0;
                for (i2 = 0; i2 < inlen; ++i2) {
                    total += in[i2];
                }
                if (total == 0.0) break block11;
                i2 = 0;
                while (i2 < inlen) {
                    int n = i2++;
                    out[n] = out[n] * factor;
                }
                for (i2 = inlen; i2 < len; ++i2) {
                    out[i2] = total / (double)len;
                }
                break block11;
            }
            double cutOff = 0.0;
            for (i = len; i < in.length; ++i) {
                cutOff += in[i];
            }
            if (cutOff != 0.0) {
                i = 0;
                while (i < len) {
                    int n = i++;
                    out[n] = out[n] + cutOff / (double)(in.length - len);
                }
            }
        }
        return out;
    }

    public void addCommand(@Nonnull PDFDrawTextCmd cmd) {
        this.textCommands.add(cmd);
    }

    private void addText(PDFDrawTextCmd baseCommand, String text, AffineTransform textTransform, Paint fillPaint, Paint strokePaint, double[] charWidths, double[] kerning, PDFRenderer renderer) {
        boolean hasUnicodemapping;
        PDFTextFormat textFormat = baseCommand.getTextFormat();
        boolean isTwoBytesPerChar = baseCommand.isAlreadyTwoBytePerChars();
        PDFFont font = textFormat.getFont();
        float fontSize = textFormat.getFontSize();
        boolean bl = hasUnicodemapping = font.getUnicodeMapping() != null || font.getEncoding() != null;
        if (this.actualText != null) {
            if (this.actualText.length() != text.length()) {
                kerning = this.resize(kerning, this.actualText.length(), true);
                charWidths = this.resize(charWidths, this.actualText.length(), false);
            }
            text = this.actualText;
        } else if (baseCommand.getListener() != null && baseCommand.getListener().doRead(ParserListener.ELEMENT_TYPE.textNoCharMapping)) {
            hasUnicodemapping = false;
        } else {
            PDFFontToUnicodeMap map = font.getUnicodeMapping();
            if (font instanceof Type1Font) {
                if (map != null) {
                    PDFDrawTextCmd.UnicodeConvertResult result = font.decodeText(text, isTwoBytesPerChar, false);
                    text = result.getContent();
                    hasUnicodemapping &= result.isValidMapping();
                    if (result.getChanges() != null) {
                        AdjustResult adjustResult = this.adjustCharData(charWidths, kerning, result);
                        kerning = adjustResult.kerning;
                        charWidths = adjustResult.charWidths;
                    }
                } else {
                    String encType = ((Type1Font)font).getEncodingType();
                    text = "WinAnsiEncoding".equals(encType) ? font.mapExtraCharacters(text, false) : ("MacRomanEncoding".equals(encType) ? this.encodeCharsFromMac(text) : font.mapExtraCharacters(text, false));
                }
            } else if (font instanceof Type3Font) {
                if (map != null) {
                    PDFDrawTextCmd.UnicodeConvertResult result = PDFDrawTextCmd.getUnicodeStringDiff(map, text, false, isTwoBytesPerChar, null, font);
                    text = result.getContent();
                    hasUnicodemapping &= result.isValidMapping();
                    if (result.getChanges() != null) {
                        AdjustResult adjustResult = this.adjustCharData(charWidths, kerning, result);
                        kerning = adjustResult.kerning;
                        charWidths = adjustResult.charWidths;
                    }
                } else {
                    PDFFontEncoding enc = font.getEncoding();
                    if (enc != null) {
                        text = this.getStringFromEncoding(enc, text);
                    }
                }
                Type3Font t2Font = (Type3Font)font;
                double scale = fontSize <= 1.0f || fontSize == 1.0f && Math.abs(textTransform.getScaleY()) < 1.0 ? (t2Font.getBbox() != null ? Math.min(t2Font.getDesignHeight(), t2Font.getMeasuredHeight()) : t2Font.getMeasuredHeight()) : (t2Font.getDesignHeight() != 0.0 ? t2Font.getDesignHeight() / t2Font.getMeasuredHeight() : t2Font.getMeasuredHeight());
                fontSize = (float)Math.abs((double)fontSize * scale);
                font = new Type3Font.Type3FontScaled(t2Font, scale);
            } else if (font instanceof OTFBasedOnAwt) {
                if (map != null) {
                    PDFDrawTextCmd.UnicodeConvertResult result = PDFDrawTextCmd.getUnicodeStringDiff(map, text, false, isTwoBytesPerChar, null, font);
                    text = result.getContent();
                    AdjustResult adjustResult = this.adjustCharData(charWidths, kerning, result);
                    kerning = adjustResult.kerning;
                    charWidths = adjustResult.charWidths;
                } else {
                    PDFFontEncoding encoding = font.getEncoding();
                    if (encoding != null) {
                        text = this.getStringFromEncoding(encoding, text);
                    } else {
                        PDFDrawTextCmd.UnicodeConvertResult result = font.decodeText(text, isTwoBytesPerChar, false);
                        text = result.getContent();
                        AdjustResult adjustResult = this.adjustCharData(charWidths, kerning, result);
                        kerning = adjustResult.kerning;
                        charWidths = adjustResult.charWidths;
                    }
                }
            } else {
                PDFDrawTextCmd.UnicodeConvertResult result = font.decodeText(text, isTwoBytesPerChar, false);
                text = result.getContent();
                hasUnicodemapping = font.isValidMapping();
                if (result.getChanges() != null) {
                    AdjustResult adjustResult = this.adjustCharData(charWidths, kerning, result);
                    kerning = adjustResult.kerning;
                    charWidths = adjustResult.charWidths;
                }
            }
        }
        if (baseCommand.getListener() != null && baseCommand.getListener().doRead(ParserListener.ELEMENT_TYPE.textNoCharMapping)) {
            hasUnicodemapping = false;
        }
        if (text == null) {
            text = "";
        }
        renderer.notifyNewTextElement(font, fontSize, textTransform, text, fillPaint, strokePaint, charWidths, kerning, hasUnicodemapping);
    }

    private String encodeCharsFromMac(String string) {
        if (string == null || string.length() == 0) {
            return new String();
        }
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            ch = FontSupport.getUnicodeFromMacEncoding(ch);
            strBuilder.append(ch);
        }
        return strBuilder.toString();
    }

    private String getStringFromEncoding(PDFFontEncoding encoding, String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            Character uChar = encoding.getCharFromEncoding(ch);
            if (uChar == null) {
                return string;
            }
            sb.append(uChar.charValue());
        }
        return sb.toString();
    }

    private AdjustResult adjustCharData(double[] charWidths, double[] kerning, PDFDrawTextCmd.UnicodeConvertResult result) {
        if (result.getChanges() == null || charWidths == null) {
            return new AdjustResult(charWidths, kerning);
        }
        int totalAdds = 0;
        for (ContentModification mod : result.getChanges()) {
            totalAdds += mod.inserted - 1;
        }
        double[] newCharWidth = new double[charWidths.length + totalAdds];
        double[] newKerning = kerning != null ? new double[kerning.length + totalAdds] : null;
        int sourceIndex = 0;
        int targetIndex = 0;
        for (ContentModification mod : result.getChanges()) {
            int len = mod.index - sourceIndex;
            if (mod.inserted == 0 && charWidths.length > mod.index + 1) {
                if (kerning != null && targetIndex > 0) {
                    int n = mod.index + 1;
                    kerning[n] = kerning[n] + (kerning[mod.index] + charWidths[mod.index]);
                } else {
                    int n = mod.index + 1;
                    charWidths[n] = charWidths[n] + charWidths[mod.index];
                }
            }
            if (len > 0) {
                System.arraycopy(charWidths, sourceIndex, newCharWidth, targetIndex, len);
                if (kerning != null) {
                    System.arraycopy(kerning, sourceIndex, newKerning, targetIndex, len);
                }
                targetIndex += len;
                sourceIndex += len;
            }
            if (mod.inserted > 1) {
                double value = charWidths[sourceIndex] / (double)mod.inserted;
                for (int i = 0; i < mod.inserted; ++i) {
                    newCharWidth[targetIndex + i] = value;
                }
                if (newKerning != null && kerning != null) {
                    newKerning[targetIndex] = kerning[mod.index];
                }
            }
            ++sourceIndex;
            targetIndex += mod.inserted;
        }
        if (sourceIndex < charWidths.length) {
            System.arraycopy(charWidths, sourceIndex, newCharWidth, targetIndex, charWidths.length - sourceIndex);
            if (kerning != null) {
                System.arraycopy(kerning, sourceIndex, newKerning, targetIndex, charWidths.length - sourceIndex);
            }
        }
        return new AdjustResult(newCharWidth, newKerning);
    }

    public void setActualText(String actualText) {
        this.actualText = actualText;
    }

    public String getActualText() {
        return this.actualText;
    }

    public List<PDFDrawTextCmd> getTextCommands() {
        return this.textCommands;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (PDFDrawTextCmd cmd : this.textCommands) {
            b.append(cmd.getText());
        }
        return "DrawTextCmds{ text='" + String.valueOf(b) + "', font=" + String.valueOf(this.textCommands.size() > 0 ? this.textCommands.get(0).getTextFormat().getFont() : "no content") + " chunks=" + this.textCommands.size() + " }";
    }

    @Override
    public void setIsVisible(boolean isVisible) {
        super.setIsVisible(isVisible);
        for (PDFDrawTextCmd cmd : this.textCommands) {
            cmd.setIsVisible(isVisible);
        }
    }

    private static class AdjustResult {
        private double[] charWidths;
        private double[] kerning;

        public AdjustResult(double[] charWidths, double[] kerning) {
            this.charWidths = charWidths;
            this.kerning = kerning;
        }
    }

    public static class ContentModification
    implements Comparable<ContentModification> {
        private int index;
        private int inserted;

        public ContentModification(int index, int inserted) {
            this.index = index;
            this.inserted = inserted;
        }

        @Override
        public int compareTo(ContentModification o) {
            return this.index - o.index;
        }
    }
}

