/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.colorspace;

public enum StandardIlluminant {
    ILLUMINANT_D50(0.964296, 1.0, 0.8251),
    ILLUMINANT_D55(0.33411, 0.34877),
    ILLUMINANT_D65(0.31382, 0.331),
    ILLUMINANT_D75(0.29968, 0.3174);

    private final double valueOfX;
    private final double valueOfY;
    private final double valueOfZ;

    private StandardIlluminant(double valX, double valY, double valZ) {
        this.valueOfX = valX;
        this.valueOfY = valY;
        this.valueOfZ = valZ;
    }

    private StandardIlluminant(double x, double y) {
        this.valueOfY = 1.0;
        this.valueOfX = x * this.valueOfY / y;
        this.valueOfZ = (1.0 - x - y) * this.valueOfY / y;
    }

    float[] getXYZAsArray() {
        return new float[]{(float)this.valueOfX, (float)this.valueOfY, (float)this.valueOfZ};
    }

    double getX() {
        return this.valueOfX;
    }

    double getY() {
        return this.valueOfY;
    }

    double getZ() {
        return this.valueOfZ;
    }
}

