/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.colorspace;

import com.inet.logging.LogManager;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import java.awt.Color;

public class IndexedColor
extends PDFColorSpace {
    private static final long serialVersionUID = -5001983708768477622L;
    protected byte[] finalcolors;
    Color[] table;
    int count;
    int nchannels = 1;

    public IndexedColor(PDFColorSpace base, int count, PDFObject stream, PDFDecrypter decryptor) throws PDFParseException {
        super(null);
        this.count = ++count;
        int numComponent = base.getNumComponents();
        this.table = new Color[count];
        PDFXref ref = stream.getRefValue();
        byte[] data = stream.getStream(ref, decryptor, true);
        if (data.length > count * numComponent) {
            if (LogManager.getApplicationLogger().isDebug()) {
                LogManager.getApplicationLogger().debug((Object)("Index color table contains " + data.length + " entries. it will be corrected"));
            }
            byte[] newdata = new byte[data.length];
            int j = 0;
            for (int i = 0; i < data.length; ++i) {
                byte b = data[i];
                if (b == 13 || b == 10) continue;
                newdata[j++] = b;
            }
            if (j != count * numComponent && LogManager.getApplicationLogger().isDebug()) {
                LogManager.getApplicationLogger().debug((Object)("Modified Index color table would contain too many entries: " + j + " it will be reset"));
            }
            data = new byte[count * numComponent];
            System.arraycopy(newdata, 0, data, 0, Math.min(j, data.length));
        }
        this.finalcolors = new byte[3 * count];
        float[] comps = new float[numComponent];
        this.nchannels = base.getNumComponents();
        int loc = 0;
        int arrSize = data.length;
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j < comps.length; ++j) {
                byte val = loc < arrSize ? data[loc++] : data[arrSize - 1];
                comps[j] = (float)(val & 0xFF) / 255.0f;
            }
            this.table[i] = (Color)base.getPaint(comps).getPaint(null);
            this.finalcolors[i * 3] = (byte)this.table[i].getRed();
            this.finalcolors[i * 3 + 1] = (byte)this.table[i].getGreen();
            this.finalcolors[i * 3 + 2] = (byte)this.table[i].getBlue();
        }
    }

    public IndexedColor(Color[] table) throws PDFParseException {
        super(null);
        this.count = table.length;
        this.table = table;
        this.finalcolors = new byte[3 * this.count];
        this.nchannels = 3;
        int loc = 0;
        for (int i = 0; i < this.count; ++i) {
            this.finalcolors[loc++] = (byte)table[i].getRed();
            this.finalcolors[loc++] = (byte)table[i].getGreen();
            this.finalcolors[loc++] = (byte)table[i].getBlue();
        }
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getColorComponents() {
        return this.finalcolors;
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    @Override
    public PDFPaint getPaint(float[] components) {
        return PDFPaint.getPaint(this.table[(int)components[0]]);
    }

    public Color[] getTable() {
        return this.table;
    }
}

