/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.colorspace;

public class BaseChromaticAdaptationTransform {
    private float[] initialWhitePoint = null;
    private float[] targetWhitePoint = null;

    protected BaseChromaticAdaptationTransform(float[] initialWhitePoint, float[] targetWhitePoint) {
        this.initialWhitePoint = (float[])initialWhitePoint.clone();
        this.targetWhitePoint = (float[])targetWhitePoint.clone();
    }

    public float[] transform(float[] initialXYZ) {
        float[] targetXYZ = new float[initialXYZ.length];
        for (int i = 0; i < initialXYZ.length; ++i) {
            targetXYZ[i] = initialXYZ[i] * this.targetWhitePoint[i] / this.initialWhitePoint[i];
        }
        return targetXYZ;
    }

    double[] getSourceWhitePointDouble() {
        return new double[]{this.initialWhitePoint[0], this.initialWhitePoint[1], this.initialWhitePoint[2]};
    }

    double[] getTargetWhitePointDouble() {
        return new double[]{this.targetWhitePoint[0], this.targetWhitePoint[1], this.targetWhitePoint[2]};
    }
}

