/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.pdfview.BaseWatchable;
import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.PDFFile;
import com.inet.pdfview.PDFImage;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.PDFSMask;
import com.inet.pdfview.PDFTextFormat;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.ParserListener;
import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.colorspace.PatternSpace;
import com.inet.pdfview.command.PDFClipCommand;
import com.inet.pdfview.command.PDFCmd;
import com.inet.pdfview.command.PDFCompositeCmd;
import com.inet.pdfview.command.PDFImageCmd;
import com.inet.pdfview.command.PDFPopCmd;
import com.inet.pdfview.command.PDFPopFormCmd;
import com.inet.pdfview.command.PDFPushCmd;
import com.inet.pdfview.command.PDFPushFormCmd;
import com.inet.pdfview.command.PDFShapeCmd;
import com.inet.pdfview.command.PDFSwitchStructureElement;
import com.inet.pdfview.command.PDFXformCmd;
import com.inet.pdfview.control.ControlData;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.NullFont;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.optionalcontent.OCG;
import com.inet.pdfview.optionalcontent.OCGHandler;
import com.inet.pdfview.optionalcontent.VisibilityFlag;
import com.inet.pdfview.pattern.PDFShader;
import com.inet.pdfview.structure.StructureTreeHandler;
import com.inet.pdfview.structure.StructureTreeNode;
import com.inet.shared.utils.BlendComposite;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;

public class PDFParser
extends BaseWatchable {
    public static final Logger LOGGER = LogManager.getLogger((String)"PDFParser");
    private Set<String> errorMessages;
    private static final Map<String, String> PARSER_TRACE_MAP = new HashMap<String, String>(){
        {
            this.put("q", "Push the parser state");
            this.put("Q", "Pop parser and graphics state");
            this.put("cm", "Set transform to array of values");
            this.put("w", "set stroke width");
            this.put("J", "set end cap style");
            this.put("j", "set line join style");
            this.put("M", "set miter limit");
            this.put("d", "set dash style and phase");
            this.put("ri", "rendering intent");
            this.put("i", "flatness tolerance");
            this.put("gs", "set graphics state to values in a named dictionary");
            this.put("m", "path move to");
            this.put("l", "path line to");
            this.put("c", "path curve to");
            this.put("v", "path curve; first control point= start");
            this.put("y", "path curve; last control point= end");
            this.put("h", "path close");
            this.put("re", "path add rectangle");
            this.put("S", "stroke the path");
            this.put("s", "close and stroke the path");
            this.put("f", "fill the path (close/not close identical)");
            this.put("F", "fill the path (close/not close identical)");
            this.put("f*", "fill the path using even/odd rule");
            this.put("F*", "fill the path using even/odd rule");
            this.put("B", "fill and stroke the path");
            this.put("B*", "fill path using even/odd rule and stroke it");
            this.put("b", "close the path, then fill and stroke it");
            this.put("b*", "close path, fill using even/odd rule, then stroke it");
            this.put("n", "clip with the path and discard it");
            this.put("W", "mark this path for clipping!");
            this.put("W*", "mark this path using even/odd rule for clipping");
            this.put("sh", "shade a region that is defined by the shader itself");
            this.put("CS", "set the stroke color space");
            this.put("cs", "set the fill color space");
            this.put("SC", "set the stroke color");
            this.put("SCN", "set fill paint or stroke paint");
            this.put("sc", "set the fill color");
            this.put("scn", "set fill paint");
            this.put("G", "set the stroke color to a Gray value");
            this.put("g", "set the fill color to a Gray value");
            this.put("RG", "set the stroke color to an RGB value");
            this.put("rg", "set the fill color to an RGB value");
            this.put("K", "set the stroke color to a CMYK value");
            this.put("k", "set the fill color to a CMYK value");
            this.put("Do", "make a do call on the referenced object");
            this.put("BT", "begin text block:  reset everything.");
            this.put("ET", "end of text.  noop");
            this.put("Tc", "set character spacing");
            this.put("Tw", "set word spacing");
            this.put("Tz", "set horizontal scaling");
            this.put("TL", "set leading");
            this.put("Tf", "set text font");
            this.put("Tr", "set text rendering mode");
            this.put("Ts", "set text rise");
            this.put("Td", "set text matrix location");
            this.put("TD", "set leading and matrix:  -y TL x y Td");
            this.put("Tm", "set text matrix");
            this.put("T*", "go to next line");
            this.put("Tj", "show text");
            this.put("'", "next line and show text:  T* string Tj");
            this.put("\"", "draw string on new line with char & word spacing");
            this.put("TJ", "show kerned string");
            this.put("BI", "parse inline image");
            this.put("BX", "catchexceptions= true");
            this.put("EX", "catchexceptions= false");
            this.put("MP", "mark point (role= mark role name)");
            this.put("DP", "mark point with dictionary (role, ref)");
            this.put("BMC", "begin marked content (role)");
            this.put("BDC", "begin marked content with dict (role, ref)");
            this.put("EMC", "");
            this.put("d0", "");
            this.put("d1", "");
            this.put("QBT", "");
        }
    };
    private Stack<Object> stack;
    private Stack<ParserState> parserStates;
    private Stack<List<OCG>> ocStack;
    private ParserState state;
    private GeneralPath path;
    private boolean errorState = false;
    private int clip;
    private int loc;
    private boolean resend = false;
    private Tok tok;
    private boolean catchexceptions;
    private boolean isType3GlyphParser;
    private PDFPage cmds;
    private byte[] stream;
    private Map<String, PDFObject> resources;
    private boolean isHexadezimal;
    private boolean ignoreParseExceptions = "true".equals(System.getProperty("pdfcIgnoreParseExceptions", ""));
    private PDFDecrypter decryptor;
    private OCGHandler ocgHandler;
    private Map<String, List<OCG>> ocgMap = new HashMap<String, List<OCG>>();
    private VisibilityFlag isOCVisible = new VisibilityFlag();
    private ParserListener listener;
    private CacheAccess cache;
    private PDFFile owner;
    boolean isAlphaChannel = false;
    private StructureTreeHandler structureHandler;
    private Stack<StructureTreeNode> structureStack;
    private boolean isPopStructurePending = false;

    public PDFParser(PDFPage cmds, byte[] stream, Map<String, PDFObject> resources, CacheAccess fontGenerationListener, PDFFile owner) {
        this(cmds, stream, resources, fontGenerationListener, null, null, owner);
    }

    public PDFParser(PDFPage cmds, byte[] stream, Map<String, PDFObject> resources, CacheAccess cache, OCGHandler ocgHandler, StructureTreeHandler structureHandler, PDFFile owner) {
        if (LOGGER.isDebug()) {
            LOGGER.debug((Object)"PDFParser c-tor");
        }
        if (cmds == null) {
            throw new IllegalArgumentException("PDFParser requires a page instance to parse!");
        }
        this.owner = owner;
        this.ocgHandler = ocgHandler;
        this.structureHandler = structureHandler;
        this.cache = cache;
        this.cmds = cmds;
        this.resources = resources;
        this.stream = stream;
        this.decryptor = cmds.getDecrypter();
        if (resources == null) {
            this.resources = new HashMap<String, PDFObject>();
        } else {
            PDFObject propertiesObject = this.resources.get("Properties");
            if (propertiesObject != null) {
                try {
                    Map<String, PDFObject> properties = propertiesObject.getDictionary();
                    if (properties != null) {
                        for (Map.Entry<String, PDFObject> e : properties.entrySet()) {
                            List<OCG> ocg = OCG.getOCG(e.getValue());
                            if (ocg == null) continue;
                            this.ocgMap.put(e.getKey(), ocg);
                        }
                    }
                }
                catch (PDFParseException e) {
                    LOGGER.error((Throwable)((Object)e));
                }
            }
        }
    }

    public void setParserListener(ParserListener listener) {
        this.listener = listener;
    }

    private Tok nextToken() {
        if (this.resend) {
            this.resend = false;
            return this.tok;
        }
        this.tok = new Tok();
        while (this.loc < this.stream.length && PDFFile.isWhiteSpace(this.stream[this.loc])) {
            ++this.loc;
        }
        if (this.loc >= this.stream.length) {
            this.tok.type = -1;
            return this.tok;
        }
        byte c = this.stream[this.loc++];
        while (c == 37) {
            StringBuffer comment = new StringBuffer();
            while (this.loc < this.stream.length && c != 10) {
                comment.append((char)c);
                c = this.stream[this.loc++];
            }
            while (this.loc < this.stream.length && PDFFile.isWhiteSpace(c)) {
                c = this.stream[this.loc++];
            }
            if (LOGGER.isDebug()) {
                LOGGER.debug((Object)("Read comment: " + comment.toString()));
            }
            if (this.loc != this.stream.length) continue;
            this.tok.type = -1;
            return this.tok;
        }
        if (c == 91) {
            this.tok.type = 9;
        } else if (c == 93) {
            this.tok.type = 8;
        } else if (c == 40) {
            this.tok.type = 7;
            this.tok.name = this.readString();
        } else if (c == 123) {
            this.tok.type = 5;
        } else if (c == 125) {
            this.tok.type = 4;
        } else if (c == 60 && this.stream[this.loc++] == 60) {
            this.tok.type = 11;
        } else if (c == 62 && this.stream[this.loc++] == 62) {
            this.tok.type = 10;
        } else if (c == 60) {
            --this.loc;
            this.tok.type = 7;
            this.tok.name = this.readByteArray();
            this.isHexadezimal = true;
        } else if (c == 47) {
            this.tok.type = 1;
            this.tok.name = this.readName();
        } else if (c == 46 || c == 45 || c >= 48 && c <= 57 || c == 43) {
            --this.loc;
            this.tok.type = 3;
            this.tok.value = this.readNum();
        } else if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 39 || c == 34) {
            --this.loc;
            this.tok.type = 2;
            this.tok.name = this.readName();
        } else {
            if (LOGGER.isDebug()) {
                LOGGER.debug((Object)("Encountered character: " + c + " (" + (char)c + ")"));
            }
            this.tok.type = 0;
        }
        if (LOGGER.isDebug()) {
            LOGGER.debug((Object)("Read token: " + String.valueOf(this.tok)));
        }
        return this.tok;
    }

    private String readName() {
        int start = this.loc;
        while (this.loc < this.stream.length && !PDFFile.isDelimiter(this.stream[this.loc])) {
            ++this.loc;
        }
        return new String(this.stream, start, this.loc - start);
    }

    private double readNum() {
        double value;
        boolean neg;
        block5: {
            byte c;
            neg = (c = this.stream[this.loc++]) == 45;
            boolean sawdot = c == 46;
            double dotmult = sawdot ? 0.1 : 1.0;
            double d = value = c >= 48 && c <= 57 ? (double)(c - 48) : 0.0;
            while (true) {
                if ((c = this.stream[this.loc++]) == 46) {
                    if (sawdot) {
                        --this.loc;
                        break block5;
                    }
                    sawdot = true;
                    dotmult = 0.1;
                    continue;
                }
                if (c < 48 || c > 57) break;
                int val = c - 48;
                if (sawdot) {
                    value += (double)val * dotmult;
                    dotmult *= 0.1;
                    continue;
                }
                value = value * 10.0 + (double)val;
            }
            --this.loc;
        }
        if (neg) {
            value = -value;
        }
        return value;
    }

    private String readString() {
        int parenthesesCount = 1;
        StringBuffer sb = new StringBuffer();
        while (this.loc < this.stream.length) {
            int c;
            if ((c = this.stream[this.loc++] & 0xFF) == 41) {
                if (--parenthesesCount == 0) {
                    break;
                }
            } else if (c == 40) {
                ++parenthesesCount;
            } else if (c == 92) {
                if ((c = this.stream[this.loc++] & 0xFF) >= 48 && c <= 57) {
                    int val = 0;
                    for (int count = 0; c >= 48 && c <= 57 && count < 3; ++count) {
                        val = val * 8 + c - 48;
                        c = this.stream[this.loc++];
                    }
                    --this.loc;
                    c = val;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 98) {
                    c = 8;
                } else if (c == 102) {
                    c = 12;
                } else if (c == 92) {
                    c = 92;
                } else if (c == 40) {
                    c = 40;
                } else if (c == 41) {
                    c = 41;
                } else if (c == 13) continue;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    private String readByteArray() {
        StringBuffer buf = new StringBuffer();
        int count = 0;
        char w = '\u0000';
        while (this.loc < this.stream.length && this.stream[this.loc] != 62) {
            char c = (char)this.stream[this.loc];
            byte b = 0;
            if (c >= '0' && c <= '9') {
                b = (byte)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                b = (byte)(10 + (c - 97));
            } else if (c >= 'A' && c <= 'F') {
                b = (byte)(10 + (c - 65));
            } else {
                ++this.loc;
                continue;
            }
            int offset = 1 - count % 2;
            w = (char)(w | (0xF & b) << offset * 4);
            if (offset == 0) {
                buf.append(w);
                w = '\u0000';
            }
            ++count;
            ++this.loc;
        }
        ++this.loc;
        return buf.toString();
    }

    @Override
    public void setup() {
        this.stack = new Stack();
        this.parserStates = new Stack();
        this.ocStack = new Stack();
        this.structureStack = new Stack();
        this.state = new ParserState();
        this.path = new GeneralPath();
        this.loc = 0;
        this.clip = 0;
        this.state.fillCS = PDFColorSpace.getColorSpace(0);
        this.state.strokeCS = PDFColorSpace.getColorSpace(0);
        this.state.textFormat = new PDFTextFormat(this.isOCVisible);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public int iterate() throws Exception {
        block208: {
            if (this.cmds == null) {
                if (PDFParser.LOGGER.isDebug()) {
                    PDFParser.LOGGER.debug((Object)"Page gone.  Stopping");
                }
                return 5;
            }
            try {
                obj = this.parseObject();
                if (obj == null) {
                    this.doAnnots2();
                    return 6;
                }
                if (obj instanceof Tok) {
                    block207: {
                        cmd = ((Tok)obj).name.intern();
                        if (PDFParser.LOGGER.isDebug()) {
                            stackTrace = new StringBuilder();
                            for (E o : this.stack) {
                                if (stackTrace.length() > 0) {
                                    stackTrace.append(", ");
                                }
                                stackTrace.append(o);
                            }
                            PDFParser.LOGGER.debug((Object)("Command: " + cmd + "  = " + PDFParser.PARSER_TRACE_MAP.get(cmd) + " (stack size is " + this.stack.size() + " = " + stackTrace.toString() + ")"));
                        }
                        if (this.isPopStructurePending && cmd != "BDC") {
                            this.reduceStructureLevel();
                            this.isPopStructurePending = false;
                        }
                        if (cmd == "q") {
                            this.parserStates.push((ParserState)this.state.clone());
                            this.cmds.addPush();
                        } else if (cmd == "Q") {
                            this.processQCmd();
                        } else if (cmd == "cm") {
                            elts = this.popFloat(cmd, 6);
                            xform = new AffineTransform(elts);
                            this.cmds.addXform(xform);
                        } else if (cmd == "w") {
                            width = this.popFloat();
                            this.cmds.addStrokeWidth(width);
                        } else if (cmd == "J") {
                            this.cmds.addEndCap(this.popInt());
                        } else if (cmd == "j") {
                            this.cmds.addLineJoin(this.popInt());
                        } else if (cmd == "M") {
                            this.cmds.addMiterLimit(this.popInt());
                        } else if (cmd == "d") {
                            phase = this.popFloat();
                            dashary = this.popFloatArray();
                            this.cmds.addDash(dashary, phase);
                        } else if (cmd != "ri") {
                            if (cmd == "i") {
                                this.popFloat();
                            } else if (cmd == "gs") {
                                this.setGSState(this.popString());
                            } else if (cmd == "m") {
                                y = this.popFloat();
                                x = this.popFloat();
                                this.path.moveTo(x, y);
                            } else if (cmd == "l") {
                                y = this.popFloat();
                                x = this.popFloat();
                                if (this.path.getCurrentPoint() != null) {
                                    this.path.lineTo(x, y);
                                }
                            } else if (cmd == "c") {
                                a = this.popFloat(cmd, 6);
                                if (this.path.getCurrentPoint() != null) {
                                    this.path.curveTo(a[0], a[1], a[2], a[3], a[4], a[5]);
                                }
                            } else if (cmd == "v") {
                                a = this.popFloat(cmd, 4);
                                cp = this.path.getCurrentPoint();
                                if (cp != null) {
                                    this.path.curveTo((float)cp.getX(), (float)cp.getY(), a[0], a[1], a[2], a[3]);
                                }
                            } else if (cmd == "y") {
                                a = this.popFloat(cmd, 4);
                                if (this.path.getCurrentPoint() != null) {
                                    this.path.curveTo(a[0], a[1], a[2], a[3], a[2], a[3]);
                                }
                            } else if (cmd == "h") {
                                try {
                                    this.closePath();
                                }
                                catch (IllegalPathStateException e) {
                                    if (!PDFParser.LOGGER.isError()) ** GOTO lbl435
                                }
                            } else if (cmd == "re") {
                                a = this.popFloat(cmd, 4);
                                this.path.moveTo(a[0], a[1]);
                                this.path.lineTo(a[0] + a[2], a[1]);
                                this.path.lineTo(a[0] + a[2], a[1] + a[3]);
                                this.path.lineTo(a[0], a[1] + a[3]);
                                this.path.closePath();
                            } else if (cmd == "S") {
                                this.addPathCommand(1);
                            } else if (cmd == "s") {
                                if (this.path.getCurrentPoint() != null) {
                                    this.path.closePath();
                                    this.addPathCommand(1);
                                }
                                this.clip = 0;
                                this.path = new GeneralPath();
                            } else if (cmd == "f" || cmd == "F") {
                                this.closePath();
                                this.addPathCommand(2);
                            } else if (cmd == "f*" || cmd == "F*") {
                                this.path.setWindingRule(0);
                                this.closePath();
                                this.addPathCommand(2);
                            } else if (cmd == "B") {
                                this.closePath();
                                this.addPathCommand(3);
                            } else if (cmd == "B*") {
                                this.path.setWindingRule(0);
                                this.addPathCommand(3);
                            } else if (cmd == "b") {
                                this.closePath();
                                this.addPathCommand(3);
                            } else if (cmd == "b*") {
                                this.closePath();
                                this.path.setWindingRule(0);
                                this.addPathCommand(3);
                            } else if (cmd == "n") {
                                if (this.clip != 0 && this.isOCVisible.isVisible()) {
                                    this.addPath(this.path, this.clip);
                                }
                                this.clip = 0;
                                this.path = new GeneralPath();
                            } else if (cmd == "W") {
                                this.clip = 4;
                            } else if (cmd == "W*") {
                                this.path.setWindingRule(0);
                                this.clip = 4;
                            } else if (cmd == "sh") {
                                gdictname = this.popString();
                                shobj = this.findResource(gdictname, "Shading");
                                this.doShader(shobj, PDFParser.getShaderFillPath(this.cmds));
                            } else if (cmd == "CS") {
                                this.state.strokeCS = this.parseColorSpace(new PDFObject(this.stack.pop(), this.owner));
                            } else if (cmd == "cs") {
                                this.state.fillCS = this.parseColorSpace(new PDFObject(this.stack.pop(), this.owner));
                            } else if (cmd == "SC") {
                                this.cmds.addStrokePaint(this.state.strokeCS.getPaint(this.popFloat(cmd, this.state.strokeCS.getNumComponents())));
                            } else if (cmd == "SCN") {
                                try {
                                    if (this.state.strokeCS instanceof PatternSpace) {
                                        this.cmds.addStrokePaint(this.doPattern((PatternSpace)this.state.strokeCS));
                                        break block207;
                                    }
                                    this.cmds.addStrokePaint(this.state.strokeCS.getPaint(this.popFloat(cmd, this.state.strokeCS.getNumComponents())));
                                }
                                catch (PDFParseException e) {
                                    PDFParser.LOGGER.warn((Object)"Failure during pattern parsing");
                                    PDFParser.LOGGER.warn((Object)e);
                                }
                            } else if (cmd == "sc") {
                                this.cmds.addFillPaint(this.state.fillCS.getPaint(this.popFloat(cmd, this.state.fillCS.getNumComponents())));
                            } else if (cmd == "scn") {
                                try {
                                    if (this.state.fillCS instanceof PatternSpace) {
                                        paint = this.doPattern((PatternSpace)this.state.fillCS);
                                        if (paint != null) {
                                            this.cmds.addFillPaint(paint);
                                        }
                                        break block207;
                                    }
                                    this.cmds.addFillPaint(this.state.fillCS.getPaint(this.popFloat(cmd, this.state.fillCS.getNumComponents())));
                                }
                                catch (PDFParseException e) {
                                    PDFParser.LOGGER.warn((Object)"Failure during pattern parsing");
                                    PDFParser.LOGGER.warn((Object)e);
                                }
                            } else if (cmd == "G") {
                                this.state.strokeCS = PDFColorSpace.getColorSpace(1);
                                this.cmds.addStrokePaint(this.state.strokeCS.getPaint(this.grayToRGB()));
                            } else if (cmd == "g") {
                                this.state.fillCS = PDFColorSpace.getColorSpace(1);
                                this.cmds.addFillPaint(this.state.fillCS.getPaint(this.grayToRGB()));
                            } else if (cmd == "RG") {
                                this.state.strokeCS = PDFColorSpace.getColorSpace(1);
                                this.cmds.addStrokePaint(this.state.strokeCS.getPaint(this.popFloat(cmd, 3)));
                            } else if (cmd == "rg") {
                                this.state.fillCS = PDFColorSpace.getColorSpace(1);
                                this.cmds.addFillPaint(this.state.fillCS.getPaint(this.popFloat(cmd, 3)));
                            } else if (cmd == "K") {
                                this.state.strokeCS = PDFColorSpace.getColorSpace(2);
                                this.cmds.addStrokePaint(this.state.strokeCS.getPaint(this.popFloat(cmd, 4)));
                            } else if (cmd == "k") {
                                this.state.fillCS = PDFColorSpace.getColorSpace(2);
                                this.cmds.addFillPaint(this.state.fillCS.getPaint(this.popFloat(cmd, 4)));
                            } else if (cmd == "Do") {
                                resId = PDFObject.decodeName(this.popString());
                                xobj = this.findResource(resId, "XObject");
                                if (xobj == null) {
                                    if (PDFParser.LOGGER.isWarning()) {
                                        PDFParser.LOGGER.warn((Object)("Image is missing: " + resId));
                                    }
                                } else {
                                    this.doXObject(xobj);
                                }
                            } else if (cmd == "BT") {
                                this.processBTCmd();
                            } else if (cmd == "ET") {
                                this.state.textFormat.end();
                            } else if (cmd == "Tc") {
                                this.state.textFormat.setCharSpacing(this.popFloat());
                            } else if (cmd == "Tw") {
                                this.state.textFormat.setWordSpacing(this.popFloat());
                            } else if (cmd == "Tz") {
                                this.state.textFormat.setHorizontalScale(this.popFloat());
                            } else if (cmd == "TL") {
                                this.state.textFormat.setLeading(this.popFloat());
                            } else if (cmd == "Tf") {
                                sz = this.popFloat();
                                fontref = this.popString();
                                this.state.textFormat.setFont(this.getFontFrom(fontref), sz);
                            } else if (cmd == "Tr") {
                                this.state.textFormat.setMode(this.popInt());
                            } else if (cmd == "Ts") {
                                this.state.textFormat.setRise(this.popFloat());
                            } else if (cmd == "Td") {
                                y = this.popFloat();
                                x = this.popFloat();
                                this.state.textFormat.carriageReturn(x, y);
                            } else if (cmd == "TD") {
                                y = this.popFloat();
                                x = this.popFloat();
                                this.state.textFormat.setLeading(-y);
                                this.state.textFormat.carriageReturn(x, y);
                            } else if (cmd == "Tm") {
                                this.state.textFormat.setMatrix(this.popFloat(cmd, 6));
                            } else if (cmd == "T*") {
                                this.state.textFormat.carriageReturn();
                            } else if (cmd == "Tj") {
                                text = this.popString();
                                if (this.listener == null || this.listener.doRead(ParserListener.ELEMENT_TYPE.text)) {
                                    textWrapper = new PDFTextFormat.TextWrapper(text, false, this.listener);
                                    this.state.textFormat.doText(this.cmds, textWrapper, this.isHexadezimal);
                                }
                                this.isHexadezimal = false;
                            } else if (cmd == "'") {
                                text = this.popString();
                                this.state.textFormat.carriageReturn();
                                if (this.listener == null || this.listener.doRead(ParserListener.ELEMENT_TYPE.text)) {
                                    textWrapper = new PDFTextFormat.TextWrapper(text, false, this.listener);
                                    this.state.textFormat.doText(this.cmds, textWrapper, this.isHexadezimal);
                                }
                                this.isHexadezimal = false;
                            } else if (cmd == "\"") {
                                string = this.popString();
                                ac = this.popFloat();
                                aw = this.popFloat();
                                this.state.textFormat.setWordSpacing(aw);
                                this.state.textFormat.setCharSpacing(ac);
                                if (this.listener == null || this.listener.doRead(ParserListener.ELEMENT_TYPE.text)) {
                                    textWrapper = new PDFTextFormat.TextWrapper(string, false, this.listener);
                                    this.state.textFormat.doText(this.cmds, textWrapper, this.isHexadezimal);
                                }
                            } else if (cmd == "TJ") {
                                array = this.popArray();
                                if (array.length != 0 && (this.listener == null || this.listener.doRead(ParserListener.ELEMENT_TYPE.text))) {
                                    this.state.textFormat.doTextExt2(this.cmds, array, false, this.listener);
                                }
                                this.isHexadezimal = false;
                            } else if (cmd == "BI") {
                                this.parseInlineImage();
                            } else if (cmd == "BX") {
                                this.catchexceptions = true;
                            } else if (cmd == "EX") {
                                this.catchexceptions = false;
                            } else if (cmd == "MP") {
                                this.popString();
                            } else if (cmd == "DP") {
                                this.popDP();
                            } else if (cmd == "BMC") {
                                name = this.popObject();
                                this.ocStack.add(null);
                            } else if (cmd == "BDC") {
                                description = this.popObject();
                                if (description instanceof Map) {
                                    map = (HashMap<Object, Object>)description;
                                    name = this.popObject();
                                } else {
                                    map = new HashMap<Object, Object>();
                                    name = description;
                                    value = description;
                                    while (this.stack.size() > 0) {
                                        o = this.popObject();
                                        if (value != null) {
                                            map.put(o, value);
                                            value = null;
                                        } else {
                                            value = o;
                                        }
                                        name = o;
                                    }
                                }
                                text = map.get("ActualText");
                                if (text instanceof PDFObject) {
                                    pdfObject = (PDFObject)text;
                                    this.state.textFormat.setActualText(pdfObject.getStringValue());
                                }
                                if ((ocLabel /* !! */  = map.get("OC")) instanceof PDFObject) {
                                    ocLabel /* !! */  = ((PDFObject)ocLabel /* !! */ ).getStringValue();
                                }
                                if (ocLabel /* !! */  instanceof String) {
                                    label = (String)ocLabel /* !! */ ;
                                    ocgs = this.ocgMap.get(label);
                                    this.ocStack.add(ocgs);
                                    this.updateVisibility();
                                } else {
                                    this.ocStack.add(null);
                                }
                                if (this.structureHandler != null) {
                                    mcid = map.get("MCID");
                                    pushed = false;
                                    if (mcid != null) {
                                        mcidValue = -1;
                                        if (mcid instanceof PDFObject) {
                                            mcidValue = ((PDFObject)mcid).getIntValue();
                                        }
                                        if (mcid instanceof Number) {
                                            mcidValue = ((Number)mcid).intValue();
                                        }
                                        if (mcidValue >= 0) {
                                            node = this.structureHandler.getNodeForMCID(mcidValue, this.cmds.getPageIndex());
                                            if (node != null) {
                                                if (!node.getTypeString().equals(name)) {
                                                    PDFParser.LOGGER.warn((Object)("Inconsistent strcuture types: " + String.valueOf((Object)node.getType()) + " <-> " + String.valueOf(name)));
                                                }
                                                if (this.isPopStructurePending && !this.structureStack.isEmpty()) {
                                                    this.structureStack.pop();
                                                }
                                                this.structureStack.push(node);
                                                command = this.structureHandler.getSwitchCommand(node);
                                                if (command != null) {
                                                    this.cmds.addCommand(command);
                                                }
                                                this.isPopStructurePending = false;
                                                pushed = true;
                                                if (text == null && (structureText = node.getActualText()) != null) {
                                                    this.state.textFormat.setActualText(structureText);
                                                }
                                            } else if (PDFParser.LOGGER.isDebug()) {
                                                PDFParser.LOGGER.debug((Object)("No structure found for BMC '" + String.valueOf(name) + "', MCID=" + mcidValue));
                                            }
                                        }
                                    }
                                    if (this.isPopStructurePending) {
                                        this.reduceStructureLevel();
                                        this.isPopStructurePending = false;
                                    }
                                    if (!pushed) {
                                        this.structureStack.push(null);
                                    }
                                }
                                this.stack.clear();
                            } else if (cmd == "EMC") {
                                this.state.textFormat.setActualText(null);
                                try {
                                    this.ocStack.pop();
                                }
                                catch (EmptyStackException e) {
                                    this.showUniqueErrMessage("Empty Stack for EMC command 'OC' found");
                                }
                                this.isPopStructurePending = true;
                                this.updateVisibility();
                            } else if (cmd == "d0") {
                                this.popFloat(cmd, 2);
                            } else if (cmd == "d1") {
                                this.popFloat(cmd, 6);
                            } else if (cmd == "QBT") {
                                this.processQCmd();
                                this.processBTCmd();
                            } else if (cmd == "PS") {
                                try {
                                    var3_4 = this.popString();
                                }
                                catch (Throwable var3_16) {
                                    // empty catch block
                                }
                                this.showUniqueErrMessage("unknown command 'PS'");
                            } else if (this.catchexceptions) {
                                if (PDFParser.LOGGER.isWarning()) {
                                    PDFParser.LOGGER.warn((Object)("**** WARNING: Unknown command: " + cmd + " **************************"));
                                }
                            } else {
                                throw new PDFParseException("Unknown command: " + cmd + " Array(" + Arrays.toString(cmd.getBytes()) + ")");
                            }
                        }
                    }
                    if (this.stack.size() != 0) {
                        PDFParser.LOGGER.warn((Object)("**** WARNING! Stack not zero! (cmd=" + cmd + ", size=" + this.stack.size() + ") *************************"));
                        this.stack.setSize(0);
                    }
                    break block208;
                }
                this.stack.push(obj);
            }
            catch (Exception exception) {
                if (this.ignoreParseExceptions) {
                    PDFParser.LOGGER.error((Object)"Parse error");
                    PDFParser.LOGGER.error((Throwable)exception);
                }
                throw exception;
            }
        }
        return 4;
    }

    private void closePath() {
        try {
            if (this.path.getCurrentPoint() != null) {
                this.path.closePath();
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)e);
        }
        this.errorState = false;
    }

    protected void reduceStructureLevel() {
        if (this.structureHandler != null) {
            try {
                PDFSwitchStructureElement command;
                StructureTreeNode level = this.structureStack.pop();
                if (level != null && (command = this.structureHandler.getSwitchCommand(level)) != null) {
                    this.cmds.addCommand(command);
                }
            }
            catch (EmptyStackException e) {
                this.showUniqueErrMessage("Empty Stack for EMC command 'MCID' found");
            }
        }
    }

    private void addPathCommand(int drawType) {
        if (this.isOCVisible.isVisible() && !this.errorState) {
            this.addPath(this.path, drawType | this.clip);
        }
        this.clip = 0;
        this.path = new GeneralPath();
    }

    public void addPath(Shape path, int style) {
        if (this.listener == null || this.listener.doRead(ParserListener.ELEMENT_TYPE.shape)) {
            this.cmds.addCommand(new PDFShapeCmd(path, style, this.isType3GlyphParser, this.cmds.getPageIndex()));
        }
    }

    private void updateVisibility() {
        this.isOCVisible.setVisible(true);
        if (this.ocgHandler == null || this.ocStack.size() == 0) {
            return;
        }
        for (List list : this.ocStack) {
            if (list == null) continue;
            boolean anyOn = false;
            for (OCG ocg : list) {
                if (ocg == null || !this.ocgHandler.isVisible(ocg)) continue;
                anyOn = true;
                return;
            }
            if (anyOn) continue;
            this.isOCVisible.setVisible(false);
            return;
        }
    }

    private void processQCmd() {
        if (this.parserStates.isEmpty()) {
            LOGGER.warn((Object)"Corrupt PDF data: Graphics state restore command without a corresponding save command");
            return;
        }
        this.cmds.addPop();
        this.state = this.parserStates.pop();
    }

    private void processBTCmd() {
        this.state.textFormat.reset();
    }

    @Override
    public void cleanup() {
        PDFSwitchStructureElement command;
        if (this.structureHandler != null && (command = this.structureHandler.getSwitchCommand(null)) != null) {
            this.cmds.addCommand(command);
        }
        this.state.textFormat.flush();
        this.cmds.finish();
        this.stack = null;
        this.parserStates = null;
        this.state = null;
        this.path = null;
        this.cmds = null;
    }

    public void setType3GlyphParser(boolean isType3GlyphParser) {
        this.isType3GlyphParser = isType3GlyphParser;
    }

    private PDFObject findResource(String name, String inDict) throws PDFParseException {
        if (inDict != null) {
            PDFObject in = this.resources.get(inDict);
            if (in == null || in.getType() != 6) {
                throw new PDFParseException("No dictionary called " + inDict + " found in the resources");
            }
            return in.getDictRef(name);
        }
        return this.resources.get(name);
    }

    private void doXObject(PDFObject obj) throws PDFParseException {
        if (obj == null) {
            throw new PDFParseException("Null object");
        }
        PDFObject subType = obj.getDictRef("Subtype");
        if (subType == null) {
            throw new PDFParseException("Subtype not defined :" + String.valueOf(obj));
        }
        String type = subType.getStringValue();
        if (type.equals("Image")) {
            this.doImage(obj);
        } else if (type.equals("Form")) {
            this.doForm(obj, null, false);
        } else {
            throw new PDFParseException("Unknown XObject subtype: " + type);
        }
    }

    private void doImage(PDFObject obj) throws PDFParseException {
        if (this.isOCVisible.isVisible() && (this.listener == null || this.listener.doRead(ParserListener.ELEMENT_TYPE.image))) {
            PDFImage image = PDFImage.createImage(obj, this.resources, this.decryptor, this.cache, this.isAlphaChannel);
            this.cmds.addCommand(new PDFImageCmd(image, this.isType3GlyphParser));
        }
    }

    private void doForm(PDFObject obj, Rectangle2D rect, boolean skipCreate) throws PDFParseException {
        PDFPage formCmds = (PDFPage)obj.getCache();
        AffineTransform at = new AffineTransform();
        PDFObject matrix = obj.getDictRef("Matrix");
        if (matrix != null) {
            float[] elts = new float[6];
            for (int i = 0; i < elts.length; ++i) {
                elts[i] = matrix.getAt(i).getFloatValue();
            }
            at = new AffineTransform(elts);
        }
        PDFObject bobj = obj.getDictRef("BBox");
        Rectangle2D.Float bbox = PDFFile.parseRect(bobj);
        if (rect != null) {
            at.translate(rect.getX(), rect.getY());
            double sx = rect.getWidth() / ((RectangularShape)bbox).getWidth();
            double sy = rect.getHeight() / ((RectangularShape)bbox).getHeight();
            if (Math.abs(sx - 1.0) > 0.2) {
                at.scale(sx, 1.0);
            }
            if (Math.abs(sy - 1.0) > 0.2) {
                at.scale(1.0, sy);
            }
        }
        if (formCmds == null) {
            PDFXref ref;
            byte[] formStream;
            List<PDFCmd> commands = this.cmds.getCommands();
            AffineTransform init = this.cmds.getInitialTransform();
            for (int i = commands.size() - 1; i >= 0; --i) {
                PDFCmd lastElement = commands.get(i);
                if (!(lastElement instanceof PDFXformCmd)) continue;
                PDFXformCmd transformLast = (PDFXformCmd)lastElement;
                init.concatenate(transformLast.getTransform());
                break;
            }
            formCmds = new PDFPage(this.cmds.getPageIndex(), bbox, init, 0, this.decryptor, null, null);
            PDFObject groupObj = obj.getDictRef("Group");
            if (groupObj != null && groupObj.getDictRef("S") != null && groupObj.getDictRef("S") != null && "Transparency".equals(groupObj.getDictRef("S").getStringValue())) {
                if (groupObj.getDictRef("I") != null) {
                    formCmds.getGroup().setIsolated(groupObj.getDictRef("I").getBooleanValue());
                }
                if (groupObj.getDictRef("K") != null) {
                    formCmds.getGroup().setKnockout(groupObj.getDictRef("K").getBooleanValue());
                }
                if (groupObj.getDictRef("CS") != null) {
                    formCmds.getGroup().setColorspace(this.parseColorSpace(groupObj.getDictRef("CS").dereference()));
                }
            }
            formCmds.setSkipDrawable(skipCreate);
            HashMap<String, PDFObject> r = new HashMap<String, PDFObject>(this.resources);
            PDFObject rsrc = obj.getDictRef("Resources");
            if (rsrc != null) {
                r.putAll(rsrc.getDictionary());
            }
            if ((formStream = obj.getStream(ref = obj.getRefValue(), this.decryptor, false)) != null) {
                PDFParser form = new PDFParser(formCmds, formStream, r, this.cache, this.owner);
                form.isAlphaChannel = this.isAlphaChannel;
                form.go(true);
                if (form.getFirstError() != null) {
                    this.setError(form.getFirstError());
                }
            }
            obj.setCache(formCmds);
        }
        if (this.isOCVisible.isVisible()) {
            this.cmds.addPush();
            this.cmds.addCommand(new PDFXformCmd(new AffineTransform(at)));
            if (bbox != null) {
                this.cmds.addCommand(new PDFClipCommand(bbox));
            }
            this.cmds.addCommand(new PDFPushFormCmd(formCmds.getGroup()));
            this.cmds.addCommands(formCmds);
            this.cmds.addCommand(new PDFPopFormCmd());
            this.cmds.addPop();
        }
    }

    private PDFPaint doPattern(PatternSpace patternSpace) throws PDFParseException {
        float[] components = null;
        String patternName = this.popString();
        PDFObject pattern = this.findResource(patternName, "Pattern");
        if (pattern == null) {
            throw new PDFParseException("Unknown pattern : " + patternName);
        }
        if (this.stack.size() > 0) {
            components = this.popFloat("SCN", this.stack.size());
        }
        return patternSpace.getPaint(pattern, components, this.resources, this.decryptor, this.cache, this.cmds, this.isAlphaChannel);
    }

    private Object parseObject() throws PDFParseException {
        Tok t = this.nextToken();
        if (t.type == 3) {
            return this.tok.value;
        }
        if (t.type == 7) {
            return this.tok.name;
        }
        if (t.type == 1) {
            return this.tok.name;
        }
        if (t.type == 11) {
            Object obj;
            HashMap<String, PDFObject> hm = new HashMap<String, PDFObject>();
            String name = null;
            while ((obj = this.parseObject()) != null) {
                if (name == null) {
                    name = (String)obj;
                    continue;
                }
                hm.put(name, new PDFObject(obj, this.owner));
                name = null;
            }
            if (this.tok.type != 10) {
                throw new PDFParseException("Inline dict should have ended with '>>'");
            }
            return hm;
        }
        if (t.type == 9) {
            Object obj;
            ArrayList<Object> ary = new ArrayList<Object>();
            while ((obj = this.parseObject()) != null) {
                ary.add(obj);
            }
            if (this.tok.type != 8) {
                throw new PDFParseException("Expected ']'");
            }
            return ary.toArray();
        }
        if (t.type == 2) {
            return t;
        }
        if (LOGGER.isDebug()) {
            LOGGER.debug((Object)("**** WARNING! parseObject unknown token! (t.type=" + t.type + ") *************************"));
        }
        return null;
    }

    private void parseInlineImage() throws PDFParseException {
        HashMap<String, PDFObject> hm = new HashMap<String, PDFObject>();
        while (true) {
            Tok t = this.nextToken();
            if (t.type == 2 && t.name.equals("ID")) break;
            String name = t.name;
            if (name.equals("BPC")) {
                name = "BitsPerComponent";
            } else if (name.equals("CS")) {
                name = "ColorSpace";
            } else if (name.equals("D")) {
                name = "Decode";
            } else if (name.equals("DP")) {
                name = "DecodeParms";
            } else if (name.equals("F")) {
                name = "Filter";
            } else if (name.equals("H")) {
                name = "Height";
            } else if (name.equals("IM")) {
                name = "ImageMask";
            } else if (name.equals("W")) {
                name = "Width";
            } else if (name.equals("I")) {
                name = "Interpolate";
            }
            Object vobj = this.parseObject();
            if (vobj instanceof String) {
                vobj = this.getFullName((String)vobj);
            } else if (vobj instanceof Object[]) {
                Object[] arr = (Object[])vobj;
                for (int i = 0; i < arr.length; ++i) {
                    if (!(arr[i] instanceof String)) continue;
                    arr[i] = this.getFullName((String)arr[i]);
                }
            }
            hm.put(name, new PDFObject(vobj, this.owner));
        }
        if (this.stream[this.loc] == 13) {
            ++this.loc;
        }
        if (this.stream[this.loc] == 10 || this.stream[this.loc] == 32) {
            ++this.loc;
        }
        PDFObject obj = new PDFObject(this.owner, 6, hm);
        int dstart = this.loc;
        while (!(this.loc >= this.stream.length - 1 || this.stream[this.loc] == 69 && this.stream[this.loc + 1] == 73 && this.loc < this.stream.length - 2 && PDFParser.isStrictWhiteSpace(this.stream[this.loc + 2]))) {
            ++this.loc;
        }
        byte[] data = new byte[this.loc - dstart];
        System.arraycopy(this.stream, dstart, data, 0, this.loc - dstart);
        obj.setStream(ArrayBuffer.wrap(data));
        this.loc += 3;
        this.doImage(obj);
    }

    private void doShader(PDFObject shaderObj, Shape clipPath) throws PDFParseException {
        Paint paint = null;
        if (this.isOCVisible.isVisible()) {
            PDFShader shader;
            try {
                shader = PDFShader.getShader(shaderObj, this.resources, this.decryptor, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), paint, this.isAlphaChannel);
            }
            catch (PDFParseException e) {
                LOGGER.error((Throwable)((Object)e));
                return;
            }
            this.cmds.addPush();
            this.cmds.addFillPaint(shader.getPaint());
            Rectangle2D bbox = shader.getBBox();
            clipPath = PDFParser.getIntersection(bbox, clipPath);
            if (clipPath != null) {
                this.addPath(clipPath, 2);
            }
            this.cmds.addPop();
        }
    }

    private PDFFont getFontFrom(String fontref) throws PDFParseException {
        PDFObject obj = this.findResource(fontref, "Font");
        if (obj == null) {
            LOGGER.warn((Object)("Cannot find Font '" + fontref + "' on page " + this.cmds.getPageIndex()));
            return new NullFont("_NORESOURCE_");
        }
        try {
            PDFFont font = PDFFont.getFont(obj, null, this.resources, this.decryptor, null, this.cache, null);
            font.setCacheAccess(this.cache);
            return font;
        }
        catch (RuntimeException e) {
            LOGGER.error("Error while parsing font '" + fontref + "'", (Throwable)e);
            return new NullFont("_NORESOURCE_");
        }
    }

    private void setGSState(String name) throws PDFParseException {
        PDFSMask pdfsMask;
        PDFObject gsobj;
        PDFCompositeCmd pdfCompositeCmd = new PDFCompositeCmd(name);
        try {
            gsobj = this.findResource(name, "ExtGState");
            if (gsobj == null) {
                return;
            }
        }
        catch (PDFParseException e) {
            LOGGER.warn((Object)e);
            return;
        }
        PDFObject d = gsobj.getDictRef("LW");
        if (d != null) {
            this.cmds.addStrokeWidth(d.getFloatValue());
        }
        if ((d = gsobj.getDictRef("LC")) != null) {
            this.cmds.addEndCap(d.getIntValue());
        }
        if ((d = gsobj.getDictRef("LJ")) != null) {
            this.cmds.addLineJoin(d.getIntValue());
        }
        if ((d = gsobj.getDictRef("Font")) != null) {
            this.state.textFormat.setFont(this.getFontFrom(d.getAt(0).getStringValue()), d.getAt(1).getFloatValue());
        }
        if ((d = gsobj.getDictRef("ML")) != null) {
            this.cmds.addMiterLimit(d.getFloatValue());
        }
        if ((d = gsobj.getDictRef("D")) != null) {
            PDFObject[] pdash = d.getAt(0).getArray();
            float[] dash = new float[pdash.length];
            for (int i = 0; i < pdash.length; ++i) {
                dash[i] = pdash[i].getFloatValue();
            }
            this.cmds.addDash(dash, d.getAt(1).getFloatValue());
        }
        if ((d = gsobj.getDictRef("CA")) != null) {
            pdfCompositeCmd.setAlphaStroke(d.getFloatValue());
        }
        if ((d = gsobj.getDictRef("ca")) != null) {
            pdfCompositeCmd.setAlphaFill(d.getFloatValue());
        }
        if ((d = gsobj.getDictRef("SM")) != null) {
            float pdash = d.getFloatValue();
        }
        if ((d = gsobj.getDictRef("AIS")) != null) {
            boolean pdash = d.getBooleanValue();
        }
        if ((d = gsobj.getDictRef("BM")) != null) {
            BlendComposite.BlendingMode blendingMode = BlendComposite.BlendingMode.NORMAL;
            switch (d.getStringValue().toUpperCase()) {
                case "NORMAL": {
                    break;
                }
                case "MULTIPLY": {
                    blendingMode = BlendComposite.BlendingMode.MULTIPLY;
                    break;
                }
                case "LUMINOSITY": {
                    blendingMode = BlendComposite.BlendingMode.LUMINOSITY;
                    break;
                }
                case "SCREEN": {
                    blendingMode = BlendComposite.BlendingMode.SCREEN;
                    break;
                }
                case "DARKEN": {
                    blendingMode = BlendComposite.BlendingMode.DARKEN;
                    break;
                }
                case "DIFFERENCE": {
                    blendingMode = BlendComposite.BlendingMode.DIFFERENCE;
                    break;
                }
                case "HARDLIGHT": {
                    blendingMode = BlendComposite.BlendingMode.HARD_LIGHT;
                    break;
                }
                case "COLOR": {
                    blendingMode = BlendComposite.BlendingMode.COLOR;
                    break;
                }
                case "EXCLUSION": {
                    blendingMode = BlendComposite.BlendingMode.EXCLUSION;
                    break;
                }
                case "COLORDODGE": {
                    blendingMode = BlendComposite.BlendingMode.COLOR_DODGE;
                    break;
                }
                case "COLORBURN": {
                    blendingMode = BlendComposite.BlendingMode.COLOR_BURN;
                    break;
                }
                case "OVERLAY": {
                    blendingMode = BlendComposite.BlendingMode.OVERLAY;
                    break;
                }
                case "LIGHTEN": {
                    blendingMode = BlendComposite.BlendingMode.LIGHTEN;
                    break;
                }
                case "SOFTLIGHT": {
                    blendingMode = BlendComposite.BlendingMode.SOFT_LIGHT;
                    break;
                }
                case "HUE": {
                    blendingMode = BlendComposite.BlendingMode.HUE;
                    break;
                }
                case "SATURATION": {
                    blendingMode = BlendComposite.BlendingMode.SATURATION;
                    break;
                }
                default: {
                    LOGGER.error((Object)("Blendmode currently not activate: " + String.valueOf(d) + " value => " + d.getStringValue()));
                }
            }
            pdfCompositeCmd.setBlendingMode(blendingMode);
        }
        if ((d = gsobj.getDictRef("TK")) != null) {
            boolean blendingMode = d.getBooleanValue();
        }
        if (!((d = gsobj.getDictRef("SMask")) == null || (pdfsMask = this.parseSMask(d)) == null || d.getType() == 3 && "None".equals(d.getStringValue()))) {
            pdfCompositeCmd.setPdfsMask(pdfsMask);
        }
        if ((d = gsobj.getDictRef("HT")) != null) {
            // empty if block
        }
        if ((d = gsobj.getDictRef("OPM")) != null) {
            // empty if block
        }
        if ((d = gsobj.getDictRef("op")) != null) {
            boolean bl = d.getBooleanValue();
        }
        if ((d = gsobj.getDictRef("BG")) != null) {
            // empty if block
        }
        if ((d = gsobj.getDictRef("UCR")) != null) {
            // empty if block
        }
        if ((d = gsobj.getDictRef("TR")) != null) {
            // empty if block
        }
        this.cmds.addCommand(pdfCompositeCmd);
    }

    private PDFSMask parseSMask(PDFObject smask) throws PDFParseException {
        PDFObject[] xObject;
        PDFObject dereference = smask.dereference();
        if (dereference.getCache() instanceof PDFSMask) {
            return (PDFSMask)dereference.getCache();
        }
        PDFObject d = dereference.getDictRef("S");
        if (d != null) {
            String string = d.getStringValue();
        }
        int numOfCommands = this.cmds.getCommandCount();
        d = dereference.getDictRef("G");
        if (d != null) {
            xObject = d.dereference();
            this.isAlphaChannel = true;
            this.doXObject((PDFObject)xObject);
            this.isAlphaChannel = false;
        }
        if ((d = dereference.getDictRef("BC")) != null) {
            xObject = d.getArray();
        }
        if ((d = dereference.getDictRef("TR")) != null) {
            // empty if block
        }
        if ((d = dereference.getDictRef("CS")) != null) {
            // empty if block
        }
        ArrayList<PDFCmd> pdfCmds = new ArrayList<PDFCmd>(this.cmds.getCommands().subList(numOfCommands, this.cmds.getCommandCount()));
        this.cmds.getCommands().removeAll(pdfCmds);
        PDFSMask mask = new PDFSMask(pdfCmds, true, this.cache);
        return mask;
    }

    PDFColorSpace parseColorSpace(PDFObject csobj) throws PDFParseException {
        if (csobj == null) {
            return this.state.fillCS;
        }
        return PDFColorSpace.getColorSpace(csobj, this.resources, this.decryptor);
    }

    private float popFloat() throws PDFParseException {
        if (this.stack.isEmpty()) {
            this.errorState = true;
            return 0.0f;
        }
        Object obj = this.stack.pop();
        if (obj instanceof Double) {
            return ((Double)obj).floatValue();
        }
        throw new PDFParseException("Expected a number here.");
    }

    private float[] popFloat(String cmd, int count) throws PDFParseException {
        float[] ary = new float[count];
        if (this.stack.size() < count) {
            if ((cmd == "SC" || cmd == "sc") && count == 3 && this.stack.size() == 1) {
                float value = this.popFloat();
                Arrays.fill(ary, value);
                return ary;
            }
            this.stack.clear();
            if (LOGGER.isWarning()) {
                LOGGER.warn((Object)("Insufficient components for '" + cmd + "', expected " + count + ", was " + this.stack.size()));
            }
            this.errorState = true;
            return ary;
        }
        for (int i = count - 1; i >= 0; --i) {
            ary[i] = this.popFloat();
        }
        return ary;
    }

    private int popInt() throws PDFParseException {
        Object obj = this.stack.pop();
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        throw new PDFParseException("Expected a number here.");
    }

    private float[] popFloatArray() throws PDFParseException {
        Object obj = this.stack.pop();
        if (!(obj instanceof Object[])) {
            throw new PDFParseException("Expected an [array] here.");
        }
        Object[] source = (Object[])obj;
        float[] ary = new float[source.length];
        for (int i = 0; i < ary.length; ++i) {
            if (!(source[i] instanceof Double)) {
                throw new PDFParseException("This array doesn't consist only of floats.");
            }
            ary[i] = ((Double)source[i]).floatValue();
        }
        return ary;
    }

    private String popString() throws PDFParseException {
        Object obj = this.stack.pop();
        if (!(obj instanceof String)) {
            throw new PDFParseException("Expected string here: " + obj.toString());
        }
        return (String)obj;
    }

    private Object popDP() throws PDFParseException {
        Object obj = this.stack.pop();
        if (obj instanceof String) {
            return obj;
        }
        if (obj instanceof HashMap) {
            return obj;
        }
        throw new PDFParseException("Expected string or hashmap here: " + obj.toString());
    }

    private Object popObject() throws PDFParseException {
        Object obj = this.stack.pop();
        if (LOGGER.isDebug() && !(obj instanceof PDFObject) && !(obj instanceof HashMap)) {
            LOGGER.debug((Object)("Expected a reference here: " + obj.toString()));
        }
        return obj;
    }

    private Object[] popArray() throws PDFParseException {
        Object obj = this.stack.pop();
        if (!(obj instanceof Object[])) {
            throw new PDFParseException("Expected an [array] here: " + obj.toString());
        }
        return (Object[])obj;
    }

    private String getFullName(String shortName) {
        if ("G".equals(shortName)) {
            shortName = "DeviceGray";
        } else if ("RGB".equals(shortName)) {
            shortName = "DeviceRGB";
        } else if ("CMYK".equals(shortName)) {
            shortName = "DeviceCMYK";
        } else if ("I".equals(shortName)) {
            shortName = "Indexed";
        } else if ("AHx".equals(shortName)) {
            shortName = "ASCIIHexDecode";
        } else if ("A85".equals(shortName)) {
            shortName = "ASCII85Decode";
        } else if ("LZW".equals(shortName)) {
            shortName = "Indexed";
        } else if ("Fl".equals(shortName)) {
            shortName = "FlateDecode";
        } else if ("RL".equals(shortName)) {
            shortName = "RunLengthDecode";
        } else if ("CCF".equals(shortName)) {
            shortName = "CCITTFaxDecode";
        } else if ("DCT".equals(shortName)) {
            shortName = "DCTDecode";
        }
        return shortName;
    }

    private void doAnnots2() throws PDFParseException {
        PDFObject[] annotations = this.cmds.getAnnots();
        if (annotations == null) {
            return;
        }
        List<ControlData> controls = this.cmds.getControlElems();
        for (PDFObject annotation : annotations) {
            PDFObject subtype = annotation.getDictRef("Subtype");
            if (subtype == null || subtype.getStringValue() == null) continue;
            if (subtype.getStringValue().equals("Widget")) {
                if (controls == null) continue;
                for (ControlData controlData : controls) {
                    PDFObject formObj;
                    if (!controlData.getAnnot().equals(annotation)) continue;
                    PDFPage resourceCommands = controlData.getDefaultTextStyleCmds();
                    if (resourceCommands != null) {
                        for (PDFCmd command : resourceCommands.getCommands()) {
                            this.cmds.addCommand(command);
                        }
                    }
                    if ((formObj = controlData.getFormObject()) != null) {
                        Rectangle2D rect = controlData.getBounds();
                        this.doForm(formObj, rect, true);
                    }
                    if (this.listener == null || !this.listener.doRead(ParserListener.ELEMENT_TYPE.annotation)) continue;
                    this.listener.addControl(controlData);
                }
                continue;
            }
            try {
                if (this.listener == null || !this.listener.doRead(ParserListener.ELEMENT_TYPE.annotation)) continue;
                this.listener.addAnnotationElement(annotation, this.cmds, this.decryptor, this.cache);
            }
            catch (PDFParseException e) {
                if (this.ignoreParseExceptions) {
                    LOGGER.warn((Object)e);
                    continue;
                }
                LOGGER.error((Throwable)((Object)e));
            }
        }
    }

    private float[] grayToRGB() throws PDFParseException, IllegalStateException {
        float[] colorVals = this.popFloat("G", 1);
        if (colorVals.length == 0) {
            throw new IllegalStateException("gray color is not defined");
        }
        float comp = colorVals[0];
        return new float[]{comp, comp, comp};
    }

    static Shape getShaderFillPath(PDFPage cmds) throws NoninvertibleTransformException {
        int popCount = 0;
        Shape clipPath = null;
        int size = cmds.getCommandCount();
        Stack<PDFXformCmd> locStack = new Stack<PDFXformCmd>();
        while (--size >= 0) {
            PDFShapeCmd lastShapeCmd;
            PDFCmd previousCmd = cmds.getCommand(size);
            if (previousCmd instanceof PDFPushCmd) {
                if (popCount <= 0) continue;
                --popCount;
                continue;
            }
            if (previousCmd instanceof PDFPopCmd) {
                ++popCount;
                continue;
            }
            if (popCount > 0) continue;
            if (previousCmd instanceof PDFXformCmd) {
                locStack.push((PDFXformCmd)previousCmd);
                continue;
            }
            if (!(previousCmd instanceof PDFShapeCmd) || (lastShapeCmd = (PDFShapeCmd)previousCmd).getStyle() != 4) continue;
            clipPath = lastShapeCmd.getPath();
            break;
        }
        AffineTransform transform = AffineTransform.getTranslateInstance(0.0, 0.0);
        while (!locStack.empty()) {
            PDFXformCmd xfcmd = (PDFXformCmd)locStack.pop();
            AffineTransform t = xfcmd.getTransform();
            if (!(Math.abs(t.getScaleX() * t.getScaleY() - t.getShearX() * t.getShearY()) > Double.MIN_VALUE)) continue;
            transform.concatenate(t);
        }
        try {
            AffineTransform inverse = transform.createInverse();
            Shape inverseGp = clipPath != null ? PDFRenderer.createTransformedShape(clipPath, inverse) : null;
            return inverseGp;
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    @Nullable
    static Shape getIntersection(@Nullable Rectangle2D bbox, @Nullable Shape clipPath) {
        if (bbox != null) {
            if (clipPath != null) {
                Area area = new Area(clipPath);
                area.intersect(new Area(bbox));
                clipPath = new GeneralPath(area);
            } else {
                clipPath = new GeneralPath(bbox);
            }
        }
        return clipPath;
    }

    private static boolean isStrictWhiteSpace(byte c) {
        return c == 32 || c == 13 || c == 10;
    }

    private void showUniqueErrMessage(String msg) {
        if (LOGGER.isDebug()) {
            if (this.errorMessages == null) {
                this.errorMessages = new HashSet<String>();
            } else if (this.errorMessages.contains(msg)) {
                return;
            }
            LOGGER.debug((Object)msg);
            this.errorMessages.add(msg);
        }
    }

    static class Tok {
        public static final int BRKB = 11;
        public static final int BRKE = 10;
        public static final int ARYB = 9;
        public static final int ARYE = 8;
        public static final int STR = 7;
        public static final int BRCB = 5;
        public static final int BRCE = 4;
        public static final int NUM = 3;
        public static final int CMD = 2;
        public static final int NAME = 1;
        public static final int UNK = 0;
        public static final int EOF = -1;
        private String name;
        private double value;
        private int type;

        Tok() {
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            switch (this.type) {
                case 3: {
                    return "NUM: " + this.value;
                }
                case 2: {
                    return "CMD: " + this.name;
                }
                case 0: {
                    return "UNK";
                }
                case -1: {
                    return "EOF";
                }
                case 1: {
                    return "NAME: " + this.name;
                }
                case 7: {
                    return "STR: (" + this.name;
                }
                case 9: {
                    return "ARY [";
                }
                case 8: {
                    return "ARY ]";
                }
            }
            return "some kind of brace (" + this.type + ")";
        }
    }

    private static class ParserState
    implements Cloneable {
        private PDFColorSpace fillCS;
        private PDFColorSpace strokeCS;
        private PDFTextFormat textFormat;

        private ParserState() {
        }

        public Object clone() {
            ParserState newState = new ParserState();
            newState.fillCS = this.fillCS;
            newState.strokeCS = this.strokeCS;
            newState.textFormat = (PDFTextFormat)this.textFormat.clone();
            return newState;
        }
    }
}

