/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

public class PDFHintTable {
    private static final int BIT_SITE_32 = 32;
    private static final int BIT_SITE_16 = 16;
    private int minObjectCount;
    private int firstPageObjLoc;
    private int bitCountForObjectCount;
    private int minPageLength;
    private int bitCountForPageLength;
    private int minContentOffset;
    private int bitCountForContentOffset;
    private int minContentLength;
    private int bitCountForContentLength;
    private int bitCountForSharedObjNumbers;
    private int bitCountForSharedObjID;
    private int bitCountForNumerator;
    private int pageCount;
    private byte[] data;
    private int bitPosition;
    PageParams[] pageParams;

    public PDFHintTable(byte[] data, int pageCount, int offsetS, int offsetO, int offsetI, int offsetL, int offsetC) {
        this.data = data;
        this.pageCount = pageCount;
    }

    public void parse() {
        this.parsePageOffsetHeader();
        this.parsePageOffsetHintTableEntries();
        this.parseSharedObjectTableHeader();
    }

    private void parsePageOffsetHeader() {
        this.minObjectCount = this.readInt(32);
        this.firstPageObjLoc = this.readInt(32);
        this.bitCountForObjectCount = this.readInt(16);
        this.minPageLength = this.readInt(32);
        this.bitCountForPageLength = this.readInt(16);
        this.minContentOffset = this.readInt(32);
        this.bitCountForContentOffset = this.readInt(16);
        this.minContentLength = this.readInt(32);
        this.bitCountForContentLength = this.readInt(16);
        this.bitCountForSharedObjNumbers = this.readInt(16);
        this.bitCountForSharedObjID = this.readInt(16);
        this.bitCountForNumerator = this.readInt(16);
        this.readInt(16);
    }

    private void parsePageOffsetHintTableEntries() {
        int j;
        int i;
        this.pageParams = new PageParams[this.pageCount];
        for (i = 0; i < this.pageCount; ++i) {
            this.pageParams[i] = new PageParams();
        }
        this.gotoByteBoundary();
        for (i = 0; i < this.pageCount; ++i) {
        }
        this.gotoByteBoundary();
        for (i = 0; i < this.pageCount; ++i) {
            this.pageParams[i].numberOfReferencedSharedObjects = this.readInt(this.bitCountForSharedObjNumbers);
        }
        this.gotoByteBoundary();
        for (i = 0; i < this.pageCount; ++i) {
            this.pageParams[i].sharedObjIndex = new int[this.pageParams[i].numberOfReferencedSharedObjects];
            for (j = 0; j < this.pageParams[i].numberOfReferencedSharedObjects; ++j) {
                this.pageParams[i].sharedObjIndex[j] = this.readInt(this.bitCountForSharedObjID);
            }
        }
        this.gotoByteBoundary();
        for (i = 0; i < this.pageCount; ++i) {
            this.pageParams[i].numerator = new int[this.pageParams[i].numberOfReferencedSharedObjects];
            for (j = 0; j < this.pageParams[i].numberOfReferencedSharedObjects; ++j) {
                this.pageParams[i].numerator[j] = this.readInt(this.bitCountForNumerator);
            }
        }
        this.gotoByteBoundary();
        for (i = 0; i < this.pageCount; ++i) {
        }
        this.gotoByteBoundary();
        for (i = 0; i < this.pageCount; ++i) {
        }
    }

    private void parseSharedObjectTableHeader() {
    }

    private int readInt(int bitSize) {
        this.bitPosition += bitSize;
        int currByteIndex = (this.bitPosition - 1) / 8;
        int currBitIndex = 7 - (this.bitPosition - 1) % 8;
        int num = 0;
        int shift = 0;
        byte current = this.data[currByteIndex];
        for (int i = 0; i < bitSize; ++i) {
            if (currBitIndex == 8) {
                currBitIndex = 0;
                current = this.data[--currByteIndex];
            }
            int val = current >> currBitIndex & 1;
            num |= val << shift;
            ++shift;
            ++currBitIndex;
        }
        return num;
    }

    private void gotoByteBoundary() {
        if (this.bitPosition % 8 != 0) {
            this.bitPosition = (this.bitPosition / 8 + 1) * 8;
        }
    }

    class PageParams {
        private int numberOfReferencedSharedObjects;
        private int[] sharedObjIndex;
        private int[] numerator;

        PageParams() {
        }
    }
}

