/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.cache.PersistenceKey;
import com.inet.cache.image.SerializableImage;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.logging.Logger;
import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.OutlineNode;
import com.inet.pdfview.PDFCrossRefEntry;
import com.inet.pdfview.PDFDestination;
import com.inet.pdfview.PDFGroup;
import com.inet.pdfview.PDFHintTable;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.ParserListener;
import com.inet.pdfview.action.GoToAction;
import com.inet.pdfview.action.PDFAction;
import com.inet.pdfview.control.ControlData;
import com.inet.pdfview.data.ArrayBuffer;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.error.PDFParserErrorCode;
import com.inet.pdfview.font.FontCache;
import com.inet.pdfview.font.FontGenerationListener;
import com.inet.pdfview.optionalcontent.OCGHandler;
import com.inet.pdfview.structure.StructureTreeHandler;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipException;
import javax.annotation.Nullable;

public class PDFFile {
    public static final boolean ALLOW_TEXT_FROM_TEXTCMD = true;
    public static final boolean READ_CONTROLS = true;
    public static final boolean READ_ALL_PAGES = false;
    public static final boolean TEST_ONE_BYTE_INTERVAL = true;
    public static final boolean CHECK_DECODE_FLAG = false;
    public static final boolean DEBUG = false;
    public static final boolean PRINT_ALL_ELEMENTS = true;
    public static final boolean USE_PDFOBJECT_CACHE = false;
    public static final int NOT_DEFINED = -1;
    private static final boolean RUN_PARSER_IN_MAIN_THREAD = true;
    static final boolean USE_HARD_IMAGE_REFERENCE = false;
    static final boolean WRAP_DECRYPTED_STREAM = false;
    static final boolean CALCULATE_IMAGE_HASH = true;
    static final boolean USE_KERN_OPERATOR = true;
    static final boolean COPY_CLIP_IN_CURRENT_STATE = true;
    private String versionString = "1.1";
    private int majorVersion = 1;
    private int minorVersion = 1;
    private static final String VERSION_COMMENT = "%PDF-";
    private IDataBuffer buf;
    private PDFCrossRefEntry[] crossRefEntries;
    private PDFObject root = null;
    private PDFObject encrypt = null;
    private PDFDecrypter decryptor;
    private PDFObject docID = null;
    private PDFObject info = null;
    private boolean printable = true;
    private boolean saveable = true;
    private int firstObjNum;
    private String producer;
    private String creator;
    private String title;
    private String creationDate;
    private String modDate;
    private String userPassword;
    private String fileName;
    private String author;
    private int pageCount = -1;
    private boolean isCrystalReports = true;
    private boolean isDownScaling = true;
    private List<PDFObject> pagesObjs;
    private List<Map<String, PDFObject>> pageResourceObjs;
    private List<ControlData> controlelements;
    private CacheAccess cache;
    private OCGHandler ocgHandler;
    private ParserListener listener;
    private FontCache fontCache = new FontCache();
    private StructureTreeHandler structureHandler;
    private HashMap<String, String> keywordMap = new HashMap();

    public PDFFile(IDataBuffer buf, String filename, String userPassword) throws PDFParseException {
        this(buf, filename, userPassword, (FontGenerationListener)null, null);
    }

    public PDFFile(IDataBuffer buf, String filename, String userPassword, final FontGenerationListener fontGenerationListener, ParserListener listener) throws PDFParseException {
        this(buf, filename, userPassword, new CacheAccess(){
            private Map<Font, Map<Object, Font>> derivedFonts = new ConcurrentHashMap<Font, Map<Object, Font>>();

            @Override
            public void fontGenerated(Font font, byte[] fontFileData, Map<Character, char[]> cmapAddition) {
                if (fontGenerationListener != null) {
                    fontGenerationListener.fontGenerated(font, fontFileData, cmapAddition);
                }
            }

            public PersistenceKey putImage(SerializableImage img) {
                return null;
            }

            @Override
            public SerializableImage getImage(Object key) {
                return null;
            }

            @Override
            public Font deriveFont(Font font, HashMap<TextAttribute, Object> attributes) {
                Map<Object, Font> derivals = this.derivedFonts.get(font);
                if (derivals != null) {
                    Font derivedFont = derivals.get(attributes);
                    return derivedFont == null ? this.addDerivative(font, attributes, derivals) : derivedFont;
                }
                derivals = new ConcurrentHashMap<Object, Font>();
                this.derivedFonts.put(font, derivals);
                return this.addDerivative(font, attributes, derivals);
            }

            private Font addDerivative(Font font, HashMap<TextAttribute, Object> attributes, Map<Object, Font> derivals) {
                Font derivedFont = font.deriveFont(attributes);
                derivals.put(attributes, derivedFont);
                return derivedFont;
            }
        }, listener);
    }

    public PDFFile(IDataBuffer buf, String filename, String userPassword, CacheAccess cache, ParserListener listener) throws PDFParseException {
        this.buf = buf;
        this.fileName = filename;
        this.userPassword = userPassword;
        this.cache = cache;
        this.listener = listener;
        if (cache == null) {
            throw new IllegalArgumentException("The passed CacheAccess instance must not be null!");
        }
        this.parseFile();
    }

    public FontCache getFontCache() {
        return this.fontCache;
    }

    public String mapKeyword(String keyword) {
        String mapped = this.keywordMap.get(keyword);
        if (mapped != null) {
            return mapped;
        }
        this.keywordMap.put(keyword, keyword);
        return keyword;
    }

    public boolean isPrintable() {
        return this.printable;
    }

    public void setDownScaling(boolean downScaling) {
        this.isDownScaling = downScaling;
    }

    public boolean isSaveable() {
        return this.saveable;
    }

    public PDFObject getRoot() {
        return this.root;
    }

    public int getNumPages() {
        if (this.pageCount < 0) {
            try {
                PDFObject pages = this.root.getDictRef("Pages");
                if (pages == null) {
                    PDFParser.LOGGER.error((Object)"PDFFile missing the Pages Parameter");
                } else {
                    this.pageCount = this.countPages(pages);
                }
            }
            catch (PDFParseException ex) {
                PDFParser.LOGGER.error((Throwable)((Object)ex));
            }
        }
        return this.pageCount;
    }

    private int countPages(PDFObject pagesNode) throws PDFParseException {
        PDFObject pageCount = pagesNode.getDictRef("Count");
        if (pageCount != null) {
            return pageCount.getIntValue();
        }
        PDFObject kids = pagesNode.getDictRef("Kids");
        if (kids != null) {
            PDFObject[] kidsArray;
            int pageCounter = 0;
            for (PDFObject ref : kidsArray = kids.dereference().getArray()) {
                PDFObject typeObj = ref.getDictRef("Type");
                if (typeObj == null) continue;
                String type = typeObj.getStringValue();
                if ("Pages".equals(type)) {
                    pageCounter += this.countPages(ref);
                    continue;
                }
                if (!"Page".equals(type)) continue;
                ++pageCounter;
            }
            return pageCounter;
        }
        return 0;
    }

    synchronized PDFObject dereference(PDFXref ref) throws PDFParseException {
        int id = ref.getID();
        int gen = ref.getGeneration();
        return this.dereference(id, gen);
    }

    private synchronized PDFObject dereference(int id, int generation) throws PDFParseException {
        if (id >= this.crossRefEntries.length || this.crossRefEntries[id] == null) {
            return PDFObject.NULL_OBJECT;
        }
        PDFObject obj = this.crossRefEntries[id].getObject();
        if (obj != null) {
            return obj;
        }
        if (this.crossRefEntries[id].isCompressed()) {
            int length;
            int objId;
            int objStreamNum = this.crossRefEntries[id].getObjectStreamNum();
            PDFObject objStream = this.crossRefEntries[objStreamNum].getObject();
            if (objStream == null) {
                objStream = this.dereference(objStreamNum, generation);
                if (objStream == null || objStream == PDFObject.NULL_OBJECT) {
                    throw new PDFParseException("object stream error");
                }
                if (objStream.getType() != 7) {
                    throw new PDFParseException("object stream error: invalid object type " + objStream.getType());
                }
                PDFObject typeobj = objStream.getDictRef("Type");
                if (!"ObjStm".equals(typeobj.getStringValue())) {
                    throw new PDFParseException("object stream error: type not defined");
                }
            }
            PDFObject numberObj = objStream.getDictRef("N");
            int objectsNumber = numberObj.getIntValue();
            PDFObject firstOffsetObj = objStream.getDictRef("First");
            int firstOffset = firstOffsetObj.getIntValue();
            PDFXref ref = this.decryptor != null ? new PDFXref(objStreamNum, 0) : null;
            byte[] data = objStream.getStream(ref, this.decryptor, true);
            int indexInObjStream = this.crossRefEntries[id].getIndexInObjectStream();
            int pos = 0;
            int j = 0;
            StringBuilder strBuilder = new StringBuilder();
            int[] indexPos = new int[objectsNumber * 2];
            while (pos < data.length) {
                char ch;
                if ((ch = (char)data[pos++]) >= '0' && ch <= '9') {
                    strBuilder.append(ch);
                    continue;
                }
                if (!Character.isWhitespace(ch) || strBuilder.length() <= 0) continue;
                indexPos[j++] = Integer.parseInt(strBuilder.toString());
                strBuilder.setLength(0);
                if (j < objectsNumber * 2) continue;
                break;
            }
            if (id != (objId = indexPos[indexInObjStream * 2])) {
                throw new IllegalStateException("invalid object id: " + id + " " + objId);
            }
            int offset = indexPos[indexInObjStream * 2 + 1] + firstOffset;
            int n = length = indexInObjStream < objectsNumber - 1 ? indexPos[indexInObjStream * 2 + 3] - indexPos[indexInObjStream * 2 + 1] : data.length - offset;
            if (offset != 0 && length != 0) {
                byte[] objdata = new byte[length];
                System.arraycopy(data, offset, objdata, 0, length);
                IDataBuffer bbuffer = ArrayBuffer.wrap(objdata);
                PDFObject tmp = this.readObject(bbuffer, false, id, generation);
                this.crossRefEntries[id].setObject(tmp);
                return tmp;
            }
        } else {
            int loc = this.crossRefEntries[id].getFilePos();
            if (loc < 0) {
                return PDFObject.NULL_OBJECT;
            }
            int startPos = this.buf.position();
            this.buf.position(loc);
            obj = this.readObject(id, generation);
            if (obj == null) {
                obj = PDFObject.NULL_OBJECT;
            }
            this.crossRefEntries[id].setObject(obj);
            this.buf.position(startPos);
        }
        return obj;
    }

    public static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10 || c == 0 || c == 12;
    }

    static boolean isDelimiter(int c) {
        return c == 40 || c == 41 || c == 123 || c == 125 || c == 91 || c == 93 || c == 47 || c == 60 || c == 62 || c == 37 || PDFFile.isWhiteSpace(c);
    }

    @Nullable
    private PDFObject readObject() throws PDFParseException {
        return this.readObject(false, 0, 0);
    }

    @Nullable
    private PDFObject readObject(int id, int generation) throws PDFParseException {
        return this.readObject(false, id, generation);
    }

    @Nullable
    private PDFObject readObject(boolean numscan, int id, int generation) throws PDFParseException {
        return this.readObject(this.buf, numscan, id, generation);
    }

    @Nullable
    private PDFObject readObject(IDataBuffer bbuffer, boolean numscan, int id, int generation) throws PDFParseException {
        int c = 0;
        PDFObject obj = null;
        while (obj == null && bbuffer.hasRemaining()) {
            while (bbuffer.hasRemaining()) {
                byte by = bbuffer.get();
                c = by;
                if (PDFFile.isWhiteSpace(by)) continue;
            }
            if (c == 60) {
                try {
                    c = bbuffer.get();
                }
                catch (Exception e) {
                    throw new IllegalStateException("buffer underflow");
                }
                if (c == 60) {
                    obj = this.readDictionary(bbuffer, id, generation);
                    continue;
                }
                bbuffer.position(bbuffer.position() - 1);
                obj = this.readHexString(bbuffer, id, generation);
                continue;
            }
            if (c == 40) {
                obj = this.readString(bbuffer);
                continue;
            }
            if (c == 91) {
                obj = this.readArray(bbuffer, id, generation);
                continue;
            }
            if (c == 47) {
                obj = this.readName(bbuffer);
                continue;
            }
            if (c == 37) {
                this.readLine(bbuffer);
                continue;
            }
            if (c >= 48 && c <= 57 || c == 45 || c == 43 || c == 46) {
                obj = this.readNumber((char)c, bbuffer);
                if (numscan) continue;
                int startPos = bbuffer.position();
                PDFObject testnum = this.readObject(bbuffer, true, id, generation);
                if (testnum != null && testnum.getType() == 2) {
                    PDFObject testR = this.readObject(bbuffer, true, id, generation);
                    if (testR != null && testR.getType() == 9 && testR.getStringValue().equals("R")) {
                        PDFXref xref = new PDFXref(obj.getIntValue(), testnum.getIntValue());
                        obj = new PDFObject(this, xref);
                        continue;
                    }
                    if (testR != null && testR.getType() == 9 && testR.getStringValue().equals("obj")) {
                        obj = this.readObjectDescription(bbuffer, id, generation);
                        continue;
                    }
                    bbuffer.position(startPos);
                    continue;
                }
                bbuffer.position(startPos);
                continue;
            }
            if (c >= 97 && c <= 122 || c >= 65 && c <= 90) {
                obj = this.readKeyword((char)c, bbuffer);
                continue;
            }
            bbuffer.position(bbuffer.position() - 1);
            break;
        }
        return obj;
    }

    private boolean nextItemIs(String match) {
        return this.nextItemIs(match, this.buf);
    }

    private boolean nextItemIs(String match, IDataBuffer bbuffer) {
        byte c;
        while (PDFFile.isWhiteSpace(c = bbuffer.get())) {
        }
        for (int i = 0; i < match.length(); ++i) {
            if (i > 0) {
                c = bbuffer.get();
            }
            if (c == match.charAt(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findItemInStream(String match, IDataBuffer bbuffer, int limit) {
        bbuffer.mark();
        try {
            int endPosition;
            int index = 0;
            int position = 0;
            int start = 0;
            int n = endPosition = limit >= 0 ? position + limit : Integer.MAX_VALUE;
            while (bbuffer.hasRemaining()) {
                char c = (char)bbuffer.get();
                if (++position == endPosition) {
                    int n2 = -1;
                    return n2;
                }
                if (PDFFile.isWhiteSpace(c)) {
                    start = position - 1;
                    index = 0;
                    continue;
                }
                if (c == match.charAt(index)) {
                    if (start < 0) {
                        start = position - 1;
                    }
                    if (++index != match.length()) continue;
                    int n3 = start;
                    return n3;
                }
                index = 0;
                start = -1;
            }
            int n4 = -1;
            return n4;
        }
        catch (IllegalStateException e) {
            int n = -1;
            return n;
        }
        finally {
            bbuffer.reset();
        }
    }

    private void processVersion(String versionString) {
        try {
            StringTokenizer tokens = new StringTokenizer(versionString, ". ");
            this.majorVersion = Integer.parseInt(tokens.nextToken());
            this.minorVersion = Integer.parseInt(tokens.nextToken());
            this.versionString = versionString;
        }
        catch (Exception e) {
            PDFParser.LOGGER.debug((Object)e);
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getVersionString() {
        return this.versionString;
    }

    private PDFObject readDictionary(IDataBuffer bbuffer, int id, int generation) throws PDFParseException {
        PDFObject name;
        HashMap<String, PDFObject> hm = new HashMap<String, PDFObject>();
        PDFObject dict = new PDFObject(this, 6, hm);
        while ((name = this.readObject(bbuffer, false, id, generation)) != null) {
            if (name.getType() != 4) {
                PDFParser.LOGGER.error((Object)("Invalid dictionary entry: expected object of type /Name but was " + name.getStringValue()));
                return dict;
            }
            PDFObject value = this.readObject(bbuffer, false, id, generation);
            if (value == null) continue;
            hm.put(name.getStringValue(), value);
        }
        if (!this.nextItemIs(">>", bbuffer)) {
            int offset = bbuffer.position();
            int nextEnd = this.findItemInStream(">>", bbuffer, 5000);
            if (nextEnd >= 0) {
                PDFParser.LOGGER.error((Object)("Error in dict '" + String.valueOf(dict) + "', invalid data was skipped"));
                bbuffer.position(offset + nextEnd + 2);
                return dict;
            }
            throw new PDFParseException("End of dictionary wasn't '>>'");
        }
        return dict;
    }

    private int readHexDigit(IDataBuffer bbuffer) throws PDFParseException {
        int a;
        while (PDFFile.isWhiteSpace(a = bbuffer.get())) {
        }
        a = a >= 48 && a <= 57 ? (a -= 48) : (a >= 97 && a <= 102 ? (a -= 87) : (a >= 65 && a <= 70 ? (a -= 55) : -1));
        return a;
    }

    private int readHexPair(IDataBuffer bbuffer) throws PDFParseException {
        int first = this.readHexDigit(bbuffer);
        if (first < 0) {
            bbuffer.position(bbuffer.position() - 1);
            return -1;
        }
        int second = this.readHexDigit(bbuffer);
        if (second < 0) {
            bbuffer.position(bbuffer.position() - 1);
            return first << 4;
        }
        return (first << 4) + second;
    }

    private PDFObject readHexString(IDataBuffer bbuffer, int id, int generation) throws PDFParseException {
        String value = null;
        if (this.decryptor != null) {
            int val;
            FastByteArrayOutputStream bytes = new FastByteArrayOutputStream();
            while ((val = this.readHexPair(bbuffer)) >= 0) {
                bytes.write(val);
            }
            byte[] data = this.decryptor.decrypt(bytes.toByteArray(), bytes.size(), id, generation);
            try {
                value = new String(data, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (value.indexOf(65533) >= 0) {
                try {
                    value = new String(data, "CP1252");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            if (value.indexOf(65533) >= 0) {
                try {
                    value = new String(data, "iso-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            if (value.indexOf(65533) >= 0) {
                try {
                    value = new String(data, "iso-8859-15");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        } else {
            int val;
            StringBuilder sb = new StringBuilder();
            while ((val = this.readHexPair(bbuffer)) >= 0) {
                sb.append((char)val);
            }
            value = sb.toString();
        }
        if (bbuffer.get() != 62) {
            throw new PDFParseException("Bad character in Hex String");
        }
        return new PDFObject(this, 3, PDFFile.unicode(value));
    }

    protected static String unicode(String input) {
        if (input.length() < 2 || input.length() % 2 != 0) {
            return input;
        }
        int c0 = input.charAt(0) & 0xFF;
        int c1 = input.charAt(1) & 0xFF;
        if (c0 == 254 && c1 == 255 || c0 == 255 && c1 == 254) {
            boolean bigEndian = input.charAt(1) == '\uffff';
            StringBuffer out = new StringBuffer();
            for (int i = 2; i < input.length(); i += 2) {
                if (bigEndian) {
                    out.append((char)(((input.charAt(i + 1) & 0xFF) << 8) + (input.charAt(i) & 0xFF)));
                    continue;
                }
                out.append((char)(((input.charAt(i) & 0xFF) << 8) + (input.charAt(i + 1) & 0xFF)));
            }
            return out.toString();
        }
        return input;
    }

    private PDFObject readString(IDataBuffer bbuffer) throws PDFParseException {
        int parencount = 1;
        StringBuffer sb = new StringBuffer();
        while (parencount > 0) {
            int c = bbuffer.get() & 0xFF;
            if (c == 40) {
                ++parencount;
            } else if (c == 41) {
                if (--parencount == 0) {
                    c = -1;
                    break;
                }
            } else if (c == 92) {
                c = bbuffer.get() & 0xFF;
                if (c == 114) {
                    c = 13;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 98) {
                    c = 8;
                } else if (c == 102) {
                    c = 12;
                }
                if (c != 13 && c != 10 && c >= 48 && c <= 57) {
                    int val = 0;
                    for (int count = 0; c >= 48 && c <= 57 && count < 3; ++count) {
                        val = val * 8 + c - 48;
                        c = bbuffer.get() & 0xFF;
                    }
                    bbuffer.position(bbuffer.position() - 1);
                    c = val;
                }
            }
            if (c < 0) continue;
            sb.append((char)c);
        }
        return new PDFObject(this, 3, PDFFile.unicode(sb.toString()));
    }

    private String readLine() {
        if (this.buf.hasRemaining()) {
            return this.readLine(this.buf);
        }
        return null;
    }

    private String readLine(IDataBuffer bbuffer) {
        StringBuffer sb = new StringBuffer();
        while (bbuffer.remaining() > 0) {
            char c = (char)bbuffer.get();
            if (c == '\r') {
                char n;
                if (bbuffer.remaining() <= 0 || (n = (char)bbuffer.get(bbuffer.position())) != '\n') break;
                bbuffer.get();
                break;
            }
            if (c == '\n') break;
            sb.append(c);
        }
        return sb.toString();
    }

    private PDFObject readArray(IDataBuffer bbuffer, int id, int generation) throws PDFParseException {
        PDFObject obj;
        ArrayList<PDFObject> ary = new ArrayList<PDFObject>();
        while ((obj = this.readObject(bbuffer, false, id, generation)) != null) {
            ary.add(obj);
        }
        if (bbuffer.get() != 93) {
            throw new PDFParseException("Array should end with ']'");
        }
        PDFObject[] objlist = new PDFObject[ary.size()];
        for (int i = 0; i < objlist.length; ++i) {
            objlist[i] = (PDFObject)ary.get(i);
        }
        return new PDFObject(this, 5, objlist);
    }

    private PDFObject readName(IDataBuffer bbuffer) throws PDFParseException {
        int c;
        StringBuffer sb = new StringBuffer();
        while (bbuffer.hasRemaining() && !PDFFile.isDelimiter(c = bbuffer.get())) {
            if (this.majorVersion != 1 && this.minorVersion != 1 && c == 35) {
                int hex = this.readHexPair(bbuffer);
                if (hex >= 0) {
                    c = hex;
                } else {
                    throw new PDFParseException("Bad #hex in /Name");
                }
            }
            sb.append((char)c);
        }
        bbuffer.position(bbuffer.position() - 1);
        return new PDFObject(this, 4, PDFFile.unicode(sb.toString()));
    }

    private PDFObject readNumber(char start, IDataBuffer bbuffer) throws PDFParseException {
        double value;
        boolean neg = start == '-';
        boolean sawdot = start == '.';
        double dotmult = sawdot ? 0.1 : 1.0;
        double d = value = start >= '0' && start <= '9' ? (double)(start - 48) : 0.0;
        while (bbuffer.hasRemaining()) {
            byte c = bbuffer.get();
            if (c == 46) {
                if (sawdot) {
                    throw new PDFParseException("Can't have two '.' in a number");
                }
                sawdot = true;
                dotmult = 0.1;
                continue;
            }
            if (c >= 48 && c <= 57) {
                int val = c - 48;
                if (sawdot) {
                    value += (double)val * dotmult;
                    dotmult *= 0.1;
                    continue;
                }
                value = value * 10.0 + (double)val;
                continue;
            }
            bbuffer.position(bbuffer.position() - 1);
            break;
        }
        if (neg) {
            value = -value;
        }
        return new PDFObject(this, 2, value);
    }

    private PDFObject readKeyword(char start, IDataBuffer bbuffer) throws PDFParseException {
        byte c;
        StringBuffer sb = new StringBuffer(String.valueOf(start));
        while (!PDFFile.isDelimiter(c = bbuffer.get())) {
            sb.append((char)c);
        }
        bbuffer.position(bbuffer.position() - 1);
        return new PDFObject(this, 9, sb.toString());
    }

    private PDFObject readObjectDescription(IDataBuffer bbuffer, int id, int generation) throws PDFParseException {
        long debugpos = bbuffer.position();
        PDFObject obj = this.readObject(bbuffer, false, id, generation);
        PDFObject endkey = this.readObject(bbuffer, false, id, generation);
        if (obj == null) {
            throw new PDFParseException("Unexpected end of object");
        }
        if (obj.getType() == 6 && endkey != null && endkey.getType() == 9 && endkey.getStringValue().equals("stream")) {
            this.readLine(bbuffer);
            IDataBuffer data = this.readStream(obj, bbuffer);
            if (data == null) {
                data = ArrayBuffer.allocate(0);
            }
            obj.setStream(data);
            endkey = this.readObject(bbuffer, false, id, generation);
            if (endkey != null && endkey.getStringValue().equals("endstream")) {
                endkey = this.readObject(bbuffer, false, id, generation);
            }
        }
        if ((endkey == null || endkey.getStringValue() == null || !endkey.getStringValue().equals("endobj")) && PDFParser.LOGGER.isDebug()) {
            PDFParser.LOGGER.debug((Object)("WARNING: object at " + debugpos + " didn't end with 'endobj'"));
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDataBuffer readStream(PDFObject dict, IDataBuffer bbuffer) throws PDFParseException {
        PDFObject lengthObj = dict.getDictRef("Length");
        int length = -1;
        if (lengthObj != null) {
            length = lengthObj.getIntValue();
        }
        if (length < 0) {
            throw new PDFParseException("Unknown length for stream");
        }
        if (length == 0) {
            return ArrayBuffer.allocate(0);
        }
        IDataBuffer streamBuf = bbuffer.slice();
        if (length > streamBuf.capacity()) {
            length = streamBuf.capacity();
        }
        streamBuf.limit(length);
        bbuffer.mark();
        bbuffer.position(bbuffer.position() + length);
        try {
            if (!this.nextItemIs("endstream", bbuffer)) {
                int pos = this.findItemInStream("endstream", streamBuf, -1);
                if (pos < 0) {
                } else {
                    if (pos == 0) {
                        PDFParser.LOGGER.debug((Object)("Stream corrupted. Specified size is " + length + " but the stream is empty"));
                        length = 0;
                        IDataBuffer iDataBuffer = ArrayBuffer.allocate(0);
                        return iDataBuffer;
                    }
                    PDFParser.LOGGER.debug((Object)("Stream corrupted. Specified size is " + length + " but endmarker was found at length " + pos));
                    streamBuf.limit(pos);
                    length = pos;
                }
            }
        }
        finally {
            bbuffer.reset();
            bbuffer.position(bbuffer.position() + length);
        }
        return streamBuf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readTrailer(int xrefpos) throws PDFParseException {
        block46: {
            PDFObject permissions;
            if (this.crossRefEntries == null) {
                this.crossRefEntries = new PDFCrossRefEntry[50];
            }
            boolean isFirstTable = true;
            while (true) {
                if (!this.nextItemIs("xref")) {
                    if ((xrefpos = this.readXRef(xrefpos)) != 0) continue;
                    break;
                }
                int prevpos = this.readXrefTable(isFirstTable);
                isFirstTable = false;
                if (prevpos == 0) break;
            }
            if (this.root == null) {
                throw new PDFParseException("The PDF strucuture is incomplete: No /Root key found in trailer dictionary");
            }
            if (this.encrypt != null && (permissions = this.encrypt.getDictRef("P")) != null) {
                PDFObject encryptMetaDataObj;
                PDFObject cryptFormatTypeObj;
                PDFObject cryptFilterFormatObj;
                PDFObject[] docStrings;
                int perms = permissions.getIntValue();
                if ((perms & 4) == 0) {
                    this.printable = false;
                }
                if ((perms & 0x10) == 0) {
                    this.saveable = false;
                }
                String docString = null;
                if (this.docID != null && (docStrings = this.docID.getArray()) != null) {
                    docString = docStrings[0].getStringValue();
                }
                PDFObject oEntryObj = this.encrypt.getDictRef("O");
                PDFObject uentryObj = this.encrypt.getDictRef("U");
                PDFObject algorithmVersionObj = this.encrypt.getDictRef("V");
                int algorithmVersion = algorithmVersionObj.getIntValue();
                PDFObject handlerRevisionObj = this.encrypt.getDictRef("R");
                int handlerRevision = handlerRevisionObj.getIntValue();
                PDFObject keyLengthObj = this.encrypt.getDictRef("Length");
                int keyLength = 40;
                if (keyLengthObj != null) {
                    keyLength = keyLengthObj.getIntValue();
                }
                String cryptFormatType = null;
                String oeEntry = null;
                String ueEntry = null;
                PDFObject cryptFilterObj = this.encrypt.getDictRef("CF");
                if (algorithmVersion >= 4 && cryptFilterObj != null && cryptFilterObj.getType() == 6 && (cryptFilterFormatObj = cryptFilterObj.getDictRef("StdCF")) != null && cryptFilterFormatObj.getType() == 6 && (cryptFormatTypeObj = cryptFilterFormatObj.getDictRef("CFM")) != null) {
                    cryptFormatType = cryptFormatTypeObj.getStringValue();
                    if (handlerRevision >= 5 && algorithmVersion == 5) {
                        PDFObject oeEntryObj = cryptFilterFormatObj.getDictRef("OE");
                        PDFObject ueEntryObj = cryptFilterFormatObj.getDictRef("UE");
                        if (oeEntryObj == null || ueEntryObj == null) {
                            oeEntryObj = oeEntryObj == null ? this.encrypt.getDictRef("OE") : oeEntryObj;
                            ueEntryObj = ueEntryObj == null ? this.encrypt.getDictRef("UE") : ueEntryObj;
                            if (oeEntryObj == null) throw new IllegalStateException("Handler revision 5 must contain OE und UE entries in encryption dictionary");
                            if (ueEntryObj == null) {
                                throw new IllegalStateException("Handler revision 5 must contain OE und UE entries in encryption dictionary");
                            }
                        }
                        oeEntry = oeEntryObj.getStringValue();
                        ueEntry = ueEntryObj.getStringValue();
                    }
                }
                boolean encryptMetaData = (encryptMetaDataObj = this.encrypt.getDictRef("EncryptMetadata")) == null || encryptMetaDataObj.getBooleanValue();
                boolean isHexString = false;
                String oEntry = oEntryObj.getStringValue();
                String uEntry = uentryObj != null ? uentryObj.getStringValue() : null;
                this.decryptor = PDFDecrypter.getDecrypter(this.userPassword, oEntry, uEntry, perms, docString, keyLength, algorithmVersion, handlerRevision, isHexString, cryptFormatType, oeEntry, ueEntry, encryptMetaData);
            }
            if (this.info != null) {
                PDFObject producerString = this.info.getDictRef("Producer");
                PDFObject creatorString = this.info.getDictRef("Creator");
                PDFObject titleString = this.info.getDictRef("Title");
                PDFObject creationDateString = this.info.getDictRef("CreationDate");
                PDFObject modDateString = this.info.getDictRef("ModDate");
                PDFObject authorString = this.info.getDictRef("Author");
                PDFXref refValue = this.info.getRefValue();
                int id = refValue != null ? refValue.getID() : 0;
                int gen = refValue != null ? refValue.getGeneration() : 0;
                boolean fromObjStm = this.crossRefEntries[id].isCompressed();
                if (this.decryptor != null && !fromObjStm) {
                    try {
                        if (producerString != null && producerString.getStringValue() != null) {
                            this.producer = producerString.getStringValue();
                            if (this.producer.toLowerCase().contains("i-net crystal clear") || this.producer.toLowerCase().contains("i-net clear reports")) {
                                this.setCrystalReports(false);
                            }
                            if (this.producer.indexOf(65533) >= 0) {
                                boolean bl;
                                if (this.userPassword != null && !this.userPassword.isEmpty()) {
                                    bl = true;
                                    throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                                }
                                bl = false;
                                throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                            }
                        }
                        if (creatorString != null && creatorString.getStringValue() != null) {
                            this.creator = creatorString.getStringValue();
                            if (this.creator.contains("i-net software ")) {
                                this.setCrystalReports(false);
                            }
                            if (this.creator.indexOf(65533) >= 0) {
                                boolean bl;
                                if (this.userPassword != null && !this.userPassword.isEmpty()) {
                                    bl = true;
                                    throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                                }
                                bl = false;
                                throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                            }
                        }
                        if (titleString != null && titleString.getStringValue() != null) {
                            this.title = titleString.getStringValue();
                            if (this.title.indexOf(65533) >= 0) {
                                boolean bl;
                                if (this.userPassword != null && !this.userPassword.isEmpty()) {
                                    bl = true;
                                    throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                                }
                                bl = false;
                                throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                            }
                        }
                        if (creationDateString != null && creationDateString.getStringValue() != null) {
                            this.creationDate = creationDateString.getStringValue();
                            if (this.creationDate.indexOf(65533) >= 0) {
                                boolean bl;
                                if (this.userPassword != null && !this.userPassword.isEmpty()) {
                                    bl = true;
                                    throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                                }
                                bl = false;
                                throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                            }
                        }
                        if (modDateString != null && modDateString.getStringValue() != null) {
                            this.modDate = modDateString.getStringValue();
                            if (this.modDate.indexOf(65533) >= 0) {
                                boolean bl;
                                if (this.userPassword != null && !this.userPassword.isEmpty()) {
                                    bl = true;
                                    throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                                }
                                bl = false;
                                throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                            }
                        }
                        if (authorString != null && authorString.getStringValue() != null) {
                            this.author = authorString.getStringValue();
                            if (this.author.indexOf(65533) >= 0) {
                                boolean bl;
                                if (this.userPassword != null && !this.userPassword.isEmpty()) {
                                    bl = true;
                                    throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                                }
                                bl = false;
                                throw new PDFDecrypter.DecryptionExcpetion(null, bl);
                            }
                        }
                        break block46;
                    }
                    catch (PDFDecrypter.DecryptionExcpetion e) {
                        e.setFilename(this.fileName);
                        throw e;
                    }
                }
                if (producerString != null) {
                    this.producer = producerString.getStringValue();
                    if (this.producer != null && (this.producer.toLowerCase().contains("i-net crystal clear") || this.producer.toLowerCase().contains("i-net clear reports"))) {
                        this.setCrystalReports(false);
                    }
                }
                if (creatorString != null) {
                    this.creator = creatorString.getStringValue();
                    if (this.creator != null && this.creator.contains("i-net software ")) {
                        this.setCrystalReports(false);
                    }
                }
                if (titleString != null) {
                    this.title = titleString.getStringValue();
                }
                if (creationDateString != null) {
                    this.creationDate = creationDateString.getStringValue();
                }
                if (modDateString != null) {
                    this.modDate = modDateString.getStringValue();
                }
                if (authorString != null) {
                    this.author = authorString.getStringValue();
                }
            }
        }
        this.ocgHandler = OCGHandler.createHandler(this.root.getDictRef("OCProperties"));
        if (this.listener == null || this.listener.doRead(ParserListener.ELEMENT_TYPE.structure)) {
            this.structureHandler = StructureTreeHandler.buildStructureTree(this.root, this.listener);
        }
        this.root.dereference();
    }

    private static String tryDecode(byte[] data) {
        String result = "";
        try {
            result = new String(data, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (result.indexOf(65533) >= 0) {
            try {
                result = new String(data, "CP1252");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (result.indexOf(65533) >= 0) {
            try {
                result = new String(data, "iso-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (result.indexOf(65533) >= 0) {
            try {
                result = new String(data, "iso-8859-15");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    private int getID(PDFXref ref, int id) {
        return ref != null ? ref.getID() : id;
    }

    private int getGeneration(PDFXref ref, int gen) {
        return ref != null ? ref.getGeneration() : gen;
    }

    private void getLineraizedData() throws PDFParseException {
        int generation;
        int id;
        PDFXref xref;
        PDFObject linearDict;
        PDFObject linearVersion;
        if (this.firstObjNum != 0 && (linearVersion = (linearDict = this.dereference(xref = new PDFXref(id = this.firstObjNum, generation = 0))).getDictRef("Linearized")) != null && linearVersion.getIntValue() == 1) {
            PDFObject pageCountObj = linearDict.getDictRef("N");
            if (pageCountObj == null || pageCountObj.getType() != 2) {
                throw new IllegalStateException("page count entry not found");
            }
            int pageCount = pageCountObj.getIntValue();
            PDFObject hintobj = linearDict.getDictRef("H");
            if (hintobj.getType() == 5) {
                PDFXref xrefH;
                PDFObject hintDict;
                byte[] data;
                int hintId;
                PDFObject[] hintArr = hintobj.getArray();
                int hintPos = hintArr[0].getIntValue();
                for (hintId = this.firstObjNum; hintId < this.crossRefEntries.length && this.crossRefEntries[hintId].getFilePos() != hintPos; ++hintId) {
                }
                if (hintId < this.crossRefEntries.length && (data = (hintDict = this.dereference(xrefH = new PDFXref(hintId, generation))).getStream(xrefH, this.decryptor, true)) != null) {
                    int offsetS = this.getTableOffset(hintDict, "S");
                    int offsetO = this.getTableOffset(hintDict, "O");
                    int offsetI = this.getTableOffset(hintDict, "I");
                    int offsetL = this.getTableOffset(hintDict, "L");
                    int offsetC = this.getTableOffset(hintDict, "C");
                    PDFHintTable hintTable = new PDFHintTable(data, pageCount, offsetS, offsetO, offsetI, offsetL, offsetC);
                    hintTable.parse();
                }
            }
        }
    }

    private void setCrystalReports(boolean isCrystalReports) {
        this.isCrystalReports = isCrystalReports;
        if (this.listener != null) {
            this.listener.setCrystalReportsExport(isCrystalReports);
        }
    }

    private void parseFile() throws PDFParseException {
        PDFObject acroForm;
        int scanPos;
        int lineOffset;
        String versionLine;
        int startIndex;
        this.buf.rewind();
        do {
            lineOffset = this.buf.position();
            versionLine = this.readLine();
            if (versionLine != null) continue;
            throw new PDFParseException(PDFParserErrorCode.invalidPDF, this.fileName);
        } while ((startIndex = versionLine.indexOf(VERSION_COMMENT)) == -1);
        if (lineOffset != 0 || startIndex != 0) {
            this.buf = this.buf.position(lineOffset + startIndex).slice();
        }
        this.processVersion(versionLine.substring(startIndex + VERSION_COMMENT.length()));
        this.setCrystalReports(!this.isInetCommentLine());
        this.buf.mark();
        this.buf.limit(Math.min(this.buf.position() + 1024, this.buf.capacity()));
        try {
            byte[] checkData = new byte[this.buf.limit() - this.buf.position()];
            this.buf.get(checkData);
            String checkString = new String(checkData);
            if (checkString.contains("/Linearized")) {
                this.buf.rewind();
                @Nullable PDFObject linearized = this.readObject();
                if (linearized != null && linearized.getType() == 6 && linearized.getDictRef("Linearized") != null && this.nextItemIs("xref")) {
                    this.buf.limit(this.buf.capacity());
                    this.readXrefTable(false);
                    for (int i = 1; i < this.crossRefEntries.length - 1; ++i) {
                        PDFXref ref = new PDFXref(i, 0);
                        PDFObject xrefStream = new PDFObject(this, ref);
                        PDFObject objType = xrefStream.getDictRef("Type");
                        if (objType == null || !"XRef".equals(objType.getStringValue())) continue;
                        this.readXRefObject(xrefStream);
                    }
                }
            }
        }
        catch (Exception e) {
            PDFParser.LOGGER.debug((Object)e);
        }
        this.buf.limit(this.buf.capacity());
        this.buf.rewind();
        this.buf.rewind();
        byte[] scan = new byte[32];
        int limit = Math.max(0, scanPos - 100000);
        int loc = 0;
        int xrefpos = -1;
        Object scans = "";
        for (scanPos = this.buf.remaining() - scan.length; scanPos >= 0 && scanPos > limit; scanPos -= scan.length - 10) {
            this.buf.position(scanPos);
            this.buf.get(scan);
            scans = new String(scan) + (String)scans;
            loc = ((String)scans).indexOf("startxref");
            if (loc >= 0) {
                if (scanPos + loc + scan.length > this.buf.limit()) break;
                scanPos += loc;
                loc = 0;
                break;
            }
            loc = ((String)scans).indexOf("xref\n0");
            if (loc <= 0) continue;
            xrefpos = loc + scanPos;
            break;
        }
        if (scanPos < limit) {
            throw new PDFParseException(PDFParserErrorCode.invalidPDF, this.fileName);
        }
        if (xrefpos < 0) {
            this.buf.position(scanPos);
            this.buf.get(scan);
            scans = new String(scan);
            if (((String)scans).charAt(loc += 10) < ' ') {
                ++loc;
            }
            while (((String)scans).charAt(loc) == ' ') {
                ++loc;
            }
            int numstart = loc;
            while (loc < ((String)scans).length() && ((String)scans).charAt(loc) >= '0' && ((String)scans).charAt(loc) <= '9') {
                ++loc;
            }
            xrefpos = Integer.parseInt(((String)scans).substring(numstart, loc));
        }
        this.buf.position(xrefpos);
        this.readTrailer(xrefpos);
        if (this.root != null && (acroForm = this.root.getDictRef("AcroForm")) != null) {
            PDFObject resourceDict = acroForm.getDictRef("DR");
            PDFObject fieldsObj = acroForm.getDictRef("Fields");
            if (fieldsObj != null && fieldsObj.getType() == 5) {
                this.controlelements = new ArrayList<ControlData>();
                PDFObject[] fields = fieldsObj.getArray();
                if (fields != null) {
                    for (int i = 0; i < fields.length; ++i) {
                        if (fields[i] == null || fields[i].getType() != 6) continue;
                        this.readAnnot2(null, null, fields[i], this.controlelements, resourceDict);
                    }
                }
            }
        }
    }

    private void readAnnot2(PDFObject parentField, String parentFieldType, PDFObject field, List<ControlData> container, PDFObject resourceDict) {
        String currentFieldType = null;
        try {
            PDFObject currentFieldTypeObj = field.getDictRef("FT");
            if (currentFieldTypeObj != null && (currentFieldTypeObj.getType() == 4 || currentFieldTypeObj.getType() == 3)) {
                currentFieldType = currentFieldTypeObj.getStringValue();
            }
            if (currentFieldType == null) {
                currentFieldType = parentFieldType;
            }
            if (currentFieldType != null && !"Sig".equals(currentFieldType) && !this.isPDFControlType(currentFieldType)) {
                PDFParser.LOGGER.warn((Object)"field type is not defined");
                return;
            }
            PDFObject kidsObj = field.getDictRef("Kids");
            if (kidsObj != null) {
                PDFObject[] kids;
                if (kidsObj.getType() == 5 && (kids = kidsObj.getArray()) != null) {
                    for (int i = 0; i < kids.length; ++i) {
                        if (kids[i] == null || kids[i].getType() != 6) continue;
                        this.readAnnot2(field, currentFieldType, kids[i], container, resourceDict);
                    }
                }
            } else {
                if (currentFieldType == null) {
                    return;
                }
                container.add(ControlData.getControl(currentFieldType, field, parentField, resourceDict, this.cache));
            }
        }
        catch (PDFParseException e) {
            PDFParser.LOGGER.warn((Object)e);
        }
    }

    private boolean isPDFControlType(String currentFieldType) {
        return "Tx".equals(currentFieldType) || "Ch".equals(currentFieldType) || "Btn".equals(currentFieldType);
    }

    public OutlineNode getOutline() throws PDFParseException {
        PDFObject oroot = this.root.getDictRef("Outlines");
        OutlineNode work = null;
        OutlineNode outline = null;
        if (oroot != null) {
            PDFObject scan = oroot.getDictRef("First");
            outline = work = new OutlineNode("<top>");
            block2: while (scan != null) {
                PDFObject kid;
                String title = scan.getDictRef("Title").getStringValue();
                OutlineNode build = new OutlineNode(title);
                work.add(build);
                PDFAction action = null;
                PDFObject actionObj = scan.getDictRef("A");
                if (actionObj != null) {
                    action = PDFAction.getAction(actionObj, this.getRoot());
                } else {
                    PDFObject destObj = scan.getDictRef("Dest");
                    if (destObj != null) {
                        try {
                            PDFDestination dest = PDFDestination.getDestination(destObj, this.getRoot());
                            action = new GoToAction(dest);
                        }
                        catch (PDFParseException dest) {
                            // empty catch block
                        }
                    }
                }
                if (action != null) {
                    build.setAction(action);
                }
                if ((kid = scan.getDictRef("First")) != null) {
                    work = build;
                    scan = kid;
                    continue;
                }
                PDFObject next = scan.getDictRef("Next");
                while (next == null) {
                    scan = scan.getDictRef("Parent");
                    next = scan.getDictRef("Next");
                    if ((work = (OutlineNode)work.getParent()) != null) continue;
                    break block2;
                }
                scan = next;
            }
        }
        return outline;
    }

    @Nullable
    public PDFPage getPage(int pagenum) {
        HashMap<String, PDFObject> resources = null;
        PDFObject pageObj = null;
        PDFPage page = null;
        PDFParser parser = null;
        try {
            PDFGroup pdfGroup;
            resources = new HashMap<String, PDFObject>();
            PDFObject topPagesObj = this.root.getDictRef("Pages");
            pageObj = this.findPage(topPagesObj, 0, pagenum, resources);
            if (pageObj == null) {
                return null;
            }
            page = this.createPage(pagenum, pageObj, this.decryptor, this.controlelements);
            byte[] stream = this.getContents(pageObj);
            if (this.structureHandler != null) {
                this.structureHandler.startPage(pageObj);
            }
            parser = new PDFParser(page, stream, resources, this.cache, this.ocgHandler, this.structureHandler, this);
            PDFObject group = pageObj.getDictRef("Group");
            if (group != null && (pdfGroup = PDFFile.parseGroup(group, parser)) != null) {
                page.getGroup().setColorspace(pdfGroup.getColorspace());
            }
            parser.setParserListener(this.listener);
        }
        catch (PDFParseException ioe) {
            if (page == null) {
                page = new PDFPage(pagenum, new Rectangle(), 0, null, null, null);
            }
            if (ioe.getCause() instanceof ZipException) {
                page.setParseError(new PDFDecrypter.DecryptionExcpetion(ioe.getCause(), this.userPassword != null && !this.userPassword.isEmpty(), this.fileName));
            } else {
                page.setParseError((Exception)((Object)ioe));
            }
            if (this.listener != null) {
                this.listener.startPage(page);
            }
            return page;
        }
        if (!parser.isFinished()) {
            parser.go(true);
        }
        if (parser.getRecentError() != null) {
            page.setParseError(parser.getRecentError());
        }
        parser = null;
        double pW = page.getBounds().getWidth();
        double pH = page.getBounds().getHeight();
        if (pH < 0.0) {
            page.getBounds().setRect(new Rectangle2D.Double(0.0, pH, pW, -pH));
        }
        PDFRenderer renderer = new PDFRenderer(page);
        renderer.setShouldScaleDown(this.isDownScaling);
        renderer.setParserListener(this.listener);
        if (!renderer.isFinished()) {
            renderer.go(true);
        }
        if (renderer.getRecentError() != null) {
            page.setParseError(renderer.getRecentError());
        }
        return page;
    }

    private byte[] getContents(PDFObject pageObj) throws PDFParseException {
        PDFObject contentsObj = pageObj.getDictRef("Contents");
        if (contentsObj == null) {
            return new byte[0];
        }
        PDFObject[] contents = contentsObj.getArray();
        if (contents.length == 0) {
            throw new PDFParseException("content contains no streams");
        }
        PDFXref ref = null;
        int len = 0;
        HashMap<PDFObject, byte[]> contentData = new HashMap<PDFObject, byte[]>();
        for (int i = 0; i < contents.length; ++i) {
            byte[] data;
            if (this.decryptor != null) {
                ref = contents[i].getRefValue();
                if (ref == null && contents.length == 1) {
                    ref = contentsObj.getRefValue();
                }
                if (ref == null) {
                    throw new PDFParseException("content reference not found" + i);
                }
            }
            if ((data = contents[i].getStream(ref, this.decryptor, true)) == null) {
                if (!PDFParser.LOGGER.isDebug()) continue;
                PDFParser.LOGGER.debug((Object)("WARNING: no stream " + i + " found"));
                continue;
            }
            len += data.length;
            contentData.put(contents[i], data);
        }
        byte[] commonContentStream = contents.length > 1 ? new byte[len + contents.length - 1] : null;
        len = 0;
        for (int i = 0; i < contents.length; ++i) {
            byte[] data = (byte[])contentData.get(contents[i]);
            if (data == null) {
                data = contents[i].getStream(ref, this.decryptor, true);
            }
            if (data == null) {
                data = new byte[]{};
            }
            if (contents.length == 1) {
                commonContentStream = data;
                continue;
            }
            System.arraycopy(data, 0, commonContentStream, len, data.length);
            len += data.length;
            if (i >= contents.length - 1) continue;
            commonContentStream[len++] = 32;
        }
        return commonContentStream;
    }

    private PDFPage createPage(int pagenum, PDFObject pageObj, PDFDecrypter decryptor, List<ControlData> controlList) throws PDFParseException {
        int rotation = 0;
        Rectangle2D mediabox = PDFFile.parseRect(this.getInheritedValue(pageObj, "MediaBox"));
        if (mediabox == null) {
            PDFObject topPagesObj = this.root.getDictRef("Pages");
            for (int findPageNr = pagenum - 1; findPageNr >= 0 && (mediabox = PDFFile.parseRect(this.getInheritedValue(this.findPage(topPagesObj, 0, findPageNr, new HashMap()), "MediaBox"))) == null; --findPageNr) {
            }
        }
        if (mediabox == null) {
            PDFParser.LOGGER.warn((Object)("There is no paper size defined for page #" + (pagenum + 1) + " in PDF '" + this.fileName + "'. A default size of 'US Letter' will be used to display the page."));
            mediabox = new Rectangle2D.Double(0.0, 0.0, 612.0, 792.0);
        }
        Rectangle2D.Float cropbox = PDFFile.parseRect(this.getInheritedValue(pageObj, "CropBox"));
        Rectangle2D.Float bleedbox = PDFFile.parseRect(this.getInheritedValue(pageObj, "BleedBox"));
        Rectangle2D.Float trimbox = PDFFile.parseRect(this.getInheritedValue(pageObj, "TrimBox"));
        Rectangle2D.Float artbox = PDFFile.parseRect(this.getInheritedValue(pageObj, "ArtBox"));
        PDFObject rotateObj = this.getInheritedValue(pageObj, "Rotate");
        if (rotateObj != null) {
            rotation = rotateObj.getIntValue();
        }
        Rectangle2D bbox = cropbox == null || ((RectangularShape)cropbox).getWidth() <= 0.0 || ((RectangularShape)cropbox).getHeight() <= 0.0 ? mediabox : cropbox;
        PDFObject[] annots = null;
        PDFObject annotsObj = pageObj.getDictRef("Annots");
        if (annotsObj != null) {
            annots = annotsObj.getArray();
        }
        PDFPage pdfPage = new PDFPage(pagenum, bbox, rotation, decryptor, annots, this.controlelements);
        pdfPage.setPageBounds("MediaBox", mediabox);
        pdfPage.setPageBounds("CropBox", cropbox);
        pdfPage.setPageBounds("BleedBox", bleedbox);
        pdfPage.setPageBounds("TrimBox", trimbox);
        pdfPage.setPageBounds("ArtBox", artbox);
        if (this.listener != null) {
            this.listener.startPage(pdfPage);
        }
        return pdfPage;
    }

    public PDFObject findPage(PDFObject pagedict, int start, int getPage, Map resources) throws PDFParseException {
        PDFObject typeObj;
        PDFObject rsrcObj = pagedict.getDictRef("Resources");
        if (rsrcObj != null) {
            resources.putAll(rsrcObj.getDictionary());
        }
        if ((typeObj = pagedict.getDictRef("Type")) != null && typeObj.getStringValue().equals("Page")) {
            return pagedict;
        }
        PDFObject kidsObj = pagedict.getDictRef("Kids");
        if (kidsObj != null) {
            PDFObject[] kids = kidsObj.getArray();
            for (int i = 0; i < kids.length; ++i) {
                int count = 1;
                PDFObject countItem = kids[i].getDictRef("Count");
                if (countItem != null) {
                    count = countItem.getIntValue();
                }
                if (start + count > getPage) {
                    return this.findPage(kids[i], start, getPage, resources);
                }
                start += count;
            }
        }
        return null;
    }

    private void readPageObjs(PDFObject pagesRootDict, List<PDFObject> pageList, List<Map<String, PDFObject>> pageResourcesList, Map<String, PDFObject> parentResources) throws PDFParseException {
        PDFObject objType = pagesRootDict.getDictRef("Type");
        if (objType == null || !objType.getStringValue().equals("Pages")) {
            throw new PDFParseException("The PDF strucuture is incomplete: Pages object not found");
        }
        if (pageList == null) {
            throw new PDFParseException("The PDF strucuture is incomplete: Page list not found");
        }
        PDFObject kidsObj = pagesRootDict.getDictRef("Kids");
        if (kidsObj != null) {
            PDFObject[] kids = kidsObj.getArray();
            for (int i = 0; i < kids.length; ++i) {
                HashMap<String, PDFObject> resources = new HashMap<String, PDFObject>(parentResources);
                objType = kids[i].getDictRef("Type");
                PDFObject rsrcObj = kids[i].getDictRef("Resources");
                if (rsrcObj != null) {
                    resources.putAll(rsrcObj.getDictionary());
                }
                if (objType != null) {
                    if (objType.getStringValue().equals("Pages")) {
                        this.readPageObjs(kids[i], pageList, pageResourcesList, resources);
                        continue;
                    }
                    if (!objType.getStringValue().equals("Page")) continue;
                    pageList.add(kids[i]);
                    pageResourcesList.add(resources);
                    continue;
                }
                PDFObject countItem = kids[i].getDictRef("Count");
                if (countItem == null) continue;
                this.readPageObjs(kids[i], pageList, pageResourcesList, resources);
            }
        }
    }

    private PDFObject getInheritedValue(PDFObject pageObj, String propName) throws PDFParseException {
        if (pageObj == null) {
            return null;
        }
        PDFObject propObj = pageObj.getDictRef(propName);
        if (propObj != null) {
            return propObj;
        }
        PDFObject parentObj = pageObj.getDictRef("Parent");
        if (parentObj != null) {
            return this.getInheritedValue(parentObj, propName);
        }
        return null;
    }

    public static Rectangle2D.Float parseRect(PDFObject obj) throws PDFParseException {
        if (obj == null) {
            return null;
        }
        if (obj.getType() == 5) {
            PDFObject[] bounds = obj.getArray();
            if (bounds.length == 4) {
                return new Rectangle2D.Float(bounds[0].getFloatValue(), bounds[1].getFloatValue(), bounds[2].getFloatValue() - bounds[0].getFloatValue(), bounds[3].getFloatValue() - bounds[1].getFloatValue());
            }
            throw new PDFParseException("Rectangle definition didn't have 4 elements");
        }
        throw new PDFParseException("Rectangle definition not an array");
    }

    public static PDFGroup parseGroup(PDFObject groupObj, PDFParser parser) throws PDFParseException {
        if (groupObj != null && groupObj.getDictRef("S") != null && "Transparency".equals(groupObj.getDictRef("S").getStringValue())) {
            PDFGroup pdfGroup = new PDFGroup();
            if (groupObj.getDictRef("I") != null) {
                pdfGroup.setIsolated(groupObj.getDictRef("I").getBooleanValue());
            }
            if (groupObj.getDictRef("K") != null) {
                pdfGroup.setKnockout(groupObj.getDictRef("K").getBooleanValue());
            }
            if (groupObj.getDictRef("CS") != null) {
                pdfGroup.setColorspace(parser.parseColorSpace(groupObj.getDictRef("CS").dereference()));
            }
            return pdfGroup;
        }
        return null;
    }

    private void writeInfo() {
        Logger log = PDFParser.LOGGER;
        log.debug((Object)"File Info");
        log.debug((Object)"---------");
        log.debug((Object)("File name: " + this.fileName));
        log.debug((Object)("Producer: " + (this.producer != null ? this.producer : "unknown")));
        log.debug((Object)("Creator:  " + (this.creator != null ? this.creator : "unknown")));
        log.debug((Object)("is CrystalReports: " + this.isCrystalReports));
        log.debug((Object)("Title:    " + (this.title != null ? this.title : "unknown")));
        log.debug((Object)("CreationDate:     " + (this.creationDate != null ? this.creationDate : "unknown")));
        log.debug((Object)("ModificationDate: " + (this.modDate != null ? this.modDate : "unknown")));
    }

    @Nullable
    public String getProducer() {
        return this.producer;
    }

    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getCreationDate() {
        return this.creationDate;
    }

    @Nullable
    public String getModDate() {
        return this.modDate;
    }

    public boolean isCrystalReportExport() {
        return this.isCrystalReports;
    }

    private int getTableOffset(PDFObject hintDict, String keyword) {
        int res = -1;
        try {
            PDFObject obj = hintDict.getDictRef(keyword);
            if (obj != null && obj.getType() == 2) {
                res = obj.getIntValue();
            }
        }
        catch (PDFParseException e) {
            Logger log = PDFParser.LOGGER;
            log.error((Object)("get table offset: " + e.getMessage()));
        }
        return res;
    }

    private int readInt(InputStream stream, int byteLen) throws PDFParseException {
        try {
            if (byteLen == 1) {
                return stream.read();
            }
            byte[] bytes = new byte[byteLen];
            stream.read(bytes);
            int val = 0;
            for (int i = 0; i < byteLen; ++i) {
                val <<= 8;
                val |= bytes[i] & 0xFF;
            }
            return val;
        }
        catch (IOException ex) {
            throw PDFParseException.create(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readXRef(int xrefpos) throws PDFParseException {
        this.buf.position(xrefpos);
        PDFObject obj = this.readObject();
        if (obj == null) throw new PDFParseException("The PDF strucuture is inconsistent: XRef table is corrupted. Try an external repair tool like MuTool to rebuild the PDF strucuture.");
        if (obj.getType() != 7) throw new PDFParseException("The PDF strucuture is inconsistent: XRef table is corrupted. Try an external repair tool like MuTool to rebuild the PDF strucuture.");
        PDFObject xreftype = obj.getDictRef("Type");
        if (xreftype.getType() != 4) throw new PDFParseException("The PDF strucuture is inconsistent: XRef table has incorrect type. Try an external repair tool like MuTool to rebuild the PDF strucuture.");
        if (!"XRef".equals(xreftype.getStringValue())) throw new PDFParseException("The PDF strucuture is inconsistent: XRef table not found. Try an external repair tool like MuTool to rebuild the PDF strucuture.");
        return this.readXRefObject(obj);
    }

    private int readXRefObject(PDFObject obj) throws PDFParseException {
        PDFObject obj6;
        PDFObject obj4;
        PDFObject obj5;
        int[] wArr = null;
        int[] indexArray = null;
        int size = 0;
        int prevXrefPos = 0;
        PDFObject obj1 = obj.getDictRef("W");
        if (obj1.getType() == 5) {
            PDFObject[] obj1wArr = obj1.getArray();
            wArr = new int[obj1wArr.length];
            for (int i = 0; i < wArr.length; ++i) {
                wArr[i] = obj1wArr[i].getIntValue();
            }
        }
        if ((obj5 = obj.getDictRef("Size")).getType() == 2) {
            size = obj5.getIntValue();
        }
        if ((obj4 = obj.getDictRef("Index")) != null) {
            if (obj4.getType() == 5) {
                PDFObject[] obj4wArr = obj4.getArray();
                indexArray = new int[obj4wArr.length];
                for (int i = 0; i < indexArray.length; ++i) {
                    indexArray[i] = obj4wArr[i].getIntValue();
                }
            }
        } else {
            indexArray = new int[]{0, size};
        }
        if ((obj6 = obj.getDictRef("Prev")) != null && obj6.getType() == 2) {
            prevXrefPos = obj6.getIntValue();
        }
        if (this.docID == null) {
            this.docID = obj.getDictRef("ID");
        }
        this.info = obj.getDictRef("Info");
        if (this.root == null) {
            this.root = obj.getDictRef("Root");
        }
        PDFXref ref = null;
        PDFDecrypter decryptor = null;
        byte[] data = obj.getStream(ref, decryptor, true);
        this.readXrefStream(data, indexArray, wArr);
        PDFObject encyptObj = obj.getDictRef("Encrypt");
        if (encyptObj != null) {
            this.encrypt = encyptObj;
        }
        return prevXrefPos;
    }

    private void readXrefStream(byte[] data, int[] indexArray, int[] wArr) throws PDFParseException {
        FastByteArrayInputStream stream = new FastByteArrayInputStream(data);
        int subsectionIndex = 0;
        while (subsectionIndex <= indexArray.length - 2) {
            int subsectionStartRef = indexArray[subsectionIndex++];
            int subsectionSize = indexArray[subsectionIndex++];
            this.readSubsection(subsectionStartRef, subsectionSize, (InputStream)stream, wArr);
        }
        stream.close();
    }

    private void readSubsection(int refstart, int reflen, InputStream stream, int[] wArr) throws PDFParseException {
        int crossRefSize;
        int n = crossRefSize = this.crossRefEntries != null ? this.crossRefEntries.length : 0;
        if (refstart + reflen >= crossRefSize) {
            PDFCrossRefEntry[] nobjIdx = new PDFCrossRefEntry[refstart + reflen];
            if (crossRefSize != 0) {
                System.arraycopy(this.crossRefEntries, 0, nobjIdx, 0, crossRefSize);
            }
            this.crossRefEntries = nobjIdx;
        }
        for (int i = 0; i < reflen; ++i) {
            int index = refstart + i;
            int type = wArr[0] == 0 ? 1 : this.readInt(stream, wArr[0]);
            int objPar1 = this.readInt(stream, wArr[1]);
            int objPar2 = 0;
            if (wArr[2] != 0) {
                objPar2 = this.readInt(stream, wArr[2]);
            }
            if (this.crossRefEntries[index] != null) continue;
            int generationNumber = 0;
            this.setCrossRefEntry(index, switch (type) {
                case 0 -> new PDFCrossRefEntry(null);
                case 1 -> new PDFCrossRefEntry(objPar1, objPar2);
                case 2 -> new PDFCrossRefEntry(objPar1, objPar2, generationNumber);
                default -> throw new PDFParseException("XRef resolve error: unknown type of cross reference '" + type + "'");
            });
        }
    }

    protected void setCrossRefEntry(int index, PDFCrossRefEntry entry) {
        this.crossRefEntries[index] = entry;
    }

    private int readXrefTable(boolean checkTable) throws PDFParseException {
        PDFObject obj;
        while ((obj = this.readObject()).getType() != 9 || !obj.getStringValue().equals("trailer")) {
            if (obj.getType() != 2) {
                throw new PDFParseException("Expected number for first xref entry");
            }
            int refstart = obj.getIntValue();
            if (this.firstObjNum == 0) {
                this.firstObjNum = refstart;
            }
            if ((obj = this.readObject()).getType() != 2) {
                throw new PDFParseException("Expected number for length of xref table");
            }
            int reflen = obj.getIntValue();
            this.readLine();
            if (this.crossRefEntries == null) {
                this.crossRefEntries = new PDFCrossRefEntry[refstart + reflen];
            }
            if (refstart + reflen >= this.crossRefEntries.length) {
                PDFCrossRefEntry[] nobjIdx = new PDFCrossRefEntry[refstart + reflen];
                System.arraycopy(this.crossRefEntries, 0, nobjIdx, 0, this.crossRefEntries.length);
                this.crossRefEntries = nobjIdx;
            }
            for (int refID = refstart; refID < refstart + reflen; ++refID) {
                byte[] refline = new byte[19];
                this.buf.get(refline);
                int pos = this.buf.position();
                byte c = this.buf.get();
                if (c >= 32) {
                    this.buf.position(pos);
                }
                if (this.crossRefEntries[refID] != null) continue;
                if (refline[17] == 110) {
                    this.setCrossRefEntry(refID, new PDFCrossRefEntry(refline));
                    continue;
                }
                this.setCrossRefEntry(refID, new PDFCrossRefEntry(null));
            }
        }
        PDFObject trailerdict = this.readObject();
        if (trailerdict.getType() != 6) {
            throw new PDFParseException("Expected dictionary after \"trailer\"");
        }
        if (this.root == null) {
            this.root = trailerdict.getDictRef("Root");
        }
        if (this.encrypt == null) {
            this.encrypt = trailerdict.getDictRef("Encrypt");
        }
        if (this.docID == null) {
            this.docID = trailerdict.getDictRef("ID");
        }
        if (this.info == null) {
            this.info = trailerdict.getDictRef("Info");
        }
        int prevpos = 0;
        PDFObject prevloc = trailerdict.getDictRef("Prev");
        if (prevloc != null) {
            prevpos = prevloc.getIntValue();
            this.buf.position(prevpos);
        }
        if (checkTable && prevpos == 0 && this.crossRefEntries[0] == null) {
            int i;
            for (i = 0; i < this.crossRefEntries.length && this.crossRefEntries[i] == null; ++i) {
            }
            if (i != 0) {
                for (int j = 0; j < this.crossRefEntries.length - i; ++j) {
                    this.setCrossRefEntry(j, this.crossRefEntries[j + i]);
                }
            }
        }
        if (this.root.getDictRef("Version") != null) {
            this.processVersion(this.root.getDictRef("Version").getStringValue());
        }
        return prevpos;
    }

    private boolean isInetCommentLine() {
        byte[] bytes = "%\u00c2\u00ab\u00c2\u00a9\u00c2\u00b1\u00c3\u00aa".getBytes();
        if (this.buf.remaining() > bytes.length) {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == this.buf.get()) continue;
                return false;
            }
            if (this.buf.get() == 10) {
                return true;
            }
        }
        return false;
    }

    public void close() {
        this.buf.close();
    }

    PDFDecrypter getDecryptor() {
        return this.decryptor;
    }

    public void setCacheAccess(CacheAccess cache) {
        this.cache = cache;
    }
}

