/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.pdfview.PDFGroup;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.command.PDFCompositeCmd;
import com.inet.shared.utils.BlendComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.LinkedList;

public class GraphicsState {
    private Shape cliprgn;
    private Shape cliprgnG;
    private BasicStroke stroke;
    private PDFPaint strokePaint;
    private PDFPaint fillPaint;
    private LinkedList<PDFCompositeCmd.PDFBlendComposite> fillComposites = new LinkedList();
    private LinkedList<PDFCompositeCmd.PDFBlendComposite> strokeComposites = new LinkedList();
    private BlendComposite defaultComposite = BlendComposite.getInstance((BlendComposite.BlendingMode)BlendComposite.BlendingMode.NORMAL);
    private AffineTransform xform;
    private PDFGroup group;
    private float currentFillAlpha = -1.0f;
    private BufferedImage currentFillMask = null;
    private float currentStrokeAlpha = -1.0f;
    private BufferedImage currentStrokeMask = null;
    private int layer;

    GraphicsState(AffineTransform xform) {
        this.stroke = new BasicStroke(1.0f, 0, 0);
        this.fillPaint = this.strokePaint = PDFPaint.getPaint(Color.black);
        this.xform = xform;
    }

    public GraphicsState copy(int layer) {
        this.layer = layer;
        GraphicsState cState = new GraphicsState((AffineTransform)this.xform.clone());
        cState.cliprgn = this.cliprgn;
        cState.cliprgnG = this.cliprgnG;
        cState.strokePaint = this.strokePaint;
        cState.fillPaint = this.fillPaint;
        cState.fillComposites = new LinkedList<PDFCompositeCmd.PDFBlendComposite>(this.fillComposites);
        cState.strokeComposites = new LinkedList<PDFCompositeCmd.PDFBlendComposite>(this.strokeComposites);
        cState.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        cState.group = (PDFGroup)this.group.clone();
        cState.currentFillAlpha = this.currentFillAlpha;
        cState.currentFillMask = this.currentFillMask;
        cState.currentStrokeAlpha = this.currentStrokeAlpha;
        cState.currentStrokeMask = this.currentStrokeMask;
        return cState;
    }

    public int getLayerNr() {
        return this.layer;
    }

    public Shape getClip() {
        return this.cliprgn;
    }

    public void setClip(Shape clip) {
        this.cliprgn = clip;
    }

    public PDFPaint getFillPaint() {
        return this.fillPaint;
    }

    public PDFPaint getStrokePaint() {
        return this.strokePaint;
    }

    public BlendComposite getFillComposite() {
        if (this.fillComposites.isEmpty()) {
            return this.defaultComposite;
        }
        return this.mergeComposite(true);
    }

    public BlendComposite getStrokeComposite() {
        if (this.strokeComposites.isEmpty()) {
            return this.defaultComposite;
        }
        return this.mergeComposite(false);
    }

    public void setClipFromGraphics(Graphics2D g) {
        this.cliprgnG = g != null ? g.getClip() : null;
    }

    public Shape getClipGraphics() {
        return this.cliprgnG;
    }

    private BlendComposite mergeComposite(boolean isFill) {
        LinkedList<PDFCompositeCmd.PDFBlendComposite> composites = isFill ? this.fillComposites : this.strokeComposites;
        float alpha = isFill ? this.currentFillAlpha : this.currentStrokeAlpha;
        BufferedImage mask = isFill ? this.currentFillMask : this.currentStrokeMask;
        BlendComposite reference = composites.getLast();
        BlendComposite derive = new BlendComposite(reference.getMode(), Math.abs(alpha), mask);
        if (this.maptToNormal()) {
            derive = derive.derive(BlendComposite.BlendingMode.NORMAL);
        }
        return derive;
    }

    public void setStrokePaint(PDFPaint strokePaint) {
        this.strokePaint = strokePaint;
    }

    public void setFillPaint(PDFPaint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void addComposite(PDFCompositeCmd.PDFBlendComposite composite, boolean isFill) {
        LinkedList<PDFCompositeCmd.PDFBlendComposite> listComposite = isFill ? this.fillComposites : this.strokeComposites;
        listComposite.addLast(composite);
        if (composite.hasDefinedAlphaValue()) {
            if (isFill) {
                this.currentFillAlpha = composite.getAlpha();
            } else {
                this.currentStrokeAlpha = composite.getAlpha();
            }
        }
        if (composite.hasDefinedMaskValue()) {
            if (isFill) {
                this.currentFillMask = composite.getMask();
            } else {
                this.currentStrokeMask = composite.getMask();
            }
        }
    }

    public void setXform(AffineTransform xform) {
        this.xform = xform;
    }

    public AffineTransform getXForm() {
        return this.xform;
    }

    public void setGroup(PDFGroup group) {
        this.group = group;
    }

    private boolean maptToNormal() {
        if (this.group == null) {
            return true;
        }
        ColorSpace colorSpace = this.group.getColorspace().getColorSpace();
        return colorSpace.getType() != 5;
    }

    public void clearCompositeList() {
        this.fillComposites = new LinkedList();
        this.strokeComposites = new LinkedList();
        this.currentFillAlpha = -1.0f;
        this.currentFillMask = null;
        this.currentStrokeAlpha = -1.0f;
        this.currentStrokeMask = null;
    }
}

