/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview;

import com.inet.pdfview.PDFParser;
import com.inet.pdfview.Watchable;
import com.inet.pdfview.error.PDFParseException;
import javax.annotation.Nullable;

public abstract class BaseWatchable
implements Watchable,
Runnable {
    private int status = 0;
    private Object statusLock = new Object();
    private Object parserLock = new Object();
    private Thread thread;
    private Exception recentError = null;
    private Exception firstError;

    protected BaseWatchable() {
        this.setStatus(1);
    }

    protected abstract int iterate() throws Exception;

    protected void setup() {
    }

    protected void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (PDFParser.LOGGER.isDebug()) {
            PDFParser.LOGGER.debug((Object)" Starting");
        }
        if (this.getStatus() == 1) {
            this.setup();
        }
        this.setStatus(2);
        Object object = this.parserLock;
        // MONITORENTER : object
        while (!this.isFinished() && this.getStatus() != 5) {
            if (this.isExecutable()) {
                this.setStatus(4);
                this.recentError = null;
                try {
                    while (this.getStatus() == 4) {
                        this.setStatus(this.iterate());
                    }
                    if (this.getStatus() != 4) continue;
                    this.setStatus(2);
                }
                catch (Exception ex) {
                    this.setError(ex);
                }
                continue;
            }
            if (PDFParser.LOGGER.isDebug()) {
                PDFParser.LOGGER.debug((Object)" status: not executable");
            }
            Object object2 = this.statusLock;
            // MONITORENTER : object2
            if (!this.isExecutable()) {
                try {
                    if (PDFParser.LOGGER.isDebug()) {
                        PDFParser.LOGGER.debug((Object)" statusLock: start waiting...");
                    }
                    this.statusLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : object2
        }
        // MONITOREXIT : object
        if (this.getStatus() == 6 || this.getStatus() == 7) {
            this.cleanup();
        }
        this.thread = null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public Exception getRecentError() {
        return this.recentError;
    }

    public Exception getFirstError() {
        return this.firstError;
    }

    public boolean isFinished() {
        int s = this.getStatus();
        return s == 6 || s == 7;
    }

    private boolean isExecutable() {
        return this.status == 2 || this.status == 4;
    }

    @Override
    public void stop() {
        this.setStatus(5);
    }

    @Override
    public synchronized void go(boolean synchronous) {
        if (PDFParser.LOGGER.isDebug()) {
            PDFParser.LOGGER.debug((Object)"go()...");
        }
        this.execute(synchronous);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinish() {
        if (PDFParser.LOGGER.isDebug()) {
            PDFParser.LOGGER.debug((Object)" calling of waitForFinish for ");
        }
        Object object = this.statusLock;
        synchronized (object) {
            while (!this.isFinished() && this.getStatus() != 5) {
                try {
                    this.statusLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void execute(boolean synchronous) {
        if (PDFParser.LOGGER.isDebug()) {
            PDFParser.LOGGER.debug((Object)"execute()  ...");
        }
        if (this.thread != null) {
            Object object = this.statusLock;
            synchronized (object) {
                if (PDFParser.LOGGER.isDebug()) {
                    PDFParser.LOGGER.debug((Object)"statusLock: ?notifying that thread is rinning");
                }
                this.statusLock.notifyAll();
            }
            return;
        }
        if (this.isFinished()) {
            if (PDFParser.LOGGER.isDebug()) {
                PDFParser.LOGGER.debug((Object)"we're all finished");
            }
            return;
        }
        if (synchronous) {
            this.thread = Thread.currentThread();
            this.run();
        } else {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(int status) {
        Object object = this.statusLock;
        synchronized (object) {
            this.status = status;
            this.statusLock.notifyAll();
        }
    }

    protected void setError(@Nullable Exception error) {
        this.recentError = error;
        if (this.firstError == null) {
            this.firstError = error;
        }
        PDFParser.LOGGER.error((Throwable)((Object)PDFParseException.create(error)));
        this.setStatus(7);
    }
}

