/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.examples.viewer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.jpedal.jbig2.JBIG2Decoder;
import org.jpedal.jbig2.examples.viewer.JBIG2Viewer;

public class NavigationToolbar
extends JToolBar {
    protected static final int FIRSTPAGE = 0;
    protected static final int FBACKPAGE = 1;
    protected static final int BACKPAGE = 2;
    protected static final int FORWARDPAGE = 3;
    protected static final int FFORWARDPAGE = 4;
    protected static final int LASTPAGE = 5;
    protected static final int SETPAGE = 6;
    protected JTextField currentPageBox = new JTextField(4);
    private JLabel totalNoOfPages = new JLabel();
    private JBIG2Viewer viewer;

    public NavigationToolbar(JBIG2Viewer viewer) {
        this.viewer = viewer;
        this.totalNoOfPages.setText("of 1");
        this.currentPageBox.setText("1");
        this.add(Box.createHorizontalGlue());
        this.addButton("Rewind To Start", "/org/jpedal/jbig2/examples/viewer/res/start.gif", 0);
        this.addButton("Back 10 Pages", "/org/jpedal/jbig2/examples/viewer/res/fback.gif", 1);
        this.addButton("Back", "/org/jpedal/jbig2/examples/viewer/res/back.gif", 2);
        this.add(new JLabel("Page"));
        this.currentPageBox.setMaximumSize(new Dimension(5, 50));
        this.currentPageBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigationToolbar.this.executeCommand(6);
            }
        });
        this.add(this.currentPageBox);
        this.add(this.totalNoOfPages);
        this.addButton("Forward", "/org/jpedal/jbig2/examples/viewer/res/forward.gif", 3);
        this.addButton("Forward 10 Pages", "/org/jpedal/jbig2/examples/viewer/res/fforward.gif", 4);
        this.addButton("Fast Forward To End", "/org/jpedal/jbig2/examples/viewer/res/end.gif", 5);
        this.add(Box.createHorizontalGlue());
    }

    public void setTotalNoOfPages(int noOfPages) {
        this.totalNoOfPages.setText("of " + noOfPages);
    }

    public void setCurrentPage(int currentPage) {
        this.currentPageBox.setText(String.valueOf(currentPage));
    }

    private void addButton(String tooltip, String url, final int type) {
        JButton button = new JButton();
        button.setIcon(new ImageIcon(this.getClass().getResource(url)));
        button.setToolTipText(tooltip);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigationToolbar.this.executeCommand(type);
            }
        });
        this.add(button);
    }

    public void executeCommand(int type) {
        JBIG2Decoder decoder = this.viewer.getDecoder();
        switch (type) {
            case 0: {
                this.viewer.displayPage(1);
                break;
            }
            case 1: {
                this.viewer.displayPage(this.viewer.getCurrentPage() - 10);
                break;
            }
            case 2: {
                this.viewer.displayPage(this.viewer.getCurrentPage() - 1);
                break;
            }
            case 3: {
                this.viewer.displayPage(this.viewer.getCurrentPage() + 1);
                break;
            }
            case 4: {
                this.viewer.displayPage(this.viewer.getCurrentPage() + 10);
                break;
            }
            case 5: {
                this.viewer.displayPage(decoder.getNumberOfPages());
                break;
            }
            case 6: {
                int page = -1;
                try {
                    page = Integer.parseInt(this.currentPageBox.getText());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                if (page >= 1 && page <= decoder.getNumberOfPages()) {
                    this.viewer.displayPage(page);
                    break;
                }
                this.currentPageBox.setText(String.valueOf(this.viewer.getCurrentPage()));
            }
        }
    }
}

