/*
 * Decompiled with CFR 0.152.
 */
package com.inet.encoder.pdf.drive;

import com.inet.annotations.InternalApi;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.RandomAccess;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.encoder.pdf.PDFParserPlugin;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.pdfview.PDFFile;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.command.PDFCmd;
import com.inet.pdfview.command.PDFDrawTextCmd;
import com.inet.pdfview.command.PDFDrawTextCmds;
import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.data.RandomAccessBuffer;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.RandomAccessRead;
import com.inet.plugin.image.PreviewGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;

@InternalApi
public class PDFDocumentTypeHandler
implements DriveFileTypeHandler {
    @Nonnull
    public String getExtensionName() {
        return "pdfc.drive.documenthandler";
    }

    public boolean acceptFileTyp(@Nullable DriveEntry entry) {
        if (entry == null) {
            return false;
        }
        @Nonnull String string = entry.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return false;
        }
        String string2 = string.substring(n + 1).toLowerCase();
        return "pdf".equals(string2);
    }

    public String getFileTypeName(@Nonnull DriveEntry entry) {
        if (this.acceptFileTyp(entry)) {
            return PDFParserPlugin.MSG.getMsg("filetype.pdf", new Object[0]);
        }
        return null;
    }

    @Nonnull
    public DriveFileTypeHandler.FileTypeDriveEntryHandler getFileTypeHandler(@Nonnull PersistenceEntry pEntry, @Nonnull DriveEntry entry) {
        return new a(pEntry, entry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreviewGenerator.ImagePreview getThumbnail(@Nonnull DriveEntry entry, @Nonnull Thumbnail.Size size, boolean pdf) throws IOException {
        if (!entry.hasFeature(RandomAccess.class)) {
            return null;
        }
        RandomAccess randomAccess = (RandomAccess)entry.getFeature(RandomAccess.class);
        if (randomAccess == null) {
            return null;
        }
        try (RandomAccessBuffer randomAccessBuffer = new RandomAccessBuffer(randomAccess.getRandomAccess());){
            PDFFile pDFFile = new PDFFile((IDataBuffer)randomAccessBuffer, "", null);
            PDFPage pDFPage = pDFFile.getPage(0);
            if (pDFPage == null) {
                PreviewGenerator.ImagePreview imagePreview = null;
                return imagePreview;
            }
            float f = pDFPage.getWidth();
            float f2 = pDFPage.getHeight();
            int n = size.getSize();
            int n2 = (int)f;
            int n3 = (int)f2;
            if (f > (float)n || f2 > (float)n) {
                double d = f > f2 ? (double)((float)n / f) : (double)((float)n / f2);
                n2 = (int)((double)f * d);
                n3 = (int)((double)f2 * d);
            }
            final BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            PDFRenderer pDFRenderer = new PDFRenderer(pDFPage, graphics2D, (Rectangle2D)new Rectangle(n2, n3), Color.WHITE);
            pDFRenderer.go(true);
            PreviewGenerator.ImagePreview imagePreview = new PreviewGenerator.ImagePreview(bufferedImage.getWidth(), bufferedImage.getHeight(), "png", new ByteArrayOutputStream()){

                public byte[] getData() {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    return byteArrayOutputStream.toByteArray();
                }

                public void writeTo(OutputStream out) throws IOException {
                    ImageIO.write((RenderedImage)bufferedImage, "png", out);
                }
            };
            return imagePreview;
        }
        catch (PDFDecrypter.DecryptionExcpetion decryptionExcpetion) {
            LogManager.getConfigLogger().debug((Object)("Cannot create FileTypeHandler for '" + entry.getName() + "' because it's password protected."));
            return null;
        }
        catch (Exception exception) {
            LogManager.getConfigLogger().error((Throwable)exception);
            return null;
        }
    }

    public Object getFileSpecificDiff(@Nonnull DriveEntry previous, @Nonnull DriveEntry after) {
        return null;
    }

    private static class a
    implements DriveFileTypeHandler.FileTypeDriveEntryHandler {
        private String g;
        private Map<String, String> h = new HashMap<String, String>();

        public a(@Nonnull PersistenceEntry persistenceEntry, @Nonnull DriveEntry driveEntry) {
            RandomAccess randomAccess;
            String string3 = driveEntry.getName();
            RandomAccessRead randomAccessRead = null;
            if (driveEntry.hasFeature(RandomAccess.class)) {
                randomAccess = (RandomAccess)driveEntry.getFeature(RandomAccess.class);
                if (randomAccess == null) {
                    return;
                }
                try {
                    randomAccessRead = randomAccess.getRandomAccess();
                }
                catch (Exception exception) {
                    LogManager.getConfigLogger().error((Throwable)exception);
                    return;
                }
            } else {
                randomAccessRead = persistenceEntry.getRandomAccessRead();
            }
            try {
                randomAccess = new RandomAccessBuffer(randomAccessRead);
                try {
                    Object object;
                    PDFFile pDFFile = new PDFFile((IDataBuffer)randomAccess, string3, null);
                    this.h.put("title", pDFFile.getTitle());
                    this.h.put("author", pDFFile.getAuthor());
                    String string4 = pDFFile.getProducer();
                    String string5 = pDFFile.getCreator();
                    if (string5 != null || string4 != null) {
                        object = new StringBuilder();
                        if (string4 != null && !string4.isBlank()) {
                            ((StringBuilder)object).append(string4);
                        }
                        if (string5 != null && !string5.isBlank() && !string5.equals(((StringBuilder)object).toString())) {
                            if (((StringBuilder)object).length() > 0) {
                                ((StringBuilder)object).append(", ");
                            }
                            ((StringBuilder)object).append(string5);
                        }
                        this.h.put("producer", ((StringBuilder)object).toString());
                    }
                    if (Objects.equals(this.h.get("producer"), this.h.get("author"))) {
                        this.h.remove("author");
                    }
                    object = (string, string2) -> {
                        if ((string2 = PDFParserPlugin.convertPDFTimeToMillis(string2)) != null) {
                            this.h.put((String)string, (String)string2);
                        }
                    };
                    object.accept("creationDate", pDFFile.getCreationDate());
                    object.accept("modificationDate", pDFFile.getModDate());
                    int n = pDFFile.getNumPages();
                    StringBuffer stringBuffer = new StringBuffer();
                    Consumer<List> consumer = list -> {
                        for (PDFDrawTextCmd pDFDrawTextCmd : list) {
                            stringBuffer.append(pDFDrawTextCmd.getText() + "\n");
                            if (stringBuffer.length() < 1000000) continue;
                            break;
                        }
                    };
                    block10: for (int i = 0; i < n; ++i) {
                        PDFPage pDFPage = pDFFile.getPage(i);
                        if (pDFPage == null) continue;
                        for (PDFCmd pDFCmd : pDFPage.getCommands()) {
                            if (pDFCmd instanceof PDFDrawTextCmd) {
                                consumer.accept(List.of((PDFDrawTextCmd)pDFCmd));
                            } else if (pDFCmd instanceof PDFDrawTextCmds) {
                                consumer.accept(((PDFDrawTextCmds)pDFCmd).getTextCommands());
                            }
                            if (stringBuffer.length() < 1000000) continue;
                            break block10;
                        }
                    }
                    this.g = stringBuffer.toString();
                }
                finally {
                    randomAccess.close();
                }
            }
            catch (PDFDecrypter.DecryptionExcpetion decryptionExcpetion) {
                LogManager.getConfigLogger().debug((Object)("Cannot create FileTypeHandler for '" + persistenceEntry.getName() + "' because it's password protected."));
                this.g = "";
            }
            catch (Exception exception) {
                LogManager.getConfigLogger().error((Throwable)exception);
            }
        }

        public String getTextForSearch() {
            return this.g;
        }

        public Map<MetaKey<?>, Object> getMetaData() {
            HashMap hashMap = new HashMap();
            BiConsumer<MetaKey, String> biConsumer = (metaKey, string) -> {
                if (this.h.containsKey(string) && !StringFunctions.isEmpty((String)this.h.get(string))) {
                    hashMap.put((MetaKey<?>)metaKey, this.h.get(string));
                }
            };
            BiConsumer<MetaKey, String> biConsumer2 = (metaKey, string) -> {
                if (this.h.containsKey(string) && !StringFunctions.isEmpty((String)this.h.get(string))) {
                    try {
                        hashMap.put((MetaKey<?>)metaKey, Long.valueOf(this.h.get(string)));
                    }
                    catch (Exception exception) {
                        LogManager.getConfigLogger().error((Throwable)exception);
                    }
                }
            };
            hashMap.put(MetaData.FILETYPE, "pdf");
            if (this.h != null) {
                biConsumer.accept(MetaData.TITLE, "title");
                biConsumer.accept(MetaData.AUTHOR, "author");
                biConsumer.accept(MetaData.PRODUCER, "producer");
                biConsumer2.accept(MetaData.CREATE, "creationDate");
                biConsumer2.accept(MetaData.MODIFIED, "modificationDate");
            }
            return hashMap;
        }
    }
}

