/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.structure;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.structure.StructureType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StructureTreeNode {
    private List<StructureTreeNode> children = new ArrayList<StructureTreeNode>();
    private StructureTreeNode parent;
    private List<MCID> mcids = null;
    private String lang = null;
    private int pageIndex = -1;
    private String type = null;
    private StructureType structureType;
    private String actualText = null;
    private String alt = null;
    private String title = null;

    public StructureTreeNode(PDFObject content, Map<String, String> roleMap) throws PDFParseException {
        PDFObject titleTextObj;
        PDFObject altTextObj;
        PDFObject actualTextObj;
        PDFObject pageRef;
        PDFObject langObject;
        String standardRole;
        PDFObject type = content.getDictRef("S");
        if (type != null) {
            this.type = type.dereference().getStringValue();
        } else {
            type = content.getDictRef("Type");
            if (type != null) {
                this.type = type.dereference().getStringValue();
            }
        }
        if (roleMap != null && (standardRole = roleMap.get(this.type)) != null) {
            this.type = standardRole;
        }
        this.structureType = StructureType.getType(this.type);
        PDFObject kEntry = content.getDictRef("K");
        if (kEntry != null) {
            if ((kEntry = kEntry.dereference()).getType() == 5) {
                PDFObject[] entries;
                for (PDFObject entry : entries = kEntry.getArray()) {
                    this.addPotentialMCID(entry);
                }
            } else {
                this.addPotentialMCID(kEntry);
            }
        }
        if ((langObject = content.getDictRef("Lang")) != null) {
            this.lang = langObject.getStringValue();
        }
        if ((pageRef = content.getDictRef("Pg")) != null && pageRef.getDictRef("Parent") != null) {
            PDFObject[] allPageRef = pageRef.getDictRef("Parent").getDictRef("Kids").getArray();
            this.pageIndex = Arrays.asList(allPageRef).indexOf(pageRef);
        }
        if ((actualTextObj = content.getDictRef("ActualText")) != null) {
            this.actualText = actualTextObj.getStringValue();
        }
        if ((altTextObj = content.getDictRef("Alt")) != null) {
            this.alt = altTextObj.getStringValue();
        }
        if ((titleTextObj = content.getDictRef("T")) != null) {
            this.title = titleTextObj.getStringValue();
        }
    }

    private void addPotentialMCID(PDFObject source) throws PDFParseException {
        PDFObject sType;
        if ((source = source.dereference()).getType() == 2) {
            if (this.mcids == null) {
                this.mcids = new ArrayList<MCID>();
            }
            this.mcids.add(new MCID(source.getIntValue(), this.pageIndex));
        } else if (source.getType() == 6 && (sType = source.getDictRef("Type")) != null && sType.getType() == 4 && "MCR".equals(sType.getStringValue())) {
            PDFObject mcid;
            PDFObject parent;
            int customPageIndex = this.pageIndex;
            PDFObject pageRef = source.getDictRef("Pg");
            if (pageRef != null && (parent = pageRef.getDictRef("Parent")) != null) {
                PDFObject[] allPageRef = parent.getDictRef("Kids").getArray();
                customPageIndex = Arrays.asList(allPageRef).indexOf(pageRef);
            }
            if (this.mcids == null) {
                this.mcids = new ArrayList<MCID>();
            }
            if ((mcid = source.getDictRef("MCID")) != null && mcid.getType() == 2) {
                this.mcids.add(new MCID(mcid.getIntValue(), customPageIndex));
            }
        }
    }

    void addChild(StructureTreeNode child) {
        this.children.add(child);
        child.parent = this;
    }

    @Nullable
    public String getActualText() {
        return this.actualText;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public String getTypeString() {
        return this.type;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getAlt() {
        return this.alt;
    }

    @Nonnull
    public StructureType getType() {
        return this.structureType;
    }

    public List<MCID> getMCID() {
        return this.mcids;
    }

    @Nullable
    public String getLanguage() {
        return this.lang != null ? this.lang : (this.getParent() != null ? this.getParent().getLanguage() : null);
    }

    @Nullable
    public StructureTreeNode getParent() {
        return this.parent;
    }

    public List<StructureTreeNode> getChildren() {
        return this.children;
    }

    public static class MCID {
        private int id;
        private int pageIndex;

        public MCID(int id, int pageIndex) {
            this.id = id;
            this.pageIndex = pageIndex;
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        public int getId() {
            return this.id;
        }
    }
}

