/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.structure;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.ParserListener;
import com.inet.pdfview.command.PDFSwitchStructureElement;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.structure.StructureTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructureTreeHandler {
    private static final String KEY_TYPE = "Type";
    private static final String KEY_STRUCT_PARENTS = "StructParents";
    private static final String KEY_STRUCT_PARENT = "StructParent";
    private static final String KEY_CLASS_MAP = "ClassMap";
    private static final String KEY_PARENT_TREE = "ParentTree";
    private static final String KEY_MAP_NUMS = "Nums";
    private static final String KEY_MAP_KIDS = "Kids";
    private static final String KEY_MARKED_CONTENT_REF = "MCR";
    private static final String KEY_OBJECT_REF = "OBJR";
    private static final String KEY_KIDS = "K";
    private static final Integer UNDEFINED_PAGE = -1;
    private Map<String, Map<String, PDFObject>> classMap;
    private Map<String, String> roleMap;
    private Map<Integer, Map<Integer, StructureTreeNode>> mcidMap = new HashMap<Integer, Map<Integer, StructureTreeNode>>();
    private ParserListener listener;
    private StructureTreeNode recentParserNode;
    private Integer currentParent;

    public static StructureTreeHandler buildStructureTree(PDFObject root, ParserListener listener) throws PDFParseException {
        PDFObject structTreeRoot = root.getDictRef("StructTreeRoot");
        if (structTreeRoot != null) {
            StructureTreeHandler handler = new StructureTreeHandler(structTreeRoot);
            handler.listener = listener;
            return handler;
        }
        return null;
    }

    private StructureTreeHandler(PDFObject structTreeRoot) throws PDFParseException {
        PDFObject classMap;
        PDFObject parentTreeRef = structTreeRoot.getDictRef(KEY_PARENT_TREE);
        if (parentTreeRef == null) {
            return;
        }
        Map<Integer, PDFXref[]> parentTree = this.parseTree(parentTreeRef);
        PDFObject roleMapObj = structTreeRoot.getDictRef("RoleMap");
        if (roleMapObj != null && roleMapObj.getType() == 6) {
            this.roleMap = new HashMap<String, String>();
            Map<String, PDFObject> dict = roleMapObj.getDictionary();
            for (Map.Entry<String, PDFObject> e : dict.entrySet()) {
                this.roleMap.put(e.getKey(), e.getValue().getStringValue());
            }
        }
        if ((classMap = structTreeRoot.getDictRef(KEY_CLASS_MAP)) != null && (classMap = classMap.dereference()).getType() == 6) {
            this.classMap = new HashMap<String, Map<String, PDFObject>>();
            for (Map.Entry<String, PDFObject> e : classMap.getDictionary().entrySet()) {
                this.classMap.put(e.getKey(), e.getValue().getDictionary());
            }
        }
        HashMap<PDFXref, StructureTreeNode> refMap = new HashMap<PDFXref, StructureTreeNode>();
        this.crawlStructure(structTreeRoot, null, refMap);
        this.mcidMap = new HashMap<Integer, Map<Integer, StructureTreeNode>>();
        for (Map.Entry<Integer, PDFXref[]> e : parentTree.entrySet()) {
            HashMap<Integer, StructureTreeNode> subMap = new HashMap<Integer, StructureTreeNode>();
            for (int i = 0; i < e.getValue().length; ++i) {
                PDFXref ref = e.getValue()[i];
                if (ref == null) continue;
                StructureTreeNode treeNode = (StructureTreeNode)refMap.get(ref);
                if (treeNode != null) {
                    subMap.put(i, treeNode);
                    continue;
                }
                PDFParser.LOGGER.warn((Object)("Missing referenced object " + String.valueOf(ref)));
            }
            this.mcidMap.put(e.getKey(), subMap);
        }
    }

    private Map<Integer, PDFXref[]> parseTree(PDFObject parentTree) throws PDFParseException {
        PDFObject nums;
        parentTree = parentTree.dereference();
        HashMap<Integer, PDFXref[]> tree = new HashMap<Integer, PDFXref[]>();
        PDFObject kids = parentTree.getDictRef(KEY_MAP_KIDS);
        if (kids != null) {
            PDFObject[] kidsArray;
            for (PDFObject kid : kidsArray = kids.dereference().getArray()) {
                Map<Integer, PDFXref[]> subTree = this.parseTree(kid);
                tree.putAll(subTree);
            }
        }
        if ((nums = parentTree.getDictRef(KEY_MAP_NUMS)) != null) {
            PDFObject[] numsArray = nums.dereference().getArray();
            for (int i = 0; i < numsArray.length / 2; ++i) {
                Integer key = numsArray[i * 2].getIntValue();
                PDFObject value = numsArray[i * 2 + 1];
                if (tree.containsKey(key)) {
                    PDFParser.LOGGER.warn((Object)("Duplicate entry in ParentTree: " + key));
                }
                if (value.getType() == 5) {
                    PDFObject[] objectArray = value.getArray();
                    PDFXref[] xrefs = new PDFXref[objectArray.length];
                    for (int j = 0; j < xrefs.length; ++j) {
                        xrefs[j] = objectArray[j].getRefValue();
                    }
                    tree.put(key, xrefs);
                    continue;
                }
                tree.put(key, new PDFXref[]{value.getRefValue()});
            }
        }
        return tree;
    }

    public PDFSwitchStructureElement getSwitchCommand(StructureTreeNode node) {
        int common;
        if (node == this.recentParserNode || this.listener == null) {
            return null;
        }
        List<StructureTreeNode> endPath = this.getPath(this.recentParserNode);
        List<StructureTreeNode> startPath = this.getPath(node);
        int max = Math.min(endPath.size(), startPath.size());
        for (common = 0; common < max && endPath.get(common) == startPath.get(common); ++common) {
        }
        endPath = new ArrayList<StructureTreeNode>(endPath.subList(common, endPath.size()));
        startPath = new ArrayList<StructureTreeNode>(startPath.subList(common, startPath.size()));
        Collections.reverse(endPath);
        this.recentParserNode = node;
        return new PDFSwitchStructureElement(node, endPath, startPath);
    }

    private List<StructureTreeNode> getPath(StructureTreeNode node) {
        ArrayList<StructureTreeNode> path = new ArrayList<StructureTreeNode>();
        while (node != null) {
            path.add(path.size(), node);
            node = node.getParent();
        }
        Collections.reverse(path);
        return path;
    }

    public StructureTreeNode getNodeForMCID(int mcid, int pageIndex) {
        Integer parent = this.currentParent != null ? this.currentParent : Integer.valueOf(pageIndex);
        Map<Integer, StructureTreeNode> pageMap = this.mcidMap.get(parent);
        StructureTreeNode result = null;
        Integer mcidObj = mcid;
        if (pageMap != null) {
            result = pageMap.get(mcidObj);
        }
        if (result != null) {
            return result;
        }
        pageMap = this.mcidMap.get(UNDEFINED_PAGE);
        return pageMap != null ? pageMap.get(mcidObj) : null;
    }

    private StructureTreeNode crawlStructure(PDFObject structTreeRoot, StructureTreeNode parent, Map<PDFXref, StructureTreeNode> refMap) throws PDFParseException {
        PDFObject children;
        PDFObject node = structTreeRoot.dereference();
        StructureTreeNode newNode = new StructureTreeNode(node, this.roleMap);
        PDFXref ref = structTreeRoot.getRefValue();
        if (ref == null) {
            PDFObject type = node.getDictRef(KEY_TYPE);
            if (type == null || !KEY_OBJECT_REF.equals(type.getStringValue())) {
                PDFParser.LOGGER.warn((Object)("Reference required for " + String.valueOf(node)));
            }
        } else {
            StructureTreeNode current = refMap.get(ref);
            if (current != null) {
                return current;
            }
            refMap.put(ref, newNode);
        }
        if (parent != null) {
            parent.addChild(newNode);
        }
        if ((children = node.getDictRef(KEY_KIDS)) != null) {
            PDFObject deref = children.dereference();
            if (deref.getType() == 5) {
                PDFObject[] array;
                for (PDFObject childRef : array = deref.getArray()) {
                    PDFObject child = childRef.dereference();
                    if (child.getType() == 6) {
                        PDFObject type = child.getDictRef(KEY_TYPE);
                        if (type == null || "StructElem".equals(type.getStringValue())) {
                            this.crawlStructure(childRef, newNode, refMap);
                            continue;
                        }
                        String typeString = type.getStringValue();
                        if (KEY_MARKED_CONTENT_REF.equals(typeString) || KEY_OBJECT_REF.equals(typeString)) continue;
                        PDFParser.LOGGER.warn((Object)("Unhandled reference: " + String.valueOf(child)));
                        continue;
                    }
                    if (child.getType() == 2) continue;
                    PDFParser.LOGGER.warn((Object)("Unhandled reference: " + String.valueOf(child)));
                }
            } else if (deref.getType() == 6) {
                this.crawlStructure(children, newNode, refMap);
            } else if (deref.getType() != 2) {
                PDFParser.LOGGER.warn((Object)("Unhandled reference: " + String.valueOf(deref)));
            }
        }
        return newNode;
    }

    public void startPage(PDFObject pageObj) throws PDFParseException {
        PDFObject structParents;
        PDFObject structParent = pageObj.getDictRef(KEY_STRUCT_PARENT);
        if (structParent != null) {
            if (structParent.getType() == 2) {
                this.currentParent = structParent.getIntValue();
            } else {
                PDFParser.LOGGER.warn((Object)("Unexpected type for StructParent: " + String.valueOf(structParent.dereference())));
            }
        }
        if ((structParents = pageObj.getDictRef(KEY_STRUCT_PARENTS)) != null) {
            if (structParents.getType() == 2) {
                this.currentParent = structParents.getIntValue();
            } else {
                PDFParser.LOGGER.warn((Object)("Unexpected type for StructParents: " + String.valueOf(structParents.dereference())));
            }
        }
    }
}

