/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern.shadertype4;

import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.function.PDFFunction;
import com.inet.pdfview.pattern.shadertype4.ColorVertex;
import com.inet.pdfview.pattern.shadertype4.VertexTriangle;
import java.awt.color.ColorSpace;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SingleTriangleGradientProcessor
implements Serializable {
    private static final long serialVersionUID = -2532387465262652278L;
    private ColorVertex v1;
    private ColorVertex v2;
    private ColorVertex v3;
    private int type;
    private PDFFunction[] functions;
    private ColorSpace origColorSpace;

    public SingleTriangleGradientProcessor(@Nonnull VertexTriangle triangle, PDFFunction @Nullable [] functions, @Nonnull PDFColorSpace pdfColorSpace) {
        this.v1 = triangle.getVertexes()[0];
        this.v2 = triangle.getVertexes()[1];
        this.v3 = triangle.getVertexes()[2];
        this.type = triangle.getType();
        this.functions = functions;
        this.origColorSpace = pdfColorSpace.getColorSpace();
    }

    public void fillRaster(int x, int y, int w, int h, int[] data) {
        if ((double)y > this.v3.getY() || (double)y < this.v1.getY() - (double)h) {
            return;
        }
        int startRow = Math.max((int)(Math.round(this.v1.getY()) - (long)y), 0);
        int endRow = Math.min((int)(Math.round(this.v3.getY()) - (long)y), h);
        int origNumberComponents = this.origColorSpace.getNumComponents();
        int numVertexComponents = this.v1.getColorComp().length;
        if (this.functions != null) {
            if (numVertexComponents != 1) {
                throw new IllegalStateException("array must have the length =1");
            }
        } else if (numVertexComponents != this.origColorSpace.getNumComponents()) {
            throw new IllegalStateException("array must have the length " + this.origColorSpace.getNumComponents());
        }
        float[] colorComp = new float[origNumberComponents];
        float[] leftComp = new float[origNumberComponents];
        float[] rightComp = new float[origNumberComponents];
        for (int row = startRow; row < endRow; ++row) {
            double leftXpos = this.getLeftValue(y + row, this.v1.getX(), this.v2.getX(), this.v3.getX());
            double rightXpos = this.getRightValue(y + row, this.v1.getX(), this.v2.getX(), this.v3.getX());
            if ((double)(x + w) < leftXpos || rightXpos < (double)x) continue;
            for (int i = 0; i < numVertexComponents; ++i) {
                leftComp[i] = (float)this.getLeftValue(y + row, this.v1.getColorComp()[i], this.v2.getColorComp()[i], this.v3.getColorComp()[i]);
                rightComp[i] = (float)this.getRightValue(y + row, this.v1.getColorComp()[i], this.v2.getColorComp()[i], this.v3.getColorComp()[i]);
            }
            for (int column = 0; column < w && x + column <= (int)rightXpos; ++column) {
                if (x + column < (int)leftXpos) continue;
                int base = (row * w + column) * 4;
                if (this.functions != null) {
                    float[] paramValues = new float[]{(float)this.interpolate(leftComp[0], rightComp[0], leftXpos, rightXpos, x + column)};
                    float[][] params = new float[origNumberComponents][];
                    if (this.functions.length != 1) {
                        for (int i = 0; i < origNumberComponents; ++i) {
                            params[i] = this.functions[i].calculate(paramValues);
                            colorComp[i] = params[i][0];
                        }
                    } else {
                        colorComp = this.functions[0].calculate(paramValues);
                    }
                } else {
                    for (int i = 0; i < leftComp.length; ++i) {
                        colorComp[i] = (float)this.interpolate(leftComp[i], rightComp[i], leftXpos, rightXpos, x + column);
                    }
                }
                float[] rgb = this.origColorSpace.toRGB(colorComp);
                for (int i = 0; i < 3; ++i) {
                    data[base + i] = (int)(rgb[i] * 255.0f);
                }
                data[base + 3] = 255;
            }
        }
    }

    private double getLeftValue(int row, double valueAtP1, double valueAtP2, double valueAtP3) {
        double leftColorComp = 0.0;
        switch (this.type) {
            case 0: 
            case 3: {
                leftColorComp = this.interpolate(valueAtP1, valueAtP3, this.v1.getY(), this.v3.getY(), row);
                break;
            }
            case 1: {
                leftColorComp = this.interpolate(valueAtP1, valueAtP2, this.v1.getY(), this.v2.getY(), row);
                break;
            }
            case 2: {
                leftColorComp = (double)row < this.v2.getY() ? this.interpolate(valueAtP1, valueAtP2, this.v1.getY(), this.v2.getY(), row) : this.interpolate(valueAtP2, valueAtP3, this.v2.getY(), this.v3.getY(), row);
            }
        }
        return leftColorComp;
    }

    private double getRightValue(int row, double valueAtP1, double valueAtP2, double valueAtP3) {
        double rightValue = 0.0;
        switch (this.type) {
            case 0: {
                rightValue = this.interpolate(valueAtP2, valueAtP3, this.v2.getY(), this.v3.getY(), row);
                break;
            }
            case 1: {
                rightValue = this.interpolate(valueAtP1, valueAtP3, this.v1.getY(), this.v3.getY(), row);
                break;
            }
            case 2: {
                rightValue = this.interpolate(valueAtP1, valueAtP3, this.v1.getY(), this.v3.getY(), row);
                break;
            }
            case 3: {
                rightValue = (double)row < this.v2.getY() ? this.interpolate(valueAtP1, valueAtP2, this.v1.getY(), this.v2.getY(), row) : this.interpolate(valueAtP2, valueAtP3, this.v2.getY(), this.v3.getY(), row);
            }
        }
        return rightValue;
    }

    private double interpolate(double val1, double val2, double param1, double param2, double param) {
        return val1 + (val2 - val1) * (param - param1) / (param2 - param1);
    }
}

