/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern;

import com.inet.pdfview.pattern.TensorProductMeshGradient;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Collection;

public class TensorProductMeshGradientContext
implements PaintContext {
    private static final int INSIDE = -1;
    private static final int OUTSIDE = 0;
    private static final int PARTIAL = 1;
    private static final double STEPS_MAX_V = 256.0;
    private static final double STEPS_MAX_U = 256.0;
    private static final double STEPS_CLIP_V = 64.0;
    private static final double STEPS_CLIP_U = 64.0;
    private static final int POOL_SIZE = 128;
    private ColorModel colorModel;
    private int width;
    private int height;
    private WritableRaster raster;
    private int[] data;
    private AffineTransform tx;
    private Collection<TensorProductMeshGradient.Patch> patches;
    private BezierRasterizer diff1Curve = new BezierRasterizer();
    private InstancePool<double[]> poolDouble4Array = new InstancePool<double[]>(128){

        @Override
        public double[] createInstance() {
            return new double[4];
        }
    };
    private InstancePool<float[]> poolFloat4Array = new InstancePool<float[]>(128){

        @Override
        public float[] createInstance() {
            return new float[4];
        }
    };
    private InstancePool<float[][]> poolFloat4x4Array = new InstancePool<float[][]>(128){

        @Override
        public float[][] createInstance() {
            return new float[4][4];
        }
    };
    private InstancePool<Point2D.Double[]> poolPoint4Array = new InstancePool<Point2D.Double[]>(128){

        @Override
        public Point2D.Double[] createInstance() {
            Point2D.Double[] array = new Point2D.Double[4];
            for (int i = 0; i < 4; ++i) {
                array[i] = new Point2D.Double();
            }
            return array;
        }
    };
    private InstancePool<Point2D.Double[][]> poolPoint4x4Array = new InstancePool<Point2D.Double[][]>(128){

        @Override
        public Point2D.Double[][] createInstance() {
            Point2D.Double[][] array = new Point2D.Double[4][4];
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    array[i][j] = new Point2D.Double();
                }
            }
            return array;
        }
    };

    public TensorProductMeshGradientContext(ColorModel colorModel, Collection<TensorProductMeshGradient.Patch> patches, AffineTransform tx) {
        this.colorModel = colorModel;
        this.patches = patches;
        this.tx = tx;
    }

    @Override
    public void dispose() {
        this.poolFloat4Array.dispose();
        this.poolDouble4Array.dispose();
        this.poolPoint4Array.dispose();
        this.data = null;
        this.raster = null;
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        if (this.width != w || this.height != h) {
            this.width = w;
            this.height = h;
            this.data = new int[this.width * this.height * 4];
            this.raster = (this.colorModel == null ? ColorModel.getRGBdefault() : this.colorModel).createCompatibleWritableRaster(w, h);
        }
        Arrays.fill(this.data, 255);
        Point2D.Double[][] points = this.poolPoint4x4Array.create();
        float[][] colors = new float[4][4];
        for (TensorProductMeshGradient.Patch patch : this.patches) {
            Point2D.Double[][] opoints = patch.getPoints();
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    Point2D.Double v = new Point2D.Double();
                    this.tx.transform(opoints[j][k], v);
                    v.x -= (double)x;
                    v.y -= (double)y;
                    points[j][k] = v;
                }
            }
            Color[] ocolors = patch.getColors();
            colors[0] = ocolors[0].getRGBComponents(new float[4]);
            colors[1] = ocolors[3].getRGBComponents(new float[4]);
            colors[2] = ocolors[1].getRGBComponents(new float[4]);
            colors[3] = ocolors[2].getRGBComponents(new float[4]);
            this.drawPatch(points, colors);
        }
        this.poolPoint4x4Array.recycle(points);
        this.raster.setPixels(0, 0, w, h, this.data);
        assert (this.poolFloat4Array.counter == 0);
        assert (this.poolFloat4x4Array.counter == 0);
        assert (this.poolPoint4Array.counter == 0);
        assert (this.poolPoint4Array.counter == 0);
        assert (this.poolPoint4x4Array.counter == 0);
        return this.raster;
    }

    private void drawPatch(Point2D.Double[][] p, float[][] colors) {
        double right;
        double bottom;
        double top = bottom = p[0][0].y;
        double left = right = p[0][0].x;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                top = Math.min(top, p[i][j].y);
                bottom = Math.max(bottom, p[i][j].y);
                left = Math.min(left, p[i][j].x);
                right = Math.max(right, p[i][j].x);
            }
        }
        int intersect = TensorProductMeshGradientContext.intersectInterval(top, bottom, 0.0, this.height) & TensorProductMeshGradientContext.intersectInterval(left, right, 0.0, this.width);
        if (intersect == 0) {
            return;
        }
        double sqrMaxSteps = 0.0;
        for (int i = 0; i < 4; ++i) {
            sqrMaxSteps = Math.max(sqrMaxSteps, TensorProductMeshGradientContext.computeSquaredRasterSteps(p[i]));
        }
        double d = intersect == -1 ? 65536.0 : 4096.0;
        if (sqrMaxSteps >= d) {
            int i;
            Point2D.Double[][] split0 = this.poolPoint4x4Array.create();
            Point2D.Double[][] split1 = this.poolPoint4x4Array.create();
            float[][] splitColors = this.poolFloat4x4Array.create();
            for (i = 0; i < 4; ++i) {
                TensorProductMeshGradientContext.splitBezier(p[i], split0[i], split1[i]);
                splitColors[0][i] = colors[0][i];
                splitColors[1][i] = colors[1][i];
                splitColors[2][i] = 0.5f * (colors[0][i] + colors[2][i]);
                splitColors[3][i] = 0.5f * (colors[1][i] + colors[3][i]);
            }
            this.drawPatch(split0, splitColors);
            for (i = 0; i < 4; ++i) {
                splitColors[0][i] = splitColors[2][i];
                splitColors[1][i] = splitColors[3][i];
                splitColors[2][i] = colors[2][i];
                splitColors[3][i] = colors[3][i];
            }
            this.drawPatch(split1, splitColors);
            this.poolPoint4x4Array.recycle(split0);
            this.poolPoint4x4Array.recycle(split1);
            this.poolFloat4x4Array.recycle(splitColors);
        } else {
            int log2steps = 32 - Integer.numberOfLeadingZeros((int)Math.sqrt(sqrMaxSteps));
            int steps = 1 << log2steps;
            BezierRasterizer[] rasterizer = new BezierRasterizer[]{new BezierRasterizer(), new BezierRasterizer(), new BezierRasterizer(), new BezierRasterizer()};
            float[] colorFrom = new float[4];
            float[] colorTo = new float[4];
            float[] dColorFrom = new float[4];
            float[] dColorTo = new float[4];
            for (int i = 0; i < 4; ++i) {
                rasterizer[i].init(p[i]);
                rasterizer[i].reduce(log2steps);
                colorFrom[i] = colors[0][i];
                colorTo[i] = colors[1][i];
                dColorFrom[i] = (colors[2][i] - colors[0][i]) / (float)steps;
                dColorTo[i] = (colors[3][i] - colors[1][i]) / (float)steps;
            }
            Point2D.Double[] nodes = this.poolPoint4Array.create();
            for (int s = 0; s <= steps; ++s) {
                int i;
                for (i = 0; i < 4; ++i) {
                    nodes[i].x = rasterizer[i].getX();
                    nodes[i].y = rasterizer[i].getY();
                }
                this.drawCurve(nodes, colorFrom, colorTo);
                for (i = 0; i < 4; ++i) {
                    rasterizer[i].step();
                    int n = i;
                    colorFrom[n] = colorFrom[n] + dColorFrom[i];
                    int n2 = i;
                    colorTo[n2] = colorTo[n2] + dColorTo[i];
                }
            }
            this.poolPoint4Array.recycle(nodes);
        }
    }

    private void drawCurve(Point2D.Double[] p, float[] color0, float[] color1) {
        double right;
        double bottom;
        double top = bottom = p[0].y;
        double left = right = p[0].x;
        for (int i = 1; i < 4; ++i) {
            top = Math.min(top, p[i].y);
            bottom = Math.max(bottom, p[i].y);
            left = Math.min(left, p[i].x);
            right = Math.max(right, p[i].x);
        }
        int intersect = TensorProductMeshGradientContext.intersectInterval(left, right, 0.0, this.width) & TensorProductMeshGradientContext.intersectInterval(top, bottom, 0.0, this.height);
        if (intersect == 0) {
            return;
        }
        double sqrMaxSteps = TensorProductMeshGradientContext.computeSquaredRasterSteps(p);
        double d = intersect == -1 ? 65536.0 : 4096.0;
        if (sqrMaxSteps >= d) {
            Point2D.Double[] split0 = this.poolPoint4Array.create();
            Point2D.Double[] splot1 = this.poolPoint4Array.create();
            float[] splitColors = this.poolFloat4Array.create();
            TensorProductMeshGradientContext.splitBezier(p, split0, splot1);
            splitColors[0] = (color0[0] + color1[0]) * 0.5f;
            splitColors[1] = (color0[1] + color1[1]) * 0.5f;
            splitColors[2] = (color0[2] + color1[2]) * 0.5f;
            splitColors[3] = (color0[3] + color1[3]) * 0.5f;
            this.drawCurve(split0, color0, splitColors);
            this.drawCurve(splot1, splitColors, color1);
            this.poolPoint4Array.recycle(split0);
            this.poolPoint4Array.recycle(splot1);
            this.poolFloat4Array.recycle(splitColors);
        } else {
            int log2steps = 32 - Integer.numberOfLeadingZeros((int)Math.sqrt(sqrMaxSteps));
            int steps = 1 << log2steps;
            this.diff1Curve.init(p);
            this.diff1Curve.reduce(log2steps);
            float dr = (color1[0] - color0[0]) / (float)steps;
            float dg = (color1[1] - color0[1]) / (float)steps;
            float db = (color1[2] - color0[2]) / (float)steps;
            float da = (color1[3] - color0[3]) / (float)steps;
            float r = color0[0];
            float g = color0[1];
            float b = color0[2];
            float a = color0[3];
            for (int s = 0; s <= steps; ++s) {
                this.drawPixel((int)this.diff1Curve.getX(), (int)this.diff1Curve.getY(), r, g, b, a);
                this.diff1Curve.step();
                r += dr;
                g += dg;
                b += db;
                a += da;
            }
            this.drawPixel((int)p[3].x, (int)p[3].y, color1[0], color1[1], color1[2], color1[3]);
        }
    }

    private void drawPixel(int x, int y, float r, float g, float b, float a) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return;
        }
        int base = (y * this.width + x) * 4;
        this.data[base + 0] = (int)(r * 255.0f);
        this.data[base + 1] = (int)(g * 255.0f);
        this.data[base + 2] = (int)(b * 255.0f);
        this.data[base + 3] = (int)(a * 255.0f);
    }

    private static int intersectInterval(double s0, double t0, double s1, double t1) {
        if (s1 <= s0 && t0 <= t1) {
            return -1;
        }
        if (s0 >= t1 || t0 <= s1) {
            return 0;
        }
        return 1;
    }

    private static void splitBezier(Point2D.Double[] curve, Point2D.Double[] result1, Point2D.Double[] result2) {
        double f3;
        double a0 = curve[0].x;
        double a1 = curve[1].x;
        double a2 = curve[2].x;
        double a3 = curve[3].x;
        double f0 = a0;
        double s3 = a3;
        double tmp = 0.5 * (a1 + a2);
        double f1 = 0.5 * (a0 + a1);
        double s2 = 0.5 * (a2 + a3);
        double f2 = 0.5 * (f1 + tmp);
        double s1 = 0.5 * (tmp + s2);
        double s0 = f3 = 0.5 * (f2 + s1);
        result1[0].x = f0;
        result1[1].x = f1;
        result1[2].x = f2;
        result1[3].x = f3;
        result2[0].x = s0;
        result2[1].x = s1;
        result2[2].x = s2;
        result2[3].x = s3;
        a0 = curve[0].y;
        a1 = curve[1].y;
        a2 = curve[2].y;
        a3 = curve[3].y;
        f0 = a0;
        s3 = a3;
        tmp = 0.5 * (a1 + a2);
        f1 = 0.5 * (a0 + a1);
        s2 = 0.5 * (a2 + a3);
        f2 = 0.5 * (f1 + tmp);
        s1 = 0.5 * (tmp + s2);
        s0 = f3 = 0.5 * (f2 + s1);
        result1[0].y = f0;
        result1[1].y = f1;
        result1[2].y = f2;
        result1[3].y = f3;
        result2[0].y = s0;
        result2[1].y = s1;
        result2[2].y = s2;
        result2[3].y = s3;
    }

    private static double computeSquaredRasterSteps(Point2D.Double[] p) {
        double tmp = p[0].distanceSq(p[1]);
        tmp = Math.max(tmp, p[2].distanceSq(p[3]));
        tmp = Math.max(tmp, p[0].distanceSq(p[2]) / 4.0);
        tmp = Math.max(tmp, p[1].distanceSq(p[3]) / 4.0);
        return 18.0 * tmp;
    }

    private static class BezierRasterizer {
        private double x0;
        private double y0;
        private double x1;
        private double y1;
        private double x2;
        private double y2;
        private double x3;
        private double y3;

        private BezierRasterizer() {
        }

        public void init(Point2D.Double[] ctrlPoints) {
            this.x0 = ctrlPoints[0].x;
            this.x1 = ctrlPoints[3].x - ctrlPoints[0].x;
            this.x2 = 6.0 * (ctrlPoints[3].x - 2.0 * ctrlPoints[2].x + ctrlPoints[1].x);
            this.x3 = 6.0 * (ctrlPoints[3].x - 3.0 * ctrlPoints[2].x + 3.0 * ctrlPoints[1].x - ctrlPoints[0].x);
            this.y0 = ctrlPoints[0].y;
            this.y1 = ctrlPoints[3].y - ctrlPoints[0].y;
            this.y2 = 6.0 * (ctrlPoints[3].y - 2.0 * ctrlPoints[2].y + ctrlPoints[1].y);
            this.y3 = 6.0 * (ctrlPoints[3].y - 3.0 * ctrlPoints[2].y + 3.0 * ctrlPoints[1].y - ctrlPoints[0].y);
        }

        public void step() {
            this.x0 += this.x1;
            this.x1 += this.x2;
            this.x2 += this.x3;
            this.y0 += this.y1;
            this.y1 += this.y2;
            this.y2 += this.y3;
        }

        public double getX() {
            return this.x0;
        }

        public double getY() {
            return this.y0;
        }

        public void reduce(int shift) {
            for (int i = 0; i < shift; ++i) {
                this.x3 *= 0.125;
                this.x2 = this.x2 * 0.25 - this.x3;
                this.x1 = (this.x1 - this.x2) * 0.5;
                this.y3 *= 0.125;
                this.y2 = this.y2 * 0.25 - this.y3;
                this.y1 = (this.y1 - this.y2) * 0.5;
            }
        }
    }

    private static abstract class InstancePool<T> {
        private Object[] array;
        private int n;
        private int counter;

        public InstancePool(int capacity) {
            this.array = new Object[capacity];
        }

        protected abstract T createInstance();

        public T create() {
            ++this.counter;
            if (this.n == 0) {
                return this.createInstance();
            }
            Object t = this.array[--this.n];
            this.array[this.n] = null;
            return (T)t;
        }

        public void recycle(T t) {
            --this.counter;
            if (this.n < this.array.length) {
                this.array[this.n++] = t;
            }
        }

        public void dispose() {
            for (int i = 0; i < this.n; ++i) {
                this.array[i] = null;
            }
            this.n = 0;
            this.counter = 0;
        }
    }
}

