/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern;

import com.inet.pdfview.pattern.TensorProductMeshGradientContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class TensorProductMeshGradient
implements Paint,
Serializable {
    private static final long serialVersionUID = 4962768687168980858L;
    private Collection<Patch> patches = new ArrayList<Patch>();

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return new TensorProductMeshGradientContext(cm, this.patches, xform);
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    public void addPatch(Patch patch) {
        this.patches.add(patch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TensorProductMeshGradient other = (TensorProductMeshGradient)obj;
        return !(this.patches == null ? other.patches != null : !this.patches.equals(other.patches));
    }

    public static class Patch
    implements Serializable {
        private static final long serialVersionUID = 4933986002883188109L;
        private Point2D.Double[][] points = new Point2D.Double[4][4];
        private Color[] colors = new Color[4];

        public Patch(Point2D.Double[][] points, Color[] colors) {
            this.points = points;
            this.colors = colors;
            if (points[1][1] == null) {
                points[1][1] = this.computeCoonInternalPoint(points[0][0], points[0][1], points[1][0], points[0][3], points[3][0], points[3][1], points[1][3], points[3][3]);
            }
            if (points[1][2] == null) {
                points[1][2] = this.computeCoonInternalPoint(points[0][3], points[0][2], points[1][3], points[0][0], points[3][3], points[3][2], points[1][0], points[3][0]);
            }
            if (points[2][1] == null) {
                points[2][1] = this.computeCoonInternalPoint(points[3][0], points[3][1], points[2][0], points[3][3], points[0][0], points[0][1], points[2][3], points[0][3]);
            }
            if (points[2][2] == null) {
                points[2][2] = this.computeCoonInternalPoint(points[3][3], points[3][2], points[2][3], points[3][0], points[0][3], points[0][2], points[2][0], points[0][0]);
            }
        }

        private Point2D.Double computeCoonInternalPoint(Point2D.Double p00, Point2D.Double p01, Point2D.Double p10, Point2D.Double p03, Point2D.Double p30, Point2D.Double p31, Point2D.Double p13, Point2D.Double p33) {
            double x = (-4.0 * p00.x + 6.0 * (p01.x + p10.x) - 2.0 * (p03.x + p30.x) + 3.0 * (p31.x + p13.x) - 1.0 * p33.x) / 9.0;
            double y = (-4.0 * p00.y + 6.0 * (p01.y + p10.y) - 2.0 * (p03.y + p30.y) + 3.0 * (p31.y + p13.y) - 1.0 * p33.y) / 9.0;
            return new Point2D.Double(x, y);
        }

        public Color[] getColors() {
            return this.colors;
        }

        public Point2D.Double[][] getPoints() {
            return this.points;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Patch other = (Patch)obj;
            if (!Arrays.equals(this.colors, other.colors)) {
                return false;
            }
            if (this.points.length != other.points.length) {
                return false;
            }
            for (int x = 0; x < this.points.length; ++x) {
                Point2D.Double[] line = this.points[x];
                Point2D.Double[] lineOther = other.points[x];
                if (line.length != lineOther.length) {
                    return false;
                }
                for (int y = 0; y < line.length; ++y) {
                    Point2D.Double p1 = line[y];
                    Point2D.Double p2 = lineOther[y];
                    if (Double.compare(((Point2D)p1).getX(), ((Point2D)p2).getX()) == 0 && Double.compare(((Point2D)p1).getY(), ((Point2D)p2).getY()) == 0) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

