/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern;

import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.function.PDFFunction;
import com.inet.pdfview.pattern.BitReader;
import com.inet.pdfview.pattern.PDFShader;
import com.inet.pdfview.pattern.ShaderPaint;
import com.inet.pdfview.pattern.shadertype4.MultipleTriangleGradientContext;
import com.inet.pdfview.pattern.shadertype4.VertexController;
import com.inet.pdfview.pattern.shadertype4.VertexTriangle;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;

public class ShaderType4
extends PDFShader {
    private static final long serialVersionUID = -4741294592850451040L;
    public static final int ALPHA_VALUE = 255;
    private PDFFunction[] functions;
    private VertexController vertextController = new VertexController();

    protected ShaderType4() {
        super(4);
    }

    @Override
    public void parse(PDFObject shaderObj, PDFDecrypter decrypter, AffineTransform transform, Paint smask, boolean isAlphaChannel) throws PDFParseException {
        double maxY;
        double minY;
        double maxX;
        double minX;
        PDFObject bitsPerFlagObj = shaderObj.getDictRef("BitsPerFlag");
        int bitsPerFlag = bitsPerFlagObj.getIntValue();
        PDFObject bitsPerCoordinateObj = shaderObj.getDictRef("BitsPerCoordinate");
        int bitsPerCoordinate = bitsPerCoordinateObj.getIntValue();
        if (bitsPerCoordinate < 2) {
            throw new IllegalArgumentException("too little size of coordinate values");
        }
        PDFObject bitsPerComponentObj = shaderObj.getDictRef("BitsPerComponent");
        int bitsPerComponent = bitsPerComponentObj.getIntValue();
        PDFObject functionObj = shaderObj.getDictRef("Function");
        if (functionObj != null) {
            PDFXref ref = functionObj.getRefValue();
            PDFObject[] functionArray = functionObj.getArray();
            this.functions = new PDFFunction[functionArray.length];
            for (int i = 0; i < this.functions.length; ++i) {
                this.functions[i] = PDFFunction.getFunction(functionArray[i], decrypter, ref);
            }
        }
        int numberOfComponents = this.functions != null ? 1 : this.getColorSpace().getNumComponents();
        PDFColorSpace resultColorSpace = this.getColorSpace();
        if (resultColorSpace != null) {
            resultColorSpace.getNumComponents();
        }
        float[] colorRangeValues = new float[2 * numberOfComponents];
        PDFObject decodeObj = shaderObj.getDictRef("Decode");
        if (decodeObj != null) {
            PDFObject[] decodeArrObj = decodeObj.getArray();
            if (decodeArrObj.length != 4 + 2 * numberOfComponents) {
                throw new IllegalStateException("invalid size of decode array: " + decodeArrObj.length);
            }
            minX = decodeArrObj[0].getDoubleValue();
            maxX = decodeArrObj[1].getDoubleValue();
            minY = decodeArrObj[2].getDoubleValue();
            maxY = decodeArrObj[3].getDoubleValue();
            for (int i = 0; i < numberOfComponents * 2; ++i) {
                colorRangeValues[i] = decodeArrObj[4 + i].getFloatValue();
            }
        } else {
            throw new IllegalStateException("decode array is not defined");
        }
        double decodeFactorX = (maxX - minX) / (double)((1L << bitsPerCoordinate) - 1L);
        double decodeFactorY = (maxY - minY) / (double)((1L << bitsPerCoordinate) - 1L);
        double[] decodeComponentFactor = new double[numberOfComponents];
        for (int i = 0; i < numberOfComponents; ++i) {
            decodeComponentFactor[i] = (colorRangeValues[2 * i + 1] - colorRangeValues[2 * i]) / (float)((1L << bitsPerComponent) - 1L);
        }
        int vertexDataLength = bitsPerFlag + bitsPerCoordinate * 2 + bitsPerComponent * numberOfComponents;
        int paddingBytesLength = vertexDataLength % 8;
        byte[] buf = shaderObj.getStream(shaderObj.getRefValue(), decrypter, true);
        FastByteArrayInputStream is = new FastByteArrayInputStream(buf);
        BitReader br = new BitReader((InputStream)is);
        try {
            while (true) {
                long y;
                long x;
                int flag = br.read(bitsPerFlag);
                if (bitsPerCoordinate % 8 == 0) {
                    x = br.readUnsignedInt(bitsPerCoordinate / 8);
                    y = br.readUnsignedInt(bitsPerCoordinate / 8);
                } else {
                    x = br.read(bitsPerCoordinate);
                    y = br.read(bitsPerCoordinate);
                }
                double vertexX = minX + (double)x * decodeFactorX;
                double vertexY = minY + (double)y * decodeFactorY;
                float[] colorComp = new float[numberOfComponents];
                for (int i = 0; i < numberOfComponents; ++i) {
                    int c = br.read(bitsPerComponent);
                    colorComp[i] = (float)((double)colorRangeValues[2 * i] + (double)c * decodeComponentFactor[i]);
                }
                this.vertextController.addVertex(flag, vertexX, vertexY, colorComp);
                if (paddingBytesLength == 0) continue;
                br.read(paddingBytesLength);
            }
        }
        catch (EOFException e) {
        }
        catch (IOException ex) {
            throw PDFParseException.create(ex);
        }
    }

    @Override
    public PDFPaint getPaint() {
        return PDFPaint.getPaint(new MultipleTriangleGradientPaint());
    }

    class MultipleTriangleGradientPaint
    implements Paint,
    Serializable,
    ShaderPaint {
        private static final long serialVersionUID = -3975779905611020465L;

        MultipleTriangleGradientPaint() {
        }

        @Override
        public int getTransparency() {
            return 3;
        }

        @Override
        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            List<VertexTriangle> transformedTriangles = ShaderType4.this.vertextController.transformVertexCoordinates(xform);
            return new MultipleTriangleGradientContext(transformedTriangles, ShaderType4.this.functions, ShaderType4.this.getColorSpace());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MultipleTriangleGradientPaint)) {
                return false;
            }
            MultipleTriangleGradientPaint other = (MultipleTriangleGradientPaint)obj;
            return ShaderType4.this.vertextController.equals(other.getOuterClass().vertextController);
        }

        private ShaderType4 getOuterClass() {
            return ShaderType4.this;
        }
    }
}

