/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.pattern.ShaderType2;
import com.inet.pdfview.pattern.ShaderType3;
import com.inet.pdfview.pattern.ShaderType4;
import com.inet.pdfview.pattern.ShaderType6;
import com.inet.pdfview.pattern.ShaderType7;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Map;

public abstract class PDFShader
implements Serializable {
    private static final long serialVersionUID = 462473351319751120L;
    public static final int FUNCTION_SHADING = 1;
    public static final int AXIAL_SHADING = 2;
    public static final int RADIAL_SHADING = 3;
    public static final int FREE_FORM_SHADING = 4;
    public static final int LATTICE_SHADING = 5;
    public static final int COONS_PATCH_MESH_SHADING = 6;
    public static final int TENSOR_PRODUCTS_MESH_SHADING = 7;
    private transient int type;
    private PDFColorSpace colorSpace;
    static final float MINIMUMFLOAT = 1.0E-4f;
    static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private transient PDFPaint background;
    private transient Rectangle2D bbox;

    protected PDFShader(int type) {
        this.type = type;
    }

    public static PDFShader getShader(PDFObject shaderObj, Map<String, PDFObject> resources, PDFDecrypter decryptor, AffineTransform pattern, Paint smask, boolean isAlphaChannel) throws PDFParseException {
        PDFObject bboxObj;
        PDFObject typeObj;
        PDFShader shader = null;
        if (shaderObj.getCache() != null) {
            if (shaderObj.getCache() instanceof PDFShader) {
                shader = (PDFShader)shaderObj.getCache();
                if (shader != null) {
                    return shader;
                }
            } else {
                throw new PDFParseException("Unsupported shader class: " + String.valueOf(shaderObj.getCache().getClass()));
            }
        }
        if ((typeObj = shaderObj.getDictRef("ShadingType")) == null) {
            throw new PDFParseException("No shader type defined!");
        }
        int type = typeObj.getIntValue();
        switch (type) {
            case 2: {
                shader = new ShaderType2();
                break;
            }
            case 3: {
                shader = new ShaderType3();
                break;
            }
            case 6: {
                shader = new ShaderType6();
                break;
            }
            case 7: {
                shader = new ShaderType7();
                break;
            }
            case 4: {
                shader = new ShaderType4();
                break;
            }
            default: {
                throw new PDFParseException("Unsupported shader type: " + type);
            }
        }
        PDFObject csObj = shaderObj.getDictRef("ColorSpace");
        if (csObj == null) {
            throw new PDFParseException("No colorspace defined!");
        }
        PDFColorSpace cs = PDFColorSpace.getColorSpace(csObj, resources, decryptor);
        shader.setColorSpace(cs);
        PDFObject bgObj = shaderObj.getDictRef("Background");
        if (bgObj != null) {
            PDFObject[] bgObjs = bgObj.getArray();
            float[] bgArray = new float[bgObjs.length];
            for (int i = 0; i < bgArray.length; ++i) {
                bgArray[i] = bgObjs[i].getFloatValue();
            }
            PDFPaint paint = cs.getPaint(bgArray);
            shader.setBackground(paint);
        }
        if ((bboxObj = shaderObj.getDictRef("BBox")) != null) {
            PDFObject[] rectObj = bboxObj.getArray();
            float minX = rectObj[0].getFloatValue();
            float minY = rectObj[1].getFloatValue();
            float maxX = rectObj[2].getFloatValue();
            float maxY = rectObj[3].getFloatValue();
            Rectangle2D.Float bbox = new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY);
            shader.setBBox(bbox);
        }
        shader.parse(shaderObj, decryptor, pattern, smask, isAlphaChannel);
        shaderObj.setCache(shader);
        return shader;
    }

    public int getType() {
        return this.type;
    }

    public PDFColorSpace getColorSpace() {
        return this.colorSpace;
    }

    protected void setColorSpace(PDFColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    public PDFPaint getBackground() {
        return this.background;
    }

    protected void setBackground(PDFPaint background) {
        this.background = background;
    }

    public Rectangle2D getBBox() {
        return this.bbox;
    }

    protected void setBBox(Rectangle2D bbox) {
        this.bbox = bbox;
    }

    public abstract void parse(PDFObject var1, PDFDecrypter var2, AffineTransform var3, Paint var4, boolean var5) throws PDFParseException;

    public abstract PDFPaint getPaint();

    public PDFPaint getPatternPaint() {
        return this.getPaint();
    }

    protected Color[] mergeAlphaChannel(Color[] colors, Color[] alphaChannel) {
        if (colors.length == alphaChannel.length) {
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = new Color(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue(), alphaChannel[i].getRed());
            }
        } else {
            PDFParser.LOGGER.warn((Object)("The case of SMask for Shading" + this.type + " is not supported."));
        }
        return colors;
    }

    static float[] normalize(float[] fractions) {
        for (int i = 1; i < fractions.length; ++i) {
            if (!(fractions[i] <= fractions[i - 1])) continue;
            fractions[i] = fractions[i - 1] + 1.0E-4f;
        }
        float min = fractions[0];
        float max = fractions[fractions.length - 1];
        if (min >= 0.0f && max <= 1.0f) {
            return fractions;
        }
        float tMin = min < 0.0f ? 0.0f : min;
        float tMax = max > 1.0f ? 1.0f : max;
        float scale = (tMax - tMin) / (max - min);
        for (int i = 0; i < fractions.length; ++i) {
            fractions[i] = (fractions[i] - min) * scale + tMin;
        }
        return fractions;
    }
}

