/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.optionalcontent;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.error.PDFParseException;
import java.util.ArrayList;
import java.util.List;

public class OCG {
    private String name;
    private String intent;

    private OCG(PDFObject ocg) throws PDFParseException {
        this.name = ocg.getDictRef("Name") != null ? ocg.getDictRef("Name").getStringValue() : "OCR #" + (ocg.getRefValue() != null ? Integer.toString(ocg.getRefValue().getID()) : Long.toString(System.identityHashCode(ocg)));
        this.intent = ocg.getDictRef("Intent") != null ? ocg.getDictRef("Intent").getStringValue() : null;
    }

    public static List<OCG> getOCG(PDFObject ocg) throws PDFParseException {
        if (ocg.getType() == 0) {
            ocg = ocg.dereference();
        }
        if (ocg.getType() != 6) {
            return null;
        }
        PDFObject typeRef = ocg.getDictRef("Type");
        if (typeRef == null) {
            return null;
        }
        String type = typeRef.getStringValue();
        if ("OCMD".equals(type)) {
            PDFObject[] ocgArray;
            PDFObject ocgs = ocg.getDictRef("OCGs");
            if (ocgs == null) {
                return null;
            }
            if (ocgs.getType() == 6) {
                return OCG.getOCG(ocgs);
            }
            if (ocgs.getType() == 5 && (ocgArray = ocgs.getArray()) != null && ocgArray.length > 0) {
                ArrayList<OCG> ocgList = new ArrayList<OCG>();
                for (PDFObject o : ocgArray) {
                    List<OCG> subList = OCG.getOCG(o);
                    if (subList == null) continue;
                    ocgList.addAll(subList);
                }
                return ocgList.size() > 0 ? ocgList : null;
            }
            return null;
        }
        if (!"OCG".equals(type)) {
            return null;
        }
        ArrayList<OCG> ocgList = new ArrayList<OCG>();
        ocgList.add(new OCG(ocg));
        return ocgList;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        if (this.name != null || this.intent != null) {
            return (this.name != null ? this.name.hashCode() : 0) + (this.intent != null ? this.intent.hashCode() : 0);
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OCG)) {
            return false;
        }
        OCG ocg = (OCG)obj;
        return (this.name == null ? ocg.name == null : this.name.equals(ocg.name)) && (this.intent == null ? ocg.intent == null : this.intent.equals(ocg.intent));
    }

    public String toString() {
        return "OCG '" + this.name + "' for intent '" + this.intent + "'";
    }
}

