/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.function.cmds;

import com.inet.pdfview.function.PSCmdParser;
import com.inet.pdfview.function.cmds.AbsCmd;
import com.inet.pdfview.function.cmds.AddCmd;
import com.inet.pdfview.function.cmds.CopyCmd;
import com.inet.pdfview.function.cmds.CvrCmd;
import com.inet.pdfview.function.cmds.DivCmd;
import com.inet.pdfview.function.cmds.DupCmd;
import com.inet.pdfview.function.cmds.ExchCmd;
import com.inet.pdfview.function.cmds.GeCmd;
import com.inet.pdfview.function.cmds.GtCmd;
import com.inet.pdfview.function.cmds.IdtyCmd;
import com.inet.pdfview.function.cmds.IfCmd;
import com.inet.pdfview.function.cmds.IfElseCmd;
import com.inet.pdfview.function.cmds.IndexCmd;
import com.inet.pdfview.function.cmds.LeCmd;
import com.inet.pdfview.function.cmds.LtCmd;
import com.inet.pdfview.function.cmds.MulCmd;
import com.inet.pdfview.function.cmds.PSOperators;
import com.inet.pdfview.function.cmds.PopCmd;
import com.inet.pdfview.function.cmds.RollCmd;
import com.inet.pdfview.function.cmds.SubCmd;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class PSCmd
implements Serializable {
    private static final long serialVersionUID = -6273546536978107153L;
    private List<Double> cmdArguments;

    PSCmd(List<Double> argList) {
        this.cmdArguments = argList;
    }

    public abstract List<Double> exec(List<Double> var1);

    public static PSCmd getCmd(String name, int type, List<Double> argList, PSCmdParser cmdParser) {
        PSOperators operator = PSOperators.valueOf(name.toUpperCase());
        PSCmd cmd = null;
        switch (operator) {
            case DUP: {
                cmd = new DupCmd(argList);
                break;
            }
            case EXCH: {
                cmd = new ExchCmd(argList);
                break;
            }
            case ROLL: {
                cmd = new RollCmd(argList);
                break;
            }
            case INDEX: {
                cmd = new IndexCmd(argList);
                break;
            }
            case CVR: {
                cmd = new CvrCmd(argList);
                break;
            }
            case SUB: {
                cmd = new SubCmd(argList);
                break;
            }
            case POP: {
                cmd = new PopCmd(argList);
                break;
            }
            case IDTY: {
                cmd = new IdtyCmd(argList);
                break;
            }
            case MUL: {
                cmd = new MulCmd(argList);
                break;
            }
            case ADD: {
                cmd = new AddCmd(argList);
                break;
            }
            case GT: {
                cmd = new GtCmd(argList);
                break;
            }
            case GE: {
                cmd = new GeCmd(argList);
                break;
            }
            case LT: {
                cmd = new LtCmd(argList);
                break;
            }
            case LE: {
                cmd = new LeCmd(argList);
                break;
            }
            case IF: {
                cmd = new IfCmd(argList, cmdParser);
                break;
            }
            case IFELSE: {
                cmd = new IfElseCmd(argList, cmdParser);
                break;
            }
            case ABS: {
                cmd = new AbsCmd(argList);
                break;
            }
            case COPY: {
                cmd = new CopyCmd(argList);
                break;
            }
            case DIV: {
                cmd = new DivCmd(argList);
                break;
            }
            default: {
                throw new UnsupportedOperationException("ps command: " + name);
            }
        }
        return cmd;
    }

    List<Double> prepareArgumentList(List<Double> list) {
        if (this.cmdArguments != null) {
            if (list == null) {
                list = new ArrayList<Double>();
            }
            list.addAll(this.cmdArguments);
        }
        return list;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSCmd other = (PSCmd)obj;
        return (this.cmdArguments != null || other.cmdArguments == null) && this.cmdArguments.equals(other.cmdArguments);
    }

    public List<Double> getCmdArguments() {
        return this.cmdArguments;
    }
}

