/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf.table;

import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.font.ttf.TrueTypeFont;
import com.inet.pdfview.font.ttf.table.CFFTable;
import com.inet.pdfview.font.ttf.table.CmapTable;
import com.inet.pdfview.font.ttf.table.GlyfTable;
import com.inet.pdfview.font.ttf.table.HeadTable;
import com.inet.pdfview.font.ttf.table.HheaTable;
import com.inet.pdfview.font.ttf.table.HmtxTable;
import com.inet.pdfview.font.ttf.table.LocaTable;
import com.inet.pdfview.font.ttf.table.MaxpTable;
import com.inet.pdfview.font.ttf.table.NameTable;
import com.inet.pdfview.font.ttf.table.OS2Table;
import com.inet.pdfview.font.ttf.table.PostTable;
import java.nio.ByteBuffer;

public abstract class TrueTypeTable {
    public static final int CMAP_TABLE = 1668112752;
    public static final int GLYF_TABLE = 1735162214;
    public static final int HEAD_TABLE = 1751474532;
    public static final int HHEA_TABLE = 1751672161;
    public static final int HMTX_TABLE = 1752003704;
    public static final int LOCA_TABLE = 1819239265;
    public static final int MAXP_TABLE = 1835104368;
    public static final int NAME_TABLE = 1851878757;
    public static final int POST_TABLE = 1886352244;
    public static final int OS2_TABLE = 1330851634;
    public static final int CFF_TABLE = 1128678944;
    private int tag;

    protected TrueTypeTable(int tag) {
        this.tag = tag;
    }

    public static TrueTypeTable createTable(TrueTypeFont ttf, int type) {
        return TrueTypeTable.createTable(ttf, type, null);
    }

    public static TrueTypeTable createTable(TrueTypeFont ttf, int type, IDataBuffer data) {
        TrueTypeTable outTable = null;
        switch (type) {
            case 1668112752: {
                outTable = new CmapTable();
                break;
            }
            case 1735162214: {
                outTable = new GlyfTable(ttf.getLOCATable(), ttf.getMAXPTable());
                break;
            }
            case 1751474532: {
                outTable = new HeadTable();
                break;
            }
            case 1751672161: {
                outTable = new HheaTable();
                break;
            }
            case 1752003704: {
                outTable = new HmtxTable(ttf.getMAXPTable(), ttf.getHHEATable());
                break;
            }
            case 1819239265: {
                outTable = new LocaTable(ttf.getMAXPTable(), ttf.getHEADTable());
                break;
            }
            case 1835104368: {
                outTable = new MaxpTable();
                break;
            }
            case 1851878757: {
                outTable = new NameTable();
                break;
            }
            case 1886352244: {
                outTable = new PostTable();
                break;
            }
            case 1330851634: {
                outTable = new OS2Table();
                break;
            }
            case 1128678944: {
                outTable = new CFFTable(ttf.getOwner());
                break;
            }
            default: {
                throw new IllegalArgumentException("TTF Table key " + type + " is undefined");
            }
        }
        if (data != null) {
            ((TrueTypeTable)outTable).setData(data);
        }
        return outTable;
    }

    public int getTag() {
        return this.tag;
    }

    public abstract ByteBuffer toByteBuffer();

    public abstract void setData(IDataBuffer var1);

    public int getLength() {
        return this.toByteBuffer().remaining();
    }

    public static String tagToString(int tag) {
        char[] c = new char[]{(char)(0xFF & tag >> 24), (char)(0xFF & tag >> 16), (char)(0xFF & tag >> 8), (char)(0xFF & tag)};
        return new String(c);
    }

    public static int stringToTag(String tag) {
        char[] c = tag.toCharArray();
        if (c.length != 4) {
            throw new IllegalArgumentException("Bad tag length: " + tag);
        }
        return c[0] << 24 | c[1] << 16 | c[2] << 8 | c[3];
    }

    public String toString() {
        String out = "    " + TrueTypeTable.tagToString(this.getTag()) + " Table.  Data is: ";
        out = this.toByteBuffer() == null ? out + "not set" : out + "set";
        return out;
    }
}

