/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf.table;

import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.font.ttf.table.TrueTypeTable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class OS2Table
extends TrueTypeTable {
    private short xAvgCharWidth = (short)2048;
    private int usWeightClass = 400;
    private int usWidthClass = 5;
    private short fsType = (short)8;
    private short ySubscriptXSize = (short)409;
    private short ySubscriptYSize = (short)409;
    private short ySubscriptXOffset = 0;
    private short ySubscriptYOffset = (short)100;
    private short ySuperscriptXSize = (short)409;
    private short ySuperscriptYSize = (short)409;
    private short ySuperscriptXOffset = 0;
    private short ySuperscriptYOffset = (short)100;
    private short yStrikeoutSize = (short)204;
    private short yStrikeoutPosition = (short)920;
    private short sFamilyClass = 0;
    private int[] ulUnicodeRange = new int[4];
    private short fsSelection = (short)64;
    private int usFirstCharIndex = 32;
    private int usLastCharIndex = 127;
    private int sTypoAscender = 3276;
    private int sTypoDescender = -819;
    private int sTypoLineGap = 819;
    private int usWinAscent;
    private int usWinDescent;
    private int ulCodePageRange1;
    private int ulCodePageRange2;
    private byte[] panose = new byte[10];
    private byte[] achVendID = new byte[4];

    public OS2Table() {
        super(1330851634);
    }

    public void setUsWinAscent(int usWinAscent) {
        this.usWinAscent = usWinAscent;
    }

    public int getUsWinAscent() {
        return this.usWinAscent;
    }

    public void setUsWinDescent(int usWinDescent) {
        this.usWinDescent = usWinDescent;
    }

    public void setxAvgCharWidth(short xAvgCharWidth) {
        this.xAvgCharWidth = xAvgCharWidth;
    }

    public void setsTypoAscender(int sTypoAscender) {
        this.sTypoAscender = sTypoAscender;
    }

    public int getsTypoAscender() {
        return this.sTypoAscender;
    }

    public void setsTypoDescender(int sTypoDescender) {
        this.sTypoDescender = sTypoDescender;
    }

    public void setsTypoLineGap(int sTypoLineGap) {
        this.sTypoLineGap = sTypoLineGap;
    }

    public void setUsFirstCharIndex(int usFirstCharIndex) {
        this.usFirstCharIndex = usFirstCharIndex;
    }

    public void setUsLastCharIndex(int usLastCharIndex) {
        this.usLastCharIndex = usLastCharIndex;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(this.getLength());
        buf.putShort((short)1);
        buf.putShort(this.xAvgCharWidth);
        buf.putShort((short)this.usWeightClass);
        buf.putShort((short)this.usWidthClass);
        buf.putShort(this.fsType);
        buf.putShort(this.ySubscriptXSize);
        buf.putShort(this.ySubscriptYSize);
        buf.putShort(this.ySubscriptXOffset);
        buf.putShort(this.ySubscriptYOffset);
        buf.putShort(this.ySuperscriptXSize);
        buf.putShort(this.ySuperscriptYSize);
        buf.putShort(this.ySuperscriptXOffset);
        buf.putShort(this.ySuperscriptYOffset);
        buf.putShort(this.yStrikeoutSize);
        buf.putShort(this.yStrikeoutPosition);
        buf.putShort(this.sFamilyClass);
        buf.put(this.panose);
        for (int i = 0; i < 4; ++i) {
            buf.putInt(this.ulUnicodeRange[i]);
        }
        buf.put(this.achVendID);
        buf.putShort(this.fsSelection);
        buf.putShort((short)this.usFirstCharIndex);
        buf.putShort((short)this.usLastCharIndex);
        buf.putShort((short)this.sTypoAscender);
        buf.putShort((short)this.sTypoDescender);
        buf.putShort((short)this.sTypoLineGap);
        buf.putShort((short)this.usWinAscent);
        buf.putShort((short)this.usWinDescent);
        buf.putInt(this.ulCodePageRange1);
        buf.putInt(this.ulCodePageRange2);
        buf.flip();
        return buf;
    }

    @Override
    public void setData(IDataBuffer data) {
        int len = data.remaining();
        if (len < 68 || len > 86) {
            throw new IllegalArgumentException("Bad Head table size");
        }
        data.getShort();
        this.xAvgCharWidth = data.getShort();
        this.usWeightClass = data.getShort();
        this.usWidthClass = data.getShort();
        this.fsType = data.getShort();
        this.ySubscriptXSize = data.getShort();
        this.ySubscriptYSize = data.getShort();
        this.ySubscriptXOffset = data.getShort();
        this.ySubscriptYOffset = data.getShort();
        this.ySuperscriptXSize = data.getShort();
        this.ySuperscriptYSize = data.getShort();
        this.ySuperscriptXOffset = data.getShort();
        this.ySuperscriptYOffset = data.getShort();
        this.yStrikeoutSize = data.getShort();
        this.yStrikeoutPosition = data.getShort();
        this.sFamilyClass = data.getShort();
        data.get(this.panose);
        for (int i = 0; i < 4; ++i) {
            this.ulUnicodeRange[i] = data.getInt();
        }
        data.get(this.achVendID);
        this.fsSelection = data.getShort();
        this.usFirstCharIndex = data.getShort();
        this.usLastCharIndex = data.getShort();
        if (len >= 78) {
            this.sTypoAscender = data.getShort();
            this.sTypoDescender = data.getShort();
            this.sTypoLineGap = data.getShort();
            this.usWinAscent = data.getShort();
            this.usWinDescent = data.getShort();
        }
        if (len == 86) {
            this.ulCodePageRange1 = data.getInt();
            this.ulCodePageRange2 = data.getInt();
        }
    }

    @Override
    public int getLength() {
        return 86;
    }

    public void setUsWeightClass(int usWeightClass) {
        this.usWeightClass = usWeightClass;
    }

    public byte[] getPanose() {
        return this.panose;
    }

    public void setFsSelection(short fsSelection) {
        this.fsSelection = fsSelection;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("    xAvgCharWidth       : ").append(this.xAvgCharWidth).append('\n');
        b.append("    usWeightClass       : ").append(this.usWeightClass).append('\n');
        b.append("    fsType              : ").append(this.fsType).append('\n');
        b.append("    ySubscriptXSize     : ").append(this.ySubscriptXSize).append('\n');
        b.append("    ySubscriptYSize     : ").append(this.ySubscriptYSize).append('\n');
        b.append("    ySubscriptXOffset   : ").append(this.ySubscriptXOffset).append('\n');
        b.append("    ySubscriptYOffset   : ").append(this.ySubscriptYOffset).append('\n');
        b.append("    ySuperscriptXSize   : ").append(this.ySuperscriptXSize).append('\n');
        b.append("    ySuperscriptYSize   : ").append(this.ySuperscriptYSize).append('\n');
        b.append("    ySuperscriptXOffset : ").append(this.ySuperscriptXOffset).append('\n');
        b.append("    ySuperscriptYOffset : ").append(this.ySuperscriptYOffset).append('\n');
        b.append("    yStrikeoutSize      : ").append(this.yStrikeoutSize).append('\n');
        b.append("    yStrikeoutPosition  : ").append(this.yStrikeoutPosition).append('\n');
        b.append("    sFamilyClass        : ").append(this.sFamilyClass).append('\n');
        b.append("    ulUnicodeRange      : ").append(Arrays.toString(this.ulUnicodeRange)).append('\n');
        b.append("    fsSelection         : ").append(this.fsSelection).append('\n');
        b.append("    usFirstCharIndex    : ").append(this.usFirstCharIndex).append('\n');
        b.append("    usLastCharIndex     : ").append(this.usLastCharIndex).append('\n');
        b.append("    sTypoAscender       : ").append(this.sTypoAscender).append('\n');
        b.append("    sTypoDescender      : ").append(this.sTypoDescender).append('\n');
        b.append("    sTypoLineGap        : ").append(this.sTypoLineGap).append('\n');
        b.append("    usWinAscent         : ").append(this.usWinAscent).append('\n');
        b.append("    usWinDescent        : ").append(this.usWinDescent).append('\n');
        b.append("    ulCodePageRange1    : ").append(this.ulCodePageRange1).append('\n');
        b.append("    ulCodePageRange2    : ").append(this.ulCodePageRange2).append('\n');
        b.append("    panose              : ").append(Arrays.toString(this.panose)).append('\n');
        b.append("    achVendID           : ").append(Arrays.toString(this.achVendID));
        return b.toString();
    }
}

