/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.ttf.cmap;

import com.inet.pdfview.data.IDataBuffer;
import com.inet.pdfview.font.ttf.cmap.CMap;
import java.nio.ByteBuffer;

public class CMapFormat6
extends CMap {
    private char firstCode;
    private char entryCount;
    private char[] glyphIdArray;

    public CMapFormat6(short language) {
        super((short)6, language);
    }

    @Override
    public void setData(int length, IDataBuffer data) {
        this.firstCode = data.getChar();
        this.entryCount = data.getChar();
        this.glyphIdArray = new char[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.glyphIdArray[i] = data.getChar();
        }
    }

    @Override
    public int getLastCode() {
        return this.firstCode + this.entryCount;
    }

    @Override
    public ByteBuffer getData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte map(byte src) {
        char dst = this.map((char)src);
        if (dst < '\u0100') {
            return (byte)dst;
        }
        return 0;
    }

    @Override
    public char map(char src) {
        int i = src - this.firstCode;
        return i < 0 || i >= this.glyphIdArray.length ? (char)'\u0000' : this.glyphIdArray[i];
    }

    @Override
    public char reverseMap(short glyphID) {
        return '\u0000';
    }
}

