/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.otf;

import com.inet.cache.MemoryStoreMap;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.data.FileBuffer;
import com.inet.pdfview.font.otf.OTFInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class OTFPool {
    private static final FilenameFilter OTF_FILTER = (file, str) -> file.isDirectory() && str.toLowerCase().endsWith(".otf");
    public static final byte[] OTF_LABEL = new byte[]{79, 84, 84, 79};
    private static final MemoryStoreMap<String, OTFInfo> fontInfos = new MemoryStoreMap(1800, true);
    private static final Map<String, String> cachedFiles = new ConcurrentHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public synchronized void init(String[] fontDirs) {
        for (String string : fontDirs) {
            void var5_5;
            File fontdir;
            String[] fontFilePaths;
            if (string == null || string.isEmpty()) continue;
            if (!string.endsWith("/") && !string.endsWith("\\")) {
                String string2 = string + "/";
            }
            if ((fontFilePaths = (fontdir = new File((String)var5_5)).list(OTF_FILTER)) == null) continue;
            for (String string3 : fontFilePaths) {
                FileBuffer fb = null;
                String string4 = (String)var5_5 + string3;
                if (cachedFiles.containsKey(string4)) continue;
                try {
                    fb = new FileBuffer(new File(string4));
                    OTFInfo fontInfo = this.readFontInfo(fb, string4);
                    if (fontInfo == null) continue;
                    List<String> fontNames = fontInfo.getFontNames(fb);
                    for (String fontName : fontNames) {
                        if (fontName == null) continue;
                        fontInfos.put((Object)fontName, (Object)fontInfo);
                    }
                    cachedFiles.put(string4, string4);
                }
                catch (Exception ex) {
                    PDFParser.LOGGER.error((Throwable)ex);
                }
                finally {
                    if (fb != null) {
                        try {
                            fb.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    @Nullable
    private OTFInfo readFontInfo(FileBuffer fb, String fontPath) throws IOException {
        byte[] label = new byte[4];
        fb.get(label);
        if (!Arrays.equals(label, OTF_LABEL) && PDFParser.LOGGER.isDebug()) {
            PDFParser.LOGGER.debug((Object)("Invalid signature of Open Type font: " + new String(label)));
            return null;
        }
        OTFInfo fontInfo = new OTFInfo(fontPath);
        fontInfo.setNumberTables(fb.getShort());
        fb.position(fb.position() + 6);
        fontInfo.readTableRecords(fb);
        if (!fontInfo.isType1CFont()) {
            return null;
        }
        return fontInfo;
    }

    @Nonnull
    public final synchronized OTFInfo getFontInfo(String fontName) {
        return (OTFInfo)fontInfos.get((Object)fontName);
    }

    static {
        fontInfos.addTimeoutListener((name, info) -> cachedFiles.remove(info.getFontPath()));
    }
}

