/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font.otf;

import com.inet.pdfview.data.FileBuffer;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.otf.OTFTABLE;
import com.inet.pdfview.font.otf.TableLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OTFInfo {
    private String fontPath;
    private int numTables;
    private Map<OTFTABLE, TableLocation> tables = new HashMap<OTFTABLE, TableLocation>();
    private PDFFont pdfFont;

    OTFInfo(String fontPath) {
        this.fontPath = fontPath;
    }

    void readTableRecords(FileBuffer fb) throws IOException {
        for (int i = 0; i < this.numTables; ++i) {
            this.readTableRecord(fb);
        }
    }

    private void readTableRecord(FileBuffer fb) throws IOException {
        byte[] tblname = new byte[4];
        fb.get(tblname);
        String tableName = new String(tblname).replace('/', '_');
        fb.position(fb.position() + 4);
        int offset = fb.getInt();
        int length = fb.getInt();
        try {
            OTFTABLE otfTable = OTFTABLE.valueOf(tableName.toUpperCase().trim());
            if (otfTable != null) {
                TableLocation loc = new TableLocation(offset, length);
                this.tables.put(otfTable, loc);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Nonnull
    List<String> getFontNames(FileBuffer fb) {
        ArrayList<String> fontNames = new ArrayList<String>();
        String fontName = null;
        TableLocation nameLocation = this.tables.get((Object)OTFTABLE.NAME);
        int tablePosition = nameLocation.getOffset();
        fb.position(tablePosition + 2);
        int namesCount = fb.getShort();
        short storagePos = fb.getShort();
        block3: for (int i = 0; i < namesCount; ++i) {
            short platform = fb.getShort();
            short enc = fb.getShort();
            short lang = fb.getShort();
            short nameId = fb.getShort();
            switch (nameId) {
                case 4: {
                    break;
                }
                default: {
                    fb.position(fb.position() + 4);
                    continue block3;
                }
            }
            short length = fb.getShort();
            short nameOffset = fb.getShort();
            fb.mark();
            int namePosition = tablePosition + storagePos + nameOffset;
            fontName = platform == 0 || platform == 3 || platform == 2 && enc == 1 ? this.readUnicodeString(namePosition, length, fb) : this.readByteString1252(namePosition, length, fb);
            if (!fontNames.contains(fontName)) {
                fontNames.add(fontName);
            }
            fb.reset();
        }
        return fontNames;
    }

    private String readUnicodeString(int offset, int length, FileBuffer fb) {
        StringBuilder builder = new StringBuilder();
        length /= 2;
        fb.position(offset);
        for (int k = 0; k < length; ++k) {
            builder.append(fb.getChar());
        }
        return builder.toString();
    }

    private String readByteString1252(int offset, int length, FileBuffer fb) {
        byte[] tmp = new byte[length];
        try {
            fb.position(offset);
            fb.get(tmp);
            return new String(tmp, "ISO-8859-1");
        }
        catch (Exception e) {
            throw new RuntimeException("can't read string: " + e.getMessage());
        }
    }

    void setNumberTables(short numTables) {
        this.numTables = numTables;
    }

    String getFontPath() {
        return this.fontPath;
    }

    @Nullable
    PDFFont getPDFFont() {
        return this.pdfFont;
    }

    void setPDFFont(PDFFont pdffont) {
        this.pdfFont = pdffont;
    }

    boolean isType1CFont() {
        return this.tables.containsKey((Object)OTFTABLE.CFF);
    }
}

