/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFTextFormat;
import com.inet.pdfview.command.PDFDrawTextCmd;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.font.AdobeCharNames;
import com.inet.pdfview.font.ExtensionCharacterMap;
import com.inet.pdfview.font.FontSupport;
import com.inet.pdfview.font.ICharMapper;
import com.inet.pdfview.font.PDFCIDMap;
import com.inet.pdfview.font.PDFCMap;
import com.inet.pdfview.font.PDFFont;
import com.inet.pdfview.font.PDFGlyph;
import com.inet.pdfview.font.Type0Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class PDFFontEncoding {
    public static final int TYPE_ENCODING = 0;
    public static final int TYPE_CMAP = 1;
    private ICharMapper baseMapper;
    private Map<Character, String> differences;
    private PDFCMap cmap;
    private int type;
    private ExtensionCharacterMap unicodeMapExtention;
    @Nullable
    private Character spaceCode;

    public PDFFontEncoding(PDFFont.Subtype fontType, PDFObject encoding, PDFDecrypter decryptor) throws PDFParseException {
        if (encoding.getType() == 4) {
            if (fontType == PDFFont.Subtype.Type0) {
                this.type = 1;
                this.cmap = PDFCMap.getCMap(encoding.getStringValue());
            } else {
                this.type = 0;
                this.baseMapper = FontSupport.getCharMapper(encoding.getStringValue());
            }
        } else {
            String typeStr = null;
            PDFObject typeObj = encoding.getDictRef("Type");
            if (typeObj != null) {
                typeStr = typeObj.getStringValue();
            }
            if ("CMap".equals(typeStr)) {
                this.type = 1;
                this.cmap = PDFCMap.getCMap(encoding, decryptor);
            } else {
                try {
                    this.parseEncoding(encoding);
                    this.type = 0;
                }
                catch (Throwable th) {
                    throw new IllegalArgumentException("Uknown encoding: " + encoding.dereference().toString() + "; font type " + String.valueOf((Object)fontType));
                }
            }
        }
    }

    public PDFFontEncoding(PDFFont.Subtype fontType) {
        if (fontType != PDFFont.Subtype.Type1) {
            throw new IllegalArgumentException("Invalid font type");
        }
        this.type = 0;
        this.baseMapper = FontSupport.getCharMapper("StandardEncoding");
    }

    public List<PDFGlyph> getGlyphs(PDFFont font, String text) {
        ArrayList<PDFGlyph> outList = new ArrayList<PDFGlyph>(text.length());
        char[] arry = text.toCharArray();
        block4: for (int i = 0; i < arry.length; ++i) {
            switch (this.type) {
                case 0: {
                    outList.add(this.getGlyphFromEncoding(font, arry[i]));
                    continue block4;
                }
                case 1: {
                    char c = (char)((arry[i] & 0xFF) << 8);
                    if (i < arry.length - 1) {
                        c = (char)(c | (char)(arry[++i] & 0xFF));
                    }
                    outList.add(this.getGlyphFromCMap(font, c, true));
                }
            }
        }
        return outList;
    }

    public List<PDFGlyph> getGlyphs(PDFFont font, PDFTextFormat.TextWrapper textWrapper) {
        if (this.type == 1 && (!(this.cmap instanceof PDFCIDMap) || ((PDFCIDMap)this.cmap).hasTwoByteKeyValue())) {
            textWrapper.transformToTwoByteText();
        }
        String text = textWrapper.getText();
        ArrayList<PDFGlyph> outList = new ArrayList<PDFGlyph>(text.length());
        char[] arry = text.toCharArray();
        Map<Character, PDFGlyph> glyphCache = font.getGlyphCache();
        block4: for (int i = 0; i < arry.length; ++i) {
            switch (this.type) {
                case 0: {
                    PDFGlyph glyph = glyphCache.get(Character.valueOf(arry[i]));
                    if (glyph == null) {
                        glyph = this.getGlyphFromEncoding(font, arry[i]);
                    }
                    outList.add(glyph);
                    continue block4;
                }
                case 1: {
                    outList.add(this.getGlyphFromCMap(font, arry[i], true));
                }
            }
        }
        return outList;
    }

    private PDFGlyph getGlyphFromEncoding(PDFFont font, char src) {
        String charName = null;
        if (src > '\u00ff') {
            PDFDrawTextCmd.UnicodeConvertResult result = font.decodeText("" + src, true, true);
            if (result.isValidMapping() && !result.getContent().isEmpty()) {
                src = result.getContent().charAt(0);
            }
            if (src > '\u00ff') {
                return null;
            }
        }
        src = (char)(src & 0xFF);
        if (this.differences != null && this.differences.containsKey(new Character(src))) {
            charName = this.differences.get(new Character(src));
        } else if (this.baseMapper != null) {
            charName = this.baseMapper.getCharName(src);
            if (this.differences != null && this.differences.containsValue(charName) && !Character.isWhitespace(src)) {
                charName = ".notdef";
            }
        }
        return font.getCachedGlyph(src, charName, false);
    }

    private PDFGlyph getGlyphFromCMap(PDFFont font, char src, boolean isTwoByteChar) {
        if (this.cmap != null) {
            PDFGlyph glyph;
            int fontID = this.cmap.getFontID(src);
            char charID = this.cmap.map(src);
            if (font instanceof Type0Font) {
                font = ((Type0Font)font).getDescendantFont(fontID);
            }
            if ((glyph = font.getCachedGlyph(charID, null, isTwoByteChar)) != null) {
                glyph.setSrcCode(src);
            }
            return glyph;
        }
        if (font instanceof Type0Font) {
            font = ((Type0Font)font).getDescendantFont(0);
            return font.getCachedGlyph(src, null, isTwoByteChar);
        }
        return null;
    }

    public void parseEncoding(PDFObject encoding) throws PDFParseException {
        PDFObject diffArrayObj;
        PDFObject baseEncObj = encoding.getDictRef("BaseEncoding");
        if (baseEncObj != null) {
            this.baseMapper = FontSupport.getCharMapper(baseEncObj.getStringValue());
        }
        if ((diffArrayObj = encoding.getDictRef("Differences")) != null) {
            this.differences = new HashMap<Character, String>();
            PDFObject[] diffArray = diffArrayObj.getArray();
            int curPosition = -1;
            for (int i = 0; i < diffArray.length; ++i) {
                if (diffArray[i].getType() == 2) {
                    curPosition = diffArray[i].getIntValue();
                    continue;
                }
                if (diffArray[i].getType() == 4) {
                    Character key = new Character((char)curPosition);
                    String glyphName = diffArray[i].getStringValue();
                    this.differences.put(key, glyphName);
                    this.extractUnicodeFromDifferencesArray(key.charValue(), glyphName);
                    ++curPosition;
                    continue;
                }
                throw new IllegalArgumentException("Unexpected type in diff array: " + String.valueOf(diffArray[i]));
            }
        }
    }

    public Character getCharFromEncoding(char src) {
        String charName = null;
        src = (char)(src & 0xFF);
        if (this.differences != null && this.differences.containsKey(new Character(src))) {
            charName = this.differences.get(new Character(src));
        } else if (this.baseMapper != null) {
            charName = this.baseMapper.getCharName(src);
            if (this.differences != null && this.differences.containsValue(charName) && !Character.isWhitespace(src)) {
                charName = ".notdef";
            }
        }
        if (charName != null) {
            Character ch = AdobeCharNames.getCharBasedOnAdobeName(charName);
            if (ch == null) {
                if (charName.startsWith("uni")) {
                    charName = charName.substring("uni".length());
                    try {
                        char c = (char)Integer.parseInt(charName, 16);
                        ch = Character.valueOf(c);
                    }
                    catch (NumberFormatException c) {}
                } else {
                    try {
                        char c = (char)Integer.parseInt(charName);
                        ch = Character.valueOf(c);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return ch;
        }
        return null;
    }

    void setCharDifferences(Map<Character, String> differences) {
        this.differences = differences;
    }

    public int getType() {
        return this.type;
    }

    public void setCharacterMapper(ICharMapper mapper) {
        this.baseMapper = mapper;
    }

    public ICharMapper getCharMapper() {
        return this.baseMapper;
    }

    @Nullable
    public Character getSpaceCode() {
        return this.spaceCode;
    }

    ExtensionCharacterMap getIndirectUnicodeExtention() {
        return this.unicodeMapExtention;
    }

    private void extractUnicodeFromDifferencesArray(char key, String glyphName) {
        char unicode = '\u0000';
        boolean unicodeFound = false;
        if (glyphName.startsWith("uni") || glyphName.startsWith("UNI")) {
            glyphName = glyphName.substring("uni".length());
            unicodeFound = true;
        } else if (glyphName.startsWith("u") || glyphName.startsWith("U")) {
            glyphName = glyphName.substring("u".length());
            unicodeFound = true;
        }
        if (unicodeFound) {
            try {
                unicode = (char)Integer.parseInt(glyphName, 16);
                if (this.unicodeMapExtention == null) {
                    this.unicodeMapExtention = new ExtensionCharacterMap();
                }
                this.unicodeMapExtention.addEntry(key, Character.valueOf(unicode).charValue());
                if (key == ' ' && glyphName.length() == 4) {
                    this.spaceCode = Character.valueOf(unicode);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (key == ' ') {
            this.spaceCode = AdobeCharNames.getCharBasedOnAdobeName(glyphName);
        }
    }
}

