/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.error.PDFParseException;

public class PDFFontDescriptor {
    private int ascent;
    private int capHeight;
    private int descent;
    private int flags;
    private String fontName;
    private String fontFamilyName;
    private int italicAngle;
    private int stemV;
    private int avgWidth = 0;
    private PDFObject fontFile;
    private PDFObject fontFile2;
    private PDFObject fontFile3;
    private int leading = 0;
    private int maxWidth = 0;
    private int missingWidth = 0;
    private int stemH = 0;
    private int xHeight = 0;
    private PDFObject charSet;

    public PDFFontDescriptor(String basefont) {
        this.setFontName(basefont);
    }

    private int getRequiredIntFromDict(PDFObject obj, String dictname) throws PDFParseException {
        PDFObject object = obj.getDictRef(dictname);
        if (object == null) {
            if (PDFParser.LOGGER.isDebug()) {
                PDFParser.LOGGER.debug((Object)("Fontdescriptor is missing required Entry '" + dictname + "'. Now using zero as fallback."));
            }
            return 0;
        }
        return object.getIntValue();
    }

    public PDFFontDescriptor(PDFObject obj) throws PDFParseException {
        this.setAscent(this.getRequiredIntFromDict(obj, "Ascent"));
        this.setCapHeight(this.getRequiredIntFromDict(obj, "CapHeight"));
        this.setDescent(this.getRequiredIntFromDict(obj, "Descent"));
        this.setFlags(this.getRequiredIntFromDict(obj, "Flags"));
        PDFObject fontNameRef = obj.getDictRef("FontName");
        this.setFontName((String)(fontNameRef != null ? fontNameRef.getStringValue() : "Unnamed" + this.hashCode()));
        this.setItalicAngle(this.getRequiredIntFromDict(obj, "ItalicAngle"));
        this.setStemV(this.getRequiredIntFromDict(obj, "StemV"));
        PDFObject family = obj.getDictRef("FontFamily");
        if (family != null) {
            this.setFontFamilyName(family.getStringValue());
        }
        if (obj.getDictionary().containsKey("AvgWidth")) {
            this.setAvgWidth(obj.getDictRef("AvgWidth").getIntValue());
        }
        if (obj.getDictionary().containsKey("FontFile")) {
            this.setFontFile(obj.getDictRef("FontFile"));
        }
        if (obj.getDictionary().containsKey("FontFile2")) {
            this.setFontFile2(obj.getDictRef("FontFile2"));
        }
        if (obj.getDictionary().containsKey("FontFile3")) {
            this.setFontFile3(obj.getDictRef("FontFile3"));
        }
        if (obj.getDictionary().containsKey("Leading")) {
            this.setLeading(obj.getDictRef("Leading").getIntValue());
        }
        if (obj.getDictionary().containsKey("MaxWidth")) {
            this.setMaxWidth(obj.getDictRef("MaxWidth").getIntValue());
        }
        if (obj.getDictionary().containsKey("MissingWidth")) {
            this.setMissingWidth(obj.getDictRef("MissingWidth").getIntValue());
        }
        if (obj.getDictionary().containsKey("StemH")) {
            this.setStemH(obj.getDictRef("StemH").getIntValue());
        }
        if (obj.getDictionary().containsKey("XHeight")) {
            this.setXHeight(obj.getDictRef("XHeight").getIntValue());
        }
        if (obj.getDictionary().containsKey("CharSet")) {
            this.setCharSet(obj.getDictRef("CharSet"));
        }
    }

    public int getAscent() {
        return this.ascent;
    }

    public void setAscent(int ascent) {
        this.ascent = ascent;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public void setCapHeight(int capHeight) {
        this.capHeight = capHeight;
    }

    public int getDescent() {
        return this.descent;
    }

    public void setDescent(int descent) {
        this.descent = descent;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
        if (this.fontFamilyName == null) {
            this.fontFamilyName = fontName;
        }
    }

    public void setFontFamilyName(String fontFamilyName) {
        this.fontFamilyName = fontFamilyName;
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(int italicAngle) {
        this.italicAngle = italicAngle;
    }

    public int getStemV() {
        return this.stemV;
    }

    public void setStemV(int stemV) {
        this.stemV = stemV;
    }

    public int getAvgWidth() {
        return this.avgWidth;
    }

    public void setAvgWidth(int avgWidth) {
        this.avgWidth = avgWidth;
    }

    public PDFObject getFontFile() {
        return this.fontFile;
    }

    public void setFontFile(PDFObject fontFile) {
        this.fontFile = fontFile;
    }

    public PDFObject getFontFile2() {
        return this.fontFile2;
    }

    public void setFontFile2(PDFObject fontFile2) {
        this.fontFile2 = fontFile2;
    }

    public PDFObject getFontFile3() {
        return this.fontFile3;
    }

    public void setFontFile3(PDFObject fontFile3) {
        this.fontFile3 = fontFile3;
    }

    public int getLeading() {
        return this.leading;
    }

    public void setLeading(int leading) {
        this.leading = leading;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    public void setMissingWidth(int missingWidth) {
        this.missingWidth = missingWidth;
    }

    public int getStemH() {
        return this.stemH;
    }

    public void setStemH(int stemH) {
        this.stemH = stemH;
    }

    public int getXHeight() {
        return this.xHeight;
    }

    public void setXHeight(int xHeight) {
        this.xHeight = xHeight;
    }

    public PDFObject getCharSet() {
        return this.charSet;
    }

    public void setCharSet(PDFObject charSet) {
        this.charSet = charSet;
    }

    public int calculateStyle() {
        int style;
        int n = style = (this.flags & 0x40000) != 0 ? 1 : 0;
        if (this.fontName.indexOf("Bold") > 0) {
            style |= 1;
        }
        if (this.italicAngle != 0 || (this.flags & 0x40) != 0) {
            style |= 2;
        }
        return style;
    }
}

