/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.font;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public class FontCache {
    private static final int FONT_CACHE_SIZE = 100;
    private long fontUsageCounter = Long.MIN_VALUE;
    private Map<String, FontInfo> cache = new HashMap<String, FontInfo>();

    public void put(String key, Font font) {
        ++this.fontUsageCounter;
        FontInfo info = new FontInfo(key, font, this.fontUsageCounter);
        this.cache.put(key, info);
        if (this.cache.size() > 100) {
            FontInfo oldest = null;
            for (FontInfo i : this.cache.values()) {
                if (oldest != null && i.usageCounter >= oldest.usageCounter) continue;
                oldest = i;
            }
            if (oldest != null) {
                this.cache.remove(oldest.keyName);
            }
        }
    }

    public Font get(String key) {
        FontInfo fontInfo = this.cache.get(key);
        if (fontInfo == null) {
            return null;
        }
        fontInfo.usageCounter = this.fontUsageCounter++;
        return fontInfo.font;
    }

    private static class FontInfo {
        private Font font;
        private String keyName;
        private long usageCounter;

        public FontInfo(String keyName, Font font, long usageCounter) {
            this.keyName = keyName;
            this.font = font;
            this.usageCounter = usageCounter;
        }
    }
}

